/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.io.sstable;

import java.io.File;
import java.util.EnumSet;
import java.util.regex.Pattern;
import org.apache.cassandra.io.sstable.Descriptor;
import org.apache.cassandra.utils.ChecksumType;
import org.apache.cassandra.utils.Pair;
import org.cassandraunit.shaded.com.google.common.base.Objects;

public class Component {
    public static final char separator = '-';
    static final EnumSet<Type> TYPES = EnumSet.allOf(Type.class);
    public static final Component DATA = new Component(Type.DATA);
    public static final Component PRIMARY_INDEX = new Component(Type.PRIMARY_INDEX);
    public static final Component FILTER = new Component(Type.FILTER);
    public static final Component COMPRESSION_INFO = new Component(Type.COMPRESSION_INFO);
    public static final Component STATS = new Component(Type.STATS);
    private static final String digestCrc32 = "Digest.crc32";
    private static final String digestAdler32 = "Digest.adler32";
    private static final String digestSha1 = "Digest.sha1";
    public static final Component DIGEST_CRC32 = new Component(Type.DIGEST, "Digest.crc32");
    public static final Component DIGEST_ADLER32 = new Component(Type.DIGEST, "Digest.adler32");
    public static final Component DIGEST_SHA1 = new Component(Type.DIGEST, "Digest.sha1");
    public static final Component CRC = new Component(Type.CRC);
    public static final Component SUMMARY = new Component(Type.SUMMARY);
    public static final Component TOC = new Component(Type.TOC);
    public final Type type;
    public final String name;
    public final int hashCode;

    public static Component digestFor(ChecksumType checksumType) {
        switch (checksumType) {
            case Adler32: {
                return DIGEST_ADLER32;
            }
            case CRC32: {
                return DIGEST_CRC32;
            }
        }
        throw new AssertionError();
    }

    public Component(Type type) {
        this(type, type.repr[0]);
        assert (type.repr.length == 1);
        assert (type != Type.CUSTOM);
    }

    public Component(Type type, String name) {
        assert (name != null) : "Component name cannot be null";
        this.type = type;
        this.name = name;
        this.hashCode = Objects.hashCode(new Object[]{type, name});
    }

    public String name() {
        return this.name;
    }

    public static Pair<Descriptor, Component> fromFilename(File directory, String name) {
        Component component;
        Pair<Descriptor, String> path = Descriptor.fromFilename(directory, name);
        Type type = Type.fromRepresentation((String)path.right);
        block0 : switch (type) {
            case DATA: {
                component = DATA;
                break;
            }
            case PRIMARY_INDEX: {
                component = PRIMARY_INDEX;
                break;
            }
            case FILTER: {
                component = FILTER;
                break;
            }
            case COMPRESSION_INFO: {
                component = COMPRESSION_INFO;
                break;
            }
            case STATS: {
                component = STATS;
                break;
            }
            case DIGEST: {
                switch ((String)path.right) {
                    case "Digest.crc32": {
                        component = DIGEST_CRC32;
                        break block0;
                    }
                    case "Digest.adler32": {
                        component = DIGEST_ADLER32;
                        break block0;
                    }
                    case "Digest.sha1": {
                        component = DIGEST_SHA1;
                        break block0;
                    }
                }
                throw new IllegalArgumentException("Invalid digest component " + (String)path.right);
            }
            case CRC: {
                component = CRC;
                break;
            }
            case SUMMARY: {
                component = SUMMARY;
                break;
            }
            case TOC: {
                component = TOC;
                break;
            }
            case SECONDARY_INDEX: {
                component = new Component(Type.SECONDARY_INDEX, (String)path.right);
                break;
            }
            case CUSTOM: {
                component = new Component(Type.CUSTOM, (String)path.right);
                break;
            }
            default: {
                throw new IllegalStateException();
            }
        }
        return Pair.create(path.left, component);
    }

    public String toString() {
        return this.name();
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Component)) {
            return false;
        }
        Component that = (Component)o;
        return this.type == that.type && this.name.equals(that.name);
    }

    public int hashCode() {
        return this.hashCode;
    }

    public static enum Type {
        DATA("Data.db"),
        PRIMARY_INDEX("Index.db"),
        FILTER("Filter.db"),
        COMPRESSION_INFO("CompressionInfo.db"),
        STATS("Statistics.db"),
        DIGEST("Digest.crc32", "Digest.adler32", "Digest.sha1"),
        CRC("CRC.db"),
        SUMMARY("Summary.db"),
        TOC("TOC.txt"),
        SECONDARY_INDEX("SI_.*.db"),
        CUSTOM(new String[]{null});

        final String[] repr;

        private Type(String repr) {
            this(new String[]{repr});
        }

        private Type(String ... repr) {
            this.repr = repr;
        }

        static Type fromRepresentation(String repr) {
            for (Type type : TYPES) {
                if (type.repr == null || type.repr.length == 0 || type.repr[0] == null || !Pattern.matches(type.repr[0], repr)) continue;
                return type;
            }
            return CUSTOM;
        }
    }
}

