/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.io.util;

import java.io.File;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import org.apache.cassandra.io.compress.BufferType;
import org.apache.cassandra.io.compress.CompressionMetadata;
import org.apache.cassandra.io.util.ChannelProxy;
import org.apache.cassandra.io.util.CompressedSegmentedFile;
import org.apache.cassandra.io.util.DataPosition;
import org.apache.cassandra.io.util.FileDataInput;
import org.apache.cassandra.io.util.LimitingRebufferer;
import org.apache.cassandra.io.util.MmapRebufferer;
import org.apache.cassandra.io.util.MmappedRegions;
import org.apache.cassandra.io.util.Rebufferer;
import org.apache.cassandra.io.util.RebuffererFactory;
import org.apache.cassandra.io.util.RebufferingInputStream;
import org.apache.cassandra.io.util.SegmentedFile;
import org.apache.cassandra.io.util.SimpleChunkReader;
import org.apache.cassandra.utils.memory.BufferPool;
import org.cassandraunit.shaded.com.google.common.annotations.VisibleForTesting;
import org.cassandraunit.shaded.com.google.common.primitives.Ints;
import org.cassandraunit.shaded.com.google.common.util.concurrent.RateLimiter;

public class RandomAccessReader
extends RebufferingInputStream
implements FileDataInput {
    public static final int DEFAULT_BUFFER_SIZE = 4096;
    public static final int MAX_BUFFER_SIZE = 65536;
    protected long markedPointer;
    @VisibleForTesting
    final Rebufferer rebufferer;
    Rebufferer.BufferHolder bufferHolder = Rebufferer.EMPTY;

    protected RandomAccessReader(Rebufferer rebufferer) {
        super(Rebufferer.EMPTY.buffer());
        this.rebufferer = rebufferer;
    }

    public static ByteBuffer allocateBuffer(int size, BufferType bufferType) {
        return BufferPool.get(size, bufferType).order(ByteOrder.BIG_ENDIAN);
    }

    @Override
    public void reBuffer() {
        if (this.isEOF()) {
            return;
        }
        this.reBufferAt(this.current());
    }

    public void reBufferAt(long position) {
        this.bufferHolder.release();
        this.bufferHolder = this.rebufferer.rebuffer(position);
        this.buffer = this.bufferHolder.buffer();
        this.buffer.position(Ints.checkedCast(position - this.bufferHolder.offset()));
        assert (this.buffer.order() == ByteOrder.BIG_ENDIAN) : "Buffer must have BIG ENDIAN byte ordering";
    }

    @Override
    public long getFilePointer() {
        if (this.buffer == null) {
            return this.rebufferer.fileLength();
        }
        return this.current();
    }

    protected long current() {
        return this.bufferHolder.offset() + (long)this.buffer.position();
    }

    @Override
    public String getPath() {
        return this.getChannel().filePath();
    }

    public ChannelProxy getChannel() {
        return this.rebufferer.channel();
    }

    @Override
    public void reset() throws IOException {
        this.seek(this.markedPointer);
    }

    @Override
    public boolean markSupported() {
        return true;
    }

    public long bytesPastMark() {
        long bytes = this.current() - this.markedPointer;
        assert (bytes >= 0L);
        return bytes;
    }

    @Override
    public DataPosition mark() {
        this.markedPointer = this.current();
        return new BufferedRandomAccessFileMark(this.markedPointer);
    }

    @Override
    public void reset(DataPosition mark) {
        assert (mark instanceof BufferedRandomAccessFileMark);
        this.seek(((BufferedRandomAccessFileMark)mark).pointer);
    }

    @Override
    public long bytesPastMark(DataPosition mark) {
        assert (mark instanceof BufferedRandomAccessFileMark);
        long bytes = this.current() - ((BufferedRandomAccessFileMark)mark).pointer;
        assert (bytes >= 0L);
        return bytes;
    }

    @Override
    public boolean isEOF() {
        return this.current() == this.length();
    }

    @Override
    public long bytesRemaining() {
        return this.length() - this.getFilePointer();
    }

    @Override
    public int available() throws IOException {
        return Ints.saturatedCast(this.bytesRemaining());
    }

    @Override
    public void close() {
        if (this.buffer == null) {
            return;
        }
        this.bufferHolder.release();
        this.rebufferer.closeReader();
        this.buffer = null;
        this.bufferHolder = null;
    }

    public String toString() {
        return this.getClass().getSimpleName() + ':' + this.rebufferer.toString();
    }

    @Override
    public void seek(long newPosition) {
        if (newPosition < 0L) {
            throw new IllegalArgumentException("new position should not be negative");
        }
        if (this.buffer == null) {
            throw new IllegalStateException("Attempted to seek in a closed RAR");
        }
        long bufferOffset = this.bufferHolder.offset();
        if (newPosition >= bufferOffset && newPosition < bufferOffset + (long)this.buffer.limit()) {
            this.buffer.position((int)(newPosition - bufferOffset));
            return;
        }
        if (newPosition > this.length()) {
            throw new IllegalArgumentException(String.format("Unable to seek to position %d in %s (%d bytes) in read-only mode", newPosition, this.getPath(), this.length()));
        }
        this.reBufferAt(newPosition);
    }

    @Override
    public final String readLine() throws IOException {
        StringBuilder line = new StringBuilder(80);
        boolean foundTerminator = false;
        long unreadPosition = -1L;
        block5: while (true) {
            int nextByte = this.read();
            switch (nextByte) {
                case -1: {
                    return line.length() != 0 ? line.toString() : null;
                }
                case 13: {
                    if (foundTerminator) {
                        this.seek(unreadPosition);
                        return line.toString();
                    }
                    foundTerminator = true;
                    unreadPosition = this.getPosition();
                    continue block5;
                }
                case 10: {
                    return line.toString();
                }
            }
            if (foundTerminator) {
                this.seek(unreadPosition);
                return line.toString();
            }
            line.append((char)nextByte);
        }
    }

    public long length() {
        return this.rebufferer.fileLength();
    }

    public long getPosition() {
        return this.current();
    }

    public double getCrcCheckChance() {
        return this.rebufferer.getCrcCheckChance();
    }

    protected static Rebufferer instantiateRebufferer(RebuffererFactory fileRebufferer, RateLimiter limiter) {
        Rebufferer rebufferer = fileRebufferer.instantiateRebufferer();
        if (limiter != null) {
            rebufferer = new LimitingRebufferer(rebufferer, limiter, 65536);
        }
        return rebufferer;
    }

    public static RandomAccessReader build(SegmentedFile file, RateLimiter limiter) {
        return new RandomAccessReader(RandomAccessReader.instantiateRebufferer(file.rebuffererFactory(), limiter));
    }

    public static Builder builder(ChannelProxy channel) {
        return new Builder(channel);
    }

    public static RandomAccessReader open(File file) {
        return new Builder(new ChannelProxy(file)).buildWithChannel();
    }

    public static RandomAccessReader open(ChannelProxy channel) {
        return new Builder(channel).build();
    }

    public static class RandomAccessReaderWithOwnChannel
    extends RandomAccessReader {
        protected RandomAccessReaderWithOwnChannel(Rebufferer rebufferer) {
            super(rebufferer);
        }

        @Override
        public void close() {
            try {
                super.close();
            }
            finally {
                try {
                    this.rebufferer.close();
                }
                finally {
                    this.getChannel().close();
                }
            }
        }
    }

    public static class Builder {
        public final ChannelProxy channel;
        protected int bufferSize;
        public BufferType bufferType;
        public ByteBuffer buffer;
        public RateLimiter limiter;
        public MmappedRegions regions;
        public CompressionMetadata compression;

        public Builder(ChannelProxy channel) {
            this.channel = channel;
            this.bufferSize = 4096;
            this.bufferType = BufferType.OFF_HEAP;
        }

        private int adjustedBufferSize() {
            if (this.limiter != null) {
                return 65536;
            }
            int wholePageSize = this.bufferSize + 4095 & 0xFFFFF000;
            return Math.min(65536, wholePageSize);
        }

        protected Rebufferer createRebufferer() {
            return RandomAccessReader.instantiateRebufferer(this.chunkReader(), this.limiter);
        }

        public RebuffererFactory chunkReader() {
            if (this.compression != null) {
                return CompressedSegmentedFile.chunkReader(this.channel, this.compression, this.regions);
            }
            if (this.regions != null) {
                return new MmapRebufferer(this.channel, -1L, this.regions);
            }
            int adjustedSize = this.adjustedBufferSize();
            return new SimpleChunkReader(this.channel, -1L, this.bufferType, adjustedSize);
        }

        public Builder bufferSize(int bufferSize) {
            if (bufferSize <= 0) {
                throw new IllegalArgumentException("bufferSize must be positive");
            }
            this.bufferSize = bufferSize;
            return this;
        }

        public Builder bufferType(BufferType bufferType) {
            this.bufferType = bufferType;
            return this;
        }

        public Builder regions(MmappedRegions regions) {
            this.regions = regions;
            return this;
        }

        public Builder compression(CompressionMetadata metadata) {
            this.compression = metadata;
            return this;
        }

        public Builder limiter(RateLimiter limiter) {
            this.limiter = limiter;
            return this;
        }

        public RandomAccessReader build() {
            return new RandomAccessReader(this.createRebufferer());
        }

        public RandomAccessReader buildWithChannel() {
            return new RandomAccessReaderWithOwnChannel(this.createRebufferer());
        }
    }

    protected static class BufferedRandomAccessFileMark
    implements DataPosition {
        final long pointer;

        public BufferedRandomAccessFileMark(long pointer) {
            this.pointer = pointer;
        }
    }
}

