/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.metrics;

import com.codahale.metrics.Clock;
import com.codahale.metrics.Reservoir;
import com.codahale.metrics.Snapshot;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.nio.charset.Charset;
import java.util.Arrays;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLongArray;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.apache.cassandra.utils.EstimatedHistogram;
import org.cassandraunit.shaded.com.google.common.annotations.VisibleForTesting;

public class DecayingEstimatedHistogramReservoir
implements Reservoir {
    public static final int DEFAULT_BUCKET_COUNT = 164;
    public static final boolean DEFAULT_ZERO_CONSIDERATION = false;
    public static final long[] DEFAULT_WITHOUT_ZERO_BUCKET_OFFSETS = EstimatedHistogram.newOffsets(164, false);
    public static final long[] DEFAULT_WITH_ZERO_BUCKET_OFFSETS = EstimatedHistogram.newOffsets(164, true);
    private final long[] bucketOffsets;
    private final AtomicLongArray decayingBuckets;
    private final AtomicLongArray buckets;
    public static final long HALF_TIME_IN_S = 60L;
    public static final double MEAN_LIFETIME_IN_S = 60.0 / Math.log(2.0);
    public static final long LANDMARK_RESET_INTERVAL_IN_MS = 1800000L;
    private final AtomicBoolean rescaling = new AtomicBoolean(false);
    private volatile long decayLandmark;
    private final ReentrantReadWriteLock lock = new ReentrantReadWriteLock();
    private final Clock clock;
    private static final Charset UTF_8 = Charset.forName("UTF-8");

    public DecayingEstimatedHistogramReservoir() {
        this(false, 164, Clock.defaultClock());
    }

    public DecayingEstimatedHistogramReservoir(boolean considerZeroes) {
        this(considerZeroes, 164, Clock.defaultClock());
    }

    public DecayingEstimatedHistogramReservoir(boolean considerZeroes, int bucketCount) {
        this(considerZeroes, bucketCount, Clock.defaultClock());
    }

    @VisibleForTesting
    DecayingEstimatedHistogramReservoir(boolean considerZeroes, int bucketCount, Clock clock) {
        this.bucketOffsets = bucketCount == 164 ? (considerZeroes ? DEFAULT_WITH_ZERO_BUCKET_OFFSETS : DEFAULT_WITHOUT_ZERO_BUCKET_OFFSETS) : EstimatedHistogram.newOffsets(bucketCount, considerZeroes);
        this.decayingBuckets = new AtomicLongArray(this.bucketOffsets.length + 1);
        this.buckets = new AtomicLongArray(this.bucketOffsets.length + 1);
        this.clock = clock;
        this.decayLandmark = clock.getTime();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void update(long value) {
        long now = this.clock.getTime();
        this.rescaleIfNeeded(now);
        int index = Arrays.binarySearch(this.bucketOffsets, value);
        if (index < 0) {
            index = -index - 1;
        }
        this.lockForRegularUsage();
        try {
            this.decayingBuckets.getAndAdd(index, this.forwardDecayWeight(now));
        }
        finally {
            this.unlockForRegularUsage();
        }
        this.buckets.getAndIncrement(index);
    }

    private long forwardDecayWeight(long now) {
        return Math.round(Math.exp((double)((now - this.decayLandmark) / 1000L) / MEAN_LIFETIME_IN_S));
    }

    public int size() {
        return this.decayingBuckets.length();
    }

    public Snapshot getSnapshot() {
        this.rescaleIfNeeded();
        this.lockForRegularUsage();
        try {
            EstimatedHistogramReservoirSnapshot estimatedHistogramReservoirSnapshot = new EstimatedHistogramReservoirSnapshot(this);
            return estimatedHistogramReservoirSnapshot;
        }
        finally {
            this.unlockForRegularUsage();
        }
    }

    @VisibleForTesting
    boolean isOverflowed() {
        return this.decayingBuckets.get(this.decayingBuckets.length() - 1) > 0L;
    }

    private void rescaleIfNeeded() {
        this.rescaleIfNeeded(this.clock.getTime());
    }

    private void rescaleIfNeeded(long now) {
        if (this.needRescale(now) && this.rescaling.compareAndSet(false, true)) {
            try {
                this.rescale(now);
            }
            finally {
                this.rescaling.set(false);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void rescale(long now) {
        if (this.needRescale(now)) {
            this.lockForRescale();
            try {
                long rescaleFactor = this.forwardDecayWeight(now);
                this.decayLandmark = now;
                int bucketCount = this.decayingBuckets.length();
                for (int i = 0; i < bucketCount; ++i) {
                    long newValue = Math.round(this.decayingBuckets.get(i) / rescaleFactor);
                    this.decayingBuckets.set(i, newValue);
                }
            }
            finally {
                this.unlockForRescale();
            }
        }
    }

    private boolean needRescale(long now) {
        return now - this.decayLandmark > 1800000L;
    }

    @VisibleForTesting
    public void clear() {
        this.lockForRescale();
        try {
            int bucketCount = this.decayingBuckets.length();
            for (int i = 0; i < bucketCount; ++i) {
                this.decayingBuckets.set(i, 0L);
                this.buckets.set(i, 0L);
            }
        }
        finally {
            this.unlockForRescale();
        }
    }

    private void lockForRegularUsage() {
        this.lock.readLock().lock();
    }

    private void unlockForRegularUsage() {
        this.lock.readLock().unlock();
    }

    private void lockForRescale() {
        this.lock.writeLock().lock();
    }

    private void unlockForRescale() {
        this.lock.writeLock().unlock();
    }

    private class EstimatedHistogramReservoirSnapshot
    extends Snapshot {
        private final long[] decayingBuckets;

        public EstimatedHistogramReservoirSnapshot(DecayingEstimatedHistogramReservoir reservoir) {
            int length = reservoir.decayingBuckets.length();
            this.decayingBuckets = new long[length];
            for (int i = 0; i < length; ++i) {
                this.decayingBuckets[i] = reservoir.decayingBuckets.get(i);
            }
        }

        public double getValue(double quantile) {
            assert (quantile >= 0.0 && quantile <= 1.0);
            int lastBucket = this.decayingBuckets.length - 1;
            if (this.decayingBuckets[lastBucket] > 0L) {
                throw new IllegalStateException("Unable to compute when histogram overflowed");
            }
            long qcount = (long)Math.ceil((double)this.count() * quantile);
            if (qcount == 0L) {
                return 0.0;
            }
            long elements = 0L;
            for (int i = 0; i < lastBucket; ++i) {
                if ((elements += this.decayingBuckets[i]) < qcount) continue;
                return DecayingEstimatedHistogramReservoir.this.bucketOffsets[i];
            }
            return 0.0;
        }

        public long[] getValues() {
            int length = DecayingEstimatedHistogramReservoir.this.buckets.length();
            long[] values = new long[length];
            for (int i = 0; i < length; ++i) {
                values[i] = DecayingEstimatedHistogramReservoir.this.buckets.get(i);
            }
            return values;
        }

        public int size() {
            return this.decayingBuckets.length;
        }

        private long count() {
            long sum = 0L;
            for (int i = 0; i < this.decayingBuckets.length; ++i) {
                sum += this.decayingBuckets[i];
            }
            return sum;
        }

        public long getMax() {
            int lastBucket = this.decayingBuckets.length - 1;
            if (this.decayingBuckets[lastBucket] > 0L) {
                return Long.MAX_VALUE;
            }
            for (int i = lastBucket - 1; i >= 0; --i) {
                if (this.decayingBuckets[i] <= 0L) continue;
                return DecayingEstimatedHistogramReservoir.this.bucketOffsets[i];
            }
            return 0L;
        }

        public double getMean() {
            int lastBucket = this.decayingBuckets.length - 1;
            if (this.decayingBuckets[lastBucket] > 0L) {
                throw new IllegalStateException("Unable to compute when histogram overflowed");
            }
            long elements = 0L;
            long sum = 0L;
            for (int i = 0; i < lastBucket; ++i) {
                long bCount = this.decayingBuckets[i];
                elements += bCount;
                sum += bCount * DecayingEstimatedHistogramReservoir.this.bucketOffsets[i];
            }
            return (double)sum / (double)elements;
        }

        public long getMin() {
            for (int i = 0; i < this.decayingBuckets.length; ++i) {
                if (this.decayingBuckets[i] <= 0L) continue;
                return i == 0 ? 0L : 1L + DecayingEstimatedHistogramReservoir.this.bucketOffsets[i - 1];
            }
            return 0L;
        }

        public double getStdDev() {
            int lastBucket = this.decayingBuckets.length - 1;
            if (this.decayingBuckets[lastBucket] > 0L) {
                throw new IllegalStateException("Unable to compute when histogram overflowed");
            }
            long count = this.count();
            if (count <= 1L) {
                return 0.0;
            }
            double mean = this.getMean();
            double sum = 0.0;
            for (int i = 0; i < lastBucket; ++i) {
                long value = DecayingEstimatedHistogramReservoir.this.bucketOffsets[i];
                double diff = (double)value - mean;
                sum += diff * diff * (double)this.decayingBuckets[i];
            }
            return Math.sqrt(sum / (double)(count - 1L));
        }

        public void dump(OutputStream output) {
            try (PrintWriter out = new PrintWriter(new OutputStreamWriter(output, UTF_8));){
                int length = this.decayingBuckets.length;
                for (int i = 0; i < length; ++i) {
                    out.printf("%d%n", this.decayingBuckets[i]);
                }
            }
        }
    }
}

