/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.repair;

import java.io.IOException;
import java.net.InetAddress;
import java.util.Collection;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import org.apache.cassandra.db.SystemKeyspace;
import org.apache.cassandra.dht.Range;
import org.apache.cassandra.dht.Token;
import org.apache.cassandra.gms.FailureDetector;
import org.apache.cassandra.net.IAsyncCallbackWithFailure;
import org.apache.cassandra.net.MessageIn;
import org.apache.cassandra.net.MessagingService;
import org.apache.cassandra.repair.messages.AnticompactionRequest;
import org.apache.cassandra.utils.CassandraVersion;
import org.cassandraunit.shaded.com.google.common.util.concurrent.AbstractFuture;

public class AnticompactionTask
extends AbstractFuture<InetAddress>
implements Runnable {
    private static final CassandraVersion VERSION_CHECKER = new CassandraVersion("2.1.5");
    private final UUID parentSession;
    private final InetAddress neighbor;
    private final Collection<Range<Token>> successfulRanges;

    public AnticompactionTask(UUID parentSession, InetAddress neighbor, Collection<Range<Token>> successfulRanges) {
        this.parentSession = parentSession;
        this.neighbor = neighbor;
        this.successfulRanges = successfulRanges;
    }

    @Override
    public void run() {
        if (FailureDetector.instance.isAlive(this.neighbor)) {
            AnticompactionRequest acr = new AnticompactionRequest(this.parentSession, this.successfulRanges);
            CassandraVersion peerVersion = SystemKeyspace.getReleaseVersion(this.neighbor);
            if (peerVersion != null && peerVersion.compareTo(VERSION_CHECKER) > 0) {
                MessagingService.instance().sendRR(acr.createMessage(), this.neighbor, new AnticompactionCallback(this), TimeUnit.DAYS.toMillis(1L), true);
            } else {
                MessagingService.instance().sendOneWay(acr.createMessage(), this.neighbor);
                this.set(this.neighbor);
            }
        } else {
            this.setException(new IOException(this.neighbor + " is down"));
        }
    }

    public static class AnticompactionCallback
    implements IAsyncCallbackWithFailure {
        final AnticompactionTask task;

        public AnticompactionCallback(AnticompactionTask task) {
            this.task = task;
        }

        @Override
        public void response(MessageIn msg) {
            this.task.set(msg.from);
        }

        @Override
        public boolean isLatencyForSnitch() {
            return false;
        }

        @Override
        public void onFailure(InetAddress from) {
            this.task.setException(new RuntimeException("Anticompaction failed or timed out in " + from));
        }
    }
}

