/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.schema;

import java.util.AbstractCollection;
import java.util.Iterator;
import java.util.Optional;
import javax.annotation.Nullable;
import org.apache.cassandra.config.CFMetaData;
import org.apache.cassandra.config.ViewDefinition;
import org.cassandraunit.shaded.com.google.common.collect.ImmutableCollection;
import org.cassandraunit.shaded.com.google.common.collect.ImmutableMap;
import org.cassandraunit.shaded.com.google.common.collect.Iterables;
import org.cassandraunit.shaded.com.google.common.collect.MapDifference;
import org.cassandraunit.shaded.com.google.common.collect.Maps;

public final class Views
implements Iterable<ViewDefinition> {
    private final ImmutableMap<String, ViewDefinition> views;

    private Views(Builder builder) {
        this.views = builder.views.build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static Views none() {
        return Views.builder().build();
    }

    @Override
    public Iterator<ViewDefinition> iterator() {
        return ((ImmutableCollection)this.views.values()).iterator();
    }

    public Iterable<CFMetaData> metadatas() {
        return Iterables.transform(this.views.values(), view -> view.metadata);
    }

    public int size() {
        return this.views.size();
    }

    public boolean isEmpty() {
        return this.views.isEmpty();
    }

    public Optional<ViewDefinition> get(String name) {
        return Optional.ofNullable(this.views.get(name));
    }

    @Nullable
    public ViewDefinition getNullable(String name) {
        return this.views.get(name);
    }

    public Views with(ViewDefinition view) {
        if (this.get(view.viewName).isPresent()) {
            throw new IllegalStateException(String.format("Materialized View %s already exists", view.viewName));
        }
        return Views.builder().add(this).add(view).build();
    }

    public Views without(String name) {
        ViewDefinition materializedView = this.get(name).orElseThrow(() -> new IllegalStateException(String.format("Materialized View %s doesn't exists", name)));
        return Views.builder().add(Iterables.filter(this, v -> v != materializedView)).build();
    }

    public Views replace(ViewDefinition view, CFMetaData cfm) {
        return this.without(view.viewName).with(view);
    }

    MapDifference<String, ViewDefinition> diff(Views other) {
        return Maps.difference(this.views, other.views);
    }

    public boolean equals(Object o) {
        return this == o || o instanceof Views && this.views.equals(((Views)o).views);
    }

    public int hashCode() {
        return this.views.hashCode();
    }

    public String toString() {
        return ((AbstractCollection)this.views.values()).toString();
    }

    public static final class Builder {
        final ImmutableMap.Builder<String, ViewDefinition> views = new ImmutableMap.Builder();

        private Builder() {
        }

        public Views build() {
            return new Views(this);
        }

        public Builder add(ViewDefinition view) {
            this.views.put(view.viewName, view);
            return this;
        }

        public Builder add(Iterable<ViewDefinition> views) {
            views.forEach(this::add);
            return this;
        }
    }
}

