/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.tools.nodetool;

import io.airlift.command.Arguments;
import io.airlift.command.Command;
import java.net.InetAddress;
import java.util.ArrayList;
import java.util.List;
import org.apache.cassandra.tools.NodeProbe;
import org.apache.cassandra.tools.NodeTool;
import org.cassandraunit.shaded.com.google.common.base.Preconditions;

@Command(name="getendpoints", description="Print the end points that owns the key")
public class GetEndpoints
extends NodeTool.NodeToolCmd {
    @Arguments(usage="<keyspace> <table> <key>", description="The keyspace, the table, and the partition key for which we need to find the endpoint")
    private List<String> args = new ArrayList<String>();

    @Override
    public void execute(NodeProbe probe) {
        Preconditions.checkArgument(this.args.size() == 3, "getendpoints requires keyspace, table and partition key arguments");
        String ks = this.args.get(0);
        String table = this.args.get(1);
        String key = this.args.get(2);
        List<InetAddress> endpoints = probe.getEndpoints(ks, table, key);
        for (InetAddress endpoint : endpoints) {
            System.out.println(endpoint.getHostAddress());
        }
    }
}

