/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.tools.nodetool;

import io.airlift.command.Arguments;
import io.airlift.command.Command;
import io.airlift.command.Option;
import java.util.ArrayList;
import java.util.List;
import org.apache.cassandra.tools.NodeProbe;
import org.apache.cassandra.tools.NodeTool;
import org.cassandraunit.shaded.com.google.common.base.Preconditions;

@Command(name="getsstables", description="Print the sstable filenames that own the key")
public class GetSSTables
extends NodeTool.NodeToolCmd {
    @Option(title="hex_format", name={"-hf", "--hex-format"}, description="Specify the key in hexadecimal string format")
    private boolean hexFormat = false;
    @Arguments(usage="<keyspace> <cfname> <key>", description="The keyspace, the column family, and the key")
    private List<String> args = new ArrayList<String>();

    @Override
    public void execute(NodeProbe probe) {
        Preconditions.checkArgument(this.args.size() == 3, "getsstables requires ks, cf and key args");
        String ks = this.args.get(0);
        String cf = this.args.get(1);
        String key = this.args.get(2);
        List<String> sstables = probe.getSSTables(ks, cf, key, this.hexFormat);
        for (String sstable : sstables) {
            System.out.println(sstable);
        }
    }
}

