/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.tracing;

import java.net.InetAddress;
import java.util.Collections;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import org.apache.cassandra.concurrent.Stage;
import org.apache.cassandra.concurrent.StageManager;
import org.apache.cassandra.db.ConsistencyLevel;
import org.apache.cassandra.db.Mutation;
import org.apache.cassandra.exceptions.OverloadedException;
import org.apache.cassandra.service.StorageProxy;
import org.apache.cassandra.tracing.TraceKeyspace;
import org.apache.cassandra.tracing.TraceState;
import org.apache.cassandra.tracing.Tracing;
import org.apache.cassandra.utils.JVMStabilityInspector;
import org.apache.cassandra.utils.WrappedRunnable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TraceStateImpl
extends TraceState {
    private static final Logger logger = LoggerFactory.getLogger(TraceStateImpl.class);
    private static final int WAIT_FOR_PENDING_EVENTS_TIMEOUT_SECS = Integer.valueOf(System.getProperty("cassandra.wait_for_tracing_events_timeout_secs", "1"));

    public TraceStateImpl(InetAddress coordinator, UUID sessionId, Tracing.TraceType traceType) {
        super(coordinator, sessionId, traceType);
    }

    @Override
    protected void traceImpl(String message) {
        String threadName = Thread.currentThread().getName();
        int elapsed = this.elapsed();
        TraceStateImpl.executeMutation(TraceKeyspace.makeEventMutation(this.sessionIdBytes, message, elapsed, threadName, this.ttl));
        if (logger.isTraceEnabled()) {
            logger.trace("Adding <{}> to trace events", (Object)message);
        }
    }

    @Override
    protected void waitForPendingEvents() {
        if (WAIT_FOR_PENDING_EVENTS_TIMEOUT_SECS <= 0) {
            return;
        }
        try {
            if (logger.isTraceEnabled()) {
                logger.trace("Waiting for up to {} seconds for trace events to complete", (Object)WAIT_FOR_PENDING_EVENTS_TIMEOUT_SECS);
            }
            StageManager.getStage(Stage.TRACING).submit(StageManager.NO_OP_TASK).get(WAIT_FOR_PENDING_EVENTS_TIMEOUT_SECS, TimeUnit.SECONDS);
        }
        catch (Throwable t) {
            JVMStabilityInspector.inspectThrowable(t);
            logger.debug("Failed to wait for tracing events to complete: {}", t);
        }
    }

    static void executeMutation(final Mutation mutation) {
        StageManager.getStage(Stage.TRACING).execute(new WrappedRunnable(){

            @Override
            protected void runMayThrow() {
                TraceStateImpl.mutateWithCatch(mutation);
            }
        });
    }

    static void mutateWithCatch(Mutation mutation) {
        try {
            StorageProxy.mutate(Collections.singletonList(mutation), ConsistencyLevel.ANY);
        }
        catch (OverloadedException e) {
            Tracing.logger.warn("Too many nodes are overloaded to save trace events");
        }
    }
}

