/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.utils;

import org.apache.cassandra.utils.BloomFilterSerializer;
import org.apache.cassandra.utils.FBUtilities;
import org.apache.cassandra.utils.IFilter;
import org.apache.cassandra.utils.concurrent.Ref;
import org.apache.cassandra.utils.concurrent.WrappedSharedCloseable;
import org.apache.cassandra.utils.obs.IBitSet;
import org.cassandraunit.shaded.com.google.common.annotations.VisibleForTesting;
import org.cassandraunit.shaded.io.netty.util.concurrent.FastThreadLocal;

public class BloomFilter
extends WrappedSharedCloseable
implements IFilter {
    private static final FastThreadLocal<long[]> reusableIndexes = new FastThreadLocal<long[]>(){

        @Override
        protected long[] initialValue() {
            return new long[21];
        }
    };
    public final IBitSet bitset;
    public final int hashCount;
    public final boolean oldBfHashOrder;

    BloomFilter(int hashCount, IBitSet bitset, boolean oldBfHashOrder) {
        super(bitset);
        this.hashCount = hashCount;
        this.bitset = bitset;
        this.oldBfHashOrder = oldBfHashOrder;
    }

    private BloomFilter(BloomFilter copy) {
        super(copy);
        this.hashCount = copy.hashCount;
        this.bitset = copy.bitset;
        this.oldBfHashOrder = copy.oldBfHashOrder;
    }

    @Override
    public long serializedSize() {
        return BloomFilterSerializer.serializedSize(this);
    }

    @VisibleForTesting
    public long[] getHashBuckets(IFilter.FilterKey key, int hashCount, long max) {
        long[] hash = new long[2];
        key.filterHash(hash);
        long[] indexes = new long[hashCount];
        this.setIndexes(hash[1], hash[0], hashCount, max, indexes);
        return indexes;
    }

    private long[] indexes(IFilter.FilterKey key) {
        long[] indexes = reusableIndexes.get();
        key.filterHash(indexes);
        this.setIndexes(indexes[1], indexes[0], this.hashCount, this.bitset.capacity(), indexes);
        return indexes;
    }

    private void setIndexes(long base, long inc, int count, long max, long[] results) {
        if (this.oldBfHashOrder) {
            long x = inc;
            inc = base;
            base = x;
        }
        for (int i = 0; i < count; ++i) {
            results[i] = FBUtilities.abs(base % max);
            base += inc;
        }
    }

    @Override
    public void add(IFilter.FilterKey key) {
        long[] indexes = this.indexes(key);
        for (int i = 0; i < this.hashCount; ++i) {
            this.bitset.set(indexes[i]);
        }
    }

    @Override
    public final boolean isPresent(IFilter.FilterKey key) {
        long[] indexes = this.indexes(key);
        for (int i = 0; i < this.hashCount; ++i) {
            if (this.bitset.get(indexes[i])) continue;
            return false;
        }
        return true;
    }

    @Override
    public void clear() {
        this.bitset.clear();
    }

    @Override
    public IFilter sharedCopy() {
        return new BloomFilter(this);
    }

    @Override
    public long offHeapSize() {
        return this.bitset.offHeapSize();
    }

    public String toString() {
        return "BloomFilter[hashCount=" + this.hashCount + ";oldBfHashOrder=" + this.oldBfHashOrder + ";capacity=" + this.bitset.capacity() + ']';
    }

    @Override
    public void addTo(Ref.IdentityCollection identities) {
        super.addTo(identities);
        this.bitset.addTo(identities);
    }
}

