/*
 * Decompiled with CFR 0.152.
 */
package org.cassandraunit.shaded.io.netty.channel;

import java.util.concurrent.ThreadFactory;
import org.cassandraunit.shaded.io.netty.channel.Channel;
import org.cassandraunit.shaded.io.netty.channel.ChannelFuture;
import org.cassandraunit.shaded.io.netty.channel.ChannelPromise;
import org.cassandraunit.shaded.io.netty.channel.EventLoop;
import org.cassandraunit.shaded.io.netty.channel.EventLoopGroup;
import org.cassandraunit.shaded.io.netty.util.concurrent.DefaultThreadFactory;
import org.cassandraunit.shaded.io.netty.util.concurrent.MultithreadEventExecutorGroup;
import org.cassandraunit.shaded.io.netty.util.internal.SystemPropertyUtil;
import org.cassandraunit.shaded.io.netty.util.internal.logging.InternalLogger;
import org.cassandraunit.shaded.io.netty.util.internal.logging.InternalLoggerFactory;

public abstract class MultithreadEventLoopGroup
extends MultithreadEventExecutorGroup
implements EventLoopGroup {
    private static final InternalLogger logger = InternalLoggerFactory.getInstance(MultithreadEventLoopGroup.class);
    private static final int DEFAULT_EVENT_LOOP_THREADS = Math.max(1, SystemPropertyUtil.getInt("org.cassandraunit.shaded.io.netty.eventLoopThreads", Runtime.getRuntime().availableProcessors() * 2));

    protected MultithreadEventLoopGroup(int nThreads, ThreadFactory threadFactory, Object ... args) {
        super(nThreads == 0 ? DEFAULT_EVENT_LOOP_THREADS : nThreads, threadFactory, args);
    }

    @Override
    protected ThreadFactory newDefaultThreadFactory() {
        return new DefaultThreadFactory(this.getClass(), 10);
    }

    @Override
    public EventLoop next() {
        return (EventLoop)super.next();
    }

    @Override
    public ChannelFuture register(Channel channel) {
        return this.next().register(channel);
    }

    @Override
    public ChannelFuture register(Channel channel, ChannelPromise promise) {
        return this.next().register(channel, promise);
    }

    static {
        if (logger.isDebugEnabled()) {
            logger.debug("-Dio.netty.eventLoopThreads: {}", (Object)DEFAULT_EVENT_LOOP_THREADS);
        }
    }
}

