/*
 * Decompiled with CFR 0.152.
 */
package org.cassandraunit.shaded.org.apache.cassandra.thrift;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.SocketException;
import org.apache.thrift.transport.TIOStreamTransport;
import org.apache.thrift.transport.TTransportException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TCustomSocket
extends TIOStreamTransport {
    private static final Logger LOGGER = LoggerFactory.getLogger((String)TCustomSocket.class.getName());
    private Socket socket = null;
    private String host = null;
    private int port = 0;
    private int timeout = 0;

    public TCustomSocket(Socket socket) throws TTransportException {
        this.socket = socket;
        try {
            socket.setSoLinger(false, 0);
            socket.setTcpNoDelay(true);
        }
        catch (SocketException sx) {
            LOGGER.warn("Could not configure socket.", (Throwable)sx);
        }
        if (this.isOpen()) {
            try {
                this.inputStream_ = new BufferedInputStream(socket.getInputStream(), 1024);
                this.outputStream_ = new BufferedOutputStream(socket.getOutputStream(), 1024);
            }
            catch (IOException iox) {
                this.close();
                throw new TTransportException(1, (Throwable)iox);
            }
        }
    }

    public TCustomSocket(String host, int port) {
        this(host, port, 0);
    }

    public TCustomSocket(String host, int port, int timeout) {
        this.host = host;
        this.port = port;
        this.timeout = timeout;
        this.initSocket();
    }

    private void initSocket() {
        this.socket = new Socket();
        try {
            this.socket.setSoLinger(false, 0);
            this.socket.setTcpNoDelay(true);
            this.socket.setSoTimeout(this.timeout);
        }
        catch (SocketException sx) {
            LOGGER.error("Could not configure socket.", (Throwable)sx);
        }
    }

    public void setTimeout(int timeout) {
        this.timeout = timeout;
        try {
            this.socket.setSoTimeout(timeout);
        }
        catch (SocketException sx) {
            LOGGER.warn("Could not set socket timeout.", (Throwable)sx);
        }
    }

    public Socket getSocket() {
        if (this.socket == null) {
            this.initSocket();
        }
        return this.socket;
    }

    public boolean isOpen() {
        if (this.socket == null) {
            return false;
        }
        return this.socket.isConnected();
    }

    public void open() throws TTransportException {
        if (this.isOpen()) {
            throw new TTransportException(2, "Socket already connected.");
        }
        if (this.host.length() == 0) {
            throw new TTransportException(1, "Cannot open null host.");
        }
        if (this.port <= 0) {
            throw new TTransportException(1, "Cannot open without port.");
        }
        if (this.socket == null) {
            this.initSocket();
        }
        try {
            this.socket.connect(new InetSocketAddress(this.host, this.port), this.timeout);
            this.inputStream_ = new BufferedInputStream(this.socket.getInputStream(), 1024);
            this.outputStream_ = new BufferedOutputStream(this.socket.getOutputStream(), 1024);
        }
        catch (IOException iox) {
            this.close();
            throw new TTransportException(1, (Throwable)iox);
        }
    }

    public void close() {
        super.close();
        if (this.socket != null) {
            try {
                this.socket.close();
            }
            catch (IOException iox) {
                LOGGER.warn("Could not close socket.", (Throwable)iox);
            }
            this.socket = null;
        }
    }
}

