/*
 * Decompiled with CFR 0.152.
 */
package org.cassandraunit.shaded.org.apache.cassandra.thrift;

import java.util.Collections;
import java.util.Map;
import java.util.Set;
import org.apache.thrift.transport.TFramedTransport;
import org.apache.thrift.transport.TSocket;
import org.apache.thrift.transport.TTransport;
import org.apache.thrift.transport.TTransportException;
import org.cassandraunit.shaded.org.apache.cassandra.thrift.ITransportFactory;

public class TFramedTransportFactory
implements ITransportFactory {
    private static final String THRIFT_FRAMED_TRANSPORT_SIZE_IN_MB = "cassandra.thrift.framed.size_mb";
    private int thriftFramedTransportSizeMb = 15;

    @Override
    public TTransport openTransport(String host, int port) throws TTransportException {
        TSocket socket = new TSocket(host, port);
        TFramedTransport transport = new TFramedTransport((TTransport)socket, this.thriftFramedTransportSizeMb * 1024 * 1024);
        transport.open();
        return transport;
    }

    @Override
    public void setOptions(Map<String, String> options) {
        if (options.containsKey(THRIFT_FRAMED_TRANSPORT_SIZE_IN_MB)) {
            this.thriftFramedTransportSizeMb = Integer.parseInt(options.get(THRIFT_FRAMED_TRANSPORT_SIZE_IN_MB));
        }
    }

    @Override
    public Set<String> supportedOptions() {
        return Collections.singleton(THRIFT_FRAMED_TRANSPORT_SIZE_IN_MB);
    }
}

