/*
 * Decompiled with CFR 0.152.
 */
package org.cassandraunit.dataset.cql;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.cassandraunit.dataset.CQLDataSet;
import org.cassandraunit.dataset.ParseException;
import org.cassandraunit.dataset.cql.SimpleCQLLexer;

public abstract class AbstractCQLDataSet
implements CQLDataSet {
    public static final String END_OF_STATEMENT_DELIMITER = ";";
    private String dataSetLocation = null;
    private String keyspaceName = null;
    private boolean keyspaceCreation = true;
    private boolean keyspaceDeletion = true;

    public AbstractCQLDataSet(String dataSetLocation) {
        this.dataSetLocation = dataSetLocation;
    }

    public AbstractCQLDataSet(String dataSetLocation, boolean keyspaceCreation, boolean keyspaceDeletion) {
        this(dataSetLocation, keyspaceCreation, keyspaceDeletion, null);
    }

    public AbstractCQLDataSet(String dataSetLocation, String keyspaceName) {
        this(dataSetLocation, true, true, keyspaceName);
    }

    public AbstractCQLDataSet(String dataSetLocation, boolean keyspaceCreation, boolean keyspaceDeletion, String keyspaceName) {
        if (this.getInputDataSetLocation(dataSetLocation) == null) {
            throw new ParseException("Dataset not found");
        }
        this.dataSetLocation = dataSetLocation;
        this.keyspaceCreation = keyspaceCreation;
        this.keyspaceDeletion = keyspaceDeletion;
        if (keyspaceName != null) {
            this.keyspaceName = keyspaceName.toLowerCase();
        }
    }

    protected abstract InputStream getInputDataSetLocation(String var1);

    @Override
    public List<String> getCQLStatements() {
        List<String> lines = this.getLines();
        return this.linesToCQLStatements(lines);
    }

    private List<String> linesToCQLStatements(List<String> lines) {
        SimpleCQLLexer lexer = new SimpleCQLLexer(lines);
        return lexer.getStatements();
    }

    public List<String> getLines() {
        InputStream inputStream = this.getInputDataSetLocation(this.dataSetLocation);
        InputStreamReader inputStreamReader = new InputStreamReader(inputStream);
        BufferedReader br = new BufferedReader(inputStreamReader);
        ArrayList<String> cqlQueries = new ArrayList<String>();
        try {
            String line;
            while ((line = br.readLine()) != null) {
                if (!StringUtils.isNotBlank((String)line)) continue;
                cqlQueries.add(line);
            }
            br.close();
            return cqlQueries;
        }
        catch (IOException e) {
            throw new ParseException(e);
        }
    }

    @Override
    public String getKeyspaceName() {
        return this.keyspaceName;
    }

    @Override
    public boolean isKeyspaceCreation() {
        return this.keyspaceCreation;
    }

    @Override
    public boolean isKeyspaceDeletion() {
        return this.keyspaceDeletion;
    }
}

