/*
 * Decompiled with CFR 0.152.
 */
package org.cassandraunit;

import com.datastax.driver.core.SocketOptions;
import org.cassandraunit.utils.EmbeddedCassandraServerHelper;
import org.junit.rules.ExternalResource;

public abstract class BaseCassandraUnit
extends ExternalResource {
    protected String configurationFileName;
    protected long startupTimeoutMillis;
    protected int readTimeoutMillis = 12000;

    public BaseCassandraUnit() {
        this(10000L);
    }

    public BaseCassandraUnit(long startupTimeoutMillis) {
        this.startupTimeoutMillis = startupTimeoutMillis;
    }

    protected void before() throws Exception {
        if (this.configurationFileName != null) {
            EmbeddedCassandraServerHelper.startEmbeddedCassandra(this.configurationFileName, this.startupTimeoutMillis);
        } else {
            EmbeddedCassandraServerHelper.startEmbeddedCassandra(this.startupTimeoutMillis);
        }
        this.load();
    }

    protected abstract void load();

    protected SocketOptions getSocketOptions() {
        SocketOptions socketOptions = new SocketOptions();
        socketOptions.setReadTimeoutMillis(this.readTimeoutMillis);
        return socketOptions;
    }
}

