/*
 * Decompiled with CFR 0.152.
 */
package org.catools.sql;

import java.math.BigDecimal;
import java.sql.CallableStatement;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.function.Predicate;
import javax.sql.DataSource;
import org.apache.commons.lang3.ArrayUtils;
import org.catools.common.collections.CHashMap;
import org.catools.common.collections.CList;
import org.catools.common.utils.CRetry;
import org.catools.common.utils.CStringUtil;
import org.slf4j.Logger;
import org.springframework.dao.EmptyResultDataAccessException;
import org.springframework.jdbc.core.CallableStatementCreator;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.jdbc.core.SqlParameter;
import org.springframework.jdbc.core.namedparam.MapSqlParameterSource;
import org.springframework.jdbc.core.namedparam.NamedParameterJdbcTemplate;
import org.springframework.jdbc.core.namedparam.SqlParameterSource;

public class CSqlDataSource {
    private static final CHashMap<String, DataSource> dataSourcesMap = new CHashMap();

    public static void addDataSource(String sourceName, DataSource dbSource) {
        dataSourcesMap.put((Object)sourceName, (Object)dbSource);
    }

    public static void query(Logger logger, String sql, String dbSource) {
        CSqlDataSource.doAction(logger, "query", dbSource, sql, "", (NamedParameterJdbcTemplate jdbcTemplate) -> {
            jdbcTemplate.getJdbcOperations().execute(sql);
            return "";
        });
    }

    public static void delete(Logger logger, String sql, String dbSource) {
        CSqlDataSource.doAction(logger, "delete", dbSource, sql, "", (NamedParameterJdbcTemplate jdbcTemplate) -> {
            jdbcTemplate.getJdbcOperations().execute(sql);
            return "";
        });
    }

    public static int update(Logger logger, String sql, String dbSource) {
        return CSqlDataSource.doAction(logger, "update", dbSource, sql, "", (NamedParameterJdbcTemplate jdbcTemplate) -> jdbcTemplate.update(sql, (SqlParameterSource)new MapSqlParameterSource()));
    }

    public static int update(Logger logger, String sql, MapSqlParameterSource paramSource, String dbSource) {
        return CSqlDataSource.doAction(logger, "update", dbSource, sql, paramSource, (NamedParameterJdbcTemplate jdbcTemplate) -> jdbcTemplate.update(sql, (SqlParameterSource)paramSource));
    }

    public static int insert(Logger logger, String sql, String dbSource) {
        return CSqlDataSource.doAction(logger, "insert", dbSource, sql, "", (NamedParameterJdbcTemplate jdbcTemplate) -> jdbcTemplate.update(sql, (SqlParameterSource)new MapSqlParameterSource()));
    }

    public static int insert(Logger logger, String sql, MapSqlParameterSource paramSource, String dbSource) {
        return CSqlDataSource.doAction(logger, "insert", dbSource, sql, paramSource, (NamedParameterJdbcTemplate jdbcTemplate) -> jdbcTemplate.update(sql, (SqlParameterSource)paramSource));
    }

    public static void query(Logger logger, String sql, MapSqlParameterSource paramSource, String dbSource) {
        CSqlDataSource.doAction(logger, "query", dbSource, sql, paramSource, (NamedParameterJdbcTemplate jdbcTemplate) -> {
            jdbcTemplate.queryForObject(sql, (SqlParameterSource)paramSource, Object.class);
            return "";
        });
    }

    public static CHashMap<String, Object> call(Logger logger, CallableStatementCreator statement, List<SqlParameter> params, String dbSource) {
        return CSqlDataSource.doAction(logger, "get", dbSource, statement.toString(), params.toString(), (NamedParameterJdbcTemplate jdbcTemplate) -> {
            try {
                Map result = jdbcTemplate.getJdbcOperations().call(statement, params);
                CSqlDataSource.logTrace(logger, "Result: " + result);
                return new CHashMap(result);
            }
            catch (EmptyResultDataAccessException e) {
                return new CHashMap();
            }
        });
    }

    public static CHashMap<String, Object> call(Logger logger, CallableStatementCreator statement, String dbSource) {
        return CSqlDataSource.call(logger, statement, new ArrayList<SqlParameter>(), dbSource);
    }

    public static String queryWithReturn(Logger logger, String sql, String dbSource) {
        return CSqlDataSource.doAction(logger, "queryWithReturn", dbSource, sql, "", (NamedParameterJdbcTemplate jdbcTemplate) -> {
            String output = (String)jdbcTemplate.getJdbcOperations().execute(connection -> {
                CallableStatement statementCreator = connection.prepareCall(sql);
                statementCreator.registerOutParameter(1, 12);
                return statementCreator;
            }, callablestatement -> {
                callablestatement.executeUpdate();
                return (String)callablestatement.getObject(1);
            });
            CSqlDataSource.logTrace(logger, "query returned value is " + output);
            return output;
        });
    }

    private static <R> R doAction(Logger logger, String actionName, String dbSource, String sql, SqlParameterSource paramSource, Function<NamedParameterJdbcTemplate, R> action) {
        return CSqlDataSource.doAction(logger, actionName, dbSource, sql, paramSource == null ? "" : paramSource.toString(), action);
    }

    private static <R> R doAction(Logger logger, String actionName, String dbSource, String sql, MapSqlParameterSource parameters, Function<NamedParameterJdbcTemplate, R> action) {
        return CSqlDataSource.doAction(logger, actionName, dbSource, sql, parameters == null ? "" : parameters.getValues().toString(), action);
    }

    private static <R> R doAction(Logger logger, String actionName, String dbSource, String sql, String parameters, Function<NamedParameterJdbcTemplate, R> action) {
        if (dataSourcesMap.size() == 0) {
            throw new IndexOutOfBoundsException("No connection available.\nPlease use CSqlDataSource.addDataSource to add new datasource.");
        }
        if (CStringUtil.isNotBlank((CharSequence)parameters)) {
            CSqlDataSource.logTrace(logger, actionName + " on " + dbSource + " => " + sql + " with parameters " + parameters);
        } else {
            CSqlDataSource.logTrace(logger, actionName + " on " + dbSource + " => " + sql);
        }
        try {
            return action.apply(new NamedParameterJdbcTemplate((DataSource)dataSourcesMap.get((Object)dbSource)));
        }
        catch (Throwable t) {
            if (logger != null) {
                logger.error("Failed to Perform " + actionName + " against " + dbSource, t);
            }
            throw t;
        }
    }

    private static <R> R doWithRetry(Function<Integer, R> m, Predicate<R> retryCondition, int retryCount, int interval, R orElse) {
        return (R)CRetry.retryIf(m, retryCondition, (int)retryCount, (int)interval, () -> orElse, (boolean)true);
    }

    private static void logTrace(Logger logger, String msg) {
        if (logger != null) {
            logger.trace(msg);
        }
    }

    public static class Wait {
        public static CHashMap<String, Object> wait(Logger logger, CallableStatementCreator statement, List<SqlParameter> params, String dbSource, Predicate<CHashMap<String, Object>> retryCondition, int retryCount, int interval) {
            return CSqlDataSource.doWithRetry(integer -> CSqlDataSource.call(logger, statement, params, dbSource), retryCondition, retryCount, interval, null);
        }

        public static CHashMap<String, Object> wait(Logger logger, CallableStatementCreator statement, List<SqlParameter> params, String dbSource, Predicate<CHashMap<String, Object>> retryCondition, int retryCount, int interval, CHashMap<String, Object> orElse) {
            return CSqlDataSource.doWithRetry(integer -> CSqlDataSource.call(logger, statement, params, dbSource), retryCondition, retryCount, interval, orElse);
        }

        public static CHashMap<String, Object> wait(Logger logger, CallableStatementCreator statement, String dbSource, Predicate<CHashMap<String, Object>> retryCondition, int retryCount, int interval) {
            return CSqlDataSource.doWithRetry(integer -> CSqlDataSource.call(logger, statement, dbSource), retryCondition, retryCount, interval, null);
        }

        public static CHashMap<String, Object> wait(Logger logger, CallableStatementCreator statement, String dbSource, Predicate<CHashMap<String, Object>> retryCondition, int retryCount, int interval, CHashMap<String, Object> orElse) {
            return CSqlDataSource.doWithRetry(integer -> CSqlDataSource.call(logger, statement, dbSource), retryCondition, retryCount, interval, orElse);
        }
    }

    public static class Batch {
        public static CList<Integer> update(Logger logger, List<String> batches, String dbSource) {
            return Batch.update(logger, batches, 500, dbSource);
        }

        public static CList<Integer> update(Logger logger, List<String> batches, int partitionSize, String dbSource) {
            return CSqlDataSource.doAction(logger, "batchUpdate", dbSource, CStringUtil.join(batches, (String)"\n"), "", jdbcTemplate -> {
                CList output = new CList();
                for (CList partition : new CList((Iterable)batches).partition(partitionSize)) {
                    output.addAll(Arrays.asList(ArrayUtils.toObject((int[])jdbcTemplate.getJdbcOperations().batchUpdate((String[])partition.toArray((Object[])new String[partition.size()])))));
                }
                return output;
            });
        }

        public static CList<Integer> update(Logger logger, String sql, List<MapSqlParameterSource> parameters, String dbSource) {
            return Batch.update(logger, sql, parameters, 500, dbSource);
        }

        public static CList<Integer> update(Logger logger, String sql, List<MapSqlParameterSource> parameters, int partitionSize, String dbSource) {
            CList batchValues = new CList(parameters).mapToList(p -> p.getValues());
            return CSqlDataSource.doAction(logger, "batchUpdate", dbSource, sql, CStringUtil.join((Iterable)batchValues, (String)"\n"), jdbcTemplate -> {
                CList output = new CList();
                for (CList partition : new CList((Iterable)parameters).partition(partitionSize)) {
                    output.addAll(Arrays.asList(ArrayUtils.toObject((int[])jdbcTemplate.batchUpdate(sql, (SqlParameterSource[])partition.toArray((Object[])new MapSqlParameterSource[partition.size()])))));
                }
                return output;
            });
        }
    }

    public static class QueryBigDecimal {
        public static BigDecimal query(Logger logger, String sql, String dbSource) {
            return QueryBigDecimal.query(logger, sql, new MapSqlParameterSource(), dbSource);
        }

        public static BigDecimal query(Logger logger, String sql, MapSqlParameterSource paramSource, String dbSource) {
            return CSqlDataSource.doAction(logger, "queryForBigDecimal", dbSource, sql, paramSource, jdbcTemplate -> {
                try {
                    BigDecimal result = (BigDecimal)jdbcTemplate.queryForObject(sql, (SqlParameterSource)paramSource, BigDecimal.class);
                    CSqlDataSource.logTrace(logger, "Result: " + result);
                    return result;
                }
                catch (EmptyResultDataAccessException e) {
                    return null;
                }
            });
        }

        public static BigDecimal query(Logger logger, String sql, MapSqlParameterSource paramSource, String dbSource, Predicate<BigDecimal> retryCondition, int retryCount, int interval) {
            return CSqlDataSource.doWithRetry(integer -> QueryBigDecimal.query(logger, sql, paramSource, dbSource), retryCondition, retryCount, interval, null);
        }

        public static BigDecimal query(Logger logger, String sql, MapSqlParameterSource paramSource, String dbSource, Predicate<BigDecimal> retryCondition, int retryCount, int interval, BigDecimal orElse) {
            return CSqlDataSource.doWithRetry(integer -> QueryBigDecimal.query(logger, sql, paramSource, dbSource), retryCondition, retryCount, interval, orElse);
        }
    }

    public static class QueryDouble {
        public static Double query(Logger logger, String sql, String dbSource) {
            return QueryDouble.query(logger, sql, new MapSqlParameterSource(), dbSource);
        }

        public static Double query(Logger logger, String sql, MapSqlParameterSource paramSource, String dbSource) {
            return CSqlDataSource.doAction(logger, "queryForDouble", dbSource, sql, paramSource, jdbcTemplate -> {
                try {
                    Double result = (Double)jdbcTemplate.queryForObject(sql, (SqlParameterSource)paramSource, Double.class);
                    CSqlDataSource.logTrace(logger, "Result: " + result);
                    return result;
                }
                catch (EmptyResultDataAccessException e) {
                    return null;
                }
            });
        }

        public static Double query(Logger logger, String sql, String dbSource, Predicate<Double> retryCondition, int retryCount, int interval) {
            return CSqlDataSource.doWithRetry(integer -> QueryDouble.query(logger, sql, dbSource), retryCondition, retryCount, interval, null);
        }

        public static Double query(Logger logger, String sql, String dbSource, Predicate<Double> retryCondition, int retryCount, int interval, Double orElse) {
            return CSqlDataSource.doWithRetry(integer -> QueryDouble.query(logger, sql, dbSource), retryCondition, retryCount, interval, orElse);
        }

        public static Double query(Logger logger, String sql, MapSqlParameterSource paramSource, String dbSource, Predicate<Double> retryCondition, int retryCount, int interval) {
            return CSqlDataSource.doWithRetry(integer -> QueryDouble.query(logger, sql, paramSource, dbSource), retryCondition, retryCount, interval, null);
        }

        public static Double query(Logger logger, String sql, MapSqlParameterSource paramSource, String dbSource, Predicate<Double> retryCondition, int retryCount, int interval, Double orElse) {
            return CSqlDataSource.doWithRetry(integer -> QueryDouble.query(logger, sql, paramSource, dbSource), retryCondition, retryCount, interval, orElse);
        }
    }

    public static class QueryBlob {
        public static String queryAsString(Logger logger, String sql, String dbSource) {
            return CSqlDataSource.doAction(logger, "", dbSource, sql, "", jdbcTemplate -> {
                try {
                    return new String((byte[])QueryObject.query(logger, sql, dbSource));
                }
                catch (EmptyResultDataAccessException e) {
                    return null;
                }
            });
        }

        public static String queryAsString(Logger logger, String sql, MapSqlParameterSource paramSource, String dbSource) {
            return CSqlDataSource.doAction(logger, "queryForBlobAsString", dbSource, sql, paramSource, jdbcTemplate -> {
                try {
                    return new String((byte[])QueryObject.query(logger, sql, paramSource, dbSource));
                }
                catch (EmptyResultDataAccessException e) {
                    return null;
                }
            });
        }

        public static String queryAsString(Logger logger, String sql, String dbSource, Predicate<String> retryCondition, int retryCount, int interval) {
            return CSqlDataSource.doWithRetry(integer -> QueryString.query(logger, sql, dbSource), retryCondition, retryCount, interval, null);
        }

        public static String queryAsString(Logger logger, String sql, String dbSource, Predicate<String> retryCondition, int retryCount, int interval, String orElse) {
            return CSqlDataSource.doWithRetry(integer -> QueryString.query(logger, sql, dbSource), retryCondition, retryCount, interval, orElse);
        }

        public static String queryAsString(Logger logger, String sql, MapSqlParameterSource paramSource, String dbSource, Predicate<String> retryCondition, int retryCount, int interval) {
            return CSqlDataSource.doWithRetry(integer -> QueryString.query(logger, sql, paramSource, dbSource), retryCondition, retryCount, interval, null);
        }

        public static String queryAsString(Logger logger, String sql, MapSqlParameterSource paramSource, String dbSource, Predicate<String> retryCondition, int retryCount, int interval, String orElse) {
            return CSqlDataSource.doWithRetry(integer -> QueryString.query(logger, sql, paramSource, dbSource), retryCondition, retryCount, interval, orElse);
        }
    }

    public static class QueryObject {
        public static Object query(Logger logger, String sql, String dbSource) {
            return QueryObject.query(logger, sql, new MapSqlParameterSource(), dbSource);
        }

        public static Object query(Logger logger, String sql, MapSqlParameterSource paramSource, String dbSource) {
            return CSqlDataSource.doAction(logger, "queryForObject", dbSource, sql, paramSource, jdbcTemplate -> {
                try {
                    return jdbcTemplate.queryForObject(sql, (SqlParameterSource)paramSource, Object.class);
                }
                catch (EmptyResultDataAccessException e) {
                    return null;
                }
            });
        }

        public static <T> T query(Logger logger, String sql, RowMapper<T> rowMapper, String dbSource) {
            return QueryObject.query(logger, sql, new MapSqlParameterSource(), rowMapper, dbSource);
        }

        public static <T> T query(Logger logger, String sql, MapSqlParameterSource paramSource, RowMapper<T> rowMapper, String dbSource) {
            return (T)CSqlDataSource.doAction(logger, "queryForMap", dbSource, sql, paramSource, jdbcTemplate -> {
                try {
                    Object result = jdbcTemplate.queryForObject(sql, (SqlParameterSource)paramSource, rowMapper);
                    CSqlDataSource.logTrace(logger, "Value found: " + result.toString());
                    return result;
                }
                catch (EmptyResultDataAccessException e) {
                    return null;
                }
            });
        }

        public static <T> T query(Logger logger, String sql, RowMapper<T> rowMapper, String dbSource, Predicate<T> retryCondition, int retryCount, int interval) {
            return CSqlDataSource.doWithRetry(integer -> QueryObject.query(logger, sql, rowMapper, dbSource), retryCondition, retryCount, interval, null);
        }

        public static <T> T query(Logger logger, String sql, RowMapper<T> rowMapper, String dbSource, Predicate<T> retryCondition, int retryCount, int interval, T orElse) {
            return (T)CSqlDataSource.doWithRetry(integer -> QueryObject.query(logger, sql, rowMapper, dbSource), retryCondition, retryCount, interval, orElse);
        }

        public static <T> T query(Logger logger, String sql, MapSqlParameterSource paramSource, RowMapper<T> rowMapper, String dbSource, Predicate<T> retryCondition, int retryCount, int interval) {
            return CSqlDataSource.doWithRetry(integer -> QueryObject.query(logger, sql, paramSource, rowMapper, dbSource), retryCondition, retryCount, interval, null);
        }

        public static <T> T query(Logger logger, String sql, MapSqlParameterSource paramSource, RowMapper<T> rowMapper, String dbSource, Predicate<T> retryCondition, int retryCount, int interval, T orElse) {
            return (T)CSqlDataSource.doWithRetry(integer -> QueryObject.query(logger, sql, paramSource, rowMapper, dbSource), retryCondition, retryCount, interval, orElse);
        }
    }

    public static class QueryMap {
        public static CHashMap<String, Object> query(Logger logger, String sql, String dbSource) {
            return QueryMap.query(logger, sql, new MapSqlParameterSource(), dbSource);
        }

        public static CHashMap<String, Object> query(Logger logger, String sql, MapSqlParameterSource paramSource, String dbSource) {
            return CSqlDataSource.doAction(logger, "queryForMap", dbSource, sql, paramSource, jdbcTemplate -> {
                try {
                    Map result = jdbcTemplate.queryForMap(sql, (SqlParameterSource)paramSource);
                    CSqlDataSource.logTrace(logger, "Row found: " + result.size());
                    return new CHashMap(result);
                }
                catch (EmptyResultDataAccessException e) {
                    return new CHashMap();
                }
            });
        }

        public static CHashMap<String, Object> query(Logger logger, String sql, String dbSource, Predicate<CHashMap<String, Object>> retryCondition, int retryCount, int interval) {
            return CSqlDataSource.doWithRetry(integer -> QueryMap.query(logger, sql, dbSource), retryCondition, retryCount, interval, null);
        }

        public static CHashMap<String, Object> query(Logger logger, String sql, String dbSource, Predicate<CHashMap<String, Object>> retryCondition, int retryCount, int interval, CHashMap<String, Object> orElse) {
            return CSqlDataSource.doWithRetry(integer -> QueryMap.query(logger, sql, dbSource), retryCondition, retryCount, interval, orElse);
        }

        public static CHashMap<String, Object> query(Logger logger, String sql, MapSqlParameterSource paramSource, String dbSource, Predicate<CHashMap<String, Object>> retryCondition, int retryCount, int interval) {
            return CSqlDataSource.doWithRetry(integer -> QueryMap.query(logger, sql, paramSource, dbSource), retryCondition, retryCount, interval, null);
        }

        public static CHashMap<String, Object> query(Logger logger, String sql, MapSqlParameterSource paramSource, String dbSource, Predicate<CHashMap<String, Object>> retryCondition, int retryCount, int interval, CHashMap<String, Object> orElse) {
            return CSqlDataSource.doWithRetry(integer -> QueryMap.query(logger, sql, paramSource, dbSource), retryCondition, retryCount, interval, orElse);
        }
    }

    public static class QueryList {
        public static <T> CList<T> query(Logger logger, String sql, RowMapper<T> rowMapper, String dbSource) {
            return QueryList.query(logger, sql, new MapSqlParameterSource(), rowMapper, dbSource);
        }

        public static <T> CList<T> query(Logger logger, String sql, MapSqlParameterSource paramSource, RowMapper<T> rowMapper, String dbSource) {
            return CSqlDataSource.doAction(logger, "queryForList", dbSource, sql, paramSource, jdbcTemplate -> {
                try {
                    List result = jdbcTemplate.query(sql, (SqlParameterSource)paramSource, rowMapper);
                    CSqlDataSource.logTrace(logger, "Row found: " + result.size());
                    return new CList((Iterable)result);
                }
                catch (EmptyResultDataAccessException e) {
                    return new CList();
                }
            });
        }

        public static <T> CList<T> query(Logger logger, String sql, SqlParameterSource paramSource, RowMapper<T> rowMapper, String dbSource) {
            return CSqlDataSource.doAction(logger, "queryForList", dbSource, sql, paramSource, jdbcTemplate -> {
                try {
                    List result = jdbcTemplate.query(sql, paramSource, rowMapper);
                    CSqlDataSource.logTrace(logger, "Row found: " + result.size());
                    return new CList((Iterable)result);
                }
                catch (EmptyResultDataAccessException e) {
                    return new CList();
                }
            });
        }

        public static <T> CList<T> query(Logger logger, String sql, Class<T> elementType, String dbSource) {
            return QueryList.query(logger, sql, new MapSqlParameterSource(), elementType, dbSource);
        }

        public static <T> CList<T> query(Logger logger, String sql, MapSqlParameterSource paramSource, Class<T> elementType, String dbSource) {
            return CSqlDataSource.doAction(logger, "queryForList", dbSource, sql, paramSource, jdbcTemplate -> {
                try {
                    List result = jdbcTemplate.queryForList(sql, (SqlParameterSource)paramSource, elementType);
                    CSqlDataSource.logTrace(logger, "Row found: " + result.size());
                    return new CList((Iterable)result);
                }
                catch (EmptyResultDataAccessException e) {
                    return new CList();
                }
            });
        }

        public static <T> CList<T> query(Logger logger, String sql, SqlParameterSource paramSource, Class<T> elementType, String dbSource) {
            return CSqlDataSource.doAction(logger, "queryForList", dbSource, sql, paramSource, jdbcTemplate -> {
                try {
                    List result = jdbcTemplate.queryForList(sql, paramSource, elementType);
                    CSqlDataSource.logTrace(logger, "Row found: " + result.size());
                    return new CList((Iterable)result);
                }
                catch (EmptyResultDataAccessException e) {
                    return new CList();
                }
            });
        }

        public static CList<Map<String, Object>> query(Logger logger, String sql, String dbSource) {
            return QueryList.query(logger, sql, new MapSqlParameterSource(), dbSource);
        }

        public static CList<Map<String, Object>> query(Logger logger, String sql, MapSqlParameterSource paramSource, String dbSource) {
            return CSqlDataSource.doAction(logger, "queryForList", dbSource, sql, paramSource, jdbcTemplate -> {
                try {
                    List result = jdbcTemplate.queryForList(sql, (SqlParameterSource)paramSource);
                    CSqlDataSource.logTrace(logger, "Row found: " + result.size());
                    return new CList((Iterable)result);
                }
                catch (EmptyResultDataAccessException e) {
                    return new CList();
                }
            });
        }

        public static <T> CList<T> query(Logger logger, String sql, RowMapper<T> rowMapper, String dbSource, Predicate<CList<T>> retryCondition, int retryCount, int interval) {
            return CSqlDataSource.doWithRetry(integer -> QueryList.query(logger, sql, rowMapper, dbSource), retryCondition, retryCount, interval, null);
        }

        public static <T> CList<T> query(Logger logger, String sql, RowMapper<T> rowMapper, String dbSource, Predicate<CList<T>> retryCondition, int retryCount, int interval, CList<T> orElse) {
            return CSqlDataSource.doWithRetry(integer -> QueryList.query(logger, sql, rowMapper, dbSource), retryCondition, retryCount, interval, orElse);
        }

        public static <T> CList<T> query(Logger logger, String sql, Class<T> elementType, String dbSource, Predicate<CList<T>> retryCondition, int retryCount, int interval) {
            return CSqlDataSource.doWithRetry(integer -> QueryList.query(logger, sql, new MapSqlParameterSource(), elementType, dbSource), retryCondition, retryCount, interval, null);
        }

        public static <T> CList<T> query(Logger logger, String sql, Class<T> elementType, String dbSource, Predicate<CList<T>> retryCondition, int retryCount, int interval, CList<T> orElse) {
            return CSqlDataSource.doWithRetry(integer -> QueryList.query(logger, sql, new MapSqlParameterSource(), elementType, dbSource), retryCondition, retryCount, interval, orElse);
        }

        public static <T> CList<T> query(Logger logger, String sql, MapSqlParameterSource paramSource, RowMapper<T> rowMapper, String dbSource, Predicate<CList<T>> retryCondition, int retryCount, int interval) {
            return CSqlDataSource.doWithRetry(integer -> QueryList.query(logger, sql, paramSource, rowMapper, dbSource), retryCondition, retryCount, interval, null);
        }

        public static <T> CList<T> query(Logger logger, String sql, MapSqlParameterSource paramSource, RowMapper<T> rowMapper, String dbSource, Predicate<CList<T>> retryCondition, int retryCount, int interval, CList<T> orElse) {
            return CSqlDataSource.doWithRetry(integer -> QueryList.query(logger, sql, paramSource, rowMapper, dbSource), retryCondition, retryCount, interval, orElse);
        }

        public static <T> CList<T> query(Logger logger, String sql, MapSqlParameterSource paramSource, Class<T> elementType, String dbSource, Predicate<CList<T>> retryCondition, int retryCount, int interval) {
            return CSqlDataSource.doWithRetry(integer -> QueryList.query(logger, sql, paramSource, elementType, dbSource), retryCondition, retryCount, interval, new CList());
        }

        public static <T> CList<T> query(Logger logger, String sql, MapSqlParameterSource paramSource, Class<T> elementType, String dbSource, Predicate<CList<T>> retryCondition, int retryCount, int interval, CList<T> orElse) {
            return CSqlDataSource.doWithRetry(integer -> QueryList.query(logger, sql, paramSource, elementType, dbSource), retryCondition, retryCount, interval, orElse);
        }

        public static CList<Map<String, Object>> query(Logger logger, String sql, String dbSource, Predicate<CList<Map<String, Object>>> retryCondition, int retryCount, int interval) {
            return CSqlDataSource.doWithRetry(integer -> QueryList.query(logger, sql, dbSource), retryCondition, retryCount, interval, null);
        }

        public static CList<Map<String, Object>> query(Logger logger, String sql, String dbSource, Predicate<CList<Map<String, Object>>> retryCondition, int retryCount, int interval, CList<Map<String, Object>> orElse) {
            return CSqlDataSource.doWithRetry(integer -> QueryList.query(logger, sql, dbSource), retryCondition, retryCount, interval, orElse);
        }

        public static CList<Map<String, Object>> query(Logger logger, String sql, MapSqlParameterSource paramSource, String dbSource, Predicate<CList<Map<String, Object>>> retryCondition, int retryCount, int interval) {
            return CSqlDataSource.doWithRetry(integer -> QueryList.query(logger, sql, paramSource, dbSource), retryCondition, retryCount, interval, null);
        }

        public static CList<Map<String, Object>> query(Logger logger, String sql, MapSqlParameterSource paramSource, String dbSource, Predicate<CList<Map<String, Object>>> retryCondition, int retryCount, int interval, CList<Map<String, Object>> orElse) {
            return CSqlDataSource.doWithRetry(integer -> QueryList.query(logger, sql, paramSource, dbSource), retryCondition, retryCount, interval, orElse);
        }
    }

    public static class QueryLong {
        public static Long query(Logger logger, String sql, String dbSource) {
            return QueryLong.query(logger, sql, new MapSqlParameterSource(), dbSource);
        }

        public static Long query(Logger logger, String sql, MapSqlParameterSource paramSource, String dbSource) {
            return CSqlDataSource.doAction(logger, "queryForLong", dbSource, sql, paramSource, jdbcTemplate -> {
                try {
                    Long result = (Long)jdbcTemplate.queryForObject(sql, (SqlParameterSource)paramSource, Long.class);
                    CSqlDataSource.logTrace(logger, "Result: " + result);
                    return result;
                }
                catch (EmptyResultDataAccessException e) {
                    return null;
                }
            });
        }

        public static Long query(Logger logger, String sql, String dbSource, Predicate<Long> retryCondition, int retryCount, int interval) {
            return CSqlDataSource.doWithRetry(integer -> QueryLong.query(logger, sql, dbSource), retryCondition, retryCount, interval, null);
        }

        public static Long query(Logger logger, String sql, String dbSource, Predicate<Long> retryCondition, int retryCount, int interval, Long orElse) {
            return CSqlDataSource.doWithRetry(integer -> QueryLong.query(logger, sql, dbSource), retryCondition, retryCount, interval, orElse);
        }

        public static Long query(Logger logger, String sql, MapSqlParameterSource paramSource, String dbSource, Predicate<Long> retryCondition, int retryCount, int interval) {
            return CSqlDataSource.doWithRetry(integer -> QueryLong.query(logger, sql, paramSource, dbSource), retryCondition, retryCount, interval, null);
        }

        public static Long query(Logger logger, String sql, MapSqlParameterSource paramSource, String dbSource, Predicate<Long> retryCondition, int retryCount, int interval, Long orElse) {
            return CSqlDataSource.doWithRetry(integer -> QueryLong.query(logger, sql, paramSource, dbSource), retryCondition, retryCount, interval, orElse);
        }
    }

    public static class QueryInt {
        public static Integer query(Logger logger, String sql, String dbSource) {
            return QueryInt.query(logger, sql, new MapSqlParameterSource(), dbSource);
        }

        public static Integer query(Logger logger, String sql, MapSqlParameterSource paramSource, String dbSource) {
            return CSqlDataSource.doAction(logger, "queryForInt", dbSource, sql, paramSource, jdbcTemplate -> {
                try {
                    int result = (Integer)jdbcTemplate.queryForObject(sql, (SqlParameterSource)paramSource, Integer.class);
                    CSqlDataSource.logTrace(logger, "Result: " + result);
                    return result;
                }
                catch (EmptyResultDataAccessException e) {
                    return null;
                }
            });
        }

        public static Integer query(Logger logger, String sql, String dbSource, Predicate<Integer> retryCondition, int retryCount, int interval) {
            return CSqlDataSource.doWithRetry(integer -> QueryInt.query(logger, sql, dbSource), retryCondition, retryCount, interval, null);
        }

        public static Integer query(Logger logger, String sql, String dbSource, Predicate<Integer> retryCondition, int retryCount, int interval, Integer orElse) {
            return CSqlDataSource.doWithRetry(integer -> QueryInt.query(logger, sql, dbSource), retryCondition, retryCount, interval, orElse);
        }

        public static Integer query(Logger logger, String sql, MapSqlParameterSource paramSource, String dbSource, Predicate<Integer> retryCondition, int retryCount, int interval) {
            return CSqlDataSource.doWithRetry(integer -> QueryInt.query(logger, sql, paramSource, dbSource), retryCondition, retryCount, interval, null);
        }

        public static Integer query(Logger logger, String sql, MapSqlParameterSource paramSource, String dbSource, Predicate<Integer> retryCondition, int retryCount, int interval, Integer orElse) {
            return CSqlDataSource.doWithRetry(integer -> QueryInt.query(logger, sql, paramSource, dbSource), retryCondition, retryCount, interval, orElse);
        }
    }

    public static class QueryDate {
        public static Date query(Logger logger, String sql, String dbSource) {
            return QueryDate.query(logger, sql, new MapSqlParameterSource(), dbSource);
        }

        public static Date query(Logger logger, String sql, MapSqlParameterSource paramSource, String dbSource) {
            return CSqlDataSource.doAction(logger, "queryForDate", dbSource, sql, paramSource, jdbcTemplate -> {
                try {
                    Date result = (Date)jdbcTemplate.queryForObject(sql, (SqlParameterSource)paramSource, Date.class);
                    CSqlDataSource.logTrace(logger, "Result: " + result);
                    return result;
                }
                catch (EmptyResultDataAccessException e) {
                    return null;
                }
            });
        }

        public static Date query(Logger logger, String sql, String dbSource, Predicate<Date> retryCondition, int retryCount, int interval) {
            return CSqlDataSource.doWithRetry(integer -> QueryDate.query(logger, sql, dbSource), retryCondition, retryCount, interval, null);
        }

        public static Date query(Logger logger, String sql, String dbSource, Predicate<Date> retryCondition, int retryCount, int interval, Date orElse) {
            return CSqlDataSource.doWithRetry(integer -> QueryDate.query(logger, sql, dbSource), retryCondition, retryCount, interval, orElse);
        }

        public static Date query(Logger logger, String sql, MapSqlParameterSource paramSource, String dbSource, Predicate<Date> retryCondition, int retryCount, int interval) {
            return CSqlDataSource.doWithRetry(integer -> QueryDate.query(logger, sql, paramSource, dbSource), retryCondition, retryCount, interval, null);
        }

        public static Date query(Logger logger, String sql, MapSqlParameterSource paramSource, String dbSource, Predicate<Date> retryCondition, int retryCount, int interval, Date orElse) {
            return CSqlDataSource.doWithRetry(integer -> QueryDate.query(logger, sql, paramSource, dbSource), retryCondition, retryCount, interval, orElse);
        }
    }

    public static class QueryString {
        public static String query(Logger logger, String sql, String dbSource) {
            return QueryString.query(logger, sql, new MapSqlParameterSource(), dbSource);
        }

        public static String query(Logger logger, String sql, MapSqlParameterSource paramSource, String dbSource) {
            return CSqlDataSource.doAction(logger, "queryForString", dbSource, sql, paramSource, jdbcTemplate -> {
                try {
                    String result = (String)jdbcTemplate.queryForObject(sql, (SqlParameterSource)paramSource, String.class);
                    CSqlDataSource.logTrace(logger, "Result: " + result);
                    return result;
                }
                catch (EmptyResultDataAccessException e) {
                    return "";
                }
            });
        }

        public static String query(Logger logger, String sql, String dbSource, Predicate<String> retryCondition, int retryCount, int interval) {
            return CSqlDataSource.doWithRetry(integer -> QueryString.query(logger, sql, dbSource), retryCondition, retryCount, interval, null);
        }

        public static String query(Logger logger, String sql, String dbSource, Predicate<String> retryCondition, int retryCount, int interval, String orElse) {
            return CSqlDataSource.doWithRetry(integer -> QueryString.query(logger, sql, dbSource), retryCondition, retryCount, interval, orElse);
        }

        public static String query(Logger logger, String sql, MapSqlParameterSource paramSource, String dbSource, Predicate<String> retryCondition, int retryCount, int interval) {
            return CSqlDataSource.doWithRetry(integer -> QueryString.query(logger, sql, paramSource, dbSource), retryCondition, retryCount, interval, null);
        }

        public static String query(Logger logger, String sql, MapSqlParameterSource paramSource, String dbSource, Predicate<String> retryCondition, int retryCount, int interval, String orElse) {
            return CSqlDataSource.doWithRetry(integer -> QueryString.query(logger, sql, paramSource, dbSource), retryCondition, retryCount, interval, orElse);
        }
    }
}

