package org.cdk8s.plus;

/**
 * (experimental) A single application container that you want to run within a pod.
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.13.0 (build 385c325)", date = "2020-10-21T06:58:44.647Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
@software.amazon.jsii.Jsii(module = org.cdk8s.plus.$Module.class, fqn = "cdk8s-plus.Container")
public class Container extends software.amazon.jsii.JsiiObject {

    protected Container(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected Container(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    /**
     * @param props This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public Container(final @org.jetbrains.annotations.NotNull org.cdk8s.plus.ContainerProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(props, "props is required") });
    }

    /**
     * (experimental) Add an environment value to the container.
     * <p>
     * The variable value can come
     * from various dynamic sources such a secrets of config maps.
     * <p>
     * @see EnvValue.fromXXX
     * @param name - The variable name. This parameter is required.
     * @param value - The variable value. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public void addEnv(final @org.jetbrains.annotations.NotNull java.lang.String name, final @org.jetbrains.annotations.NotNull org.cdk8s.plus.EnvValue value) {
        this.jsiiCall("addEnv", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(name, "name is required"), java.util.Objects.requireNonNull(value, "value is required") });
    }

    /**
     * (experimental) Mount a volume to a specific path so that it is accessible by the container.
     * <p>
     * Every pod that is configured to use this container will autmoatically have access to the volume.
     * <p>
     * @param path - The desired path in the container. This parameter is required.
     * @param volume - The volume to mount. This parameter is required.
     * @param options
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public void mount(final @org.jetbrains.annotations.NotNull java.lang.String path, final @org.jetbrains.annotations.NotNull org.cdk8s.plus.Volume volume, final @org.jetbrains.annotations.Nullable org.cdk8s.plus.MountOptions options) {
        this.jsiiCall("mount", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(path, "path is required"), java.util.Objects.requireNonNull(volume, "volume is required"), options });
    }

    /**
     * (experimental) Mount a volume to a specific path so that it is accessible by the container.
     * <p>
     * Every pod that is configured to use this container will autmoatically have access to the volume.
     * <p>
     * @param path - The desired path in the container. This parameter is required.
     * @param volume - The volume to mount. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public void mount(final @org.jetbrains.annotations.NotNull java.lang.String path, final @org.jetbrains.annotations.NotNull org.cdk8s.plus.Volume volume) {
        this.jsiiCall("mount", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(path, "path is required"), java.util.Objects.requireNonNull(volume, "volume is required") });
    }

    /**
     * (experimental) The environment variables for this container.
     * <p>
     * Returns a copy. To add environment variables use <code>addEnv()</code>.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, org.cdk8s.plus.EnvValue> getEnv() {
        return java.util.Collections.unmodifiableMap(this.jsiiGet("env", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(org.cdk8s.plus.EnvValue.class))));
    }

    /**
     * (experimental) The container image.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public @org.jetbrains.annotations.NotNull java.lang.String getImage() {
        return this.jsiiGet("image", java.lang.String.class);
    }

    /**
     * (experimental) Image pull policy for this container.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public @org.jetbrains.annotations.NotNull org.cdk8s.plus.ImagePullPolicy getImagePullPolicy() {
        return this.jsiiGet("imagePullPolicy", org.cdk8s.plus.ImagePullPolicy.class);
    }

    /**
     * (experimental) Volume mounts configured for this container.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public @org.jetbrains.annotations.NotNull java.util.List<org.cdk8s.plus.VolumeMount> getMounts() {
        return java.util.Collections.unmodifiableList(this.jsiiGet("mounts", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(org.cdk8s.plus.VolumeMount.class))));
    }

    /**
     * (experimental) The name of the container.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public @org.jetbrains.annotations.NotNull java.lang.String getName() {
        return this.jsiiGet("name", java.lang.String.class);
    }

    /**
     * (experimental) Arguments to the entrypoint.
     * <p>
     * @return a copy of the arguments array, cannot be modified.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getArgs() {
        return java.util.Optional.ofNullable((java.util.List<java.lang.String>)(this.jsiiGet("args", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class))))).map(java.util.Collections::unmodifiableList).orElse(null);
    }

    /**
     * (experimental) Entrypoint array (the command to execute when the container starts).
     * <p>
     * @return a copy of the entrypoint array, cannot be modified
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getCommand() {
        return java.util.Optional.ofNullable((java.util.List<java.lang.String>)(this.jsiiGet("command", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class))))).map(java.util.Collections::unmodifiableList).orElse(null);
    }

    /**
     * (experimental) The port this container exposes.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public @org.jetbrains.annotations.Nullable java.lang.Number getPort() {
        return this.jsiiGet("port", java.lang.Number.class);
    }

    /**
     * (experimental) The working directory inside the container.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public @org.jetbrains.annotations.Nullable java.lang.String getWorkingDir() {
        return this.jsiiGet("workingDir", java.lang.String.class);
    }

    /**
     * (experimental) A fluent builder for {@link org.cdk8s.plus.Container}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public static final class Builder implements software.amazon.jsii.Builder<org.cdk8s.plus.Container> {
        /**
         * @return a new instance of {@link Builder}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public static Builder create() {
            return new Builder();
        }

        private final org.cdk8s.plus.ContainerProps.Builder props;

        private Builder() {
            this.props = new org.cdk8s.plus.ContainerProps.Builder();
        }

        /**
         * (experimental) Docker image name.
         * <p>
         * @return {@code this}
         * @param image Docker image name. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder image(final java.lang.String image) {
            this.props.image(image);
            return this;
        }

        /**
         * (experimental) Arguments to the entrypoint. The docker image's CMD is used if `command` is not provided.
         * <p>
         * Variable references $(VAR_NAME) are expanded using the container's
         * environment. If a variable cannot be resolved, the reference in the input
         * string will be unchanged. The $(VAR_NAME) syntax can be escaped with a
         * double $$, ie: $$(VAR_NAME). Escaped references will never be expanded,
         * regardless of whether the variable exists or not.
         * <p>
         * Cannot be updated.
         * <p>
         * Default: []
         * <p>
         * @return {@code this}
         * @see https://kubernetes.io/docs/tasks/inject-data-application/define-command-argument-container/#running-a-command-in-a-shell
         * @param args Arguments to the entrypoint. The docker image's CMD is used if `command` is not provided. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder args(final java.util.List<java.lang.String> args) {
            this.props.args(args);
            return this;
        }

        /**
         * (experimental) Entrypoint array.
         * <p>
         * Not executed within a shell. The docker image's ENTRYPOINT is used if this is not provided. Variable references $(VAR_NAME) are expanded using the container's environment.
         * If a variable cannot be resolved, the reference in the input string will be unchanged. The $(VAR_NAME) syntax can be escaped with a double $$, ie: $$(VAR_NAME).
         * Escaped references will never be expanded, regardless of whether the variable exists or not. Cannot be updated.
         * More info: https://kubernetes.io/docs/tasks/inject-data-application/define-command-argument-container/#running-a-command-in-a-shell
         * <p>
         * Default: - The docker image's ENTRYPOINT.
         * <p>
         * @return {@code this}
         * @param command Entrypoint array. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder command(final java.util.List<java.lang.String> command) {
            this.props.command(command);
            return this;
        }

        /**
         * (experimental) List of environment variables to set in the container.
         * <p>
         * Cannot be updated.
         * <p>
         * Default: - No environment variables.
         * <p>
         * @return {@code this}
         * @param env List of environment variables to set in the container. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder env(final java.util.Map<java.lang.String, ? extends org.cdk8s.plus.EnvValue> env) {
            this.props.env(env);
            return this;
        }

        /**
         * (experimental) Image pull policy for this container.
         * <p>
         * Default: ImagePullPolicy.ALWAYS
         * <p>
         * @return {@code this}
         * @param imagePullPolicy Image pull policy for this container. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder imagePullPolicy(final org.cdk8s.plus.ImagePullPolicy imagePullPolicy) {
            this.props.imagePullPolicy(imagePullPolicy);
            return this;
        }

        /**
         * (experimental) Name of the container specified as a DNS_LABEL.
         * <p>
         * Each container in a pod must have a unique name (DNS_LABEL). Cannot be updated.
         * <p>
         * Default: 'main'
         * <p>
         * @return {@code this}
         * @param name Name of the container specified as a DNS_LABEL. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder name(final java.lang.String name) {
            this.props.name(name);
            return this;
        }

        /**
         * (experimental) Number of port to expose on the pod's IP address.
         * <p>
         * This must be a valid port number, 0 &lt; x &lt; 65536.
         * <p>
         * Default: - No port is exposed.
         * <p>
         * @return {@code this}
         * @param port Number of port to expose on the pod's IP address. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder port(final java.lang.Number port) {
            this.props.port(port);
            return this;
        }

        /**
         * (experimental) Determines when the container is ready to serve traffic.
         * <p>
         * Default: - no readiness probe is defined
         * <p>
         * @return {@code this}
         * @param readiness Determines when the container is ready to serve traffic. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder readiness(final org.cdk8s.plus.Probe readiness) {
            this.props.readiness(readiness);
            return this;
        }

        /**
         * (experimental) Pod volumes to mount into the container's filesystem.
         * <p>
         * Cannot be updated.
         * <p>
         * @return {@code this}
         * @param volumeMounts Pod volumes to mount into the container's filesystem. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder volumeMounts(final java.util.List<? extends org.cdk8s.plus.VolumeMount> volumeMounts) {
            this.props.volumeMounts(volumeMounts);
            return this;
        }

        /**
         * (experimental) Container's working directory.
         * <p>
         * If not specified, the container runtime's default will be used, which might be configured in the container image. Cannot be updated.
         * <p>
         * Default: - The container runtime's default.
         * <p>
         * @return {@code this}
         * @param workingDir Container's working directory. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder workingDir(final java.lang.String workingDir) {
            this.props.workingDir(workingDir);
            return this;
        }

        /**
         * @returns a newly built instance of {@link org.cdk8s.plus.Container}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        @Override
        public org.cdk8s.plus.Container build() {
            return new org.cdk8s.plus.Container(
                this.props.build()
            );
        }
    }
}
