package org.cdk8s.plus;

/**
 * (experimental) Properties for creating a container.
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.13.0 (build 385c325)", date = "2020-10-21T06:58:44.649Z")
@software.amazon.jsii.Jsii(module = org.cdk8s.plus.$Module.class, fqn = "cdk8s-plus.ContainerProps")
@software.amazon.jsii.Jsii.Proxy(ContainerProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
public interface ContainerProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * (experimental) Docker image name.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    @org.jetbrains.annotations.NotNull java.lang.String getImage();

    /**
     * (experimental) Arguments to the entrypoint. The docker image's CMD is used if `command` is not provided.
     * <p>
     * Variable references $(VAR_NAME) are expanded using the container's
     * environment. If a variable cannot be resolved, the reference in the input
     * string will be unchanged. The $(VAR_NAME) syntax can be escaped with a
     * double $$, ie: $$(VAR_NAME). Escaped references will never be expanded,
     * regardless of whether the variable exists or not.
     * <p>
     * Cannot be updated.
     * <p>
     * Default: []
     * <p>
     * @see https://kubernetes.io/docs/tasks/inject-data-application/define-command-argument-container/#running-a-command-in-a-shell
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getArgs() {
        return null;
    }

    /**
     * (experimental) Entrypoint array.
     * <p>
     * Not executed within a shell. The docker image's ENTRYPOINT is used if this is not provided. Variable references $(VAR_NAME) are expanded using the container's environment.
     * If a variable cannot be resolved, the reference in the input string will be unchanged. The $(VAR_NAME) syntax can be escaped with a double $$, ie: $$(VAR_NAME).
     * Escaped references will never be expanded, regardless of whether the variable exists or not. Cannot be updated.
     * More info: https://kubernetes.io/docs/tasks/inject-data-application/define-command-argument-container/#running-a-command-in-a-shell
     * <p>
     * Default: - The docker image's ENTRYPOINT.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getCommand() {
        return null;
    }

    /**
     * (experimental) List of environment variables to set in the container.
     * <p>
     * Cannot be updated.
     * <p>
     * Default: - No environment variables.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    default @org.jetbrains.annotations.Nullable java.util.Map<java.lang.String, org.cdk8s.plus.EnvValue> getEnv() {
        return null;
    }

    /**
     * (experimental) Image pull policy for this container.
     * <p>
     * Default: ImagePullPolicy.ALWAYS
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    default @org.jetbrains.annotations.Nullable org.cdk8s.plus.ImagePullPolicy getImagePullPolicy() {
        return null;
    }

    /**
     * (experimental) Name of the container specified as a DNS_LABEL.
     * <p>
     * Each container in a pod must have a unique name (DNS_LABEL). Cannot be updated.
     * <p>
     * Default: 'main'
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    default @org.jetbrains.annotations.Nullable java.lang.String getName() {
        return null;
    }

    /**
     * (experimental) Number of port to expose on the pod's IP address.
     * <p>
     * This must be a valid port number, 0 &lt; x &lt; 65536.
     * <p>
     * Default: - No port is exposed.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    default @org.jetbrains.annotations.Nullable java.lang.Number getPort() {
        return null;
    }

    /**
     * (experimental) Determines when the container is ready to serve traffic.
     * <p>
     * Default: - no readiness probe is defined
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    default @org.jetbrains.annotations.Nullable org.cdk8s.plus.Probe getReadiness() {
        return null;
    }

    /**
     * (experimental) Pod volumes to mount into the container's filesystem.
     * <p>
     * Cannot be updated.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    default @org.jetbrains.annotations.Nullable java.util.List<org.cdk8s.plus.VolumeMount> getVolumeMounts() {
        return null;
    }

    /**
     * (experimental) Container's working directory.
     * <p>
     * If not specified, the container runtime's default will be used, which might be configured in the container image. Cannot be updated.
     * <p>
     * Default: - The container runtime's default.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    default @org.jetbrains.annotations.Nullable java.lang.String getWorkingDir() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link ContainerProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link ContainerProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public static final class Builder implements software.amazon.jsii.Builder<ContainerProps> {
        private java.lang.String image;
        private java.util.List<java.lang.String> args;
        private java.util.List<java.lang.String> command;
        private java.util.Map<java.lang.String, org.cdk8s.plus.EnvValue> env;
        private org.cdk8s.plus.ImagePullPolicy imagePullPolicy;
        private java.lang.String name;
        private java.lang.Number port;
        private org.cdk8s.plus.Probe readiness;
        private java.util.List<org.cdk8s.plus.VolumeMount> volumeMounts;
        private java.lang.String workingDir;

        /**
         * Sets the value of {@link ContainerProps#getImage}
         * @param image Docker image name. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder image(java.lang.String image) {
            this.image = image;
            return this;
        }

        /**
         * Sets the value of {@link ContainerProps#getArgs}
         * @param args Arguments to the entrypoint. The docker image's CMD is used if `command` is not provided.
         *             Variable references $(VAR_NAME) are expanded using the container's
         *             environment. If a variable cannot be resolved, the reference in the input
         *             string will be unchanged. The $(VAR_NAME) syntax can be escaped with a
         *             double $$, ie: $$(VAR_NAME). Escaped references will never be expanded,
         *             regardless of whether the variable exists or not.
         *             <p>
         *             Cannot be updated.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder args(java.util.List<java.lang.String> args) {
            this.args = args;
            return this;
        }

        /**
         * Sets the value of {@link ContainerProps#getCommand}
         * @param command Entrypoint array.
         *                Not executed within a shell. The docker image's ENTRYPOINT is used if this is not provided. Variable references $(VAR_NAME) are expanded using the container's environment.
         *                If a variable cannot be resolved, the reference in the input string will be unchanged. The $(VAR_NAME) syntax can be escaped with a double $$, ie: $$(VAR_NAME).
         *                Escaped references will never be expanded, regardless of whether the variable exists or not. Cannot be updated.
         *                More info: https://kubernetes.io/docs/tasks/inject-data-application/define-command-argument-container/#running-a-command-in-a-shell
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder command(java.util.List<java.lang.String> command) {
            this.command = command;
            return this;
        }

        /**
         * Sets the value of {@link ContainerProps#getEnv}
         * @param env List of environment variables to set in the container.
         *            Cannot be updated.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        @SuppressWarnings("unchecked")
        public Builder env(java.util.Map<java.lang.String, ? extends org.cdk8s.plus.EnvValue> env) {
            this.env = (java.util.Map<java.lang.String, org.cdk8s.plus.EnvValue>)env;
            return this;
        }

        /**
         * Sets the value of {@link ContainerProps#getImagePullPolicy}
         * @param imagePullPolicy Image pull policy for this container.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder imagePullPolicy(org.cdk8s.plus.ImagePullPolicy imagePullPolicy) {
            this.imagePullPolicy = imagePullPolicy;
            return this;
        }

        /**
         * Sets the value of {@link ContainerProps#getName}
         * @param name Name of the container specified as a DNS_LABEL.
         *             Each container in a pod must have a unique name (DNS_LABEL). Cannot be updated.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder name(java.lang.String name) {
            this.name = name;
            return this;
        }

        /**
         * Sets the value of {@link ContainerProps#getPort}
         * @param port Number of port to expose on the pod's IP address.
         *             This must be a valid port number, 0 &lt; x &lt; 65536.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder port(java.lang.Number port) {
            this.port = port;
            return this;
        }

        /**
         * Sets the value of {@link ContainerProps#getReadiness}
         * @param readiness Determines when the container is ready to serve traffic.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder readiness(org.cdk8s.plus.Probe readiness) {
            this.readiness = readiness;
            return this;
        }

        /**
         * Sets the value of {@link ContainerProps#getVolumeMounts}
         * @param volumeMounts Pod volumes to mount into the container's filesystem.
         *                     Cannot be updated.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        @SuppressWarnings("unchecked")
        public Builder volumeMounts(java.util.List<? extends org.cdk8s.plus.VolumeMount> volumeMounts) {
            this.volumeMounts = (java.util.List<org.cdk8s.plus.VolumeMount>)volumeMounts;
            return this;
        }

        /**
         * Sets the value of {@link ContainerProps#getWorkingDir}
         * @param workingDir Container's working directory.
         *                   If not specified, the container runtime's default will be used, which might be configured in the container image. Cannot be updated.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder workingDir(java.lang.String workingDir) {
            this.workingDir = workingDir;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link ContainerProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        @Override
        public ContainerProps build() {
            return new Jsii$Proxy(image, args, command, env, imagePullPolicy, name, port, readiness, volumeMounts, workingDir);
        }
    }

    /**
     * An implementation for {@link ContainerProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements ContainerProps {
        private final java.lang.String image;
        private final java.util.List<java.lang.String> args;
        private final java.util.List<java.lang.String> command;
        private final java.util.Map<java.lang.String, org.cdk8s.plus.EnvValue> env;
        private final org.cdk8s.plus.ImagePullPolicy imagePullPolicy;
        private final java.lang.String name;
        private final java.lang.Number port;
        private final org.cdk8s.plus.Probe readiness;
        private final java.util.List<org.cdk8s.plus.VolumeMount> volumeMounts;
        private final java.lang.String workingDir;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.image = this.jsiiGet("image", java.lang.String.class);
            this.args = this.jsiiGet("args", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
            this.command = this.jsiiGet("command", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
            this.env = this.jsiiGet("env", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(org.cdk8s.plus.EnvValue.class)));
            this.imagePullPolicy = this.jsiiGet("imagePullPolicy", org.cdk8s.plus.ImagePullPolicy.class);
            this.name = this.jsiiGet("name", java.lang.String.class);
            this.port = this.jsiiGet("port", java.lang.Number.class);
            this.readiness = this.jsiiGet("readiness", org.cdk8s.plus.Probe.class);
            this.volumeMounts = this.jsiiGet("volumeMounts", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(org.cdk8s.plus.VolumeMount.class)));
            this.workingDir = this.jsiiGet("workingDir", java.lang.String.class);
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        @SuppressWarnings("unchecked")
        private Jsii$Proxy(final java.lang.String image, final java.util.List<java.lang.String> args, final java.util.List<java.lang.String> command, final java.util.Map<java.lang.String, ? extends org.cdk8s.plus.EnvValue> env, final org.cdk8s.plus.ImagePullPolicy imagePullPolicy, final java.lang.String name, final java.lang.Number port, final org.cdk8s.plus.Probe readiness, final java.util.List<? extends org.cdk8s.plus.VolumeMount> volumeMounts, final java.lang.String workingDir) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.image = java.util.Objects.requireNonNull(image, "image is required");
            this.args = args;
            this.command = command;
            this.env = (java.util.Map<java.lang.String, org.cdk8s.plus.EnvValue>)env;
            this.imagePullPolicy = imagePullPolicy;
            this.name = name;
            this.port = port;
            this.readiness = readiness;
            this.volumeMounts = (java.util.List<org.cdk8s.plus.VolumeMount>)volumeMounts;
            this.workingDir = workingDir;
        }

        @Override
        public java.lang.String getImage() {
            return this.image;
        }

        @Override
        public java.util.List<java.lang.String> getArgs() {
            return this.args;
        }

        @Override
        public java.util.List<java.lang.String> getCommand() {
            return this.command;
        }

        @Override
        public java.util.Map<java.lang.String, org.cdk8s.plus.EnvValue> getEnv() {
            return this.env;
        }

        @Override
        public org.cdk8s.plus.ImagePullPolicy getImagePullPolicy() {
            return this.imagePullPolicy;
        }

        @Override
        public java.lang.String getName() {
            return this.name;
        }

        @Override
        public java.lang.Number getPort() {
            return this.port;
        }

        @Override
        public org.cdk8s.plus.Probe getReadiness() {
            return this.readiness;
        }

        @Override
        public java.util.List<org.cdk8s.plus.VolumeMount> getVolumeMounts() {
            return this.volumeMounts;
        }

        @Override
        public java.lang.String getWorkingDir() {
            return this.workingDir;
        }

        @Override
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("image", om.valueToTree(this.getImage()));
            if (this.getArgs() != null) {
                data.set("args", om.valueToTree(this.getArgs()));
            }
            if (this.getCommand() != null) {
                data.set("command", om.valueToTree(this.getCommand()));
            }
            if (this.getEnv() != null) {
                data.set("env", om.valueToTree(this.getEnv()));
            }
            if (this.getImagePullPolicy() != null) {
                data.set("imagePullPolicy", om.valueToTree(this.getImagePullPolicy()));
            }
            if (this.getName() != null) {
                data.set("name", om.valueToTree(this.getName()));
            }
            if (this.getPort() != null) {
                data.set("port", om.valueToTree(this.getPort()));
            }
            if (this.getReadiness() != null) {
                data.set("readiness", om.valueToTree(this.getReadiness()));
            }
            if (this.getVolumeMounts() != null) {
                data.set("volumeMounts", om.valueToTree(this.getVolumeMounts()));
            }
            if (this.getWorkingDir() != null) {
                data.set("workingDir", om.valueToTree(this.getWorkingDir()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("cdk8s-plus.ContainerProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            ContainerProps.Jsii$Proxy that = (ContainerProps.Jsii$Proxy) o;

            if (!image.equals(that.image)) return false;
            if (this.args != null ? !this.args.equals(that.args) : that.args != null) return false;
            if (this.command != null ? !this.command.equals(that.command) : that.command != null) return false;
            if (this.env != null ? !this.env.equals(that.env) : that.env != null) return false;
            if (this.imagePullPolicy != null ? !this.imagePullPolicy.equals(that.imagePullPolicy) : that.imagePullPolicy != null) return false;
            if (this.name != null ? !this.name.equals(that.name) : that.name != null) return false;
            if (this.port != null ? !this.port.equals(that.port) : that.port != null) return false;
            if (this.readiness != null ? !this.readiness.equals(that.readiness) : that.readiness != null) return false;
            if (this.volumeMounts != null ? !this.volumeMounts.equals(that.volumeMounts) : that.volumeMounts != null) return false;
            return this.workingDir != null ? this.workingDir.equals(that.workingDir) : that.workingDir == null;
        }

        @Override
        public int hashCode() {
            int result = this.image.hashCode();
            result = 31 * result + (this.args != null ? this.args.hashCode() : 0);
            result = 31 * result + (this.command != null ? this.command.hashCode() : 0);
            result = 31 * result + (this.env != null ? this.env.hashCode() : 0);
            result = 31 * result + (this.imagePullPolicy != null ? this.imagePullPolicy.hashCode() : 0);
            result = 31 * result + (this.name != null ? this.name.hashCode() : 0);
            result = 31 * result + (this.port != null ? this.port.hashCode() : 0);
            result = 31 * result + (this.readiness != null ? this.readiness.hashCode() : 0);
            result = 31 * result + (this.volumeMounts != null ? this.volumeMounts.hashCode() : 0);
            result = 31 * result + (this.workingDir != null ? this.workingDir.hashCode() : 0);
            return result;
        }
    }
}
