package org.cdk8s.plus;

/**
 * (experimental) A Deployment provides declarative updates for Pods and ReplicaSets.
 * <p>
 * You describe a desired state in a Deployment, and the Deployment Controller changes the actual
 * state to the desired state at a controlled rate. You can define Deployments to create new ReplicaSets, or to remove
 * existing Deployments and adopt all their resources with new Deployments.
 * <p>
 * <blockquote>
 * <p>
 * Note: Do not manage ReplicaSets owned by a Deployment. Consider opening an issue in the main Kubernetes repository if your use case is not covered below.
 * <p>
 * </blockquote>
 * <p>
 * <h2>Use Case</h2>
 * <p>
 * The following are typical use cases for Deployments:
 * <p>
 * <ul>
 * <li>Create a Deployment to rollout a ReplicaSet. The ReplicaSet creates Pods in the background.
 * Check the status of the rollout to see if it succeeds or not.</li>
 * <li>Declare the new state of the Pods by updating the PodTemplateSpec of the Deployment.
 * A new ReplicaSet is created and the Deployment manages moving the Pods from the old ReplicaSet to the new one at a controlled rate.
 * Each new ReplicaSet updates the revision of the Deployment.</li>
 * <li>Rollback to an earlier Deployment revision if the current state of the Deployment is not stable.
 * Each rollback updates the revision of the Deployment.</li>
 * <li>Scale up the Deployment to facilitate more load.</li>
 * <li>Pause the Deployment to apply multiple fixes to its PodTemplateSpec and then resume it to start a new rollout.</li>
 * <li>Use the status of the Deployment as an indicator that a rollout has stuck.</li>
 * <li>Clean up older ReplicaSets that you don't need anymore.</li>
 * </ul>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.13.0 (build 385c325)", date = "2020-10-21T06:58:44.652Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
@software.amazon.jsii.Jsii(module = org.cdk8s.plus.$Module.class, fqn = "cdk8s-plus.Deployment")
public class Deployment extends org.cdk8s.plus.Resource implements org.cdk8s.plus.IPodTemplate {

    protected Deployment(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected Deployment(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    /**
     * @param scope This parameter is required.
     * @param id This parameter is required.
     * @param props
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public Deployment(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.Nullable org.cdk8s.plus.DeploymentProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), props });
    }

    /**
     * @param scope This parameter is required.
     * @param id This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public Deployment(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required") });
    }

    /**
     * (experimental) Add a container to the pod.
     * <p>
     * @param container This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    @Override
    public void addContainer(final @org.jetbrains.annotations.NotNull org.cdk8s.plus.Container container) {
        this.jsiiCall("addContainer", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(container, "container is required") });
    }

    /**
     * (experimental) Add a volume to the pod.
     * <p>
     * @param volume This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    @Override
    public void addVolume(final @org.jetbrains.annotations.NotNull org.cdk8s.plus.Volume volume) {
        this.jsiiCall("addVolume", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(volume, "volume is required") });
    }

    /**
     * (experimental) Expose a deployment via a service.
     * <p>
     * This is equivalent to running <code>kubectl expose deployment &lt;deployment-name&gt;</code>.
     * <p>
     * @param port The port number the service will bind to. This parameter is required.
     * @param options Options.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public @org.jetbrains.annotations.NotNull org.cdk8s.plus.Service expose(final @org.jetbrains.annotations.NotNull java.lang.Number port, final @org.jetbrains.annotations.Nullable org.cdk8s.plus.ExposeOptions options) {
        return this.jsiiCall("expose", org.cdk8s.plus.Service.class, new Object[] { java.util.Objects.requireNonNull(port, "port is required"), options });
    }

    /**
     * (experimental) Expose a deployment via a service.
     * <p>
     * This is equivalent to running <code>kubectl expose deployment &lt;deployment-name&gt;</code>.
     * <p>
     * @param port The port number the service will bind to. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public @org.jetbrains.annotations.NotNull org.cdk8s.plus.Service expose(final @org.jetbrains.annotations.NotNull java.lang.Number port) {
        return this.jsiiCall("expose", org.cdk8s.plus.Service.class, new Object[] { java.util.Objects.requireNonNull(port, "port is required") });
    }

    /**
     * (experimental) Configure a label selector to this deployment.
     * <p>
     * Pods that have the label will be selected by deployments configured with this spec.
     * <p>
     * @param key - The label key. This parameter is required.
     * @param value - The label value. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public void selectByLabel(final @org.jetbrains.annotations.NotNull java.lang.String key, final @org.jetbrains.annotations.NotNull java.lang.String value) {
        this.jsiiCall("selectByLabel", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(key, "key is required"), java.util.Objects.requireNonNull(value, "value is required") });
    }

    /**
     * (experimental) The underlying cdk8s API object.
     * <p>
     * @see base.Resource.apiObject
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    protected @org.jetbrains.annotations.NotNull org.cdk8s.ApiObject getApiObject() {
        return this.jsiiGet("apiObject", org.cdk8s.ApiObject.class);
    }

    /**
     * (experimental) The containers belonging to the pod.
     * <p>
     * Use <code>addContainer</code> to add containers.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public @org.jetbrains.annotations.NotNull java.util.List<org.cdk8s.plus.Container> getContainers() {
        return java.util.Collections.unmodifiableList(this.jsiiGet("containers", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(org.cdk8s.plus.Container.class))));
    }

    /**
     * (experimental) The labels this deployment will match against in order to select pods.
     * <p>
     * Returns a a copy. Use <code>selectByLabel()</code> to add labels.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.String> getLabelSelector() {
        return java.util.Collections.unmodifiableMap(this.jsiiGet("labelSelector", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class))));
    }

    /**
     * (experimental) Provides read/write access to the underlying pod metadata of the resource.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public @org.jetbrains.annotations.NotNull org.cdk8s.ApiObjectMetadataDefinition getPodMetadata() {
        return this.jsiiGet("podMetadata", org.cdk8s.ApiObjectMetadataDefinition.class);
    }

    /**
     * (experimental) Number of desired pods.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public @org.jetbrains.annotations.NotNull java.lang.Number getReplicas() {
        return this.jsiiGet("replicas", java.lang.Number.class);
    }

    /**
     * (experimental) The volumes associated with this pod.
     * <p>
     * Use <code>addVolume</code> to add volumes.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public @org.jetbrains.annotations.NotNull java.util.List<org.cdk8s.plus.Volume> getVolumes() {
        return java.util.Collections.unmodifiableList(this.jsiiGet("volumes", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(org.cdk8s.plus.Volume.class))));
    }

    /**
     * (experimental) Restart policy for all containers within the pod.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public @org.jetbrains.annotations.Nullable org.cdk8s.plus.RestartPolicy getRestartPolicy() {
        return this.jsiiGet("restartPolicy", org.cdk8s.plus.RestartPolicy.class);
    }

    /**
     * (experimental) The service account used to run this pod.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public @org.jetbrains.annotations.Nullable org.cdk8s.plus.IServiceAccount getServiceAccount() {
        return this.jsiiGet("serviceAccount", org.cdk8s.plus.IServiceAccount.class);
    }

    /**
     * (experimental) A fluent builder for {@link org.cdk8s.plus.Deployment}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public static final class Builder implements software.amazon.jsii.Builder<org.cdk8s.plus.Deployment> {
        /**
         * @return a new instance of {@link Builder}.
         * @param scope This parameter is required.
         * @param id This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public static Builder create(final software.constructs.Construct scope, final java.lang.String id) {
            return new Builder(scope, id);
        }

        private final software.constructs.Construct scope;
        private final java.lang.String id;
        private org.cdk8s.plus.DeploymentProps.Builder props;

        private Builder(final software.constructs.Construct scope, final java.lang.String id) {
            this.scope = scope;
            this.id = id;
        }

        /**
         * (experimental) Metadata that all persisted resources must have, which includes all objects users must create.
         * <p>
         * @return {@code this}
         * @param metadata Metadata that all persisted resources must have, which includes all objects users must create. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder metadata(final org.cdk8s.ApiObjectMetadata metadata) {
            this.props().metadata(metadata);
            return this;
        }

        /**
         * (experimental) List of containers belonging to the pod.
         * <p>
         * Containers cannot currently be
         * added or removed. There must be at least one container in a Pod.
         * <p>
         * You can add additionnal containers using <code>podSpec.addContainer()</code>
         * <p>
         * Default: - No containers. Note that a pod spec must include at least one container.
         * <p>
         * @return {@code this}
         * @param containers List of containers belonging to the pod. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder containers(final java.util.List<? extends org.cdk8s.plus.Container> containers) {
            this.props().containers(containers);
            return this;
        }

        /**
         * (experimental) Restart policy for all containers within the pod.
         * <p>
         * Default: RestartPolicy.ALWAYS
         * <p>
         * @return {@code this}
         * @see https://kubernetes.io/docs/concepts/workloads/pods/pod-lifecycle/#restart-policy
         * @param restartPolicy Restart policy for all containers within the pod. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder restartPolicy(final org.cdk8s.plus.RestartPolicy restartPolicy) {
            this.props().restartPolicy(restartPolicy);
            return this;
        }

        /**
         * (experimental) A service account provides an identity for processes that run in a Pod.
         * <p>
         * When you (a human) access the cluster (for example, using kubectl), you are
         * authenticated by the apiserver as a particular User Account (currently this
         * is usually admin, unless your cluster administrator has customized your
         * cluster). Processes in containers inside pods can also contact the
         * apiserver. When they do, they are authenticated as a particular Service
         * Account (for example, default).
         * <p>
         * Default: - No service account.
         * <p>
         * @return {@code this}
         * @see https://kubernetes.io/docs/tasks/configure-pod-container/configure-service-account/
         * @param serviceAccount A service account provides an identity for processes that run in a Pod. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder serviceAccount(final org.cdk8s.plus.IServiceAccount serviceAccount) {
            this.props().serviceAccount(serviceAccount);
            return this;
        }

        /**
         * (experimental) List of volumes that can be mounted by containers belonging to the pod.
         * <p>
         * You can also add volumes later using <code>podSpec.addVolume()</code>
         * <p>
         * Default: - No volumes.
         * <p>
         * @return {@code this}
         * @see https://kubernetes.io/docs/concepts/storage/volumes
         * @param volumes List of volumes that can be mounted by containers belonging to the pod. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder volumes(final java.util.List<? extends org.cdk8s.plus.Volume> volumes) {
            this.props().volumes(volumes);
            return this;
        }

        /**
         * (experimental) The pod metadata.
         * <p>
         * @return {@code this}
         * @param podMetadata The pod metadata. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder podMetadata(final org.cdk8s.ApiObjectMetadata podMetadata) {
            this.props().podMetadata(podMetadata);
            return this;
        }

        /**
         * (experimental) Automatically allocates a pod selector for this deployment.
         * <p>
         * If this is set to <code>false</code> you must define your selector through
         * <code>deployment.podMetadata.addLabel()</code> and <code>deployment.selectByLabel()</code>.
         * <p>
         * Default: true
         * <p>
         * @return {@code this}
         * @param defaultSelector Automatically allocates a pod selector for this deployment. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder defaultSelector(final java.lang.Boolean defaultSelector) {
            this.props().defaultSelector(defaultSelector);
            return this;
        }

        /**
         * (experimental) Number of desired pods.
         * <p>
         * Default: 1
         * <p>
         * @return {@code this}
         * @param replicas Number of desired pods. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder replicas(final java.lang.Number replicas) {
            this.props().replicas(replicas);
            return this;
        }

        /**
         * @returns a newly built instance of {@link org.cdk8s.plus.Deployment}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        @Override
        public org.cdk8s.plus.Deployment build() {
            return new org.cdk8s.plus.Deployment(
                this.scope,
                this.id,
                this.props != null ? this.props.build() : null
            );
        }

        private org.cdk8s.plus.DeploymentProps.Builder props() {
            if (this.props == null) {
                this.props = new org.cdk8s.plus.DeploymentProps.Builder();
            }
            return this.props;
        }
    }
}
