package org.cdk8s.plus;

/**
 * (experimental) Options for volumes populated with an empty directory.
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.13.0 (build 385c325)", date = "2020-10-21T06:58:44.657Z")
@software.amazon.jsii.Jsii(module = org.cdk8s.plus.$Module.class, fqn = "cdk8s-plus.EmptyDirVolumeOptions")
@software.amazon.jsii.Jsii.Proxy(EmptyDirVolumeOptions.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
public interface EmptyDirVolumeOptions extends software.amazon.jsii.JsiiSerializable {

    /**
     * (experimental) By default, emptyDir volumes are stored on whatever medium is backing the node - that might be disk or SSD or network storage, depending on your environment.
     * <p>
     * However, you can set the emptyDir.medium field to
     * <code>EmptyDirMedium.MEMORY</code> to tell Kubernetes to mount a tmpfs (RAM-backed
     * filesystem) for you instead. While tmpfs is very fast, be aware that unlike
     * disks, tmpfs is cleared on node reboot and any files you write will count
     * against your Container's memory limit.
     * <p>
     * Default: EmptyDirMedium.DEFAULT
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    default @org.jetbrains.annotations.Nullable org.cdk8s.plus.EmptyDirMedium getMedium() {
        return null;
    }

    /**
     * (experimental) Total amount of local storage required for this EmptyDir volume.
     * <p>
     * The size
     * limit is also applicable for memory medium. The maximum usage on memory
     * medium EmptyDir would be the minimum value between the SizeLimit specified
     * here and the sum of memory limits of all containers in a pod.
     * <p>
     * Default: - limit is undefined
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    default @org.jetbrains.annotations.Nullable org.cdk8s.plus.Size getSizeLimit() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link EmptyDirVolumeOptions}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link EmptyDirVolumeOptions}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public static final class Builder implements software.amazon.jsii.Builder<EmptyDirVolumeOptions> {
        private org.cdk8s.plus.EmptyDirMedium medium;
        private org.cdk8s.plus.Size sizeLimit;

        /**
         * Sets the value of {@link EmptyDirVolumeOptions#getMedium}
         * @param medium By default, emptyDir volumes are stored on whatever medium is backing the node - that might be disk or SSD or network storage, depending on your environment.
         *               However, you can set the emptyDir.medium field to
         *               <code>EmptyDirMedium.MEMORY</code> to tell Kubernetes to mount a tmpfs (RAM-backed
         *               filesystem) for you instead. While tmpfs is very fast, be aware that unlike
         *               disks, tmpfs is cleared on node reboot and any files you write will count
         *               against your Container's memory limit.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder medium(org.cdk8s.plus.EmptyDirMedium medium) {
            this.medium = medium;
            return this;
        }

        /**
         * Sets the value of {@link EmptyDirVolumeOptions#getSizeLimit}
         * @param sizeLimit Total amount of local storage required for this EmptyDir volume.
         *                  The size
         *                  limit is also applicable for memory medium. The maximum usage on memory
         *                  medium EmptyDir would be the minimum value between the SizeLimit specified
         *                  here and the sum of memory limits of all containers in a pod.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder sizeLimit(org.cdk8s.plus.Size sizeLimit) {
            this.sizeLimit = sizeLimit;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link EmptyDirVolumeOptions}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        @Override
        public EmptyDirVolumeOptions build() {
            return new Jsii$Proxy(medium, sizeLimit);
        }
    }

    /**
     * An implementation for {@link EmptyDirVolumeOptions}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements EmptyDirVolumeOptions {
        private final org.cdk8s.plus.EmptyDirMedium medium;
        private final org.cdk8s.plus.Size sizeLimit;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.medium = this.jsiiGet("medium", org.cdk8s.plus.EmptyDirMedium.class);
            this.sizeLimit = this.jsiiGet("sizeLimit", org.cdk8s.plus.Size.class);
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        private Jsii$Proxy(final org.cdk8s.plus.EmptyDirMedium medium, final org.cdk8s.plus.Size sizeLimit) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.medium = medium;
            this.sizeLimit = sizeLimit;
        }

        @Override
        public org.cdk8s.plus.EmptyDirMedium getMedium() {
            return this.medium;
        }

        @Override
        public org.cdk8s.plus.Size getSizeLimit() {
            return this.sizeLimit;
        }

        @Override
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            if (this.getMedium() != null) {
                data.set("medium", om.valueToTree(this.getMedium()));
            }
            if (this.getSizeLimit() != null) {
                data.set("sizeLimit", om.valueToTree(this.getSizeLimit()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("cdk8s-plus.EmptyDirVolumeOptions"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            EmptyDirVolumeOptions.Jsii$Proxy that = (EmptyDirVolumeOptions.Jsii$Proxy) o;

            if (this.medium != null ? !this.medium.equals(that.medium) : that.medium != null) return false;
            return this.sizeLimit != null ? this.sizeLimit.equals(that.sizeLimit) : that.sizeLimit == null;
        }

        @Override
        public int hashCode() {
            int result = this.medium != null ? this.medium.hashCode() : 0;
            result = 31 * result + (this.sizeLimit != null ? this.sizeLimit.hashCode() : 0);
            return result;
        }
    }
}
