package org.cdk8s.plus;

/**
 * (experimental) Represents the rules mapping the paths under a specified host to the related backend services.
 * <p>
 * Incoming requests are first evaluated for a host match,
 * then routed to the backend associated with the matching path.
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.13.0 (build 385c325)", date = "2020-10-21T06:58:44.666Z")
@software.amazon.jsii.Jsii(module = org.cdk8s.plus.$Module.class, fqn = "cdk8s-plus.IngressRule")
@software.amazon.jsii.Jsii.Proxy(IngressRule.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
public interface IngressRule extends software.amazon.jsii.JsiiSerializable {

    /**
     * (experimental) Backend defines the referenced service endpoint to which the traffic will be forwarded to.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    @org.jetbrains.annotations.NotNull org.cdk8s.plus.IngressBackend getBackend();

    /**
     * (experimental) Host is the fully qualified domain name of a network host, as defined by RFC 3986.
     * <p>
     * Note the following deviations from the "host" part of the URI as
     * defined in the RFC: 1. IPs are not allowed. Currently an IngressRuleValue
     * can only apply to the IP in the Spec of the parent Ingress. 2. The <code>:</code>
     * delimiter is not respected because ports are not allowed. Currently the
     * port of an Ingress is implicitly :80 for http and :443 for https. Both
     * these may change in the future. Incoming requests are matched against the
     * host before the IngressRuleValue.
     * <p>
     * Default: - If the host is unspecified, the Ingress routes all traffic based
     * on the specified IngressRuleValue.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    default @org.jetbrains.annotations.Nullable java.lang.String getHost() {
        return null;
    }

    /**
     * (experimental) Path is an extended POSIX regex as defined by IEEE Std 1003.1, (i.e this follows the egrep/unix syntax, not the perl syntax) matched against the path of an incoming request. Currently it can contain characters disallowed from the conventional "path" part of a URL as defined by RFC 3986. Paths must begin with a '/'.
     * <p>
     * Default: - If unspecified, the path defaults to a catch all sending traffic
     * to the backend.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    default @org.jetbrains.annotations.Nullable java.lang.String getPath() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link IngressRule}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link IngressRule}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public static final class Builder implements software.amazon.jsii.Builder<IngressRule> {
        private org.cdk8s.plus.IngressBackend backend;
        private java.lang.String host;
        private java.lang.String path;

        /**
         * Sets the value of {@link IngressRule#getBackend}
         * @param backend Backend defines the referenced service endpoint to which the traffic will be forwarded to. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder backend(org.cdk8s.plus.IngressBackend backend) {
            this.backend = backend;
            return this;
        }

        /**
         * Sets the value of {@link IngressRule#getHost}
         * @param host Host is the fully qualified domain name of a network host, as defined by RFC 3986.
         *             Note the following deviations from the "host" part of the URI as
         *             defined in the RFC: 1. IPs are not allowed. Currently an IngressRuleValue
         *             can only apply to the IP in the Spec of the parent Ingress. 2. The <code>:</code>
         *             delimiter is not respected because ports are not allowed. Currently the
         *             port of an Ingress is implicitly :80 for http and :443 for https. Both
         *             these may change in the future. Incoming requests are matched against the
         *             host before the IngressRuleValue.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder host(java.lang.String host) {
            this.host = host;
            return this;
        }

        /**
         * Sets the value of {@link IngressRule#getPath}
         * @param path Path is an extended POSIX regex as defined by IEEE Std 1003.1, (i.e this follows the egrep/unix syntax, not the perl syntax) matched against the path of an incoming request. Currently it can contain characters disallowed from the conventional "path" part of a URL as defined by RFC 3986. Paths must begin with a '/'.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder path(java.lang.String path) {
            this.path = path;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link IngressRule}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        @Override
        public IngressRule build() {
            return new Jsii$Proxy(backend, host, path);
        }
    }

    /**
     * An implementation for {@link IngressRule}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements IngressRule {
        private final org.cdk8s.plus.IngressBackend backend;
        private final java.lang.String host;
        private final java.lang.String path;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.backend = this.jsiiGet("backend", org.cdk8s.plus.IngressBackend.class);
            this.host = this.jsiiGet("host", java.lang.String.class);
            this.path = this.jsiiGet("path", java.lang.String.class);
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        private Jsii$Proxy(final org.cdk8s.plus.IngressBackend backend, final java.lang.String host, final java.lang.String path) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.backend = java.util.Objects.requireNonNull(backend, "backend is required");
            this.host = host;
            this.path = path;
        }

        @Override
        public org.cdk8s.plus.IngressBackend getBackend() {
            return this.backend;
        }

        @Override
        public java.lang.String getHost() {
            return this.host;
        }

        @Override
        public java.lang.String getPath() {
            return this.path;
        }

        @Override
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("backend", om.valueToTree(this.getBackend()));
            if (this.getHost() != null) {
                data.set("host", om.valueToTree(this.getHost()));
            }
            if (this.getPath() != null) {
                data.set("path", om.valueToTree(this.getPath()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("cdk8s-plus.IngressRule"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            IngressRule.Jsii$Proxy that = (IngressRule.Jsii$Proxy) o;

            if (!backend.equals(that.backend)) return false;
            if (this.host != null ? !this.host.equals(that.host) : that.host != null) return false;
            return this.path != null ? this.path.equals(that.path) : that.path == null;
        }

        @Override
        public int hashCode() {
            int result = this.backend.hashCode();
            result = 31 * result + (this.host != null ? this.host.hashCode() : 0);
            result = 31 * result + (this.path != null ? this.path.hashCode() : 0);
            return result;
        }
    }
}
