package org.cdk8s.plus;

/**
 * (experimental) Properties of a `PodSpec`.
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.13.0 (build 385c325)", date = "2020-10-21T06:58:44.683Z")
@software.amazon.jsii.Jsii(module = org.cdk8s.plus.$Module.class, fqn = "cdk8s-plus.PodSpecProps")
@software.amazon.jsii.Jsii.Proxy(PodSpecProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
public interface PodSpecProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * (experimental) List of containers belonging to the pod.
     * <p>
     * Containers cannot currently be
     * added or removed. There must be at least one container in a Pod.
     * <p>
     * You can add additionnal containers using <code>podSpec.addContainer()</code>
     * <p>
     * Default: - No containers. Note that a pod spec must include at least one container.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    default @org.jetbrains.annotations.Nullable java.util.List<org.cdk8s.plus.Container> getContainers() {
        return null;
    }

    /**
     * (experimental) Restart policy for all containers within the pod.
     * <p>
     * Default: RestartPolicy.ALWAYS
     * <p>
     * @see https://kubernetes.io/docs/concepts/workloads/pods/pod-lifecycle/#restart-policy
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    default @org.jetbrains.annotations.Nullable org.cdk8s.plus.RestartPolicy getRestartPolicy() {
        return null;
    }

    /**
     * (experimental) A service account provides an identity for processes that run in a Pod.
     * <p>
     * When you (a human) access the cluster (for example, using kubectl), you are
     * authenticated by the apiserver as a particular User Account (currently this
     * is usually admin, unless your cluster administrator has customized your
     * cluster). Processes in containers inside pods can also contact the
     * apiserver. When they do, they are authenticated as a particular Service
     * Account (for example, default).
     * <p>
     * Default: - No service account.
     * <p>
     * @see https://kubernetes.io/docs/tasks/configure-pod-container/configure-service-account/
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    default @org.jetbrains.annotations.Nullable org.cdk8s.plus.IServiceAccount getServiceAccount() {
        return null;
    }

    /**
     * (experimental) List of volumes that can be mounted by containers belonging to the pod.
     * <p>
     * You can also add volumes later using <code>podSpec.addVolume()</code>
     * <p>
     * Default: - No volumes.
     * <p>
     * @see https://kubernetes.io/docs/concepts/storage/volumes
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    default @org.jetbrains.annotations.Nullable java.util.List<org.cdk8s.plus.Volume> getVolumes() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link PodSpecProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link PodSpecProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public static final class Builder implements software.amazon.jsii.Builder<PodSpecProps> {
        private java.util.List<org.cdk8s.plus.Container> containers;
        private org.cdk8s.plus.RestartPolicy restartPolicy;
        private org.cdk8s.plus.IServiceAccount serviceAccount;
        private java.util.List<org.cdk8s.plus.Volume> volumes;

        /**
         * Sets the value of {@link PodSpecProps#getContainers}
         * @param containers List of containers belonging to the pod.
         *                   Containers cannot currently be
         *                   added or removed. There must be at least one container in a Pod.
         *                   <p>
         *                   You can add additionnal containers using <code>podSpec.addContainer()</code>
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        @SuppressWarnings("unchecked")
        public Builder containers(java.util.List<? extends org.cdk8s.plus.Container> containers) {
            this.containers = (java.util.List<org.cdk8s.plus.Container>)containers;
            return this;
        }

        /**
         * Sets the value of {@link PodSpecProps#getRestartPolicy}
         * @param restartPolicy Restart policy for all containers within the pod.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder restartPolicy(org.cdk8s.plus.RestartPolicy restartPolicy) {
            this.restartPolicy = restartPolicy;
            return this;
        }

        /**
         * Sets the value of {@link PodSpecProps#getServiceAccount}
         * @param serviceAccount A service account provides an identity for processes that run in a Pod.
         *                       When you (a human) access the cluster (for example, using kubectl), you are
         *                       authenticated by the apiserver as a particular User Account (currently this
         *                       is usually admin, unless your cluster administrator has customized your
         *                       cluster). Processes in containers inside pods can also contact the
         *                       apiserver. When they do, they are authenticated as a particular Service
         *                       Account (for example, default).
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder serviceAccount(org.cdk8s.plus.IServiceAccount serviceAccount) {
            this.serviceAccount = serviceAccount;
            return this;
        }

        /**
         * Sets the value of {@link PodSpecProps#getVolumes}
         * @param volumes List of volumes that can be mounted by containers belonging to the pod.
         *                You can also add volumes later using <code>podSpec.addVolume()</code>
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        @SuppressWarnings("unchecked")
        public Builder volumes(java.util.List<? extends org.cdk8s.plus.Volume> volumes) {
            this.volumes = (java.util.List<org.cdk8s.plus.Volume>)volumes;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link PodSpecProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        @Override
        public PodSpecProps build() {
            return new Jsii$Proxy(containers, restartPolicy, serviceAccount, volumes);
        }
    }

    /**
     * An implementation for {@link PodSpecProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements PodSpecProps {
        private final java.util.List<org.cdk8s.plus.Container> containers;
        private final org.cdk8s.plus.RestartPolicy restartPolicy;
        private final org.cdk8s.plus.IServiceAccount serviceAccount;
        private final java.util.List<org.cdk8s.plus.Volume> volumes;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.containers = this.jsiiGet("containers", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(org.cdk8s.plus.Container.class)));
            this.restartPolicy = this.jsiiGet("restartPolicy", org.cdk8s.plus.RestartPolicy.class);
            this.serviceAccount = this.jsiiGet("serviceAccount", org.cdk8s.plus.IServiceAccount.class);
            this.volumes = this.jsiiGet("volumes", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(org.cdk8s.plus.Volume.class)));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        @SuppressWarnings("unchecked")
        private Jsii$Proxy(final java.util.List<? extends org.cdk8s.plus.Container> containers, final org.cdk8s.plus.RestartPolicy restartPolicy, final org.cdk8s.plus.IServiceAccount serviceAccount, final java.util.List<? extends org.cdk8s.plus.Volume> volumes) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.containers = (java.util.List<org.cdk8s.plus.Container>)containers;
            this.restartPolicy = restartPolicy;
            this.serviceAccount = serviceAccount;
            this.volumes = (java.util.List<org.cdk8s.plus.Volume>)volumes;
        }

        @Override
        public java.util.List<org.cdk8s.plus.Container> getContainers() {
            return this.containers;
        }

        @Override
        public org.cdk8s.plus.RestartPolicy getRestartPolicy() {
            return this.restartPolicy;
        }

        @Override
        public org.cdk8s.plus.IServiceAccount getServiceAccount() {
            return this.serviceAccount;
        }

        @Override
        public java.util.List<org.cdk8s.plus.Volume> getVolumes() {
            return this.volumes;
        }

        @Override
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            if (this.getContainers() != null) {
                data.set("containers", om.valueToTree(this.getContainers()));
            }
            if (this.getRestartPolicy() != null) {
                data.set("restartPolicy", om.valueToTree(this.getRestartPolicy()));
            }
            if (this.getServiceAccount() != null) {
                data.set("serviceAccount", om.valueToTree(this.getServiceAccount()));
            }
            if (this.getVolumes() != null) {
                data.set("volumes", om.valueToTree(this.getVolumes()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("cdk8s-plus.PodSpecProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            PodSpecProps.Jsii$Proxy that = (PodSpecProps.Jsii$Proxy) o;

            if (this.containers != null ? !this.containers.equals(that.containers) : that.containers != null) return false;
            if (this.restartPolicy != null ? !this.restartPolicy.equals(that.restartPolicy) : that.restartPolicy != null) return false;
            if (this.serviceAccount != null ? !this.serviceAccount.equals(that.serviceAccount) : that.serviceAccount != null) return false;
            return this.volumes != null ? this.volumes.equals(that.volumes) : that.volumes == null;
        }

        @Override
        public int hashCode() {
            int result = this.containers != null ? this.containers.hashCode() : 0;
            result = 31 * result + (this.restartPolicy != null ? this.restartPolicy.hashCode() : 0);
            result = 31 * result + (this.serviceAccount != null ? this.serviceAccount.hashCode() : 0);
            result = 31 * result + (this.volumes != null ? this.volumes.hashCode() : 0);
            return result;
        }
    }
}
