package org.cdk8s.plus;

/**
 * (experimental) An abstract way to expose an application running on a set of Pods as a network service.
 * <p>
 * With Kubernetes you don't need to modify your application to use an unfamiliar service discovery mechanism.
 * Kubernetes gives Pods their own IP addresses and a single DNS name for a set of Pods, and can load-balance across them.
 * <p>
 * For example, consider a stateless image-processing backend which is running with 3 replicas. Those replicas are fungible—frontends do not care which backend they use.
 * While the actual Pods that compose the backend set may change, the frontend clients should not need to be aware of that,
 * nor should they need to keep track of the set of backends themselves.
 * The Service abstraction enables this decoupling.
 * <p>
 * If you're able to use Kubernetes APIs for service discovery in your application, you can query the API server for Endpoints,
 * that get updated whenever the set of Pods in a Service changes. For non-native applications, Kubernetes offers ways to place a network port
 * or load balancer in between your application and the backend Pods.
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.13.0 (build 385c325)", date = "2020-10-21T06:58:44.691Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
@software.amazon.jsii.Jsii(module = org.cdk8s.plus.$Module.class, fqn = "cdk8s-plus.Service")
public class Service extends org.cdk8s.plus.Resource {

    protected Service(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected Service(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    /**
     * @param scope This parameter is required.
     * @param id This parameter is required.
     * @param props
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public Service(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.Nullable org.cdk8s.plus.ServiceProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), props });
    }

    /**
     * @param scope This parameter is required.
     * @param id This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public Service(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required") });
    }

    /**
     * (experimental) Associate a deployment to this service.
     * <p>
     * Requests will be routed to the port exposed by the first container in the
     * deployment's pods. The deployment's <code>labelSelector</code> will be used to select
     * pods.
     * <p>
     * @param deployment The deployment to expose. This parameter is required.
     * @param port The external port. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public void addDeployment(final @org.jetbrains.annotations.NotNull org.cdk8s.plus.Deployment deployment, final @org.jetbrains.annotations.NotNull java.lang.Number port) {
        this.jsiiCall("addDeployment", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(deployment, "deployment is required"), java.util.Objects.requireNonNull(port, "port is required") });
    }

    /**
     * (experimental) Services defined using this spec will select pods according the provided label.
     * <p>
     * @param label The label key. This parameter is required.
     * @param value The label value. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public void addSelector(final @org.jetbrains.annotations.NotNull java.lang.String label, final @org.jetbrains.annotations.NotNull java.lang.String value) {
        this.jsiiCall("addSelector", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(label, "label is required"), java.util.Objects.requireNonNull(value, "value is required") });
    }

    /**
     * (experimental) Configure a port the service will bind to.
     * <p>
     * This method can be called multiple times.
     * <p>
     * @param port The port definition. This parameter is required.
     * @param options
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public void serve(final @org.jetbrains.annotations.NotNull java.lang.Number port, final @org.jetbrains.annotations.Nullable org.cdk8s.plus.ServicePortOptions options) {
        this.jsiiCall("serve", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(port, "port is required"), options });
    }

    /**
     * (experimental) Configure a port the service will bind to.
     * <p>
     * This method can be called multiple times.
     * <p>
     * @param port The port definition. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public void serve(final @org.jetbrains.annotations.NotNull java.lang.Number port) {
        this.jsiiCall("serve", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(port, "port is required") });
    }

    /**
     * (experimental) The underlying cdk8s API object.
     * <p>
     * @see base.Resource.apiObject
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    protected @org.jetbrains.annotations.NotNull org.cdk8s.ApiObject getApiObject() {
        return this.jsiiGet("apiObject", org.cdk8s.ApiObject.class);
    }

    /**
     * (experimental) Ports for this service.
     * <p>
     * Use <code>serve()</code> to expose additional service ports.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public @org.jetbrains.annotations.NotNull java.util.List<org.cdk8s.plus.ServicePort> getPorts() {
        return java.util.Collections.unmodifiableList(this.jsiiGet("ports", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(org.cdk8s.plus.ServicePort.class))));
    }

    /**
     * (experimental) Returns the labels which are used to select pods for this service.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.String> getSelector() {
        return java.util.Collections.unmodifiableMap(this.jsiiGet("selector", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class))));
    }

    /**
     * (experimental) Determines how the Service is exposed.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public @org.jetbrains.annotations.NotNull org.cdk8s.plus.ServiceType getType() {
        return this.jsiiGet("type", org.cdk8s.plus.ServiceType.class);
    }

    /**
     * (experimental) The IP address of the service and is usually assigned randomly by the master.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public @org.jetbrains.annotations.Nullable java.lang.String getClusterIp() {
        return this.jsiiGet("clusterIP", java.lang.String.class);
    }

    /**
     * (experimental) A fluent builder for {@link org.cdk8s.plus.Service}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public static final class Builder implements software.amazon.jsii.Builder<org.cdk8s.plus.Service> {
        /**
         * @return a new instance of {@link Builder}.
         * @param scope This parameter is required.
         * @param id This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public static Builder create(final software.constructs.Construct scope, final java.lang.String id) {
            return new Builder(scope, id);
        }

        private final software.constructs.Construct scope;
        private final java.lang.String id;
        private org.cdk8s.plus.ServiceProps.Builder props;

        private Builder(final software.constructs.Construct scope, final java.lang.String id) {
            this.scope = scope;
            this.id = id;
        }

        /**
         * (experimental) Metadata that all persisted resources must have, which includes all objects users must create.
         * <p>
         * @return {@code this}
         * @param metadata Metadata that all persisted resources must have, which includes all objects users must create. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder metadata(final org.cdk8s.ApiObjectMetadata metadata) {
            this.props().metadata(metadata);
            return this;
        }

        /**
         * (experimental) The IP address of the service and is usually assigned randomly by the master.
         * <p>
         * If an address is specified manually and is not in use by others, it
         * will be allocated to the service; otherwise, creation of the service will
         * fail. This field can not be changed through updates. Valid values are
         * "None", empty string (""), or a valid IP address. "None" can be specified
         * for headless services when proxying is not required. Only applies to types
         * ClusterIP, NodePort, and LoadBalancer. Ignored if type is ExternalName.
         * <p>
         * Default: - Automatically assigned.
         * <p>
         * @return {@code this}
         * @see https://kubernetes.io/docs/concepts/services-networking/service/#virtual-ips-and-service-proxies
         * @param clusterIp The IP address of the service and is usually assigned randomly by the master. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder clusterIp(final java.lang.String clusterIp) {
            this.props().clusterIp(clusterIp);
            return this;
        }

        /**
         * (experimental) A list of IP addresses for which nodes in the cluster will also accept traffic for this service.
         * <p>
         * These IPs are not managed by Kubernetes. The user
         * is responsible for ensuring that traffic arrives at a node with this IP. A
         * common example is external load-balancers that are not part of the
         * Kubernetes system.
         * <p>
         * Default: - No external IPs.
         * <p>
         * @return {@code this}
         * @param externalIPs A list of IP addresses for which nodes in the cluster will also accept traffic for this service. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder externalIPs(final java.util.List<java.lang.String> externalIPs) {
            this.props().externalIPs(externalIPs);
            return this;
        }

        /**
         * (experimental) The port exposed by this service.
         * <p>
         * More info: https://kubernetes.io/docs/concepts/services-networking/service/#virtual-ips-and-service-proxies
         * <p>
         * @return {@code this}
         * @param ports The port exposed by this service. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder ports(final java.util.List<? extends org.cdk8s.plus.ServicePort> ports) {
            this.props().ports(ports);
            return this;
        }

        /**
         * (experimental) Determines how the Service is exposed.
         * <p>
         * More info: https://kubernetes.io/docs/concepts/services-networking/service/#publishing-services-service-types
         * <p>
         * Default: ServiceType.ClusterIP
         * <p>
         * @return {@code this}
         * @param type Determines how the Service is exposed. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder type(final org.cdk8s.plus.ServiceType type) {
            this.props().type(type);
            return this;
        }

        /**
         * @returns a newly built instance of {@link org.cdk8s.plus.Service}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        @Override
        public org.cdk8s.plus.Service build() {
            return new org.cdk8s.plus.Service(
                this.scope,
                this.id,
                this.props != null ? this.props.build() : null
            );
        }

        private org.cdk8s.plus.ServiceProps.Builder props() {
            if (this.props == null) {
                this.props = new org.cdk8s.plus.ServiceProps.Builder();
            }
            return this.props;
        }
    }
}
