package org.cdk8s.plus;

/**
 * (experimental) A service account provides an identity for processes that run in a Pod.
 * <p>
 * When you (a human) access the cluster (for example, using kubectl), you are
 * authenticated by the apiserver as a particular User Account (currently this
 * is usually admin, unless your cluster administrator has customized your
 * cluster). Processes in containers inside pods can also contact the apiserver.
 * When they do, they are authenticated as a particular Service Account (for
 * example, default).
 * <p>
 * @see https://kubernetes.io/docs/tasks/configure-pod-container/configure-service-account
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.13.0 (build 385c325)", date = "2020-10-21T06:58:44.694Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
@software.amazon.jsii.Jsii(module = org.cdk8s.plus.$Module.class, fqn = "cdk8s-plus.ServiceAccount")
public class ServiceAccount extends org.cdk8s.plus.Resource implements org.cdk8s.plus.IServiceAccount {

    protected ServiceAccount(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected ServiceAccount(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    /**
     * @param scope This parameter is required.
     * @param id This parameter is required.
     * @param props
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public ServiceAccount(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.Nullable org.cdk8s.plus.ServiceAccountProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), props });
    }

    /**
     * @param scope This parameter is required.
     * @param id This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public ServiceAccount(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required") });
    }

    /**
     * (experimental) Imports a service account from the cluster as a reference.
     * <p>
     * @param name The name of the service account resource. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public static @org.jetbrains.annotations.NotNull org.cdk8s.plus.IServiceAccount fromServiceAccountName(final @org.jetbrains.annotations.NotNull java.lang.String name) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(org.cdk8s.plus.ServiceAccount.class, "fromServiceAccountName", org.cdk8s.plus.IServiceAccount.class, new Object[] { java.util.Objects.requireNonNull(name, "name is required") });
    }

    /**
     * (experimental) Allow a secret to be accessed by pods using this service account.
     * <p>
     * @param secret The secret. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public void addSecret(final @org.jetbrains.annotations.NotNull org.cdk8s.plus.ISecret secret) {
        this.jsiiCall("addSecret", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(secret, "secret is required") });
    }

    /**
     * (experimental) The underlying cdk8s API object.
     * <p>
     * @see base.Resource.apiObject
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    protected @org.jetbrains.annotations.NotNull org.cdk8s.ApiObject getApiObject() {
        return this.jsiiGet("apiObject", org.cdk8s.ApiObject.class);
    }

    /**
     * (experimental) List of secrets allowed to be used by pods running using this service account.
     * <p>
     * Returns a copy. To add a secret, use <code>addSecret()</code>.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public @org.jetbrains.annotations.NotNull java.util.List<org.cdk8s.plus.ISecret> getSecrets() {
        return java.util.Collections.unmodifiableList(this.jsiiGet("secrets", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(org.cdk8s.plus.ISecret.class))));
    }

    /**
     * (experimental) A fluent builder for {@link org.cdk8s.plus.ServiceAccount}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public static final class Builder implements software.amazon.jsii.Builder<org.cdk8s.plus.ServiceAccount> {
        /**
         * @return a new instance of {@link Builder}.
         * @param scope This parameter is required.
         * @param id This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public static Builder create(final software.constructs.Construct scope, final java.lang.String id) {
            return new Builder(scope, id);
        }

        private final software.constructs.Construct scope;
        private final java.lang.String id;
        private org.cdk8s.plus.ServiceAccountProps.Builder props;

        private Builder(final software.constructs.Construct scope, final java.lang.String id) {
            this.scope = scope;
            this.id = id;
        }

        /**
         * (experimental) Metadata that all persisted resources must have, which includes all objects users must create.
         * <p>
         * @return {@code this}
         * @param metadata Metadata that all persisted resources must have, which includes all objects users must create. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder metadata(final org.cdk8s.ApiObjectMetadata metadata) {
            this.props().metadata(metadata);
            return this;
        }

        /**
         * (experimental) List of secrets allowed to be used by pods running using this ServiceAccount.
         * <p>
         * @return {@code this}
         * @see https://kubernetes.io/docs/concepts/configuration/secret
         * @param secrets List of secrets allowed to be used by pods running using this ServiceAccount. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder secrets(final java.util.List<? extends org.cdk8s.plus.ISecret> secrets) {
            this.props().secrets(secrets);
            return this;
        }

        /**
         * @returns a newly built instance of {@link org.cdk8s.plus.ServiceAccount}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        @Override
        public org.cdk8s.plus.ServiceAccount build() {
            return new org.cdk8s.plus.ServiceAccount(
                this.scope,
                this.id,
                this.props != null ? this.props.build() : null
            );
        }

        private org.cdk8s.plus.ServiceAccountProps.Builder props() {
            if (this.props == null) {
                this.props = new org.cdk8s.plus.ServiceAccountProps.Builder();
            }
            return this.props;
        }
    }
}
