package org.cdk8s.plus;

/**
 * (experimental) Properties for initialization of `Service`.
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.13.0 (build 385c325)", date = "2020-10-21T06:58:44.700Z")
@software.amazon.jsii.Jsii(module = org.cdk8s.plus.$Module.class, fqn = "cdk8s-plus.ServiceProps")
@software.amazon.jsii.Jsii.Proxy(ServiceProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
public interface ServiceProps extends software.amazon.jsii.JsiiSerializable, org.cdk8s.plus.ResourceProps {

    /**
     * (experimental) The IP address of the service and is usually assigned randomly by the master.
     * <p>
     * If an address is specified manually and is not in use by others, it
     * will be allocated to the service; otherwise, creation of the service will
     * fail. This field can not be changed through updates. Valid values are
     * "None", empty string (""), or a valid IP address. "None" can be specified
     * for headless services when proxying is not required. Only applies to types
     * ClusterIP, NodePort, and LoadBalancer. Ignored if type is ExternalName.
     * <p>
     * Default: - Automatically assigned.
     * <p>
     * @see https://kubernetes.io/docs/concepts/services-networking/service/#virtual-ips-and-service-proxies
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    default @org.jetbrains.annotations.Nullable java.lang.String getClusterIp() {
        return null;
    }

    /**
     * (experimental) A list of IP addresses for which nodes in the cluster will also accept traffic for this service.
     * <p>
     * These IPs are not managed by Kubernetes. The user
     * is responsible for ensuring that traffic arrives at a node with this IP. A
     * common example is external load-balancers that are not part of the
     * Kubernetes system.
     * <p>
     * Default: - No external IPs.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getExternalIPs() {
        return null;
    }

    /**
     * (experimental) The port exposed by this service.
     * <p>
     * More info: https://kubernetes.io/docs/concepts/services-networking/service/#virtual-ips-and-service-proxies
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    default @org.jetbrains.annotations.Nullable java.util.List<org.cdk8s.plus.ServicePort> getPorts() {
        return null;
    }

    /**
     * (experimental) Determines how the Service is exposed.
     * <p>
     * More info: https://kubernetes.io/docs/concepts/services-networking/service/#publishing-services-service-types
     * <p>
     * Default: ServiceType.ClusterIP
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    default @org.jetbrains.annotations.Nullable org.cdk8s.plus.ServiceType getType() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link ServiceProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link ServiceProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public static final class Builder implements software.amazon.jsii.Builder<ServiceProps> {
        private java.lang.String clusterIp;
        private java.util.List<java.lang.String> externalIPs;
        private java.util.List<org.cdk8s.plus.ServicePort> ports;
        private org.cdk8s.plus.ServiceType type;
        private org.cdk8s.ApiObjectMetadata metadata;

        /**
         * Sets the value of {@link ServiceProps#getClusterIp}
         * @param clusterIp The IP address of the service and is usually assigned randomly by the master.
         *                  If an address is specified manually and is not in use by others, it
         *                  will be allocated to the service; otherwise, creation of the service will
         *                  fail. This field can not be changed through updates. Valid values are
         *                  "None", empty string (""), or a valid IP address. "None" can be specified
         *                  for headless services when proxying is not required. Only applies to types
         *                  ClusterIP, NodePort, and LoadBalancer. Ignored if type is ExternalName.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder clusterIp(java.lang.String clusterIp) {
            this.clusterIp = clusterIp;
            return this;
        }

        /**
         * Sets the value of {@link ServiceProps#getExternalIPs}
         * @param externalIPs A list of IP addresses for which nodes in the cluster will also accept traffic for this service.
         *                    These IPs are not managed by Kubernetes. The user
         *                    is responsible for ensuring that traffic arrives at a node with this IP. A
         *                    common example is external load-balancers that are not part of the
         *                    Kubernetes system.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder externalIPs(java.util.List<java.lang.String> externalIPs) {
            this.externalIPs = externalIPs;
            return this;
        }

        /**
         * Sets the value of {@link ServiceProps#getPorts}
         * @param ports The port exposed by this service.
         *              More info: https://kubernetes.io/docs/concepts/services-networking/service/#virtual-ips-and-service-proxies
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        @SuppressWarnings("unchecked")
        public Builder ports(java.util.List<? extends org.cdk8s.plus.ServicePort> ports) {
            this.ports = (java.util.List<org.cdk8s.plus.ServicePort>)ports;
            return this;
        }

        /**
         * Sets the value of {@link ServiceProps#getType}
         * @param type Determines how the Service is exposed.
         *             More info: https://kubernetes.io/docs/concepts/services-networking/service/#publishing-services-service-types
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder type(org.cdk8s.plus.ServiceType type) {
            this.type = type;
            return this;
        }

        /**
         * Sets the value of {@link ServiceProps#getMetadata}
         * @param metadata Metadata that all persisted resources must have, which includes all objects users must create.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder metadata(org.cdk8s.ApiObjectMetadata metadata) {
            this.metadata = metadata;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link ServiceProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        @Override
        public ServiceProps build() {
            return new Jsii$Proxy(clusterIp, externalIPs, ports, type, metadata);
        }
    }

    /**
     * An implementation for {@link ServiceProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements ServiceProps {
        private final java.lang.String clusterIp;
        private final java.util.List<java.lang.String> externalIPs;
        private final java.util.List<org.cdk8s.plus.ServicePort> ports;
        private final org.cdk8s.plus.ServiceType type;
        private final org.cdk8s.ApiObjectMetadata metadata;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.clusterIp = this.jsiiGet("clusterIP", java.lang.String.class);
            this.externalIPs = this.jsiiGet("externalIPs", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
            this.ports = this.jsiiGet("ports", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(org.cdk8s.plus.ServicePort.class)));
            this.type = this.jsiiGet("type", org.cdk8s.plus.ServiceType.class);
            this.metadata = this.jsiiGet("metadata", org.cdk8s.ApiObjectMetadata.class);
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        @SuppressWarnings("unchecked")
        private Jsii$Proxy(final java.lang.String clusterIp, final java.util.List<java.lang.String> externalIPs, final java.util.List<? extends org.cdk8s.plus.ServicePort> ports, final org.cdk8s.plus.ServiceType type, final org.cdk8s.ApiObjectMetadata metadata) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.clusterIp = clusterIp;
            this.externalIPs = externalIPs;
            this.ports = (java.util.List<org.cdk8s.plus.ServicePort>)ports;
            this.type = type;
            this.metadata = metadata;
        }

        @Override
        public java.lang.String getClusterIp() {
            return this.clusterIp;
        }

        @Override
        public java.util.List<java.lang.String> getExternalIPs() {
            return this.externalIPs;
        }

        @Override
        public java.util.List<org.cdk8s.plus.ServicePort> getPorts() {
            return this.ports;
        }

        @Override
        public org.cdk8s.plus.ServiceType getType() {
            return this.type;
        }

        @Override
        public org.cdk8s.ApiObjectMetadata getMetadata() {
            return this.metadata;
        }

        @Override
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            if (this.getClusterIp() != null) {
                data.set("clusterIP", om.valueToTree(this.getClusterIp()));
            }
            if (this.getExternalIPs() != null) {
                data.set("externalIPs", om.valueToTree(this.getExternalIPs()));
            }
            if (this.getPorts() != null) {
                data.set("ports", om.valueToTree(this.getPorts()));
            }
            if (this.getType() != null) {
                data.set("type", om.valueToTree(this.getType()));
            }
            if (this.getMetadata() != null) {
                data.set("metadata", om.valueToTree(this.getMetadata()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("cdk8s-plus.ServiceProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            ServiceProps.Jsii$Proxy that = (ServiceProps.Jsii$Proxy) o;

            if (this.clusterIp != null ? !this.clusterIp.equals(that.clusterIp) : that.clusterIp != null) return false;
            if (this.externalIPs != null ? !this.externalIPs.equals(that.externalIPs) : that.externalIPs != null) return false;
            if (this.ports != null ? !this.ports.equals(that.ports) : that.ports != null) return false;
            if (this.type != null ? !this.type.equals(that.type) : that.type != null) return false;
            return this.metadata != null ? this.metadata.equals(that.metadata) : that.metadata == null;
        }

        @Override
        public int hashCode() {
            int result = this.clusterIp != null ? this.clusterIp.hashCode() : 0;
            result = 31 * result + (this.externalIPs != null ? this.externalIPs.hashCode() : 0);
            result = 31 * result + (this.ports != null ? this.ports.hashCode() : 0);
            result = 31 * result + (this.type != null ? this.type.hashCode() : 0);
            result = 31 * result + (this.metadata != null ? this.metadata.hashCode() : 0);
            return result;
        }
    }
}
