/*
 * Decompiled with CFR 0.152.
 */
package org.cdk8s.plus;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.cdk8s.ApiObject;
import org.cdk8s.ApiObjectMetadata;
import org.cdk8s.plus.$Module;
import org.cdk8s.plus.IngressBackend;
import org.cdk8s.plus.IngressProps;
import org.cdk8s.plus.IngressRule;
import org.cdk8s.plus.Resource;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import software.amazon.jsii.Jsii;
import software.amazon.jsii.JsiiEngine;
import software.amazon.jsii.JsiiObject;
import software.amazon.jsii.JsiiObjectRef;
import software.amazon.jsii.NativeType;
import software.constructs.Construct;

@Jsii(module=$Module.class, fqn="cdk8s-plus.Ingress")
public class Ingress
extends Resource {
    protected Ingress(JsiiObjectRef objRef) {
        super(objRef);
    }

    protected Ingress(JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    public Ingress(@NotNull Construct scope, @NotNull String id, @Nullable IngressProps props) {
        super(JsiiObject.InitializationMode.JSII);
        JsiiEngine.getInstance().createNewObject((Object)this, new Object[]{Objects.requireNonNull(scope, "scope is required"), Objects.requireNonNull(id, "id is required"), props});
    }

    public Ingress(@NotNull Construct scope, @NotNull String id) {
        super(JsiiObject.InitializationMode.JSII);
        JsiiEngine.getInstance().createNewObject((Object)this, new Object[]{Objects.requireNonNull(scope, "scope is required"), Objects.requireNonNull(id, "id is required")});
    }

    public void addDefaultBackend(@NotNull IngressBackend backend) {
        this.jsiiCall("addDefaultBackend", NativeType.VOID, new Object[]{Objects.requireNonNull(backend, "backend is required")});
    }

    public void addHostDefaultBackend(@NotNull String host, @NotNull IngressBackend backend) {
        this.jsiiCall("addHostDefaultBackend", NativeType.VOID, new Object[]{Objects.requireNonNull(host, "host is required"), Objects.requireNonNull(backend, "backend is required")});
    }

    public void addHostRule(@NotNull String host, @NotNull String path, @NotNull IngressBackend backend) {
        this.jsiiCall("addHostRule", NativeType.VOID, new Object[]{Objects.requireNonNull(host, "host is required"), Objects.requireNonNull(path, "path is required"), Objects.requireNonNull(backend, "backend is required")});
    }

    public void addRule(@NotNull String path, @NotNull IngressBackend backend) {
        this.jsiiCall("addRule", NativeType.VOID, new Object[]{Objects.requireNonNull(path, "path is required"), Objects.requireNonNull(backend, "backend is required")});
    }

    public void addRules(IngressRule ... rules) {
        this.jsiiCall("addRules", NativeType.VOID, Arrays.stream(rules).toArray(Object[]::new));
    }

    @NotNull
    protected List<String> onValidate() {
        return Collections.unmodifiableList((List)this.jsiiCall("onValidate", NativeType.listOf((NativeType)NativeType.forClass(String.class)), new Object[0]));
    }

    @Override
    @NotNull
    protected ApiObject getApiObject() {
        return (ApiObject)this.jsiiGet("apiObject", ApiObject.class);
    }

    public static final class Builder
    implements software.amazon.jsii.Builder<Ingress> {
        private final Construct scope;
        private final String id;
        private IngressProps.Builder props;

        public static Builder create(Construct scope, String id) {
            return new Builder(scope, id);
        }

        private Builder(Construct scope, String id) {
            this.scope = scope;
            this.id = id;
        }

        public Builder metadata(ApiObjectMetadata metadata) {
            this.props().metadata(metadata);
            return this;
        }

        public Builder defaultBackend(IngressBackend defaultBackend) {
            this.props().defaultBackend(defaultBackend);
            return this;
        }

        public Builder rules(List<? extends IngressRule> rules) {
            this.props().rules(rules);
            return this;
        }

        public Ingress build() {
            return new Ingress(this.scope, this.id, this.props != null ? this.props.build() : null);
        }

        private IngressProps.Builder props() {
            if (this.props == null) {
                this.props = new IngressProps.Builder();
            }
            return this.props;
        }
    }
}

