/*
 * Decompiled with CFR 0.152.
 */
package org.cdk8s.plus;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.cdk8s.ApiObject;
import org.cdk8s.ApiObjectMetadata;
import org.cdk8s.plus.;
import org.cdk8s.plus.Deployment;
import org.cdk8s.plus.Resource;
import org.cdk8s.plus.ServicePort;
import org.cdk8s.plus.ServicePortOptions;
import org.cdk8s.plus.ServiceProps;
import org.cdk8s.plus.ServiceType;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import software.amazon.jsii.Jsii;
import software.amazon.jsii.JsiiEngine;
import software.amazon.jsii.JsiiObject;
import software.amazon.jsii.JsiiObjectRef;
import software.amazon.jsii.NativeType;
import software.constructs.Construct;

@Jsii(module=.Module.class, fqn="cdk8s-plus.Service")
public class Service
extends Resource {
    protected Service(JsiiObjectRef objRef) {
        super(objRef);
    }

    protected Service(JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    public Service(@NotNull Construct scope, @NotNull String id, @Nullable ServiceProps props) {
        super(JsiiObject.InitializationMode.JSII);
        JsiiEngine.getInstance().createNewObject((Object)this, new Object[]{Objects.requireNonNull(scope, "scope is required"), Objects.requireNonNull(id, "id is required"), props});
    }

    public Service(@NotNull Construct scope, @NotNull String id) {
        super(JsiiObject.InitializationMode.JSII);
        JsiiEngine.getInstance().createNewObject((Object)this, new Object[]{Objects.requireNonNull(scope, "scope is required"), Objects.requireNonNull(id, "id is required")});
    }

    public void addDeployment(@NotNull Deployment deployment, @NotNull Number port) {
        this.jsiiCall("addDeployment", NativeType.VOID, new Object[]{Objects.requireNonNull(deployment, "deployment is required"), Objects.requireNonNull(port, "port is required")});
    }

    public void addSelector(@NotNull String label, @NotNull String value) {
        this.jsiiCall("addSelector", NativeType.VOID, new Object[]{Objects.requireNonNull(label, "label is required"), Objects.requireNonNull(value, "value is required")});
    }

    public void serve(@NotNull Number port, @Nullable ServicePortOptions options) {
        this.jsiiCall("serve", NativeType.VOID, new Object[]{Objects.requireNonNull(port, "port is required"), options});
    }

    public void serve(@NotNull Number port) {
        this.jsiiCall("serve", NativeType.VOID, new Object[]{Objects.requireNonNull(port, "port is required")});
    }

    @Override
    @NotNull
    protected ApiObject getApiObject() {
        return (ApiObject)this.jsiiGet("apiObject", ApiObject.class);
    }

    @NotNull
    public List<ServicePort> getPorts() {
        return Collections.unmodifiableList((List)this.jsiiGet("ports", NativeType.listOf((NativeType)NativeType.forClass(ServicePort.class))));
    }

    @NotNull
    public Map<String, String> getSelector() {
        return Collections.unmodifiableMap((Map)this.jsiiGet("selector", NativeType.mapOf((NativeType)NativeType.forClass(String.class))));
    }

    @NotNull
    public ServiceType getType() {
        return (ServiceType)((Object)this.jsiiGet("type", ServiceType.class));
    }

    @Nullable
    public String getClusterIp() {
        return (String)this.jsiiGet("clusterIP", String.class);
    }

    public static final class Builder
    implements software.amazon.jsii.Builder<Service> {
        private final Construct scope;
        private final String id;
        private ServiceProps.Builder props;

        public static Builder create(Construct scope, String id) {
            return new Builder(scope, id);
        }

        private Builder(Construct scope, String id) {
            this.scope = scope;
            this.id = id;
        }

        public Builder metadata(ApiObjectMetadata metadata) {
            this.props().metadata(metadata);
            return this;
        }

        public Builder clusterIp(String clusterIp) {
            this.props().clusterIp(clusterIp);
            return this;
        }

        public Builder externalIPs(List<String> externalIPs) {
            this.props().externalIPs(externalIPs);
            return this;
        }

        public Builder ports(List<? extends ServicePort> ports) {
            this.props().ports(ports);
            return this;
        }

        public Builder type(ServiceType type) {
            this.props().type(type);
            return this;
        }

        public Service build() {
            return new Service(this.scope, this.id, this.props != null ? this.props.build() : null);
        }

        private ServiceProps.Builder props() {
            if (this.props == null) {
                this.props = new ServiceProps.Builder();
            }
            return this.props;
        }
    }
}

