/*
 * Decompiled with CFR 0.152.
 */
package org.cempaka.cyclone.cli;

import java.io.IOException;
import java.time.Duration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.cempaka.cyclone.listeners.DaemonChannel;
import org.cempaka.cyclone.listeners.UdpDaemonChannel;
import org.cempaka.cyclone.listeners.payloads.EndedPayload;
import org.cempaka.cyclone.listeners.payloads.Payload;
import org.cempaka.cyclone.listeners.payloads.RunningPayload;
import org.cempaka.cyclone.listeners.payloads.StartedPayload;
import org.cempaka.cyclone.measurements.MeasurementRegistry;
import org.cempaka.cyclone.runner.LoopRunner;
import org.cempaka.cyclone.runner.Runner;
import org.cempaka.cyclone.runner.SimpleRunner;
import org.cempaka.cyclone.runner.ThreadRunner;
import picocli.CommandLine;

public class CycloneCli {
    private static final Duration RUNNER_AWAIT_TIME = Duration.ofMinutes(1L);
    @CommandLine.Option(names={"-c", "--test-classes"}, description={"test names to run"}, required=true, split=",")
    private String[] testNames;
    @CommandLine.Option(names={"-n", "--loopCount"}, description={"number of loops to run"}, defaultValue="1")
    private long loopCount;
    @CommandLine.Option(names={"-t", "--threads"}, description={"number of threads to run"}, defaultValue="1")
    private int threads;
    @CommandLine.Option(names={"-p", "--parameters"}, description={"passed parameters to tests"}, split=",")
    private Map<String, String> parameters = new HashMap<String, String>();
    @CommandLine.Option(names={"--daemon-port"}, description={"daemon port to send updates"})
    private int daemonPort;
    @CommandLine.Option(names={"--test-id"}, description={"test id to receive updates"})
    private String testId = "unknown";
    @CommandLine.Option(names={"--measurement-period"}, description={"measurements period in seconds"}, defaultValue="5")
    private int measurementsPeriod;
    private final MeasurementRegistry measurementRegistry = new MeasurementRegistry();
    private final DaemonChannel daemonChannel = new UdpDaemonChannel();
    private final ScheduledExecutorService metricsExecutor = Executors.newSingleThreadScheduledExecutor();

    private CycloneCli() {
    }

    public static void main(String[] args) throws IOException, InterruptedException {
        CycloneCli cycloneCli = new CycloneCli();
        new CommandLine((Object)cycloneCli).parse(args);
        int exitCode = cycloneCli.run();
        System.exit(exitCode);
    }

    private int run() throws IOException, InterruptedException {
        if (this.isUdpEnabled()) {
            this.daemonChannel.connect();
            this.daemonChannel.write((Payload)new StartedPayload(this.testId), this.daemonPort);
            this.metricsExecutor.scheduleAtFixedRate(this::reportMetrics, 1L, this.measurementsPeriod, TimeUnit.SECONDS);
        }
        EndedPayload endedPayload = this.runTest();
        this.metricsExecutor.shutdown();
        this.metricsExecutor.awaitTermination(1L, TimeUnit.MINUTES);
        if (this.isUdpEnabled()) {
            this.daemonChannel.write((Payload)endedPayload, this.daemonPort);
        }
        this.daemonChannel.close();
        return endedPayload.getExitCode();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private EndedPayload runTest() throws InterruptedException {
        List<Class> testClasses = this.loadTestClasses();
        SimpleRunner simpleRunner = new SimpleRunner(testClasses, this.parameters, this.measurementRegistry);
        ThreadRunner threadRunner = new ThreadRunner((Runner)simpleRunner, this.threads);
        LoopRunner runner = new LoopRunner((Runner)threadRunner, this.loopCount);
        try {
            runner.run();
            this.reportMetrics();
            EndedPayload endedPayload = new EndedPayload(this.testId, 0);
            return endedPayload;
        }
        catch (Exception e) {
            e.printStackTrace();
            EndedPayload endedPayload = new EndedPayload(this.testId, -1);
            return endedPayload;
        }
        finally {
            threadRunner.awaitTermination(RUNNER_AWAIT_TIME);
        }
    }

    private boolean isUdpEnabled() {
        return this.daemonPort > 0;
    }

    private void reportMetrics() {
        if (this.isUdpEnabled()) {
            Map measurements = this.measurementRegistry.getSnapshots();
            RunningPayload runningPayload = new RunningPayload(this.testId, measurements);
            this.daemonChannel.write((Payload)runningPayload, this.daemonPort);
        }
    }

    private List<Class> loadTestClasses() {
        return Stream.of(this.testNames).map(className -> {
            try {
                return Class.forName(className);
            }
            catch (ClassNotFoundException e) {
                throw new RuntimeException(e);
            }
        }).collect(Collectors.toList());
    }
}

