/*
 * Decompiled with CFR 0.152.
 */
package org.cempaka.cyclone.cli;

import com.google.common.reflect.ClassPath;
import java.io.IOException;
import java.lang.reflect.Field;
import java.util.stream.Stream;
import org.cempaka.cyclone.utils.Metadata;
import org.cempaka.cyclone.utils.Reflections;

public class MetadataPrint {
    public static void main(String[] args) throws IOException {
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        ClassPath.from((ClassLoader)classLoader).getTopLevelClasses().stream().filter(MetadataPrint::isTestClass).map(ClassPath.ClassInfo::load).filter(clazz -> Stream.of(clazz.getDeclaredMethods()).anyMatch(Reflections::isThunderboltMethod)).forEach(MetadataPrint::printTestMetadata);
    }

    private static void printTestMetadata(Class<?> clazz) {
        Object object = Reflections.newInstance(clazz);
        System.out.print(clazz.getName());
        MetadataPrint.printSeparator();
        Stream.of(clazz.getDeclaredFields()).filter(Reflections::isFieldParameter).forEach(field -> {
            field.setAccessible(true);
            System.out.print(field.getName() + ":" + field.getType().getSimpleName() + ":" + Reflections.getFieldValue((Object)object, (Field)field));
            MetadataPrint.printSeparator();
        });
        System.out.print("\n");
    }

    private static boolean isTestClass(ClassPath.ClassInfo classInfo) {
        return Metadata.TEST_PATTERN.asPredicate().test(classInfo.getSimpleName());
    }

    private static void printSeparator() {
        System.out.print(";");
    }
}

