/*
 * Decompiled with CFR 0.152.
 */
package org.cempaka.cyclone.measurements.codehale;

import com.codahale.metrics.Snapshot;
import com.codahale.metrics.Timer;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.TimeUnit;
import org.cempaka.cyclone.measurements.Measurement;

public class TimerMeasurement
extends Measurement {
    private final Timer timer = new Timer();

    public TimerMeasurement(String name) {
        super(name);
    }

    public void update(long duration, TimeUnit timeUnit) {
        this.timer.update(duration, timeUnit);
    }

    public Timer.Context time() {
        return this.timer.time();
    }

    public <T> T time(Callable<T> callable) throws Exception {
        return (T)this.timer.time(callable);
    }

    public Map<String, Double> getSnapshot() {
        Snapshot snapshot = this.timer.getSnapshot();
        HashMap<String, Double> metrics = new HashMap<String, Double>();
        metrics.put("median", snapshot.getMedian());
        metrics.put("mean", snapshot.getMean());
        metrics.put("max", Double.valueOf(snapshot.getMax()));
        metrics.put("min", Double.valueOf(snapshot.getMin()));
        metrics.put("p75", snapshot.get75thPercentile());
        metrics.put("p95", snapshot.get95thPercentile());
        metrics.put("p99", snapshot.get99thPercentile());
        metrics.put("p999", snapshot.get999thPercentile());
        return Collections.unmodifiableMap(metrics);
    }
}

