/*
 * Copyright Red Hat Inc. and/or its affiliates and other contributors
 * as indicated by the authors tag. All rights reserved.
 *
 * This copyrighted material is made available to anyone wishing to use,
 * modify, copy, or redistribute it subject to the terms and conditions
 * of the GNU General Public License version 2.
 * 
 * This particular file is subject to the "Classpath" exception as provided in the 
 * LICENSE file that accompanied this code.
 * 
 * This program is distributed in the hope that it will be useful, but WITHOUT A
 * WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR A
 * PARTICULAR PURPOSE.  See the GNU General Public License for more details.
 * You should have received a copy of the GNU General Public License,
 * along with this distribution; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston,
 * MA  02110-1301, USA.
 */

package com.redhat.ceylon.ant;

import org.apache.tools.ant.types.DataType;
import org.apache.tools.ant.types.Reference;

public class Link extends DataType {
    public String url;
    public String pattern;

    @AntDoc("A URL or path of a module repository containing documentation "
            + "for external dependencies.")
    public void setUrl(String url){
        this.url = url;
    }
    
    @AntDoc("A module name prefix limiting the applicability of the "
            + "URL to modules whose name matches the prefix.")
    public void setPattern(String pattern){
        this.pattern = pattern;
    }
    
    @Override
    @AntDoc("A reference to a `<link>` defined outside this task.")
    public void setRefid(Reference reference) {
        super.setRefid(reference);
    }

    @Override
    public String toString() {
        if(pattern == null)
            return url;
        else
            return pattern+"="+url;
    }

    @Override
    public int hashCode() {
        final int prime = 31;
        int result = 1;
        result = prime * result + ((url == null) ? 0 : url.hashCode());
        result = prime * result + ((pattern == null) ? 0 : pattern.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj)
            return true;
        if (obj == null)
            return false;
        if (getClass() != obj.getClass())
            return false;
        Link other = (Link) obj;
        if (url == null) {
            if (other.url != null)
                return false;
        } else if (!url.equals(other.url))
            return false;
        if (pattern == null) {
            if (other.pattern != null)
                return false;
        } else if (!pattern.equals(other.pattern))
            return false;
        return true;
    }
    
    
}
