/*
 * Copyright 2011 Red Hat inc. and third party contributors as noted 
 * by the author tags.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package com.redhat.ceylon.cmr.impl;

/**
 * Thrown when a module artifact has an invalid SHA1 signature.
 *
 * @author Stéphane Épardaud <stef@epardaud.fr>
 */
@SuppressWarnings("serial")
public class InvalidArchiveException extends RuntimeException {

    private String path;
    private String repository;

    public InvalidArchiveException(String message, String path, String repository) {
        super(message);
        this.path = path;
        this.repository = repository;
    }

    public String getPath(){
        return path;
    }

    public String getRepository() {
        return repository;
    }
}
