package com.redhat.ceylon.compiler.typechecker.tree;

import static com.redhat.ceylon.compiler.typechecker.tree.Walker.*;

import org.antlr.runtime.Token;

import java.util.*;

public class Tree {

    /**
     * A file containing Ceylon source.
     */
    public static class CompilationUnit extends Node {

        public CompilationUnit(Token token) {
            super(token);
        }

        @Override public void visit(Visitor visitor) {
            try {
                visitor.visit(this);
            }
            catch (Exception e) {
                visitor.handleException(e, this);
            }
        }

        @Override public void visitChildren(Visitor visitor) {
            walkCompilationUnit(visitor, this);
        }

        private List<CompilerAnnotation> compilerAnnotations = new ArrayList<CompilerAnnotation>(3);
        public List<CompilerAnnotation> getCompilerAnnotations() { return compilerAnnotations; }
        public void addCompilerAnnotation(CompilerAnnotation node) { compilerAnnotations.add(node); connect(node); }

        private ImportList importList;
        public ImportList getImportList() { return importList; }
        public void setImportList(ImportList node) { importList = node; connect(node); }

        private List<ModuleDescriptor> moduleDescriptors = new ArrayList<ModuleDescriptor>(3);
        public List<ModuleDescriptor> getModuleDescriptors() { return moduleDescriptors; }
        public void addModuleDescriptor(ModuleDescriptor node) { moduleDescriptors.add(node); connect(node); }

        private List<PackageDescriptor> packageDescriptors = new ArrayList<PackageDescriptor>(3);
        public List<PackageDescriptor> getPackageDescriptors() { return packageDescriptors; }
        public void addPackageDescriptor(PackageDescriptor node) { packageDescriptors.add(node); connect(node); }

        private List<Declaration> declarations = new ArrayList<Declaration>(3);
        public List<Declaration> getDeclarations() { return declarations; }
        public void addDeclaration(Declaration node) { declarations.add(node); connect(node); }

        private boolean literalsProcessed;
        public boolean getLiteralsProcessed() { return literalsProcessed; }
        public void setLiteralsProcessed(boolean value) { literalsProcessed = value; }

    }

    /**
     * A module descriptor.
     */
    public static class ModuleDescriptor extends StatementOrArgument {

        public ModuleDescriptor(Token token) {
            super(token);
        }

        @Override public void visit(Visitor visitor) {
            try {
                visitor.visit(this);
            }
            catch (Exception e) {
                visitor.handleException(e, this);
            }
        }

        @Override public void visitChildren(Visitor visitor) {
            walkModuleDescriptor(visitor, this);
        }

        private AnnotationList annotationList;
        public AnnotationList getAnnotationList() { return annotationList; }
        public void setAnnotationList(AnnotationList node) { annotationList = node; connect(node); }

        private ImportPath importPath;
        public ImportPath getImportPath() { return importPath; }
        public void setImportPath(ImportPath node) { importPath = node; connect(node); }

        private Identifier namespace;
        public Identifier getNamespace() { return namespace; }
        public void setNamespace(Identifier node) { namespace = node; connect(node); }

        private ImportPath groupImportPath;
        public ImportPath getGroupImportPath() { return groupImportPath; }
        public void setGroupImportPath(ImportPath node) { groupImportPath = node; connect(node); }

        private QuotedLiteral groupQuotedLiteral;
        public QuotedLiteral getGroupQuotedLiteral() { return groupQuotedLiteral; }
        public void setGroupQuotedLiteral(QuotedLiteral node) { groupQuotedLiteral = node; connect(node); }

        private QuotedLiteral artifact;
        public QuotedLiteral getArtifact() { return artifact; }
        public void setArtifact(QuotedLiteral node) { artifact = node; connect(node); }

        private QuotedLiteral classifier;
        public QuotedLiteral getClassifier() { return classifier; }
        public void setClassifier(QuotedLiteral node) { classifier = node; connect(node); }

        private QuotedLiteral version;
        public QuotedLiteral getVersion() { return version; }
        public void setVersion(QuotedLiteral node) { version = node; connect(node); }

        private ImportModuleList importModuleList;
        public ImportModuleList getImportModuleList() { return importModuleList; }
        public void setImportModuleList(ImportModuleList node) { importModuleList = node; connect(node); }

    }

    /**
     * A package descriptor.
     */
    public static class PackageDescriptor extends StatementOrArgument {

        public PackageDescriptor(Token token) {
            super(token);
        }

        @Override public void visit(Visitor visitor) {
            try {
                visitor.visit(this);
            }
            catch (Exception e) {
                visitor.handleException(e, this);
            }
        }

        @Override public void visitChildren(Visitor visitor) {
            walkPackageDescriptor(visitor, this);
        }

        private AnnotationList annotationList;
        public AnnotationList getAnnotationList() { return annotationList; }
        public void setAnnotationList(AnnotationList node) { annotationList = node; connect(node); }

        private ImportPath importPath;
        public ImportPath getImportPath() { return importPath; }
        public void setImportPath(ImportPath node) { importPath = node; connect(node); }

    }

    /**
     * A list of modules imported by a module.
     */
    public static class ImportModuleList extends Node {

        public ImportModuleList(Token token) {
            super(token);
        }

        @Override public void visit(Visitor visitor) {
            try {
                visitor.visit(this);
            }
            catch (Exception e) {
                visitor.handleException(e, this);
            }
        }

        @Override public void visitChildren(Visitor visitor) {
            walkImportModuleList(visitor, this);
        }

        private List<AnyAttribute> constants = new ArrayList<AnyAttribute>(3);
        public List<AnyAttribute> getConstants() { return constants; }
        public void addConstant(AnyAttribute node) { constants.add(node); connect(node); }

        private List<ImportModule> importModules = new ArrayList<ImportModule>(3);
        public List<ImportModule> getImportModules() { return importModules; }
        public void addImportModule(ImportModule node) { importModules.add(node); connect(node); }

    }

    /**
     * A module import.
     */
    public static class ImportModule extends StatementOrArgument {

        public ImportModule(Token token) {
            super(token);
        }

        @Override public void visit(Visitor visitor) {
            try {
                visitor.visit(this);
            }
            catch (Exception e) {
                visitor.handleException(e, this);
            }
        }

        @Override public void visitChildren(Visitor visitor) {
            walkImportModule(visitor, this);
        }

        private AnnotationList annotationList;
        public AnnotationList getAnnotationList() { return annotationList; }
        public void setAnnotationList(AnnotationList node) { annotationList = node; connect(node); }

        private Identifier namespace;
        public Identifier getNamespace() { return namespace; }
        public void setNamespace(Identifier node) { namespace = node; connect(node); }

        private ImportPath importPath;
        public ImportPath getImportPath() { return importPath; }
        public void setImportPath(ImportPath node) { importPath = node; connect(node); }

        private QuotedLiteral quotedLiteral;
        public QuotedLiteral getQuotedLiteral() { return quotedLiteral; }
        public void setQuotedLiteral(QuotedLiteral node) { quotedLiteral = node; connect(node); }

        private QuotedLiteral artifact;
        public QuotedLiteral getArtifact() { return artifact; }
        public void setArtifact(QuotedLiteral node) { artifact = node; connect(node); }

        private QuotedLiteral classifier;
        public QuotedLiteral getClassifier() { return classifier; }
        public void setClassifier(QuotedLiteral node) { classifier = node; connect(node); }

        private QuotedLiteral version;
        public QuotedLiteral getVersion() { return version; }
        public void setVersion(QuotedLiteral node) { version = node; connect(node); }

        private BaseMemberExpression constantVersion;
        public BaseMemberExpression getConstantVersion() { return constantVersion; }
        public void setConstantVersion(BaseMemberExpression node) { constantVersion = node; connect(node); }

        private String name;
        public String getName() { return name; }
        public void setName(String value) { name = value; }

    }

    /**
     * A list of packages imported by a compilation unit.
     */
    public static class ImportList extends Node {

        public ImportList(Token token) {
            super(token);
        }

        @Override public void visit(Visitor visitor) {
            try {
                visitor.visit(this);
            }
            catch (Exception e) {
                visitor.handleException(e, this);
            }
        }

        @Override public void visitChildren(Visitor visitor) {
            walkImportList(visitor, this);
        }

        private List<Import> imports = new ArrayList<Import>(3);
        public List<Import> getImports() { return imports; }
        public void addImport(Import node) { imports.add(node); connect(node); }

    }

    /**
     * A package import.
     */
    public static class Import extends StatementOrArgument {

        public Import(Token token) {
            super(token);
        }

        @Override public void visit(Visitor visitor) {
            try {
                visitor.visit(this);
            }
            catch (Exception e) {
                visitor.handleException(e, this);
            }
        }

        @Override public void visitChildren(Visitor visitor) {
            walkImport(visitor, this);
        }

        private ImportPath importPath;
        public ImportPath getImportPath() { return importPath; }
        public void setImportPath(ImportPath node) { importPath = node; connect(node); }

        private ImportMemberOrTypeList importMemberOrTypeList;
        public ImportMemberOrTypeList getImportMemberOrTypeList() { return importMemberOrTypeList; }
        public void setImportMemberOrTypeList(ImportMemberOrTypeList node) { importMemberOrTypeList = node; connect(node); }

    }

    /**
     * A reference to a package or module.
     */
    public static class ImportPath extends Node {

        public ImportPath(Token token) {
            super(token);
        }

        @Override public void visit(Visitor visitor) {
            try {
                visitor.visit(this);
            }
            catch (Exception e) {
                visitor.handleException(e, this);
            }
        }

        @Override public void visitChildren(Visitor visitor) {
            walkImportPath(visitor, this);
        }

        private List<Identifier> identifiers = new ArrayList<Identifier>(3);
        public List<Identifier> getIdentifiers() { return identifiers; }
        public void addIdentifier(Identifier node) { identifiers.add(node); connect(node); }

        private com.redhat.ceylon.model.typechecker.model.Referenceable model;
        public com.redhat.ceylon.model.typechecker.model.Referenceable getModel() { return model; }
        public void setModel(com.redhat.ceylon.model.typechecker.model.Referenceable value) { model = value; }

    }

    /**
     * A list of declarations imported from a package.
     */
    public static class ImportMemberOrTypeList extends Node {

        public ImportMemberOrTypeList(Token token) {
            super(token);
        }

        @Override public void visit(Visitor visitor) {
            try {
                visitor.visit(this);
            }
            catch (Exception e) {
                visitor.handleException(e, this);
            }
        }

        @Override public void visitChildren(Visitor visitor) {
            walkImportMemberOrTypeList(visitor, this);
        }

        private List<ImportMemberOrType> importMemberOrTypes = new ArrayList<ImportMemberOrType>(3);
        public List<ImportMemberOrType> getImportMemberOrTypes() { return importMemberOrTypes; }
        public void addImportMemberOrType(ImportMemberOrType node) { importMemberOrTypes.add(node); connect(node); }

        private ImportWildcard importWildcard;
        public ImportWildcard getImportWildcard() { return importWildcard; }
        public void setImportWildcard(ImportWildcard node) { importWildcard = node; connect(node); }

        private com.redhat.ceylon.model.typechecker.model.ImportList importList;
        public com.redhat.ceylon.model.typechecker.model.ImportList getImportList() { return importList; }
        public void setImportList(com.redhat.ceylon.model.typechecker.model.ImportList value) { importList = value; }

    }

    /**
     * A declaration imported from a package.
     */
    public static class ImportMemberOrType extends StatementOrArgument {

        public ImportMemberOrType(Token token) {
            super(token);
        }

        @Override public void visit(Visitor visitor) {
            try {
                visitor.visit(this);
            }
            catch (Exception e) {
                visitor.handleException(e, this);
            }
        }

        @Override public void visitChildren(Visitor visitor) {
            walkImportMemberOrType(visitor, this);
        }

        private Alias alias;
        public Alias getAlias() { return alias; }
        public void setAlias(Alias node) { alias = node; connect(node); }

        private Identifier identifier;
        public Identifier getIdentifier() { return identifier; }
        public void setIdentifier(Identifier node) { identifier = node; connect(node); }

        private ImportMemberOrTypeList importMemberOrTypeList;
        public ImportMemberOrTypeList getImportMemberOrTypeList() { return importMemberOrTypeList; }
        public void setImportMemberOrTypeList(ImportMemberOrTypeList node) { importMemberOrTypeList = node; connect(node); }

        private com.redhat.ceylon.model.typechecker.model.Declaration declarationModel;
        public com.redhat.ceylon.model.typechecker.model.Declaration getDeclarationModel() { return declarationModel; }
        public void setDeclarationModel(com.redhat.ceylon.model.typechecker.model.Declaration value) { declarationModel = value; }

        private com.redhat.ceylon.model.typechecker.model.Import importModel;
        public com.redhat.ceylon.model.typechecker.model.Import getImportModel() { return importModel; }
        public void setImportModel(com.redhat.ceylon.model.typechecker.model.Import value) { importModel = value; }

    }

    /**
     * An imported function or value.
     */
    public static class ImportMember extends ImportMemberOrType {

        public ImportMember(Token token) {
            super(token);
        }

        @Override public void visit(Visitor visitor) {
            try {
                visitor.visit(this);
            }
            catch (Exception e) {
                visitor.handleException(e, this);
            }
        }

        @Override public void visitChildren(Visitor visitor) {
            walkImportMember(visitor, this);
        }

    }

    /**
     * An imported type.
     */
    public static class ImportType extends ImportMemberOrType {

        public ImportType(Token token) {
            super(token);
        }

        @Override public void visit(Visitor visitor) {
            try {
                visitor.visit(this);
            }
            catch (Exception e) {
                visitor.handleException(e, this);
            }
        }

        @Override public void visitChildren(Visitor visitor) {
            walkImportType(visitor, this);
        }

    }

    /**
     * An alias for an imported declaration.
     */
    public static class Alias extends Node {

        public Alias(Token token) {
            super(token);
        }

        @Override public void visit(Visitor visitor) {
            try {
                visitor.visit(this);
            }
            catch (Exception e) {
                visitor.handleException(e, this);
            }
        }

        @Override public void visitChildren(Visitor visitor) {
            walkAlias(visitor, this);
        }

        private Identifier identifier;
        public Identifier getIdentifier() { return identifier; }
        public void setIdentifier(Identifier node) { identifier = node; connect(node); }

    }

    /**
     * A wildcard in a package import statement.
     */
    public static class ImportWildcard extends Node {

        public ImportWildcard(Token token) {
            super(token);
        }

        @Override public void visit(Visitor visitor) {
            try {
                visitor.visit(this);
            }
            catch (Exception e) {
                visitor.handleException(e, this);
            }
        }

        @Override public void visitChildren(Visitor visitor) {
            walkImportWildcard(visitor, this);
        }

    }

    /**
     * A declaration.
     */
    public static abstract class Declaration extends Statement {

        public Declaration(Token token) {
            super(token);
        }

        @Override public void visit(Visitor visitor) {
            try {
                visitor.visit(this);
            }
            catch (Exception e) {
                visitor.handleException(e, this);
            }
        }

        @Override public void visitChildren(Visitor visitor) {
            walkDeclaration(visitor, this);
        }

        private AnnotationList annotationList;
        public AnnotationList getAnnotationList() { return annotationList; }
        public void setAnnotationList(AnnotationList node) { annotationList = node; connect(node); }

        private Identifier identifier;
        public Identifier getIdentifier() { return identifier; }
        public void setIdentifier(Identifier node) { identifier = node; connect(node); }

        public abstract com.redhat.ceylon.model.typechecker.model.Declaration getDeclarationModel();

    }

    public static class MissingDeclaration extends Declaration {

        public MissingDeclaration(Token token) {
            super(token);
        }

        @Override public void visit(Visitor visitor) {
            try {
                visitor.visit(this);
            }
            catch (Exception e) {
                visitor.handleException(e, this);
            }
        }

        @Override public void visitChildren(Visitor visitor) {
            walkMissingDeclaration(visitor, this);
        }

        private com.redhat.ceylon.model.typechecker.model.Declaration declarationModel;
        public com.redhat.ceylon.model.typechecker.model.Declaration getDeclarationModel() { return declarationModel; }
        public void setDeclarationModel(com.redhat.ceylon.model.typechecker.model.Declaration value) { declarationModel = value; }

    }

    /**
     * A class, interface, or type parameter declaration.
     */
    public static abstract class TypeDeclaration extends Declaration {

        public TypeDeclaration(Token token) {
            super(token);
        }

        @Override public void visit(Visitor visitor) {
            try {
                visitor.visit(this);
            }
            catch (Exception e) {
                visitor.handleException(e, this);
            }
        }

        @Override public void visitChildren(Visitor visitor) {
            walkTypeDeclaration(visitor, this);
        }

        private TypeParameterList typeParameterList;
        public TypeParameterList getTypeParameterList() { return typeParameterList; }
        public void setTypeParameterList(TypeParameterList node) { typeParameterList = node; connect(node); }

        public abstract com.redhat.ceylon.model.typechecker.model.TypeDeclaration getDeclarationModel();

    }

    /**
     * A class or interface declaration.
     */
    public static abstract class ClassOrInterface extends TypeDeclaration {

        public ClassOrInterface(Token token) {
            super(token);
        }

        @Override public void visit(Visitor visitor) {
            try {
                visitor.visit(this);
            }
            catch (Exception e) {
                visitor.handleException(e, this);
            }
        }

        @Override public void visitChildren(Visitor visitor) {
            walkClassOrInterface(visitor, this);
        }

        public abstract com.redhat.ceylon.model.typechecker.model.ClassOrInterface getDeclarationModel();

    }

    /**
     * The constraints for a certain type parameter.
     */
    public static class TypeAliasDeclaration extends TypeDeclaration {

        public TypeAliasDeclaration(Token token) {
            super(token);
        }

        @Override public void visit(Visitor visitor) {
            try {
                visitor.visit(this);
            }
            catch (Exception e) {
                visitor.handleException(e, this);
            }
        }

        @Override public void visitChildren(Visitor visitor) {
            walkTypeAliasDeclaration(visitor, this);
        }

        private TypeConstraintList typeConstraintList;
        public TypeConstraintList getTypeConstraintList() { return typeConstraintList; }
        public void setTypeConstraintList(TypeConstraintList node) { typeConstraintList = node; connect(node); }

        private TypeSpecifier typeSpecifier;
        public TypeSpecifier getTypeSpecifier() { return typeSpecifier; }
        public void setTypeSpecifier(TypeSpecifier node) { typeSpecifier = node; connect(node); }

        private com.redhat.ceylon.model.typechecker.model.TypeAlias declarationModel;
        public com.redhat.ceylon.model.typechecker.model.TypeAlias getDeclarationModel() { return declarationModel; }
        public void setDeclarationModel(com.redhat.ceylon.model.typechecker.model.TypeAlias value) { declarationModel = value; }

    }

    public static class SatisfiedTypes extends Node {

        public SatisfiedTypes(Token token) {
            super(token);
        }

        @Override public void visit(Visitor visitor) {
            try {
                visitor.visit(this);
            }
            catch (Exception e) {
                visitor.handleException(e, this);
            }
        }

        @Override public void visitChildren(Visitor visitor) {
            walkSatisfiedTypes(visitor, this);
        }

        private List<StaticType> types = new ArrayList<StaticType>(3);
        public List<StaticType> getTypes() { return types; }
        public void addType(StaticType node) { types.add(node); connect(node); }

    }

    public static class AbstractedType extends Node {

        public AbstractedType(Token token) {
            super(token);
        }

        @Override public void visit(Visitor visitor) {
            try {
                visitor.visit(this);
            }
            catch (Exception e) {
                visitor.handleException(e, this);
            }
        }

        @Override public void visitChildren(Visitor visitor) {
            walkAbstractedType(visitor, this);
        }

        private StaticType type;
        public StaticType getType() { return type; }
        public void setType(StaticType node) { type = node; connect(node); }

    }

    public static class CaseTypes extends Node {

        public CaseTypes(Token token) {
            super(token);
        }

        @Override public void visit(Visitor visitor) {
            try {
                visitor.visit(this);
            }
            catch (Exception e) {
                visitor.handleException(e, this);
            }
        }

        @Override public void visitChildren(Visitor visitor) {
            walkCaseTypes(visitor, this);
        }

        private List<StaticType> types = new ArrayList<StaticType>(3);
        public List<StaticType> getTypes() { return types; }
        public void addType(StaticType node) { types.add(node); connect(node); }

        private List<StaticMemberOrTypeExpression> baseMemberExpressions = new ArrayList<StaticMemberOrTypeExpression>(3);
        public List<StaticMemberOrTypeExpression> getBaseMemberExpressions() { return baseMemberExpressions; }
        public void addBaseMemberExpression(StaticMemberOrTypeExpression node) { baseMemberExpressions.add(node); connect(node); }

    }

    public static class ExtendedType extends Node {

        public ExtendedType(Token token) {
            super(token);
        }

        @Override public void visit(Visitor visitor) {
            try {
                visitor.visit(this);
            }
            catch (Exception e) {
                visitor.handleException(e, this);
            }
        }

        @Override public void visitChildren(Visitor visitor) {
            walkExtendedType(visitor, this);
        }

        private SimpleType type;
        public SimpleType getType() { return type; }
        public void setType(SimpleType node) { type = node; connect(node); }

        private InvocationExpression invocationExpression;
        public InvocationExpression getInvocationExpression() { return invocationExpression; }
        public void setInvocationExpression(InvocationExpression node) { invocationExpression = node; connect(node); }

    }

    /**
     * A list of constraints organized by parameter.
     */
    public static class TypeConstraintList extends Node {

        public TypeConstraintList(Token token) {
            super(token);
        }

        @Override public void visit(Visitor visitor) {
            try {
                visitor.visit(this);
            }
            catch (Exception e) {
                visitor.handleException(e, this);
            }
        }

        @Override public void visitChildren(Visitor visitor) {
            walkTypeConstraintList(visitor, this);
        }

        private List<TypeConstraint> typeConstraints = new ArrayList<TypeConstraint>(3);
        public List<TypeConstraint> getTypeConstraints() { return typeConstraints; }
        public void addTypeConstraint(TypeConstraint node) { typeConstraints.add(node); connect(node); }

    }

    /**
     * A set of type constraints on a certain type parameter.
     */
    public static class TypeConstraint extends TypeDeclaration {

        public TypeConstraint(Token token) {
            super(token);
        }

        @Override public void visit(Visitor visitor) {
            try {
                visitor.visit(this);
            }
            catch (Exception e) {
                visitor.handleException(e, this);
            }
        }

        @Override public void visitChildren(Visitor visitor) {
            walkTypeConstraint(visitor, this);
        }

        private CaseTypes caseTypes;
        public CaseTypes getCaseTypes() { return caseTypes; }
        public void setCaseTypes(CaseTypes node) { caseTypes = node; connect(node); }

        private SatisfiedTypes satisfiedTypes;
        public SatisfiedTypes getSatisfiedTypes() { return satisfiedTypes; }
        public void setSatisfiedTypes(SatisfiedTypes node) { satisfiedTypes = node; connect(node); }

        private AbstractedType abstractedType;
        public AbstractedType getAbstractedType() { return abstractedType; }
        public void setAbstractedType(AbstractedType node) { abstractedType = node; connect(node); }

        private com.redhat.ceylon.model.typechecker.model.TypeParameter declarationModel;
        public com.redhat.ceylon.model.typechecker.model.TypeParameter getDeclarationModel() { return declarationModel; }
        public void setDeclarationModel(com.redhat.ceylon.model.typechecker.model.TypeParameter value) { declarationModel = value; }

    }

    /**
     * An aliased type specified in a type or interface alias.
     */
    public static class TypeSpecifier extends Node {

        public TypeSpecifier(Token token) {
            super(token);
        }

        @Override public void visit(Visitor visitor) {
            try {
                visitor.visit(this);
            }
            catch (Exception e) {
                visitor.handleException(e, this);
            }
        }

        @Override public void visitChildren(Visitor visitor) {
            walkTypeSpecifier(visitor, this);
        }

        private StaticType type;
        public StaticType getType() { return type; }
        public void setType(StaticType node) { type = node; connect(node); }

    }

    /**
     * A default type argument for a type parameter
     */
    public static class DefaultTypeArgument extends TypeSpecifier {

        public DefaultTypeArgument(Token token) {
            super(token);
        }

        @Override public void visit(Visitor visitor) {
            try {
                visitor.visit(this);
            }
            catch (Exception e) {
                visitor.handleException(e, this);
            }
        }

        @Override public void visitChildren(Visitor visitor) {
            walkDefaultTypeArgument(visitor, this);
        }

    }

    /**
     * An aliased class specified in a class alias.
     */
    public static class ClassSpecifier extends Node {

        public ClassSpecifier(Token token) {
            super(token);
        }

        @Override public void visit(Visitor visitor) {
            try {
                visitor.visit(this);
            }
            catch (Exception e) {
                visitor.handleException(e, this);
            }
        }

        @Override public void visitChildren(Visitor visitor) {
            walkClassSpecifier(visitor, this);
        }

        private SimpleType type;
        public SimpleType getType() { return type; }
        public void setType(SimpleType node) { type = node; connect(node); }

        private InvocationExpression invocationExpression;
        public InvocationExpression getInvocationExpression() { return invocationExpression; }
        public void setInvocationExpression(InvocationExpression node) { invocationExpression = node; connect(node); }

    }

    /**
     * A class declaration or alias.
     */
    public static class AnyClass extends ClassOrInterface {

        public AnyClass(Token token) {
            super(token);
        }

        @Override public void visit(Visitor visitor) {
            try {
                visitor.visit(this);
            }
            catch (Exception e) {
                visitor.handleException(e, this);
            }
        }

        @Override public void visitChildren(Visitor visitor) {
            walkAnyClass(visitor, this);
        }

        private ParameterList parameterList;
        public ParameterList getParameterList() { return parameterList; }
        public void setParameterList(ParameterList node) { parameterList = node; connect(node); }

        private CaseTypes caseTypes;
        public CaseTypes getCaseTypes() { return caseTypes; }
        public void setCaseTypes(CaseTypes node) { caseTypes = node; connect(node); }

        private ExtendedType extendedType;
        public ExtendedType getExtendedType() { return extendedType; }
        public void setExtendedType(ExtendedType node) { extendedType = node; connect(node); }

        private SatisfiedTypes satisfiedTypes;
        public SatisfiedTypes getSatisfiedTypes() { return satisfiedTypes; }
        public void setSatisfiedTypes(SatisfiedTypes node) { satisfiedTypes = node; connect(node); }

        private TypeConstraintList typeConstraintList;
        public TypeConstraintList getTypeConstraintList() { return typeConstraintList; }
        public void setTypeConstraintList(TypeConstraintList node) { typeConstraintList = node; connect(node); }

        private com.redhat.ceylon.model.typechecker.model.Class declarationModel;
        public com.redhat.ceylon.model.typechecker.model.Class getDeclarationModel() { return declarationModel; }
        public void setDeclarationModel(com.redhat.ceylon.model.typechecker.model.Class value) { declarationModel = value; }

    }

    /**
     * A class declaration.
     */
    public static class ClassDefinition extends AnyClass {

        public ClassDefinition(Token token) {
            super(token);
        }

        @Override public void visit(Visitor visitor) {
            try {
                visitor.visit(this);
            }
            catch (Exception e) {
                visitor.handleException(e, this);
            }
        }

        @Override public void visitChildren(Visitor visitor) {
            walkClassDefinition(visitor, this);
        }

        private ClassBody classBody;
        public ClassBody getClassBody() { return classBody; }
        public void setClassBody(ClassBody node) { classBody = node; connect(node); }

    }

    /**
     * A value constructor.
     */
    public static class Enumerated extends Declaration {

        public Enumerated(Token token) {
            super(token);
        }

        @Override public void visit(Visitor visitor) {
            try {
                visitor.visit(this);
            }
            catch (Exception e) {
                visitor.handleException(e, this);
            }
        }

        @Override public void visitChildren(Visitor visitor) {
            walkEnumerated(visitor, this);
        }

        private DelegatedConstructor delegatedConstructor;
        public DelegatedConstructor getDelegatedConstructor() { return delegatedConstructor; }
        public void setDelegatedConstructor(DelegatedConstructor node) { delegatedConstructor = node; connect(node); }

        private Block block;
        public Block getBlock() { return block; }
        public void setBlock(Block node) { block = node; connect(node); }

        private com.redhat.ceylon.model.typechecker.model.Value declarationModel;
        public com.redhat.ceylon.model.typechecker.model.Value getDeclarationModel() { return declarationModel; }
        public void setDeclarationModel(com.redhat.ceylon.model.typechecker.model.Value value) { declarationModel = value; }

        private com.redhat.ceylon.model.typechecker.model.Constructor enumerated;
        public com.redhat.ceylon.model.typechecker.model.Constructor getEnumerated() { return enumerated; }
        public void setEnumerated(com.redhat.ceylon.model.typechecker.model.Constructor value) { enumerated = value; }

    }

    /**
     * A callable constructor.
     */
    public static class Constructor extends Declaration {

        public Constructor(Token token) {
            super(token);
        }

        @Override public void visit(Visitor visitor) {
            try {
                visitor.visit(this);
            }
            catch (Exception e) {
                visitor.handleException(e, this);
            }
        }

        @Override public void visitChildren(Visitor visitor) {
            walkConstructor(visitor, this);
        }

        private ParameterList parameterList;
        public ParameterList getParameterList() { return parameterList; }
        public void setParameterList(ParameterList node) { parameterList = node; connect(node); }

        private DelegatedConstructor delegatedConstructor;
        public DelegatedConstructor getDelegatedConstructor() { return delegatedConstructor; }
        public void setDelegatedConstructor(DelegatedConstructor node) { delegatedConstructor = node; connect(node); }

        private Block block;
        public Block getBlock() { return block; }
        public void setBlock(Block node) { block = node; connect(node); }

        private com.redhat.ceylon.model.typechecker.model.Function declarationModel;
        public com.redhat.ceylon.model.typechecker.model.Function getDeclarationModel() { return declarationModel; }
        public void setDeclarationModel(com.redhat.ceylon.model.typechecker.model.Function value) { declarationModel = value; }

        private com.redhat.ceylon.model.typechecker.model.Constructor constructor;
        public com.redhat.ceylon.model.typechecker.model.Constructor getConstructor() { return constructor; }
        public void setConstructor(com.redhat.ceylon.model.typechecker.model.Constructor value) { constructor = value; }

    }

    public static class DelegatedConstructor extends Node {

        public DelegatedConstructor(Token token) {
            super(token);
        }

        @Override public void visit(Visitor visitor) {
            try {
                visitor.visit(this);
            }
            catch (Exception e) {
                visitor.handleException(e, this);
            }
        }

        @Override public void visitChildren(Visitor visitor) {
            walkDelegatedConstructor(visitor, this);
        }

        private SimpleType type;
        public SimpleType getType() { return type; }
        public void setType(SimpleType node) { type = node; connect(node); }

        private InvocationExpression invocationExpression;
        public InvocationExpression getInvocationExpression() { return invocationExpression; }
        public void setInvocationExpression(InvocationExpression node) { invocationExpression = node; connect(node); }

    }

    /**
     * A class alias.
     */
    public static class ClassDeclaration extends AnyClass {

        public ClassDeclaration(Token token) {
            super(token);
        }

        @Override public void visit(Visitor visitor) {
            try {
                visitor.visit(this);
            }
            catch (Exception e) {
                visitor.handleException(e, this);
            }
        }

        @Override public void visitChildren(Visitor visitor) {
            walkClassDeclaration(visitor, this);
        }

        private ClassSpecifier classSpecifier;
        public ClassSpecifier getClassSpecifier() { return classSpecifier; }
        public void setClassSpecifier(ClassSpecifier node) { classSpecifier = node; connect(node); }

    }

    /**
     * An interface declaration or alias.
     */
    public static class AnyInterface extends ClassOrInterface {

        public AnyInterface(Token token) {
            super(token);
        }

        @Override public void visit(Visitor visitor) {
            try {
                visitor.visit(this);
            }
            catch (Exception e) {
                visitor.handleException(e, this);
            }
        }

        @Override public void visitChildren(Visitor visitor) {
            walkAnyInterface(visitor, this);
        }

        private CaseTypes caseTypes;
        public CaseTypes getCaseTypes() { return caseTypes; }
        public void setCaseTypes(CaseTypes node) { caseTypes = node; connect(node); }

        private SatisfiedTypes satisfiedTypes;
        public SatisfiedTypes getSatisfiedTypes() { return satisfiedTypes; }
        public void setSatisfiedTypes(SatisfiedTypes node) { satisfiedTypes = node; connect(node); }

        private TypeConstraintList typeConstraintList;
        public TypeConstraintList getTypeConstraintList() { return typeConstraintList; }
        public void setTypeConstraintList(TypeConstraintList node) { typeConstraintList = node; connect(node); }

        private com.redhat.ceylon.model.typechecker.model.Interface declarationModel;
        public com.redhat.ceylon.model.typechecker.model.Interface getDeclarationModel() { return declarationModel; }
        public void setDeclarationModel(com.redhat.ceylon.model.typechecker.model.Interface value) { declarationModel = value; }

    }

    /**
     * An interface declaration.
     */
    public static class InterfaceDefinition extends AnyInterface {

        public InterfaceDefinition(Token token) {
            super(token);
        }

        @Override public void visit(Visitor visitor) {
            try {
                visitor.visit(this);
            }
            catch (Exception e) {
                visitor.handleException(e, this);
            }
        }

        @Override public void visitChildren(Visitor visitor) {
            walkInterfaceDefinition(visitor, this);
        }

        private InterfaceBody interfaceBody;
        public InterfaceBody getInterfaceBody() { return interfaceBody; }
        public void setInterfaceBody(InterfaceBody node) { interfaceBody = node; connect(node); }

        private boolean dynamic;
        public boolean getDynamic() { return dynamic; }
        public void setDynamic(boolean value) { dynamic = value; }

    }

    /**
     * An interface alias.
     */
    public static class InterfaceDeclaration extends AnyInterface {

        public InterfaceDeclaration(Token token) {
            super(token);
        }

        @Override public void visit(Visitor visitor) {
            try {
                visitor.visit(this);
            }
            catch (Exception e) {
                visitor.handleException(e, this);
            }
        }

        @Override public void visitChildren(Visitor visitor) {
            walkInterfaceDeclaration(visitor, this);
        }

        private TypeSpecifier typeSpecifier;
        public TypeSpecifier getTypeSpecifier() { return typeSpecifier; }
        public void setTypeSpecifier(TypeSpecifier node) { typeSpecifier = node; connect(node); }

    }

    /**
     * A function or value declaration.
     */
    public static abstract class TypedDeclaration extends Declaration {

        public TypedDeclaration(Token token) {
            super(token);
        }

        @Override public void visit(Visitor visitor) {
            try {
                visitor.visit(this);
            }
            catch (Exception e) {
                visitor.handleException(e, this);
            }
        }

        @Override public void visitChildren(Visitor visitor) {
            walkTypedDeclaration(visitor, this);
        }

        private Type type;
        public Type getType() { return type; }
        public void setType(Type node) { type = node; connect(node); }

        public abstract com.redhat.ceylon.model.typechecker.model.TypedDeclaration getDeclarationModel();

    }

    /**
     * Any kind of value declaration.
     */
    public static abstract class AnyAttribute extends TypedDeclaration {

        public AnyAttribute(Token token) {
            super(token);
        }

        @Override public void visit(Visitor visitor) {
            try {
                visitor.visit(this);
            }
            catch (Exception e) {
                visitor.handleException(e, this);
            }
        }

        @Override public void visitChildren(Visitor visitor) {
            walkAnyAttribute(visitor, this);
        }

    }

    /**
     * A simple, forward, or formal value declaration.
     */
    public static class AttributeDeclaration extends AnyAttribute {

        public AttributeDeclaration(Token token) {
            super(token);
        }

        @Override public void visit(Visitor visitor) {
            try {
                visitor.visit(this);
            }
            catch (Exception e) {
                visitor.handleException(e, this);
            }
        }

        @Override public void visitChildren(Visitor visitor) {
            walkAttributeDeclaration(visitor, this);
        }

        private SpecifierOrInitializerExpression specifierOrInitializerExpression;
        public SpecifierOrInitializerExpression getSpecifierOrInitializerExpression() { return specifierOrInitializerExpression; }
        public void setSpecifierOrInitializerExpression(SpecifierOrInitializerExpression node) { specifierOrInitializerExpression = node; connect(node); }

        private com.redhat.ceylon.model.typechecker.model.Value declarationModel;
        public com.redhat.ceylon.model.typechecker.model.Value getDeclarationModel() { return declarationModel; }
        public void setDeclarationModel(com.redhat.ceylon.model.typechecker.model.Value value) { declarationModel = value; }

    }

    /**
     * A value getter declaration.
     */
    public static class AttributeGetterDefinition extends AnyAttribute {

        public AttributeGetterDefinition(Token token) {
            super(token);
        }

        @Override public void visit(Visitor visitor) {
            try {
                visitor.visit(this);
            }
            catch (Exception e) {
                visitor.handleException(e, this);
            }
        }

        @Override public void visitChildren(Visitor visitor) {
            walkAttributeGetterDefinition(visitor, this);
        }

        private Block block;
        public Block getBlock() { return block; }
        public void setBlock(Block node) { block = node; connect(node); }

        private com.redhat.ceylon.model.typechecker.model.Value declarationModel;
        public com.redhat.ceylon.model.typechecker.model.Value getDeclarationModel() { return declarationModel; }
        public void setDeclarationModel(com.redhat.ceylon.model.typechecker.model.Value value) { declarationModel = value; }

    }

    /**
     * An value setter declaration.
     */
    public static class AttributeSetterDefinition extends TypedDeclaration {

        public AttributeSetterDefinition(Token token) {
            super(token);
        }

        @Override public void visit(Visitor visitor) {
            try {
                visitor.visit(this);
            }
            catch (Exception e) {
                visitor.handleException(e, this);
            }
        }

        @Override public void visitChildren(Visitor visitor) {
            walkAttributeSetterDefinition(visitor, this);
        }

        private Block block;
        public Block getBlock() { return block; }
        public void setBlock(Block node) { block = node; connect(node); }

        private SpecifierExpression specifierExpression;
        public SpecifierExpression getSpecifierExpression() { return specifierExpression; }
        public void setSpecifierExpression(SpecifierExpression node) { specifierExpression = node; connect(node); }

        private com.redhat.ceylon.model.typechecker.model.Setter declarationModel;
        public com.redhat.ceylon.model.typechecker.model.Setter getDeclarationModel() { return declarationModel; }
        public void setDeclarationModel(com.redhat.ceylon.model.typechecker.model.Setter value) { declarationModel = value; }

    }

    /**
     * Any kind of function declaration.
     */
    public static class AnyMethod extends TypedDeclaration {

        public AnyMethod(Token token) {
            super(token);
        }

        @Override public void visit(Visitor visitor) {
            try {
                visitor.visit(this);
            }
            catch (Exception e) {
                visitor.handleException(e, this);
            }
        }

        @Override public void visitChildren(Visitor visitor) {
            walkAnyMethod(visitor, this);
        }

        private TypeParameterList typeParameterList;
        public TypeParameterList getTypeParameterList() { return typeParameterList; }
        public void setTypeParameterList(TypeParameterList node) { typeParameterList = node; connect(node); }

        private List<ParameterList> parameterLists = new ArrayList<ParameterList>(3);
        public List<ParameterList> getParameterLists() { return parameterLists; }
        public void addParameterList(ParameterList node) { parameterLists.add(node); connect(node); }

        private TypeConstraintList typeConstraintList;
        public TypeConstraintList getTypeConstraintList() { return typeConstraintList; }
        public void setTypeConstraintList(TypeConstraintList node) { typeConstraintList = node; connect(node); }

        private com.redhat.ceylon.model.typechecker.model.Function declarationModel;
        public com.redhat.ceylon.model.typechecker.model.Function getDeclarationModel() { return declarationModel; }
        public void setDeclarationModel(com.redhat.ceylon.model.typechecker.model.Function value) { declarationModel = value; }

    }

    /**
     * A function declaration followed by a block.
     */
    public static class MethodDefinition extends AnyMethod {

        public MethodDefinition(Token token) {
            super(token);
        }

        @Override public void visit(Visitor visitor) {
            try {
                visitor.visit(this);
            }
            catch (Exception e) {
                visitor.handleException(e, this);
            }
        }

        @Override public void visitChildren(Visitor visitor) {
            walkMethodDefinition(visitor, this);
        }

        private Block block;
        public Block getBlock() { return block; }
        public void setBlock(Block node) { block = node; connect(node); }

    }

    /**
     * A function forward declaration or function declaration followed by a specification.
     */
    public static class MethodDeclaration extends AnyMethod {

        public MethodDeclaration(Token token) {
            super(token);
        }

        @Override public void visit(Visitor visitor) {
            try {
                visitor.visit(this);
            }
            catch (Exception e) {
                visitor.handleException(e, this);
            }
        }

        @Override public void visitChildren(Visitor visitor) {
            walkMethodDeclaration(visitor, this);
        }

        private SpecifierExpression specifierExpression;
        public SpecifierExpression getSpecifierExpression() { return specifierExpression; }
        public void setSpecifierExpression(SpecifierExpression node) { specifierExpression = node; connect(node); }

    }

    /**
     * Specifies that a function has no specific return value.
     */
    public static class VoidModifier extends Type {

        public VoidModifier(Token token) {
            super(token);
        }

        @Override public void visit(Visitor visitor) {
            try {
                visitor.visit(this);
            }
            catch (Exception e) {
                visitor.handleException(e, this);
            }
        }

        @Override public void visitChildren(Visitor visitor) {
            walkVoidModifier(visitor, this);
        }

    }

    /**
     * An object declaration.
     */
    public static class ObjectDefinition extends TypedDeclaration {

        public ObjectDefinition(Token token) {
            super(token);
        }

        @Override public void visit(Visitor visitor) {
            try {
                visitor.visit(this);
            }
            catch (Exception e) {
                visitor.handleException(e, this);
            }
        }

        @Override public void visitChildren(Visitor visitor) {
            walkObjectDefinition(visitor, this);
        }

        private ExtendedType extendedType;
        public ExtendedType getExtendedType() { return extendedType; }
        public void setExtendedType(ExtendedType node) { extendedType = node; connect(node); }

        private SatisfiedTypes satisfiedTypes;
        public SatisfiedTypes getSatisfiedTypes() { return satisfiedTypes; }
        public void setSatisfiedTypes(SatisfiedTypes node) { satisfiedTypes = node; connect(node); }

        private ClassBody classBody;
        public ClassBody getClassBody() { return classBody; }
        public void setClassBody(ClassBody node) { classBody = node; connect(node); }

        private com.redhat.ceylon.model.typechecker.model.Value declarationModel;
        public com.redhat.ceylon.model.typechecker.model.Value getDeclarationModel() { return declarationModel; }
        public void setDeclarationModel(com.redhat.ceylon.model.typechecker.model.Value value) { declarationModel = value; }

        private com.redhat.ceylon.model.typechecker.model.Class anonymousClass;
        public com.redhat.ceylon.model.typechecker.model.Class getAnonymousClass() { return anonymousClass; }
        public void setAnonymousClass(com.redhat.ceylon.model.typechecker.model.Class value) { anonymousClass = value; }

    }

    /**
     * A parameter list for a function or class.
     */
    public static class ParameterList extends Node {

        public ParameterList(Token token) {
            super(token);
        }

        @Override public void visit(Visitor visitor) {
            try {
                visitor.visit(this);
            }
            catch (Exception e) {
                visitor.handleException(e, this);
            }
        }

        @Override public void visitChildren(Visitor visitor) {
            walkParameterList(visitor, this);
        }

        private List<Parameter> parameters = new ArrayList<Parameter>(3);
        public List<Parameter> getParameters() { return parameters; }
        public void addParameter(Parameter node) { parameters.add(node); connect(node); }

        private com.redhat.ceylon.model.typechecker.model.ParameterList model;
        public com.redhat.ceylon.model.typechecker.model.ParameterList getModel() { return model; }
        public void setModel(com.redhat.ceylon.model.typechecker.model.ParameterList value) { model = value; }

    }

    /**
     * A parameter declaration.
     */
    public static abstract class Parameter extends Node {

        public Parameter(Token token) {
            super(token);
        }

        @Override public void visit(Visitor visitor) {
            try {
                visitor.visit(this);
            }
            catch (Exception e) {
                visitor.handleException(e, this);
            }
        }

        @Override public void visitChildren(Visitor visitor) {
            walkParameter(visitor, this);
        }

        private com.redhat.ceylon.model.typechecker.model.Parameter parameterModel;
        public com.redhat.ceylon.model.typechecker.model.Parameter getParameterModel() { return parameterModel; }
        public void setParameterModel(com.redhat.ceylon.model.typechecker.model.Parameter value) { parameterModel = value; }

    }

    public static abstract class ParameterDeclaration extends Parameter {

        public ParameterDeclaration(Token token) {
            super(token);
        }

        @Override public void visit(Visitor visitor) {
            try {
                visitor.visit(this);
            }
            catch (Exception e) {
                visitor.handleException(e, this);
            }
        }

        @Override public void visitChildren(Visitor visitor) {
            walkParameterDeclaration(visitor, this);
        }

        private TypedDeclaration typedDeclaration;
        public TypedDeclaration getTypedDeclaration() { return typedDeclaration; }
        public void setTypedDeclaration(TypedDeclaration node) { typedDeclaration = node; connect(node); }

    }

    /**
     * An ordinary (value) parameter.
     */
    public static class ValueParameterDeclaration extends ParameterDeclaration {

        public ValueParameterDeclaration(Token token) {
            super(token);
        }

        @Override public void visit(Visitor visitor) {
            try {
                visitor.visit(this);
            }
            catch (Exception e) {
                visitor.handleException(e, this);
            }
        }

        @Override public void visitChildren(Visitor visitor) {
            walkValueParameterDeclaration(visitor, this);
        }

    }

    /**
     * An (functional) parameter with its own parameter list.
     */
    public static class FunctionalParameterDeclaration extends ParameterDeclaration {

        public FunctionalParameterDeclaration(Token token) {
            super(token);
        }

        @Override public void visit(Visitor visitor) {
            try {
                visitor.visit(this);
            }
            catch (Exception e) {
                visitor.handleException(e, this);
            }
        }

        @Override public void visitChildren(Visitor visitor) {
            walkFunctionalParameterDeclaration(visitor, this);
        }

    }

    /**
     * A reference to a parameter declared like an ordinary forward value inside the body of the function or class.
     */
    public static class InitializerParameter extends Parameter {

        public InitializerParameter(Token token) {
            super(token);
        }

        @Override public void visit(Visitor visitor) {
            try {
                visitor.visit(this);
            }
            catch (Exception e) {
                visitor.handleException(e, this);
            }
        }

        @Override public void visitChildren(Visitor visitor) {
            walkInitializerParameter(visitor, this);
        }

        private Identifier identifier;
        public Identifier getIdentifier() { return identifier; }
        public void setIdentifier(Identifier node) { identifier = node; connect(node); }

        private SpecifierExpression specifierExpression;
        public SpecifierExpression getSpecifierExpression() { return specifierExpression; }
        public void setSpecifierExpression(SpecifierExpression node) { specifierExpression = node; connect(node); }

    }

    public static class PatternParameter extends Parameter {

        public PatternParameter(Token token) {
            super(token);
        }

        @Override public void visit(Visitor visitor) {
            try {
                visitor.visit(this);
            }
            catch (Exception e) {
                visitor.handleException(e, this);
            }
        }

        @Override public void visitChildren(Visitor visitor) {
            walkPatternParameter(visitor, this);
        }

        private Pattern pattern;
        public Pattern getPattern() { return pattern; }
        public void setPattern(Pattern node) { pattern = node; connect(node); }

    }

    /**
     * A list of type parameters in a generic declaration.
     */
    public static class TypeParameterList extends Node {

        public TypeParameterList(Token token) {
            super(token);
        }

        @Override public void visit(Visitor visitor) {
            try {
                visitor.visit(this);
            }
            catch (Exception e) {
                visitor.handleException(e, this);
            }
        }

        @Override public void visitChildren(Visitor visitor) {
            walkTypeParameterList(visitor, this);
        }

        private List<TypeParameterDeclaration> typeParameterDeclarations = new ArrayList<TypeParameterDeclaration>(3);
        public List<TypeParameterDeclaration> getTypeParameterDeclarations() { return typeParameterDeclarations; }
        public void addTypeParameterDeclaration(TypeParameterDeclaration node) { typeParameterDeclarations.add(node); connect(node); }

    }

    /**
     * A single type parameter of a generic declaration.
     */
    public static class TypeParameterDeclaration extends Declaration {

        public TypeParameterDeclaration(Token token) {
            super(token);
        }

        @Override public void visit(Visitor visitor) {
            try {
                visitor.visit(this);
            }
            catch (Exception e) {
                visitor.handleException(e, this);
            }
        }

        @Override public void visitChildren(Visitor visitor) {
            walkTypeParameterDeclaration(visitor, this);
        }

        private TypeVariance typeVariance;
        public TypeVariance getTypeVariance() { return typeVariance; }
        public void setTypeVariance(TypeVariance node) { typeVariance = node; connect(node); }

        private TypeSpecifier typeSpecifier;
        public TypeSpecifier getTypeSpecifier() { return typeSpecifier; }
        public void setTypeSpecifier(TypeSpecifier node) { typeSpecifier = node; connect(node); }

        private com.redhat.ceylon.model.typechecker.model.TypeParameter declarationModel;
        public com.redhat.ceylon.model.typechecker.model.TypeParameter getDeclarationModel() { return declarationModel; }
        public void setDeclarationModel(com.redhat.ceylon.model.typechecker.model.TypeParameter value) { declarationModel = value; }

    }

    /**
     * The variance of a type parameter.
     */
    public static class TypeVariance extends Node {

        public TypeVariance(Token token) {
            super(token);
        }

        @Override public void visit(Visitor visitor) {
            try {
                visitor.visit(this);
            }
            catch (Exception e) {
                visitor.handleException(e, this);
            }
        }

        @Override public void visitChildren(Visitor visitor) {
            walkTypeVariance(visitor, this);
        }

    }

    /**
     * A list of statements.
     */
    public static abstract class Body extends Node {

        public Body(Token token) {
            super(token);
        }

        @Override public void visit(Visitor visitor) {
            try {
                visitor.visit(this);
            }
            catch (Exception e) {
                visitor.handleException(e, this);
            }
        }

        @Override public void visitChildren(Visitor visitor) {
            walkBody(visitor, this);
        }

        private ImportList importList;
        public ImportList getImportList() { return importList; }
        public void setImportList(ImportList node) { importList = node; connect(node); }

        private List<Statement> statements = new ArrayList<Statement>(3);
        public List<Statement> getStatements() { return statements; }
        public void addStatement(Statement node) { statements.add(node); connect(node); }

    }

    /**
     * A method or attribute body containing statements and declarations.
     */
    public static class Block extends Body {

        public Block(Token token) {
            super(token);
        }

        @Override public void visit(Visitor visitor) {
            try {
                visitor.visit(this);
            }
            catch (Exception e) {
                visitor.handleException(e, this);
            }
        }

        @Override public void visitChildren(Visitor visitor) {
            walkBlock(visitor, this);
        }

        private boolean definitelyReturns;
        public boolean getDefinitelyReturns() { return definitelyReturns; }
        public void setDefinitelyReturns(boolean value) { definitelyReturns = value; }

        private boolean definitelyBreaksOrContinues;
        public boolean getDefinitelyBreaksOrContinues() { return definitelyBreaksOrContinues; }
        public void setDefinitelyBreaksOrContinues(boolean value) { definitelyBreaksOrContinues = value; }

    }

    /**
     * A class body.
     */
    public static class ClassBody extends Body {

        public ClassBody(Token token) {
            super(token);
        }

        @Override public void visit(Visitor visitor) {
            try {
                visitor.visit(this);
            }
            catch (Exception e) {
                visitor.handleException(e, this);
            }
        }

        @Override public void visitChildren(Visitor visitor) {
            walkClassBody(visitor, this);
        }

    }

    /**
     * An interface body.
     */
    public static class InterfaceBody extends Body {

        public InterfaceBody(Token token) {
            super(token);
        }

        @Override public void visit(Visitor visitor) {
            try {
                visitor.visit(this);
            }
            catch (Exception e) {
                visitor.handleException(e, this);
            }
        }

        @Override public void visitChildren(Visitor visitor) {
            walkInterfaceBody(visitor, this);
        }

    }

    public static abstract class Type extends Node {

        public Type(Token token) {
            super(token);
        }

        @Override public void visit(Visitor visitor) {
            try {
                visitor.visit(this);
            }
            catch (Exception e) {
                visitor.handleException(e, this);
            }
        }

        @Override public void visitChildren(Visitor visitor) {
            walkType(visitor, this);
        }

        private com.redhat.ceylon.model.typechecker.model.Type typeModel;
        public com.redhat.ceylon.model.typechecker.model.Type getTypeModel() { return typeModel; }
        public void setTypeModel(com.redhat.ceylon.model.typechecker.model.Type value) { typeModel = value; }

    }

    public static abstract class StaticType extends Type {

        public StaticType(Token token) {
            super(token);
        }

        @Override public void visit(Visitor visitor) {
            try {
                visitor.visit(this);
            }
            catch (Exception e) {
                visitor.handleException(e, this);
            }
        }

        @Override public void visitChildren(Visitor visitor) {
            walkStaticType(visitor, this);
        }

        private TypeVariance typeVariance;
        public TypeVariance getTypeVariance() { return typeVariance; }
        public void setTypeVariance(TypeVariance node) { typeVariance = node; connect(node); }

        private boolean staticTypePrimary;
        public boolean getStaticTypePrimary() { return staticTypePrimary; }
        public void setStaticTypePrimary(boolean value) { staticTypePrimary = value; }

        private boolean metamodel;
        public boolean getMetamodel() { return metamodel; }
        public void setMetamodel(boolean value) { metamodel = value; }

    }

    public static class GroupedType extends StaticType {

        public GroupedType(Token token) {
            super(token);
        }

        @Override public void visit(Visitor visitor) {
            try {
                visitor.visit(this);
            }
            catch (Exception e) {
                visitor.handleException(e, this);
            }
        }

        @Override public void visitChildren(Visitor visitor) {
            walkGroupedType(visitor, this);
        }

        private StaticType type;
        public StaticType getType() { return type; }
        public void setType(StaticType node) { type = node; connect(node); }

    }

    /**
     * A produced type.
     */
    public static abstract class SimpleType extends StaticType {

        public SimpleType(Token token) {
            super(token);
        }

        @Override public void visit(Visitor visitor) {
            try {
                visitor.visit(this);
            }
            catch (Exception e) {
                visitor.handleException(e, this);
            }
        }

        @Override public void visitChildren(Visitor visitor) {
            walkSimpleType(visitor, this);
        }

        private Identifier identifier;
        public Identifier getIdentifier() { return identifier; }
        public void setIdentifier(Identifier node) { identifier = node; connect(node); }

        private TypeArgumentList typeArgumentList;
        public TypeArgumentList getTypeArgumentList() { return typeArgumentList; }
        public void setTypeArgumentList(TypeArgumentList node) { typeArgumentList = node; connect(node); }

        private com.redhat.ceylon.model.typechecker.model.TypeDeclaration declarationModel;
        public com.redhat.ceylon.model.typechecker.model.TypeDeclaration getDeclarationModel() { return declarationModel; }
        public void setDeclarationModel(com.redhat.ceylon.model.typechecker.model.TypeDeclaration value) { declarationModel = value; }

        private boolean inherited;
        public boolean getInherited() { return inherited; }
        public void setInherited(boolean value) { inherited = value; }

    }

    public static class BaseType extends SimpleType {

        public BaseType(Token token) {
            super(token);
        }

        @Override public void visit(Visitor visitor) {
            try {
                visitor.visit(this);
            }
            catch (Exception e) {
                visitor.handleException(e, this);
            }
        }

        @Override public void visitChildren(Visitor visitor) {
            walkBaseType(visitor, this);
        }

        private boolean packageQualified;
        public boolean getPackageQualified() { return packageQualified; }
        public void setPackageQualified(boolean value) { packageQualified = value; }

    }

    public static class QualifiedType extends SimpleType {

        public QualifiedType(Token token) {
            super(token);
        }

        @Override public void visit(Visitor visitor) {
            try {
                visitor.visit(this);
            }
            catch (Exception e) {
                visitor.handleException(e, this);
            }
        }

        @Override public void visitChildren(Visitor visitor) {
            walkQualifiedType(visitor, this);
        }

        private StaticType outerType;
        public StaticType getOuterType() { return outerType; }
        public void setOuterType(StaticType node) { outerType = node; connect(node); }

    }

    public static class UnionType extends StaticType {

        public UnionType(Token token) {
            super(token);
        }

        @Override public void visit(Visitor visitor) {
            try {
                visitor.visit(this);
            }
            catch (Exception e) {
                visitor.handleException(e, this);
            }
        }

        @Override public void visitChildren(Visitor visitor) {
            walkUnionType(visitor, this);
        }

        private List<StaticType> staticTypes = new ArrayList<StaticType>(3);
        public List<StaticType> getStaticTypes() { return staticTypes; }
        public void addStaticType(StaticType node) { staticTypes.add(node); connect(node); }

    }

    public static class IntersectionType extends StaticType {

        public IntersectionType(Token token) {
            super(token);
        }

        @Override public void visit(Visitor visitor) {
            try {
                visitor.visit(this);
            }
            catch (Exception e) {
                visitor.handleException(e, this);
            }
        }

        @Override public void visitChildren(Visitor visitor) {
            walkIntersectionType(visitor, this);
        }

        private List<StaticType> staticTypes = new ArrayList<StaticType>(3);
        public List<StaticType> getStaticTypes() { return staticTypes; }
        public void addStaticType(StaticType node) { staticTypes.add(node); connect(node); }

    }

    public static class SequenceType extends StaticType {

        public SequenceType(Token token) {
            super(token);
        }

        @Override public void visit(Visitor visitor) {
            try {
                visitor.visit(this);
            }
            catch (Exception e) {
                visitor.handleException(e, this);
            }
        }

        @Override public void visitChildren(Visitor visitor) {
            walkSequenceType(visitor, this);
        }

        private StaticType elementType;
        public StaticType getElementType() { return elementType; }
        public void setElementType(StaticType node) { elementType = node; connect(node); }

        private NaturalLiteral length;
        public NaturalLiteral getLength() { return length; }
        public void setLength(NaturalLiteral node) { length = node; connect(node); }

    }

    public static class IterableType extends StaticType {

        public IterableType(Token token) {
            super(token);
        }

        @Override public void visit(Visitor visitor) {
            try {
                visitor.visit(this);
            }
            catch (Exception e) {
                visitor.handleException(e, this);
            }
        }

        @Override public void visitChildren(Visitor visitor) {
            walkIterableType(visitor, this);
        }

        private Type elementType;
        public Type getElementType() { return elementType; }
        public void setElementType(Type node) { elementType = node; connect(node); }

    }

    public static class OptionalType extends StaticType {

        public OptionalType(Token token) {
            super(token);
        }

        @Override public void visit(Visitor visitor) {
            try {
                visitor.visit(this);
            }
            catch (Exception e) {
                visitor.handleException(e, this);
            }
        }

        @Override public void visitChildren(Visitor visitor) {
            walkOptionalType(visitor, this);
        }

        private StaticType definiteType;
        public StaticType getDefiniteType() { return definiteType; }
        public void setDefiniteType(StaticType node) { definiteType = node; connect(node); }

    }

    public static class TupleType extends StaticType {

        public TupleType(Token token) {
            super(token);
        }

        @Override public void visit(Visitor visitor) {
            try {
                visitor.visit(this);
            }
            catch (Exception e) {
                visitor.handleException(e, this);
            }
        }

        @Override public void visitChildren(Visitor visitor) {
            walkTupleType(visitor, this);
        }

        private List<Type> elementTypes = new ArrayList<Type>(3);
        public List<Type> getElementTypes() { return elementTypes; }
        public void addElementType(Type node) { elementTypes.add(node); connect(node); }

    }

    public static class FunctionType extends StaticType {

        public FunctionType(Token token) {
            super(token);
        }

        @Override public void visit(Visitor visitor) {
            try {
                visitor.visit(this);
            }
            catch (Exception e) {
                visitor.handleException(e, this);
            }
        }

        @Override public void visitChildren(Visitor visitor) {
            walkFunctionType(visitor, this);
        }

        private StaticType returnType;
        public StaticType getReturnType() { return returnType; }
        public void setReturnType(StaticType node) { returnType = node; connect(node); }

        private List<Type> argumentTypes = new ArrayList<Type>(3);
        public List<Type> getArgumentTypes() { return argumentTypes; }
        public void addArgumentType(Type node) { argumentTypes.add(node); connect(node); }

    }

    public static class EntryType extends StaticType {

        public EntryType(Token token) {
            super(token);
        }

        @Override public void visit(Visitor visitor) {
            try {
                visitor.visit(this);
            }
            catch (Exception e) {
                visitor.handleException(e, this);
            }
        }

        @Override public void visitChildren(Visitor visitor) {
            walkEntryType(visitor, this);
        }

        private StaticType keyType;
        public StaticType getKeyType() { return keyType; }
        public void setKeyType(StaticType node) { keyType = node; connect(node); }

        private StaticType valueType;
        public StaticType getValueType() { return valueType; }
        public void setValueType(StaticType node) { valueType = node; connect(node); }

    }

    public static class TypeConstructor extends StaticType {

        public TypeConstructor(Token token) {
            super(token);
        }

        @Override public void visit(Visitor visitor) {
            try {
                visitor.visit(this);
            }
            catch (Exception e) {
                visitor.handleException(e, this);
            }
        }

        @Override public void visitChildren(Visitor visitor) {
            walkTypeConstructor(visitor, this);
        }

        private TypeParameterList typeParameterList;
        public TypeParameterList getTypeParameterList() { return typeParameterList; }
        public void setTypeParameterList(TypeParameterList node) { typeParameterList = node; connect(node); }

        private Type type;
        public Type getType() { return type; }
        public void setType(Type node) { type = node; connect(node); }

        private TypeConstraintList typeConstraintList;
        public TypeConstraintList getTypeConstraintList() { return typeConstraintList; }
        public void setTypeConstraintList(TypeConstraintList node) { typeConstraintList = node; connect(node); }

        private com.redhat.ceylon.model.typechecker.model.TypeAlias declarationModel;
        public com.redhat.ceylon.model.typechecker.model.TypeAlias getDeclarationModel() { return declarationModel; }
        public void setDeclarationModel(com.redhat.ceylon.model.typechecker.model.TypeAlias value) { declarationModel = value; }

    }

    public static class SuperType extends StaticType {

        public SuperType(Token token) {
            super(token);
        }

        @Override public void visit(Visitor visitor) {
            try {
                visitor.visit(this);
            }
            catch (Exception e) {
                visitor.handleException(e, this);
            }
        }

        @Override public void visitChildren(Visitor visitor) {
            walkSuperType(visitor, this);
        }

    }

    public static abstract class MetaLiteral extends Primary {

        public MetaLiteral(Token token) {
            super(token);
        }

        @Override public void visit(Visitor visitor) {
            try {
                visitor.visit(this);
            }
            catch (Exception e) {
                visitor.handleException(e, this);
            }
        }

        @Override public void visitChildren(Visitor visitor) {
            walkMetaLiteral(visitor, this);
        }

        private boolean wantsDeclaration;
        public boolean getWantsDeclaration() { return wantsDeclaration; }
        public void setWantsDeclaration(boolean value) { wantsDeclaration = value; }

        private boolean broken;
        public boolean getBroken() { return broken; }
        public void setBroken(boolean value) { broken = value; }

        private com.redhat.ceylon.model.typechecker.model.Declaration declaration;
        public com.redhat.ceylon.model.typechecker.model.Declaration getDeclaration() { return declaration; }
        public void setDeclaration(com.redhat.ceylon.model.typechecker.model.Declaration value) { declaration = value; }

    }

    public static class TypeLiteral extends MetaLiteral {

        public TypeLiteral(Token token) {
            super(token);
        }

        @Override public void visit(Visitor visitor) {
            try {
                visitor.visit(this);
            }
            catch (Exception e) {
                visitor.handleException(e, this);
            }
        }

        @Override public void visitChildren(Visitor visitor) {
            walkTypeLiteral(visitor, this);
        }

        private StaticType type;
        public StaticType getType() { return type; }
        public void setType(StaticType node) { type = node; connect(node); }

    }

    public static class MemberLiteral extends MetaLiteral {

        public MemberLiteral(Token token) {
            super(token);
        }

        @Override public void visit(Visitor visitor) {
            try {
                visitor.visit(this);
            }
            catch (Exception e) {
                visitor.handleException(e, this);
            }
        }

        @Override public void visitChildren(Visitor visitor) {
            walkMemberLiteral(visitor, this);
        }

        private StaticType type;
        public StaticType getType() { return type; }
        public void setType(StaticType node) { type = node; connect(node); }

        private Identifier identifier;
        public Identifier getIdentifier() { return identifier; }
        public void setIdentifier(Identifier node) { identifier = node; connect(node); }

        private TypeArgumentList typeArgumentList;
        public TypeArgumentList getTypeArgumentList() { return typeArgumentList; }
        public void setTypeArgumentList(TypeArgumentList node) { typeArgumentList = node; connect(node); }

        private boolean packageQualified;
        public boolean getPackageQualified() { return packageQualified; }
        public void setPackageQualified(boolean value) { packageQualified = value; }

        private com.redhat.ceylon.model.typechecker.model.Reference target;
        public com.redhat.ceylon.model.typechecker.model.Reference getTarget() { return target; }
        public void setTarget(com.redhat.ceylon.model.typechecker.model.Reference value) { target = value; }

    }

    public static class ClassLiteral extends TypeLiteral {

        public ClassLiteral(Token token) {
            super(token);
        }

        @Override public void visit(Visitor visitor) {
            try {
                visitor.visit(this);
            }
            catch (Exception e) {
                visitor.handleException(e, this);
            }
        }

        @Override public void visitChildren(Visitor visitor) {
            walkClassLiteral(visitor, this);
        }

    }

    public static class NewLiteral extends TypeLiteral {

        public NewLiteral(Token token) {
            super(token);
        }

        @Override public void visit(Visitor visitor) {
            try {
                visitor.visit(this);
            }
            catch (Exception e) {
                visitor.handleException(e, this);
            }
        }

        @Override public void visitChildren(Visitor visitor) {
            walkNewLiteral(visitor, this);
        }

    }

    public static class InterfaceLiteral extends TypeLiteral {

        public InterfaceLiteral(Token token) {
            super(token);
        }

        @Override public void visit(Visitor visitor) {
            try {
                visitor.visit(this);
            }
            catch (Exception e) {
                visitor.handleException(e, this);
            }
        }

        @Override public void visitChildren(Visitor visitor) {
            walkInterfaceLiteral(visitor, this);
        }

    }

    public static class AliasLiteral extends TypeLiteral {

        public AliasLiteral(Token token) {
            super(token);
        }

        @Override public void visit(Visitor visitor) {
            try {
                visitor.visit(this);
            }
            catch (Exception e) {
                visitor.handleException(e, this);
            }
        }

        @Override public void visitChildren(Visitor visitor) {
            walkAliasLiteral(visitor, this);
        }

    }

    public static class TypeParameterLiteral extends TypeLiteral {

        public TypeParameterLiteral(Token token) {
            super(token);
        }

        @Override public void visit(Visitor visitor) {
            try {
                visitor.visit(this);
            }
            catch (Exception e) {
                visitor.handleException(e, this);
            }
        }

        @Override public void visitChildren(Visitor visitor) {
            walkTypeParameterLiteral(visitor, this);
        }

    }

    public static class ValueLiteral extends MemberLiteral {

        public ValueLiteral(Token token) {
            super(token);
        }

        @Override public void visit(Visitor visitor) {
            try {
                visitor.visit(this);
            }
            catch (Exception e) {
                visitor.handleException(e, this);
            }
        }

        @Override public void visitChildren(Visitor visitor) {
            walkValueLiteral(visitor, this);
        }

    }

    public static class FunctionLiteral extends MemberLiteral {

        public FunctionLiteral(Token token) {
            super(token);
        }

        @Override public void visit(Visitor visitor) {
            try {
                visitor.visit(this);
            }
            catch (Exception e) {
                visitor.handleException(e, this);
            }
        }

        @Override public void visitChildren(Visitor visitor) {
            walkFunctionLiteral(visitor, this);
        }

    }

    public static class ModuleLiteral extends MetaLiteral {

        public ModuleLiteral(Token token) {
            super(token);
        }

        @Override public void visit(Visitor visitor) {
            try {
                visitor.visit(this);
            }
            catch (Exception e) {
                visitor.handleException(e, this);
            }
        }

        @Override public void visitChildren(Visitor visitor) {
            walkModuleLiteral(visitor, this);
        }

        private ImportPath importPath;
        public ImportPath getImportPath() { return importPath; }
        public void setImportPath(ImportPath node) { importPath = node; connect(node); }

        private boolean restriction;
        public boolean getRestriction() { return restriction; }
        public void setRestriction(boolean value) { restriction = value; }

    }

    public static class PackageLiteral extends MetaLiteral {

        public PackageLiteral(Token token) {
            super(token);
        }

        @Override public void visit(Visitor visitor) {
            try {
                visitor.visit(this);
            }
            catch (Exception e) {
                visitor.handleException(e, this);
            }
        }

        @Override public void visitChildren(Visitor visitor) {
            walkPackageLiteral(visitor, this);
        }

        private ImportPath importPath;
        public ImportPath getImportPath() { return importPath; }
        public void setImportPath(ImportPath node) { importPath = node; connect(node); }

    }

    public static class DynamicModifier extends Type {

        public DynamicModifier(Token token) {
            super(token);
        }

        @Override public void visit(Visitor visitor) {
            try {
                visitor.visit(this);
            }
            catch (Exception e) {
                visitor.handleException(e, this);
            }
        }

        @Override public void visitChildren(Visitor visitor) {
            walkDynamicModifier(visitor, this);
        }

    }

    /**
     * Specifies that the type of a block local declaration should be inferred.
     */
    public static abstract class LocalModifier extends Type {

        public LocalModifier(Token token) {
            super(token);
        }

        @Override public void visit(Visitor visitor) {
            try {
                visitor.visit(this);
            }
            catch (Exception e) {
                visitor.handleException(e, this);
            }
        }

        @Override public void visitChildren(Visitor visitor) {
            walkLocalModifier(visitor, this);
        }

    }

    /**
     * Specifies that the type of a local declaration should be inferred.
     */
    public static class ValueModifier extends LocalModifier {

        public ValueModifier(Token token) {
            super(token);
        }

        @Override public void visit(Visitor visitor) {
            try {
                visitor.visit(this);
            }
            catch (Exception e) {
                visitor.handleException(e, this);
            }
        }

        @Override public void visitChildren(Visitor visitor) {
            walkValueModifier(visitor, this);
        }

    }

    /**
     * Specifies that the type of a method declaration should be inferred.
     */
    public static class FunctionModifier extends LocalModifier {

        public FunctionModifier(Token token) {
            super(token);
        }

        @Override public void visit(Visitor visitor) {
            try {
                visitor.visit(this);
            }
            catch (Exception e) {
                visitor.handleException(e, this);
            }
        }

        @Override public void visitChildren(Visitor visitor) {
            walkFunctionModifier(visitor, this);
        }

    }

    /**
     * A variable introduced into the tree by the parser.
     */
    public static class SyntheticVariable extends ValueModifier {

        public SyntheticVariable(Token token) {
            super(token);
        }

        @Override public void visit(Visitor visitor) {
            try {
                visitor.visit(this);
            }
            catch (Exception e) {
                visitor.handleException(e, this);
            }
        }

        @Override public void visitChildren(Visitor visitor) {
            walkSyntheticVariable(visitor, this);
        }

    }

    /**
     * A list of type arguments in a generic invocation.
     */
    public static class TypeArguments extends Node {

        public TypeArguments(Token token) {
            super(token);
        }

        @Override public void visit(Visitor visitor) {
            try {
                visitor.visit(this);
            }
            catch (Exception e) {
                visitor.handleException(e, this);
            }
        }

        @Override public void visitChildren(Visitor visitor) {
            walkTypeArguments(visitor, this);
        }

        private List<com.redhat.ceylon.model.typechecker.model.Type> typeModels;
        public List<com.redhat.ceylon.model.typechecker.model.Type> getTypeModels() { return typeModels; }
        public void setTypeModels(List<com.redhat.ceylon.model.typechecker.model.Type> value) { typeModels = value; }

    }

    /**
     * A list of type arguments in a produced type.
     */
    public static class TypeArgumentList extends TypeArguments {

        public TypeArgumentList(Token token) {
            super(token);
        }

        @Override public void visit(Visitor visitor) {
            try {
                visitor.visit(this);
            }
            catch (Exception e) {
                visitor.handleException(e, this);
            }
        }

        @Override public void visitChildren(Visitor visitor) {
            walkTypeArgumentList(visitor, this);
        }

        private List<Type> types = new ArrayList<Type>(3);
        public List<Type> getTypes() { return types; }
        public void addType(Type node) { types.add(node); connect(node); }

    }

    /**
     * Indicates that the type arguments to a generic invocation are inferred by the typechecker.
     */
    public static class InferredTypeArguments extends TypeArguments {

        public InferredTypeArguments(Token token) {
            super(token);
        }

        @Override public void visit(Visitor visitor) {
            try {
                visitor.visit(this);
            }
            catch (Exception e) {
                visitor.handleException(e, this);
            }
        }

        @Override public void visitChildren(Visitor visitor) {
            walkInferredTypeArguments(visitor, this);
        }

    }

    public static class SequencedType extends Type {

        public SequencedType(Token token) {
            super(token);
        }

        @Override public void visit(Visitor visitor) {
            try {
                visitor.visit(this);
            }
            catch (Exception e) {
                visitor.handleException(e, this);
            }
        }

        @Override public void visitChildren(Visitor visitor) {
            walkSequencedType(visitor, this);
        }

        private Type type;
        public Type getType() { return type; }
        public void setType(Type node) { type = node; connect(node); }

        private boolean atLeastOne;
        public boolean getAtLeastOne() { return atLeastOne; }
        public void setAtLeastOne(boolean value) { atLeastOne = value; }

    }

    public static class DefaultedType extends Type {

        public DefaultedType(Token token) {
            super(token);
        }

        @Override public void visit(Visitor visitor) {
            try {
                visitor.visit(this);
            }
            catch (Exception e) {
                visitor.handleException(e, this);
            }
        }

        @Override public void visitChildren(Visitor visitor) {
            walkDefaultedType(visitor, this);
        }

        private Type type;
        public Type getType() { return type; }
        public void setType(Type node) { type = node; connect(node); }

    }

    public static class SpreadType extends Type {

        public SpreadType(Token token) {
            super(token);
        }

        @Override public void visit(Visitor visitor) {
            try {
                visitor.visit(this);
            }
            catch (Exception e) {
                visitor.handleException(e, this);
            }
        }

        @Override public void visitChildren(Visitor visitor) {
            walkSpreadType(visitor, this);
        }

        private Type type;
        public Type getType() { return type; }
        public void setType(Type node) { type = node; connect(node); }

    }

    /**
     * A control directive.
     */
    public static abstract class Directive extends ExecutableStatement {

        public Directive(Token token) {
            super(token);
        }

        @Override public void visit(Visitor visitor) {
            try {
                visitor.visit(this);
            }
            catch (Exception e) {
                visitor.handleException(e, this);
            }
        }

        @Override public void visitChildren(Visitor visitor) {
            walkDirective(visitor, this);
        }

    }

    public static class Return extends Directive {

        public Return(Token token) {
            super(token);
        }

        @Override public void visit(Visitor visitor) {
            try {
                visitor.visit(this);
            }
            catch (Exception e) {
                visitor.handleException(e, this);
            }
        }

        @Override public void visitChildren(Visitor visitor) {
            walkReturn(visitor, this);
        }

        private Expression expression;
        public Expression getExpression() { return expression; }
        public void setExpression(Expression node) { expression = node; connect(node); }

        private com.redhat.ceylon.model.typechecker.model.Declaration declaration;
        public com.redhat.ceylon.model.typechecker.model.Declaration getDeclaration() { return declaration; }
        public void setDeclaration(com.redhat.ceylon.model.typechecker.model.Declaration value) { declaration = value; }

    }

    public static class Throw extends Directive {

        public Throw(Token token) {
            super(token);
        }

        @Override public void visit(Visitor visitor) {
            try {
                visitor.visit(this);
            }
            catch (Exception e) {
                visitor.handleException(e, this);
            }
        }

        @Override public void visitChildren(Visitor visitor) {
            walkThrow(visitor, this);
        }

        private Expression expression;
        public Expression getExpression() { return expression; }
        public void setExpression(Expression node) { expression = node; connect(node); }

    }

    public static class Continue extends Directive {

        public Continue(Token token) {
            super(token);
        }

        @Override public void visit(Visitor visitor) {
            try {
                visitor.visit(this);
            }
            catch (Exception e) {
                visitor.handleException(e, this);
            }
        }

        @Override public void visitChildren(Visitor visitor) {
            walkContinue(visitor, this);
        }

    }

    public static class Break extends Directive {

        public Break(Token token) {
            super(token);
        }

        @Override public void visit(Visitor visitor) {
            try {
                visitor.visit(this);
            }
            catch (Exception e) {
                visitor.handleException(e, this);
            }
        }

        @Override public void visitChildren(Visitor visitor) {
            walkBreak(visitor, this);
        }

    }

    /**
     * A statement or named argument.
     */
    public static abstract class StatementOrArgument extends Node {

        public StatementOrArgument(Token token) {
            super(token);
        }

        @Override public void visit(Visitor visitor) {
            try {
                visitor.visit(this);
            }
            catch (Exception e) {
                visitor.handleException(e, this);
            }
        }

        @Override public void visitChildren(Visitor visitor) {
            walkStatementOrArgument(visitor, this);
        }

        private List<CompilerAnnotation> compilerAnnotations = new ArrayList<CompilerAnnotation>(3);
        public List<CompilerAnnotation> getCompilerAnnotations() { return compilerAnnotations; }
        public void addCompilerAnnotation(CompilerAnnotation node) { compilerAnnotations.add(node); connect(node); }

    }

    /**
     * A statement or declaration.
     */
    public static abstract class Statement extends StatementOrArgument {

        public Statement(Token token) {
            super(token);
        }

        @Override public void visit(Visitor visitor) {
            try {
                visitor.visit(this);
            }
            catch (Exception e) {
                visitor.handleException(e, this);
            }
        }

        @Override public void visitChildren(Visitor visitor) {
            walkStatement(visitor, this);
        }

    }

    public static class CompilerAnnotation extends Node {

        public CompilerAnnotation(Token token) {
            super(token);
        }

        @Override public void visit(Visitor visitor) {
            try {
                visitor.visit(this);
            }
            catch (Exception e) {
                visitor.handleException(e, this);
            }
        }

        @Override public void visitChildren(Visitor visitor) {
            walkCompilerAnnotation(visitor, this);
        }

        private Identifier identifier;
        public Identifier getIdentifier() { return identifier; }
        public void setIdentifier(Identifier node) { identifier = node; connect(node); }

        private StringLiteral stringLiteral;
        public StringLiteral getStringLiteral() { return stringLiteral; }
        public void setStringLiteral(StringLiteral node) { stringLiteral = node; connect(node); }

    }

    /**
     * An expression statement, specification statement, or control structure.
     */
    public static abstract class ExecutableStatement extends Statement {

        public ExecutableStatement(Token token) {
            super(token);
        }

        @Override public void visit(Visitor visitor) {
            try {
                visitor.visit(this);
            }
            catch (Exception e) {
                visitor.handleException(e, this);
            }
        }

        @Override public void visitChildren(Visitor visitor) {
            walkExecutableStatement(visitor, this);
        }

    }

    /**
     * An assertion.
     */
    public static class Assertion extends ExecutableStatement {

        public Assertion(Token token) {
            super(token);
        }

        @Override public void visit(Visitor visitor) {
            try {
                visitor.visit(this);
            }
            catch (Exception e) {
                visitor.handleException(e, this);
            }
        }

        @Override public void visitChildren(Visitor visitor) {
            walkAssertion(visitor, this);
        }

        private AnnotationList annotationList;
        public AnnotationList getAnnotationList() { return annotationList; }
        public void setAnnotationList(AnnotationList node) { annotationList = node; connect(node); }

        private ConditionList conditionList;
        public ConditionList getConditionList() { return conditionList; }
        public void setConditionList(ConditionList node) { conditionList = node; connect(node); }

    }

    /**
     * A specification statement
     */
    public static class SpecifierStatement extends ExecutableStatement {

        public SpecifierStatement(Token token) {
            super(token);
        }

        @Override public void visit(Visitor visitor) {
            try {
                visitor.visit(this);
            }
            catch (Exception e) {
                visitor.handleException(e, this);
            }
        }

        @Override public void visitChildren(Visitor visitor) {
            walkSpecifierStatement(visitor, this);
        }

        private Term baseMemberExpression;
        public Term getBaseMemberExpression() { return baseMemberExpression; }
        public void setBaseMemberExpression(Term node) { baseMemberExpression = node; connect(node); }

        private SpecifierExpression specifierExpression;
        public SpecifierExpression getSpecifierExpression() { return specifierExpression; }
        public void setSpecifierExpression(SpecifierExpression node) { specifierExpression = node; connect(node); }

        private com.redhat.ceylon.model.typechecker.model.TypedDeclaration declaration;
        public com.redhat.ceylon.model.typechecker.model.TypedDeclaration getDeclaration() { return declaration; }
        public void setDeclaration(com.redhat.ceylon.model.typechecker.model.TypedDeclaration value) { declaration = value; }

        private boolean refinement;
        public boolean getRefinement() { return refinement; }
        public void setRefinement(boolean value) { refinement = value; }

        private com.redhat.ceylon.model.typechecker.model.TypedDeclaration refined;
        public com.redhat.ceylon.model.typechecker.model.TypedDeclaration getRefined() { return refined; }
        public void setRefined(com.redhat.ceylon.model.typechecker.model.TypedDeclaration value) { refined = value; }

    }

    /**
     * An expression statement.
     */
    public static class ExpressionStatement extends ExecutableStatement {

        public ExpressionStatement(Token token) {
            super(token);
        }

        @Override public void visit(Visitor visitor) {
            try {
                visitor.visit(this);
            }
            catch (Exception e) {
                visitor.handleException(e, this);
            }
        }

        @Override public void visitChildren(Visitor visitor) {
            walkExpressionStatement(visitor, this);
        }

        private Expression expression;
        public Expression getExpression() { return expression; }
        public void setExpression(Expression node) { expression = node; connect(node); }

    }

    public static abstract class Pattern extends Node {

        public Pattern(Token token) {
            super(token);
        }

        @Override public void visit(Visitor visitor) {
            try {
                visitor.visit(this);
            }
            catch (Exception e) {
                visitor.handleException(e, this);
            }
        }

        @Override public void visitChildren(Visitor visitor) {
            walkPattern(visitor, this);
        }

    }

    public static class VariablePattern extends Pattern {

        public VariablePattern(Token token) {
            super(token);
        }

        @Override public void visit(Visitor visitor) {
            try {
                visitor.visit(this);
            }
            catch (Exception e) {
                visitor.handleException(e, this);
            }
        }

        @Override public void visitChildren(Visitor visitor) {
            walkVariablePattern(visitor, this);
        }

        private Variable variable;
        public Variable getVariable() { return variable; }
        public void setVariable(Variable node) { variable = node; connect(node); }

    }

    public static class TuplePattern extends Pattern {

        public TuplePattern(Token token) {
            super(token);
        }

        @Override public void visit(Visitor visitor) {
            try {
                visitor.visit(this);
            }
            catch (Exception e) {
                visitor.handleException(e, this);
            }
        }

        @Override public void visitChildren(Visitor visitor) {
            walkTuplePattern(visitor, this);
        }

        private List<Pattern> patterns = new ArrayList<Pattern>(3);
        public List<Pattern> getPatterns() { return patterns; }
        public void addPattern(Pattern node) { patterns.add(node); connect(node); }

    }

    public static class KeyValuePattern extends Pattern {

        public KeyValuePattern(Token token) {
            super(token);
        }

        @Override public void visit(Visitor visitor) {
            try {
                visitor.visit(this);
            }
            catch (Exception e) {
                visitor.handleException(e, this);
            }
        }

        @Override public void visitChildren(Visitor visitor) {
            walkKeyValuePattern(visitor, this);
        }

        private Pattern key;
        public Pattern getKey() { return key; }
        public void setKey(Pattern node) { key = node; connect(node); }

        private Pattern value;
        public Pattern getValue() { return value; }
        public void setValue(Pattern node) { value = node; connect(node); }

    }

    public static class Destructure extends ExecutableStatement {

        public Destructure(Token token) {
            super(token);
        }

        @Override public void visit(Visitor visitor) {
            try {
                visitor.visit(this);
            }
            catch (Exception e) {
                visitor.handleException(e, this);
            }
        }

        @Override public void visitChildren(Visitor visitor) {
            walkDestructure(visitor, this);
        }

        private ValueModifier type;
        public ValueModifier getType() { return type; }
        public void setType(ValueModifier node) { type = node; connect(node); }

        private Pattern pattern;
        public Pattern getPattern() { return pattern; }
        public void setPattern(Pattern node) { pattern = node; connect(node); }

        private SpecifierExpression specifierExpression;
        public SpecifierExpression getSpecifierExpression() { return specifierExpression; }
        public void setSpecifierExpression(SpecifierExpression node) { specifierExpression = node; connect(node); }

        private boolean patternCase;
        public boolean getPatternCase() { return patternCase; }
        public void setPatternCase(boolean value) { patternCase = value; }

    }

    /**
     * A control structure.
     */
    public static class ControlStatement extends ExecutableStatement {

        public ControlStatement(Token token) {
            super(token);
        }

        @Override public void visit(Visitor visitor) {
            try {
                visitor.visit(this);
            }
            catch (Exception e) {
                visitor.handleException(e, this);
            }
        }

        @Override public void visitChildren(Visitor visitor) {
            walkControlStatement(visitor, this);
        }

    }

    public static class ControlClause extends Node {

        public ControlClause(Token token) {
            super(token);
        }

        @Override public void visit(Visitor visitor) {
            try {
                visitor.visit(this);
            }
            catch (Exception e) {
                visitor.handleException(e, this);
            }
        }

        @Override public void visitChildren(Visitor visitor) {
            walkControlClause(visitor, this);
        }

        private com.redhat.ceylon.model.typechecker.model.ControlBlock controlBlock;
        public com.redhat.ceylon.model.typechecker.model.ControlBlock getControlBlock() { return controlBlock; }
        public void setControlBlock(com.redhat.ceylon.model.typechecker.model.ControlBlock value) { controlBlock = value; }

    }

    public static class DynamicStatement extends ControlStatement {

        public DynamicStatement(Token token) {
            super(token);
        }

        @Override public void visit(Visitor visitor) {
            try {
                visitor.visit(this);
            }
            catch (Exception e) {
                visitor.handleException(e, this);
            }
        }

        @Override public void visitChildren(Visitor visitor) {
            walkDynamicStatement(visitor, this);
        }

        private DynamicClause dynamicClause;
        public DynamicClause getDynamicClause() { return dynamicClause; }
        public void setDynamicClause(DynamicClause node) { dynamicClause = node; connect(node); }

    }

    public static class DynamicClause extends ControlClause {

        public DynamicClause(Token token) {
            super(token);
        }

        @Override public void visit(Visitor visitor) {
            try {
                visitor.visit(this);
            }
            catch (Exception e) {
                visitor.handleException(e, this);
            }
        }

        @Override public void visitChildren(Visitor visitor) {
            walkDynamicClause(visitor, this);
        }

        private Block block;
        public Block getBlock() { return block; }
        public void setBlock(Block node) { block = node; connect(node); }

    }

    public static class LetExpression extends Term {

        public LetExpression(Token token) {
            super(token);
        }

        @Override public void visit(Visitor visitor) {
            try {
                visitor.visit(this);
            }
            catch (Exception e) {
                visitor.handleException(e, this);
            }
        }

        @Override public void visitChildren(Visitor visitor) {
            walkLetExpression(visitor, this);
        }

        private LetClause letClause;
        public LetClause getLetClause() { return letClause; }
        public void setLetClause(LetClause node) { letClause = node; connect(node); }

    }

    public static class LetClause extends ControlClause {

        public LetClause(Token token) {
            super(token);
        }

        @Override public void visit(Visitor visitor) {
            try {
                visitor.visit(this);
            }
            catch (Exception e) {
                visitor.handleException(e, this);
            }
        }

        @Override public void visitChildren(Visitor visitor) {
            walkLetClause(visitor, this);
        }

        private List<Statement> variables = new ArrayList<Statement>(3);
        public List<Statement> getVariables() { return variables; }
        public void addVariable(Statement node) { variables.add(node); connect(node); }

        private Expression expression;
        public Expression getExpression() { return expression; }
        public void setExpression(Expression node) { expression = node; connect(node); }

    }

    public static class IfStatement extends ControlStatement {

        public IfStatement(Token token) {
            super(token);
        }

        @Override public void visit(Visitor visitor) {
            try {
                visitor.visit(this);
            }
            catch (Exception e) {
                visitor.handleException(e, this);
            }
        }

        @Override public void visitChildren(Visitor visitor) {
            walkIfStatement(visitor, this);
        }

        private IfClause ifClause;
        public IfClause getIfClause() { return ifClause; }
        public void setIfClause(IfClause node) { ifClause = node; connect(node); }

        private ElseClause elseClause;
        public ElseClause getElseClause() { return elseClause; }
        public void setElseClause(ElseClause node) { elseClause = node; connect(node); }

    }

    public static class IfClause extends ControlClause {

        public IfClause(Token token) {
            super(token);
        }

        @Override public void visit(Visitor visitor) {
            try {
                visitor.visit(this);
            }
            catch (Exception e) {
                visitor.handleException(e, this);
            }
        }

        @Override public void visitChildren(Visitor visitor) {
            walkIfClause(visitor, this);
        }

        private ConditionList conditionList;
        public ConditionList getConditionList() { return conditionList; }
        public void setConditionList(ConditionList node) { conditionList = node; connect(node); }

        private Block block;
        public Block getBlock() { return block; }
        public void setBlock(Block node) { block = node; connect(node); }

        private Expression expression;
        public Expression getExpression() { return expression; }
        public void setExpression(Expression node) { expression = node; connect(node); }

    }

    public static class ElseClause extends ControlClause {

        public ElseClause(Token token) {
            super(token);
        }

        @Override public void visit(Visitor visitor) {
            try {
                visitor.visit(this);
            }
            catch (Exception e) {
                visitor.handleException(e, this);
            }
        }

        @Override public void visitChildren(Visitor visitor) {
            walkElseClause(visitor, this);
        }

        private Variable variable;
        public Variable getVariable() { return variable; }
        public void setVariable(Variable node) { variable = node; connect(node); }

        private Block block;
        public Block getBlock() { return block; }
        public void setBlock(Block node) { block = node; connect(node); }

        private Expression expression;
        public Expression getExpression() { return expression; }
        public void setExpression(Expression node) { expression = node; connect(node); }

    }

    public static class SwitchStatement extends ControlStatement {

        public SwitchStatement(Token token) {
            super(token);
        }

        @Override public void visit(Visitor visitor) {
            try {
                visitor.visit(this);
            }
            catch (Exception e) {
                visitor.handleException(e, this);
            }
        }

        @Override public void visitChildren(Visitor visitor) {
            walkSwitchStatement(visitor, this);
        }

        private SwitchClause switchClause;
        public SwitchClause getSwitchClause() { return switchClause; }
        public void setSwitchClause(SwitchClause node) { switchClause = node; connect(node); }

        private SwitchCaseList switchCaseList;
        public SwitchCaseList getSwitchCaseList() { return switchCaseList; }
        public void setSwitchCaseList(SwitchCaseList node) { switchCaseList = node; connect(node); }

        private com.redhat.ceylon.model.typechecker.model.ControlBlock controlBlock;
        public com.redhat.ceylon.model.typechecker.model.ControlBlock getControlBlock() { return controlBlock; }
        public void setControlBlock(com.redhat.ceylon.model.typechecker.model.ControlBlock value) { controlBlock = value; }

    }

    public static class SwitchClause extends Node {

        public SwitchClause(Token token) {
            super(token);
        }

        @Override public void visit(Visitor visitor) {
            try {
                visitor.visit(this);
            }
            catch (Exception e) {
                visitor.handleException(e, this);
            }
        }

        @Override public void visitChildren(Visitor visitor) {
            walkSwitchClause(visitor, this);
        }

        private Switched switched;
        public Switched getSwitched() { return switched; }
        public void setSwitched(Switched node) { switched = node; connect(node); }

    }

    public static class Switched extends Node {

        public Switched(Token token) {
            super(token);
        }

        @Override public void visit(Visitor visitor) {
            try {
                visitor.visit(this);
            }
            catch (Exception e) {
                visitor.handleException(e, this);
            }
        }

        @Override public void visitChildren(Visitor visitor) {
            walkSwitched(visitor, this);
        }

        private Variable variable;
        public Variable getVariable() { return variable; }
        public void setVariable(Variable node) { variable = node; connect(node); }

        private Expression expression;
        public Expression getExpression() { return expression; }
        public void setExpression(Expression node) { expression = node; connect(node); }

    }

    public static class SwitchCaseList extends Node {

        public SwitchCaseList(Token token) {
            super(token);
        }

        @Override public void visit(Visitor visitor) {
            try {
                visitor.visit(this);
            }
            catch (Exception e) {
                visitor.handleException(e, this);
            }
        }

        @Override public void visitChildren(Visitor visitor) {
            walkSwitchCaseList(visitor, this);
        }

        private List<CaseClause> caseClauses = new ArrayList<CaseClause>(3);
        public List<CaseClause> getCaseClauses() { return caseClauses; }
        public void addCaseClause(CaseClause node) { caseClauses.add(node); connect(node); }

        private ElseClause elseClause;
        public ElseClause getElseClause() { return elseClause; }
        public void setElseClause(ElseClause node) { elseClause = node; connect(node); }

    }

    public static class CaseClause extends ControlClause {

        public CaseClause(Token token) {
            super(token);
        }

        @Override public void visit(Visitor visitor) {
            try {
                visitor.visit(this);
            }
            catch (Exception e) {
                visitor.handleException(e, this);
            }
        }

        @Override public void visitChildren(Visitor visitor) {
            walkCaseClause(visitor, this);
        }

        private CaseItem caseItem;
        public CaseItem getCaseItem() { return caseItem; }
        public void setCaseItem(CaseItem node) { caseItem = node; connect(node); }

        private Block block;
        public Block getBlock() { return block; }
        public void setBlock(Block node) { block = node; connect(node); }

        private Expression expression;
        public Expression getExpression() { return expression; }
        public void setExpression(Expression node) { expression = node; connect(node); }

        private boolean overlapping;
        public boolean getOverlapping() { return overlapping; }
        public void setOverlapping(boolean value) { overlapping = value; }

    }

    public static class CaseItem extends Node {

        public CaseItem(Token token) {
            super(token);
        }

        @Override public void visit(Visitor visitor) {
            try {
                visitor.visit(this);
            }
            catch (Exception e) {
                visitor.handleException(e, this);
            }
        }

        @Override public void visitChildren(Visitor visitor) {
            walkCaseItem(visitor, this);
        }

    }

    public static class MatchCase extends CaseItem {

        public MatchCase(Token token) {
            super(token);
        }

        @Override public void visit(Visitor visitor) {
            try {
                visitor.visit(this);
            }
            catch (Exception e) {
                visitor.handleException(e, this);
            }
        }

        @Override public void visitChildren(Visitor visitor) {
            walkMatchCase(visitor, this);
        }

        private ExpressionList expressionList;
        public ExpressionList getExpressionList() { return expressionList; }
        public void setExpressionList(ExpressionList node) { expressionList = node; connect(node); }

    }

    public static class IsCase extends CaseItem {

        public IsCase(Token token) {
            super(token);
        }

        @Override public void visit(Visitor visitor) {
            try {
                visitor.visit(this);
            }
            catch (Exception e) {
                visitor.handleException(e, this);
            }
        }

        @Override public void visitChildren(Visitor visitor) {
            walkIsCase(visitor, this);
        }

        private Type type;
        public Type getType() { return type; }
        public void setType(Type node) { type = node; connect(node); }

        private Variable variable;
        public Variable getVariable() { return variable; }
        public void setVariable(Variable node) { variable = node; connect(node); }

    }

    public static class PatternCase extends CaseItem {

        public PatternCase(Token token) {
            super(token);
        }

        @Override public void visit(Visitor visitor) {
            try {
                visitor.visit(this);
            }
            catch (Exception e) {
                visitor.handleException(e, this);
            }
        }

        @Override public void visitChildren(Visitor visitor) {
            walkPatternCase(visitor, this);
        }

        private Pattern pattern;
        public Pattern getPattern() { return pattern; }
        public void setPattern(Pattern node) { pattern = node; connect(node); }

    }

    public static class SatisfiesCase extends CaseItem {

        public SatisfiesCase(Token token) {
            super(token);
        }

        @Override public void visit(Visitor visitor) {
            try {
                visitor.visit(this);
            }
            catch (Exception e) {
                visitor.handleException(e, this);
            }
        }

        @Override public void visitChildren(Visitor visitor) {
            walkSatisfiesCase(visitor, this);
        }

        private Type type;
        public Type getType() { return type; }
        public void setType(Type node) { type = node; connect(node); }

    }

    public static class TryCatchStatement extends ControlStatement {

        public TryCatchStatement(Token token) {
            super(token);
        }

        @Override public void visit(Visitor visitor) {
            try {
                visitor.visit(this);
            }
            catch (Exception e) {
                visitor.handleException(e, this);
            }
        }

        @Override public void visitChildren(Visitor visitor) {
            walkTryCatchStatement(visitor, this);
        }

        private TryClause tryClause;
        public TryClause getTryClause() { return tryClause; }
        public void setTryClause(TryClause node) { tryClause = node; connect(node); }

        private List<CatchClause> catchClauses = new ArrayList<CatchClause>(3);
        public List<CatchClause> getCatchClauses() { return catchClauses; }
        public void addCatchClause(CatchClause node) { catchClauses.add(node); connect(node); }

        private FinallyClause finallyClause;
        public FinallyClause getFinallyClause() { return finallyClause; }
        public void setFinallyClause(FinallyClause node) { finallyClause = node; connect(node); }

    }

    public static class TryClause extends ControlClause {

        public TryClause(Token token) {
            super(token);
        }

        @Override public void visit(Visitor visitor) {
            try {
                visitor.visit(this);
            }
            catch (Exception e) {
                visitor.handleException(e, this);
            }
        }

        @Override public void visitChildren(Visitor visitor) {
            walkTryClause(visitor, this);
        }

        private ResourceList resourceList;
        public ResourceList getResourceList() { return resourceList; }
        public void setResourceList(ResourceList node) { resourceList = node; connect(node); }

        private Block block;
        public Block getBlock() { return block; }
        public void setBlock(Block node) { block = node; connect(node); }

    }

    public static class CatchClause extends ControlClause {

        public CatchClause(Token token) {
            super(token);
        }

        @Override public void visit(Visitor visitor) {
            try {
                visitor.visit(this);
            }
            catch (Exception e) {
                visitor.handleException(e, this);
            }
        }

        @Override public void visitChildren(Visitor visitor) {
            walkCatchClause(visitor, this);
        }

        private CatchVariable catchVariable;
        public CatchVariable getCatchVariable() { return catchVariable; }
        public void setCatchVariable(CatchVariable node) { catchVariable = node; connect(node); }

        private Block block;
        public Block getBlock() { return block; }
        public void setBlock(Block node) { block = node; connect(node); }

    }

    public static class FinallyClause extends ControlClause {

        public FinallyClause(Token token) {
            super(token);
        }

        @Override public void visit(Visitor visitor) {
            try {
                visitor.visit(this);
            }
            catch (Exception e) {
                visitor.handleException(e, this);
            }
        }

        @Override public void visitChildren(Visitor visitor) {
            walkFinallyClause(visitor, this);
        }

        private Block block;
        public Block getBlock() { return block; }
        public void setBlock(Block node) { block = node; connect(node); }

    }

    public static class ResourceList extends Node {

        public ResourceList(Token token) {
            super(token);
        }

        @Override public void visit(Visitor visitor) {
            try {
                visitor.visit(this);
            }
            catch (Exception e) {
                visitor.handleException(e, this);
            }
        }

        @Override public void visitChildren(Visitor visitor) {
            walkResourceList(visitor, this);
        }

        private List<Resource> resources = new ArrayList<Resource>(3);
        public List<Resource> getResources() { return resources; }
        public void addResource(Resource node) { resources.add(node); connect(node); }

    }

    public static class Resource extends Node {

        public Resource(Token token) {
            super(token);
        }

        @Override public void visit(Visitor visitor) {
            try {
                visitor.visit(this);
            }
            catch (Exception e) {
                visitor.handleException(e, this);
            }
        }

        @Override public void visitChildren(Visitor visitor) {
            walkResource(visitor, this);
        }

        private Variable variable;
        public Variable getVariable() { return variable; }
        public void setVariable(Variable node) { variable = node; connect(node); }

        private Expression expression;
        public Expression getExpression() { return expression; }
        public void setExpression(Expression node) { expression = node; connect(node); }

    }

    public static class CatchVariable extends Node {

        public CatchVariable(Token token) {
            super(token);
        }

        @Override public void visit(Visitor visitor) {
            try {
                visitor.visit(this);
            }
            catch (Exception e) {
                visitor.handleException(e, this);
            }
        }

        @Override public void visitChildren(Visitor visitor) {
            walkCatchVariable(visitor, this);
        }

        private Variable variable;
        public Variable getVariable() { return variable; }
        public void setVariable(Variable node) { variable = node; connect(node); }

    }

    public static class ForStatement extends ControlStatement {

        public ForStatement(Token token) {
            super(token);
        }

        @Override public void visit(Visitor visitor) {
            try {
                visitor.visit(this);
            }
            catch (Exception e) {
                visitor.handleException(e, this);
            }
        }

        @Override public void visitChildren(Visitor visitor) {
            walkForStatement(visitor, this);
        }

        private ForClause forClause;
        public ForClause getForClause() { return forClause; }
        public void setForClause(ForClause node) { forClause = node; connect(node); }

        private ElseClause elseClause;
        public ElseClause getElseClause() { return elseClause; }
        public void setElseClause(ElseClause node) { elseClause = node; connect(node); }

        private boolean exits;
        public boolean getExits() { return exits; }
        public void setExits(boolean value) { exits = value; }

    }

    public static class ForClause extends ControlClause {

        public ForClause(Token token) {
            super(token);
        }

        @Override public void visit(Visitor visitor) {
            try {
                visitor.visit(this);
            }
            catch (Exception e) {
                visitor.handleException(e, this);
            }
        }

        @Override public void visitChildren(Visitor visitor) {
            walkForClause(visitor, this);
        }

        private ForIterator forIterator;
        public ForIterator getForIterator() { return forIterator; }
        public void setForIterator(ForIterator node) { forIterator = node; connect(node); }

        private Block block;
        public Block getBlock() { return block; }
        public void setBlock(Block node) { block = node; connect(node); }

    }

    public static class ForIterator extends StatementOrArgument {

        public ForIterator(Token token) {
            super(token);
        }

        @Override public void visit(Visitor visitor) {
            try {
                visitor.visit(this);
            }
            catch (Exception e) {
                visitor.handleException(e, this);
            }
        }

        @Override public void visitChildren(Visitor visitor) {
            walkForIterator(visitor, this);
        }

        private SpecifierExpression specifierExpression;
        public SpecifierExpression getSpecifierExpression() { return specifierExpression; }
        public void setSpecifierExpression(SpecifierExpression node) { specifierExpression = node; connect(node); }

    }

    public static class ValueIterator extends ForIterator {

        public ValueIterator(Token token) {
            super(token);
        }

        @Override public void visit(Visitor visitor) {
            try {
                visitor.visit(this);
            }
            catch (Exception e) {
                visitor.handleException(e, this);
            }
        }

        @Override public void visitChildren(Visitor visitor) {
            walkValueIterator(visitor, this);
        }

        private Variable variable;
        public Variable getVariable() { return variable; }
        public void setVariable(Variable node) { variable = node; connect(node); }

    }

    public static class PatternIterator extends ForIterator {

        public PatternIterator(Token token) {
            super(token);
        }

        @Override public void visit(Visitor visitor) {
            try {
                visitor.visit(this);
            }
            catch (Exception e) {
                visitor.handleException(e, this);
            }
        }

        @Override public void visitChildren(Visitor visitor) {
            walkPatternIterator(visitor, this);
        }

        private Pattern pattern;
        public Pattern getPattern() { return pattern; }
        public void setPattern(Pattern node) { pattern = node; connect(node); }

    }

    public static class WhileStatement extends ControlStatement {

        public WhileStatement(Token token) {
            super(token);
        }

        @Override public void visit(Visitor visitor) {
            try {
                visitor.visit(this);
            }
            catch (Exception e) {
                visitor.handleException(e, this);
            }
        }

        @Override public void visitChildren(Visitor visitor) {
            walkWhileStatement(visitor, this);
        }

        private WhileClause whileClause;
        public WhileClause getWhileClause() { return whileClause; }
        public void setWhileClause(WhileClause node) { whileClause = node; connect(node); }

    }

    public static class WhileClause extends ControlClause {

        public WhileClause(Token token) {
            super(token);
        }

        @Override public void visit(Visitor visitor) {
            try {
                visitor.visit(this);
            }
            catch (Exception e) {
                visitor.handleException(e, this);
            }
        }

        @Override public void visitChildren(Visitor visitor) {
            walkWhileClause(visitor, this);
        }

        private ConditionList conditionList;
        public ConditionList getConditionList() { return conditionList; }
        public void setConditionList(ConditionList node) { conditionList = node; connect(node); }

        private Block block;
        public Block getBlock() { return block; }
        public void setBlock(Block node) { block = node; connect(node); }

    }

    public static class ConditionList extends Node {

        public ConditionList(Token token) {
            super(token);
        }

        @Override public void visit(Visitor visitor) {
            try {
                visitor.visit(this);
            }
            catch (Exception e) {
                visitor.handleException(e, this);
            }
        }

        @Override public void visitChildren(Visitor visitor) {
            walkConditionList(visitor, this);
        }

        private List<Condition> conditions = new ArrayList<Condition>(3);
        public List<Condition> getConditions() { return conditions; }
        public void addCondition(Condition node) { conditions.add(node); connect(node); }

    }

    public static abstract class Condition extends Node {

        public Condition(Token token) {
            super(token);
        }

        @Override public void visit(Visitor visitor) {
            try {
                visitor.visit(this);
            }
            catch (Exception e) {
                visitor.handleException(e, this);
            }
        }

        @Override public void visitChildren(Visitor visitor) {
            walkCondition(visitor, this);
        }

        private boolean assertion;
        public boolean getAssertion() { return assertion; }
        public void setAssertion(boolean value) { assertion = value; }

    }

    public static class BooleanCondition extends Condition {

        public BooleanCondition(Token token) {
            super(token);
        }

        @Override public void visit(Visitor visitor) {
            try {
                visitor.visit(this);
            }
            catch (Exception e) {
                visitor.handleException(e, this);
            }
        }

        @Override public void visitChildren(Visitor visitor) {
            walkBooleanCondition(visitor, this);
        }

        private Expression expression;
        public Expression getExpression() { return expression; }
        public void setExpression(Expression node) { expression = node; connect(node); }

    }

    public static abstract class ExistsOrNonemptyCondition extends Condition {

        public ExistsOrNonemptyCondition(Token token) {
            super(token);
        }

        @Override public void visit(Visitor visitor) {
            try {
                visitor.visit(this);
            }
            catch (Exception e) {
                visitor.handleException(e, this);
            }
        }

        @Override public void visitChildren(Visitor visitor) {
            walkExistsOrNonemptyCondition(visitor, this);
        }

        private Statement variable;
        public Statement getVariable() { return variable; }
        public void setVariable(Statement node) { variable = node; connect(node); }

        private Expression brokenExpression;
        public Expression getBrokenExpression() { return brokenExpression; }
        public void setBrokenExpression(Expression node) { brokenExpression = node; connect(node); }

        private boolean not;
        public boolean getNot() { return not; }
        public void setNot(boolean value) { not = value; }

    }

    public static class ExistsCondition extends ExistsOrNonemptyCondition {

        public ExistsCondition(Token token) {
            super(token);
        }

        @Override public void visit(Visitor visitor) {
            try {
                visitor.visit(this);
            }
            catch (Exception e) {
                visitor.handleException(e, this);
            }
        }

        @Override public void visitChildren(Visitor visitor) {
            walkExistsCondition(visitor, this);
        }

    }

    public static class NonemptyCondition extends ExistsOrNonemptyCondition {

        public NonemptyCondition(Token token) {
            super(token);
        }

        @Override public void visit(Visitor visitor) {
            try {
                visitor.visit(this);
            }
            catch (Exception e) {
                visitor.handleException(e, this);
            }
        }

        @Override public void visitChildren(Visitor visitor) {
            walkNonemptyCondition(visitor, this);
        }

    }

    public static class IsCondition extends Condition {

        public IsCondition(Token token) {
            super(token);
        }

        @Override public void visit(Visitor visitor) {
            try {
                visitor.visit(this);
            }
            catch (Exception e) {
                visitor.handleException(e, this);
            }
        }

        @Override public void visitChildren(Visitor visitor) {
            walkIsCondition(visitor, this);
        }

        private Type type;
        public Type getType() { return type; }
        public void setType(Type node) { type = node; connect(node); }

        private Variable variable;
        public Variable getVariable() { return variable; }
        public void setVariable(Variable node) { variable = node; connect(node); }

        private boolean not;
        public boolean getNot() { return not; }
        public void setNot(boolean value) { not = value; }

    }

    public static class SatisfiesCondition extends Condition {

        public SatisfiesCondition(Token token) {
            super(token);
        }

        @Override public void visit(Visitor visitor) {
            try {
                visitor.visit(this);
            }
            catch (Exception e) {
                visitor.handleException(e, this);
            }
        }

        @Override public void visitChildren(Visitor visitor) {
            walkSatisfiesCondition(visitor, this);
        }

        private Type type;
        public Type getType() { return type; }
        public void setType(Type node) { type = node; connect(node); }

        private Identifier identifier;
        public Identifier getIdentifier() { return identifier; }
        public void setIdentifier(Identifier node) { identifier = node; connect(node); }

    }

    public static class Variable extends TypedDeclaration {

        public Variable(Token token) {
            super(token);
        }

        @Override public void visit(Visitor visitor) {
            try {
                visitor.visit(this);
            }
            catch (Exception e) {
                visitor.handleException(e, this);
            }
        }

        @Override public void visitChildren(Visitor visitor) {
            walkVariable(visitor, this);
        }

        private List<ParameterList> parameterLists = new ArrayList<ParameterList>(3);
        public List<ParameterList> getParameterLists() { return parameterLists; }
        public void addParameterList(ParameterList node) { parameterLists.add(node); connect(node); }

        private SpecifierExpression specifierExpression;
        public SpecifierExpression getSpecifierExpression() { return specifierExpression; }
        public void setSpecifierExpression(SpecifierExpression node) { specifierExpression = node; connect(node); }

        private com.redhat.ceylon.model.typechecker.model.Value declarationModel;
        public com.redhat.ceylon.model.typechecker.model.Value getDeclarationModel() { return declarationModel; }
        public void setDeclarationModel(com.redhat.ceylon.model.typechecker.model.Value value) { declarationModel = value; }

    }

    public static abstract class Term extends Node {

        public Term(Token token) {
            super(token);
        }

        @Override public void visit(Visitor visitor) {
            try {
                visitor.visit(this);
            }
            catch (Exception e) {
                visitor.handleException(e, this);
            }
        }

        @Override public void visitChildren(Visitor visitor) {
            walkTerm(visitor, this);
        }

        private com.redhat.ceylon.model.typechecker.model.Type typeModel;
        public com.redhat.ceylon.model.typechecker.model.Type getTypeModel() { return typeModel; }
        public void setTypeModel(com.redhat.ceylon.model.typechecker.model.Type value) { typeModel = value; }

        private boolean unboxed;
        public boolean getUnboxed() { return unboxed; }
        public void setUnboxed(boolean value) { unboxed = value; }

        private boolean typeErased;
        public boolean getTypeErased() { return typeErased; }
        public void setTypeErased(boolean value) { typeErased = value; }

        private boolean untrustedType;
        public boolean getUntrustedType() { return untrustedType; }
        public void setUntrustedType(boolean value) { untrustedType = value; }

        private boolean small;
        public boolean getSmall() { return small; }
        public void setSmall(boolean value) { small = value; }

    }

    public static abstract class OperatorExpression extends Term {

        public OperatorExpression(Token token) {
            super(token);
        }

        @Override public void visit(Visitor visitor) {
            try {
                visitor.visit(this);
            }
            catch (Exception e) {
                visitor.handleException(e, this);
            }
        }

        @Override public void visitChildren(Visitor visitor) {
            walkOperatorExpression(visitor, this);
        }

    }

    public static abstract class BinaryOperatorExpression extends OperatorExpression {

        public BinaryOperatorExpression(Token token) {
            super(token);
        }

        @Override public void visit(Visitor visitor) {
            try {
                visitor.visit(this);
            }
            catch (Exception e) {
                visitor.handleException(e, this);
            }
        }

        @Override public void visitChildren(Visitor visitor) {
            walkBinaryOperatorExpression(visitor, this);
        }

        private Term leftTerm;
        public Term getLeftTerm() { return leftTerm; }
        public void setLeftTerm(Term node) { leftTerm = node; connect(node); }

        private Term rightTerm;
        public Term getRightTerm() { return rightTerm; }
        public void setRightTerm(Term node) { rightTerm = node; connect(node); }

    }

    public static abstract class ArithmeticOp extends BinaryOperatorExpression {

        public ArithmeticOp(Token token) {
            super(token);
        }

        @Override public void visit(Visitor visitor) {
            try {
                visitor.visit(this);
            }
            catch (Exception e) {
                visitor.handleException(e, this);
            }
        }

        @Override public void visitChildren(Visitor visitor) {
            walkArithmeticOp(visitor, this);
        }

    }

    public static class SumOp extends ArithmeticOp {

        public SumOp(Token token) {
            super(token);
        }

        @Override public void visit(Visitor visitor) {
            try {
                visitor.visit(this);
            }
            catch (Exception e) {
                visitor.handleException(e, this);
            }
        }

        @Override public void visitChildren(Visitor visitor) {
            walkSumOp(visitor, this);
        }

    }

    public static class DifferenceOp extends ArithmeticOp {

        public DifferenceOp(Token token) {
            super(token);
        }

        @Override public void visit(Visitor visitor) {
            try {
                visitor.visit(this);
            }
            catch (Exception e) {
                visitor.handleException(e, this);
            }
        }

        @Override public void visitChildren(Visitor visitor) {
            walkDifferenceOp(visitor, this);
        }

    }

    public static class ProductOp extends ArithmeticOp {

        public ProductOp(Token token) {
            super(token);
        }

        @Override public void visit(Visitor visitor) {
            try {
                visitor.visit(this);
            }
            catch (Exception e) {
                visitor.handleException(e, this);
            }
        }

        @Override public void visitChildren(Visitor visitor) {
            walkProductOp(visitor, this);
        }

    }

    public static class QuotientOp extends ArithmeticOp {

        public QuotientOp(Token token) {
            super(token);
        }

        @Override public void visit(Visitor visitor) {
            try {
                visitor.visit(this);
            }
            catch (Exception e) {
                visitor.handleException(e, this);
            }
        }

        @Override public void visitChildren(Visitor visitor) {
            walkQuotientOp(visitor, this);
        }

    }

    public static class PowerOp extends ArithmeticOp {

        public PowerOp(Token token) {
            super(token);
        }

        @Override public void visit(Visitor visitor) {
            try {
                visitor.visit(this);
            }
            catch (Exception e) {
                visitor.handleException(e, this);
            }
        }

        @Override public void visitChildren(Visitor visitor) {
            walkPowerOp(visitor, this);
        }

    }

    public static class RemainderOp extends ArithmeticOp {

        public RemainderOp(Token token) {
            super(token);
        }

        @Override public void visit(Visitor visitor) {
            try {
                visitor.visit(this);
            }
            catch (Exception e) {
                visitor.handleException(e, this);
            }
        }

        @Override public void visitChildren(Visitor visitor) {
            walkRemainderOp(visitor, this);
        }

    }

    public static abstract class AssignmentOp extends BinaryOperatorExpression {

        public AssignmentOp(Token token) {
            super(token);
        }

        @Override public void visit(Visitor visitor) {
            try {
                visitor.visit(this);
            }
            catch (Exception e) {
                visitor.handleException(e, this);
            }
        }

        @Override public void visitChildren(Visitor visitor) {
            walkAssignmentOp(visitor, this);
        }

    }

    public static class AssignOp extends AssignmentOp {

        public AssignOp(Token token) {
            super(token);
        }

        @Override public void visit(Visitor visitor) {
            try {
                visitor.visit(this);
            }
            catch (Exception e) {
                visitor.handleException(e, this);
            }
        }

        @Override public void visitChildren(Visitor visitor) {
            walkAssignOp(visitor, this);
        }

    }

    public static abstract class ArithmeticAssignmentOp extends AssignmentOp {

        public ArithmeticAssignmentOp(Token token) {
            super(token);
        }

        @Override public void visit(Visitor visitor) {
            try {
                visitor.visit(this);
            }
            catch (Exception e) {
                visitor.handleException(e, this);
            }
        }

        @Override public void visitChildren(Visitor visitor) {
            walkArithmeticAssignmentOp(visitor, this);
        }

    }

    public static class AddAssignOp extends ArithmeticAssignmentOp {

        public AddAssignOp(Token token) {
            super(token);
        }

        @Override public void visit(Visitor visitor) {
            try {
                visitor.visit(this);
            }
            catch (Exception e) {
                visitor.handleException(e, this);
            }
        }

        @Override public void visitChildren(Visitor visitor) {
            walkAddAssignOp(visitor, this);
        }

    }

    public static class SubtractAssignOp extends ArithmeticAssignmentOp {

        public SubtractAssignOp(Token token) {
            super(token);
        }

        @Override public void visit(Visitor visitor) {
            try {
                visitor.visit(this);
            }
            catch (Exception e) {
                visitor.handleException(e, this);
            }
        }

        @Override public void visitChildren(Visitor visitor) {
            walkSubtractAssignOp(visitor, this);
        }

    }

    public static class MultiplyAssignOp extends ArithmeticAssignmentOp {

        public MultiplyAssignOp(Token token) {
            super(token);
        }

        @Override public void visit(Visitor visitor) {
            try {
                visitor.visit(this);
            }
            catch (Exception e) {
                visitor.handleException(e, this);
            }
        }

        @Override public void visitChildren(Visitor visitor) {
            walkMultiplyAssignOp(visitor, this);
        }

    }

    public static class DivideAssignOp extends ArithmeticAssignmentOp {

        public DivideAssignOp(Token token) {
            super(token);
        }

        @Override public void visit(Visitor visitor) {
            try {
                visitor.visit(this);
            }
            catch (Exception e) {
                visitor.handleException(e, this);
            }
        }

        @Override public void visitChildren(Visitor visitor) {
            walkDivideAssignOp(visitor, this);
        }

    }

    public static class RemainderAssignOp extends ArithmeticAssignmentOp {

        public RemainderAssignOp(Token token) {
            super(token);
        }

        @Override public void visit(Visitor visitor) {
            try {
                visitor.visit(this);
            }
            catch (Exception e) {
                visitor.handleException(e, this);
            }
        }

        @Override public void visitChildren(Visitor visitor) {
            walkRemainderAssignOp(visitor, this);
        }

    }

    public static abstract class BitwiseAssignmentOp extends AssignmentOp {

        public BitwiseAssignmentOp(Token token) {
            super(token);
        }

        @Override public void visit(Visitor visitor) {
            try {
                visitor.visit(this);
            }
            catch (Exception e) {
                visitor.handleException(e, this);
            }
        }

        @Override public void visitChildren(Visitor visitor) {
            walkBitwiseAssignmentOp(visitor, this);
        }

    }

    public static class IntersectAssignOp extends BitwiseAssignmentOp {

        public IntersectAssignOp(Token token) {
            super(token);
        }

        @Override public void visit(Visitor visitor) {
            try {
                visitor.visit(this);
            }
            catch (Exception e) {
                visitor.handleException(e, this);
            }
        }

        @Override public void visitChildren(Visitor visitor) {
            walkIntersectAssignOp(visitor, this);
        }

    }

    public static class UnionAssignOp extends BitwiseAssignmentOp {

        public UnionAssignOp(Token token) {
            super(token);
        }

        @Override public void visit(Visitor visitor) {
            try {
                visitor.visit(this);
            }
            catch (Exception e) {
                visitor.handleException(e, this);
            }
        }

        @Override public void visitChildren(Visitor visitor) {
            walkUnionAssignOp(visitor, this);
        }

    }

    public static class ComplementAssignOp extends BitwiseAssignmentOp {

        public ComplementAssignOp(Token token) {
            super(token);
        }

        @Override public void visit(Visitor visitor) {
            try {
                visitor.visit(this);
            }
            catch (Exception e) {
                visitor.handleException(e, this);
            }
        }

        @Override public void visitChildren(Visitor visitor) {
            walkComplementAssignOp(visitor, this);
        }

    }

    public static abstract class LogicalAssignmentOp extends AssignmentOp {

        public LogicalAssignmentOp(Token token) {
            super(token);
        }

        @Override public void visit(Visitor visitor) {
            try {
                visitor.visit(this);
            }
            catch (Exception e) {
                visitor.handleException(e, this);
            }
        }

        @Override public void visitChildren(Visitor visitor) {
            walkLogicalAssignmentOp(visitor, this);
        }

    }

    public static class AndAssignOp extends LogicalAssignmentOp {

        public AndAssignOp(Token token) {
            super(token);
        }

        @Override public void visit(Visitor visitor) {
            try {
                visitor.visit(this);
            }
            catch (Exception e) {
                visitor.handleException(e, this);
            }
        }

        @Override public void visitChildren(Visitor visitor) {
            walkAndAssignOp(visitor, this);
        }

    }

    public static class OrAssignOp extends LogicalAssignmentOp {

        public OrAssignOp(Token token) {
            super(token);
        }

        @Override public void visit(Visitor visitor) {
            try {
                visitor.visit(this);
            }
            catch (Exception e) {
                visitor.handleException(e, this);
            }
        }

        @Override public void visitChildren(Visitor visitor) {
            walkOrAssignOp(visitor, this);
        }

    }

    public static abstract class LogicalOp extends BinaryOperatorExpression {

        public LogicalOp(Token token) {
            super(token);
        }

        @Override public void visit(Visitor visitor) {
            try {
                visitor.visit(this);
            }
            catch (Exception e) {
                visitor.handleException(e, this);
            }
        }

        @Override public void visitChildren(Visitor visitor) {
            walkLogicalOp(visitor, this);
        }

    }

    public static class AndOp extends LogicalOp {

        public AndOp(Token token) {
            super(token);
        }

        @Override public void visit(Visitor visitor) {
            try {
                visitor.visit(this);
            }
            catch (Exception e) {
                visitor.handleException(e, this);
            }
        }

        @Override public void visitChildren(Visitor visitor) {
            walkAndOp(visitor, this);
        }

    }

    public static class OrOp extends LogicalOp {

        public OrOp(Token token) {
            super(token);
        }

        @Override public void visit(Visitor visitor) {
            try {
                visitor.visit(this);
            }
            catch (Exception e) {
                visitor.handleException(e, this);
            }
        }

        @Override public void visitChildren(Visitor visitor) {
            walkOrOp(visitor, this);
        }

    }

    public static abstract class BitwiseOp extends BinaryOperatorExpression {

        public BitwiseOp(Token token) {
            super(token);
        }

        @Override public void visit(Visitor visitor) {
            try {
                visitor.visit(this);
            }
            catch (Exception e) {
                visitor.handleException(e, this);
            }
        }

        @Override public void visitChildren(Visitor visitor) {
            walkBitwiseOp(visitor, this);
        }

    }

    public static class IntersectionOp extends BitwiseOp {

        public IntersectionOp(Token token) {
            super(token);
        }

        @Override public void visit(Visitor visitor) {
            try {
                visitor.visit(this);
            }
            catch (Exception e) {
                visitor.handleException(e, this);
            }
        }

        @Override public void visitChildren(Visitor visitor) {
            walkIntersectionOp(visitor, this);
        }

    }

    public static class UnionOp extends BitwiseOp {

        public UnionOp(Token token) {
            super(token);
        }

        @Override public void visit(Visitor visitor) {
            try {
                visitor.visit(this);
            }
            catch (Exception e) {
                visitor.handleException(e, this);
            }
        }

        @Override public void visitChildren(Visitor visitor) {
            walkUnionOp(visitor, this);
        }

    }

    public static class ComplementOp extends BitwiseOp {

        public ComplementOp(Token token) {
            super(token);
        }

        @Override public void visit(Visitor visitor) {
            try {
                visitor.visit(this);
            }
            catch (Exception e) {
                visitor.handleException(e, this);
            }
        }

        @Override public void visitChildren(Visitor visitor) {
            walkComplementOp(visitor, this);
        }

    }

    public static abstract class EqualityOp extends BinaryOperatorExpression {

        public EqualityOp(Token token) {
            super(token);
        }

        @Override public void visit(Visitor visitor) {
            try {
                visitor.visit(this);
            }
            catch (Exception e) {
                visitor.handleException(e, this);
            }
        }

        @Override public void visitChildren(Visitor visitor) {
            walkEqualityOp(visitor, this);
        }

    }

    public static class EqualOp extends EqualityOp {

        public EqualOp(Token token) {
            super(token);
        }

        @Override public void visit(Visitor visitor) {
            try {
                visitor.visit(this);
            }
            catch (Exception e) {
                visitor.handleException(e, this);
            }
        }

        @Override public void visitChildren(Visitor visitor) {
            walkEqualOp(visitor, this);
        }

    }

    public static class NotEqualOp extends EqualityOp {

        public NotEqualOp(Token token) {
            super(token);
        }

        @Override public void visit(Visitor visitor) {
            try {
                visitor.visit(this);
            }
            catch (Exception e) {
                visitor.handleException(e, this);
            }
        }

        @Override public void visitChildren(Visitor visitor) {
            walkNotEqualOp(visitor, this);
        }

    }

    public static abstract class ComparisonOp extends BinaryOperatorExpression {

        public ComparisonOp(Token token) {
            super(token);
        }

        @Override public void visit(Visitor visitor) {
            try {
                visitor.visit(this);
            }
            catch (Exception e) {
                visitor.handleException(e, this);
            }
        }

        @Override public void visitChildren(Visitor visitor) {
            walkComparisonOp(visitor, this);
        }

    }

    public static class LargerOp extends ComparisonOp {

        public LargerOp(Token token) {
            super(token);
        }

        @Override public void visit(Visitor visitor) {
            try {
                visitor.visit(this);
            }
            catch (Exception e) {
                visitor.handleException(e, this);
            }
        }

        @Override public void visitChildren(Visitor visitor) {
            walkLargerOp(visitor, this);
        }

    }

    public static class SmallerOp extends ComparisonOp {

        public SmallerOp(Token token) {
            super(token);
        }

        @Override public void visit(Visitor visitor) {
            try {
                visitor.visit(this);
            }
            catch (Exception e) {
                visitor.handleException(e, this);
            }
        }

        @Override public void visitChildren(Visitor visitor) {
            walkSmallerOp(visitor, this);
        }

    }

    public static class LargeAsOp extends ComparisonOp {

        public LargeAsOp(Token token) {
            super(token);
        }

        @Override public void visit(Visitor visitor) {
            try {
                visitor.visit(this);
            }
            catch (Exception e) {
                visitor.handleException(e, this);
            }
        }

        @Override public void visitChildren(Visitor visitor) {
            walkLargeAsOp(visitor, this);
        }

    }

    public static class SmallAsOp extends ComparisonOp {

        public SmallAsOp(Token token) {
            super(token);
        }

        @Override public void visit(Visitor visitor) {
            try {
                visitor.visit(this);
            }
            catch (Exception e) {
                visitor.handleException(e, this);
            }
        }

        @Override public void visitChildren(Visitor visitor) {
            walkSmallAsOp(visitor, this);
        }

    }

    public static class ScaleOp extends BinaryOperatorExpression {

        public ScaleOp(Token token) {
            super(token);
        }

        @Override public void visit(Visitor visitor) {
            try {
                visitor.visit(this);
            }
            catch (Exception e) {
                visitor.handleException(e, this);
            }
        }

        @Override public void visitChildren(Visitor visitor) {
            walkScaleOp(visitor, this);
        }

    }

    public static abstract class Bound extends Term {

        public Bound(Token token) {
            super(token);
        }

        @Override public void visit(Visitor visitor) {
            try {
                visitor.visit(this);
            }
            catch (Exception e) {
                visitor.handleException(e, this);
            }
        }

        @Override public void visitChildren(Visitor visitor) {
            walkBound(visitor, this);
        }

        private Term term;
        public Term getTerm() { return term; }
        public void setTerm(Term node) { term = node; connect(node); }

    }

    public static class OpenBound extends Bound {

        public OpenBound(Token token) {
            super(token);
        }

        @Override public void visit(Visitor visitor) {
            try {
                visitor.visit(this);
            }
            catch (Exception e) {
                visitor.handleException(e, this);
            }
        }

        @Override public void visitChildren(Visitor visitor) {
            walkOpenBound(visitor, this);
        }

    }

    public static class ClosedBound extends Bound {

        public ClosedBound(Token token) {
            super(token);
        }

        @Override public void visit(Visitor visitor) {
            try {
                visitor.visit(this);
            }
            catch (Exception e) {
                visitor.handleException(e, this);
            }
        }

        @Override public void visitChildren(Visitor visitor) {
            walkClosedBound(visitor, this);
        }

    }

    public static class WithinOp extends OperatorExpression {

        public WithinOp(Token token) {
            super(token);
        }

        @Override public void visit(Visitor visitor) {
            try {
                visitor.visit(this);
            }
            catch (Exception e) {
                visitor.handleException(e, this);
            }
        }

        @Override public void visitChildren(Visitor visitor) {
            walkWithinOp(visitor, this);
        }

        private Bound upperBound;
        public Bound getUpperBound() { return upperBound; }
        public void setUpperBound(Bound node) { upperBound = node; connect(node); }

        private Bound lowerBound;
        public Bound getLowerBound() { return lowerBound; }
        public void setLowerBound(Bound node) { lowerBound = node; connect(node); }

        private Term term;
        public Term getTerm() { return term; }
        public void setTerm(Term node) { term = node; connect(node); }

    }

    public static class DefaultOp extends BinaryOperatorExpression {

        public DefaultOp(Token token) {
            super(token);
        }

        @Override public void visit(Visitor visitor) {
            try {
                visitor.visit(this);
            }
            catch (Exception e) {
                visitor.handleException(e, this);
            }
        }

        @Override public void visitChildren(Visitor visitor) {
            walkDefaultOp(visitor, this);
        }

    }

    public static class ThenOp extends BinaryOperatorExpression {

        public ThenOp(Token token) {
            super(token);
        }

        @Override public void visit(Visitor visitor) {
            try {
                visitor.visit(this);
            }
            catch (Exception e) {
                visitor.handleException(e, this);
            }
        }

        @Override public void visitChildren(Visitor visitor) {
            walkThenOp(visitor, this);
        }

    }

    public static class IdenticalOp extends BinaryOperatorExpression {

        public IdenticalOp(Token token) {
            super(token);
        }

        @Override public void visit(Visitor visitor) {
            try {
                visitor.visit(this);
            }
            catch (Exception e) {
                visitor.handleException(e, this);
            }
        }

        @Override public void visitChildren(Visitor visitor) {
            walkIdenticalOp(visitor, this);
        }

    }

    public static class EntryOp extends BinaryOperatorExpression {

        public EntryOp(Token token) {
            super(token);
        }

        @Override public void visit(Visitor visitor) {
            try {
                visitor.visit(this);
            }
            catch (Exception e) {
                visitor.handleException(e, this);
            }
        }

        @Override public void visitChildren(Visitor visitor) {
            walkEntryOp(visitor, this);
        }

    }

    public static class RangeOp extends BinaryOperatorExpression {

        public RangeOp(Token token) {
            super(token);
        }

        @Override public void visit(Visitor visitor) {
            try {
                visitor.visit(this);
            }
            catch (Exception e) {
                visitor.handleException(e, this);
            }
        }

        @Override public void visitChildren(Visitor visitor) {
            walkRangeOp(visitor, this);
        }

    }

    public static class SegmentOp extends BinaryOperatorExpression {

        public SegmentOp(Token token) {
            super(token);
        }

        @Override public void visit(Visitor visitor) {
            try {
                visitor.visit(this);
            }
            catch (Exception e) {
                visitor.handleException(e, this);
            }
        }

        @Override public void visitChildren(Visitor visitor) {
            walkSegmentOp(visitor, this);
        }

    }

    public static class CompareOp extends BinaryOperatorExpression {

        public CompareOp(Token token) {
            super(token);
        }

        @Override public void visit(Visitor visitor) {
            try {
                visitor.visit(this);
            }
            catch (Exception e) {
                visitor.handleException(e, this);
            }
        }

        @Override public void visitChildren(Visitor visitor) {
            walkCompareOp(visitor, this);
        }

    }

    public static class InOp extends BinaryOperatorExpression {

        public InOp(Token token) {
            super(token);
        }

        @Override public void visit(Visitor visitor) {
            try {
                visitor.visit(this);
            }
            catch (Exception e) {
                visitor.handleException(e, this);
            }
        }

        @Override public void visitChildren(Visitor visitor) {
            walkInOp(visitor, this);
        }

    }

    public static abstract class UnaryOperatorExpression extends OperatorExpression {

        public UnaryOperatorExpression(Token token) {
            super(token);
        }

        @Override public void visit(Visitor visitor) {
            try {
                visitor.visit(this);
            }
            catch (Exception e) {
                visitor.handleException(e, this);
            }
        }

        @Override public void visitChildren(Visitor visitor) {
            walkUnaryOperatorExpression(visitor, this);
        }

        private Term term;
        public Term getTerm() { return term; }
        public void setTerm(Term node) { term = node; connect(node); }

    }

    public static class NotOp extends UnaryOperatorExpression {

        public NotOp(Token token) {
            super(token);
        }

        @Override public void visit(Visitor visitor) {
            try {
                visitor.visit(this);
            }
            catch (Exception e) {
                visitor.handleException(e, this);
            }
        }

        @Override public void visitChildren(Visitor visitor) {
            walkNotOp(visitor, this);
        }

    }

    public static class Exists extends UnaryOperatorExpression {

        public Exists(Token token) {
            super(token);
        }

        @Override public void visit(Visitor visitor) {
            try {
                visitor.visit(this);
            }
            catch (Exception e) {
                visitor.handleException(e, this);
            }
        }

        @Override public void visitChildren(Visitor visitor) {
            walkExists(visitor, this);
        }

    }

    public static class Nonempty extends UnaryOperatorExpression {

        public Nonempty(Token token) {
            super(token);
        }

        @Override public void visit(Visitor visitor) {
            try {
                visitor.visit(this);
            }
            catch (Exception e) {
                visitor.handleException(e, this);
            }
        }

        @Override public void visitChildren(Visitor visitor) {
            walkNonempty(visitor, this);
        }

    }

    public static class NegativeOp extends UnaryOperatorExpression {

        public NegativeOp(Token token) {
            super(token);
        }

        @Override public void visit(Visitor visitor) {
            try {
                visitor.visit(this);
            }
            catch (Exception e) {
                visitor.handleException(e, this);
            }
        }

        @Override public void visitChildren(Visitor visitor) {
            walkNegativeOp(visitor, this);
        }

    }

    public static class PositiveOp extends UnaryOperatorExpression {

        public PositiveOp(Token token) {
            super(token);
        }

        @Override public void visit(Visitor visitor) {
            try {
                visitor.visit(this);
            }
            catch (Exception e) {
                visitor.handleException(e, this);
            }
        }

        @Override public void visitChildren(Visitor visitor) {
            walkPositiveOp(visitor, this);
        }

    }

    public static abstract class TypeOperatorExpression extends UnaryOperatorExpression {

        public TypeOperatorExpression(Token token) {
            super(token);
        }

        @Override public void visit(Visitor visitor) {
            try {
                visitor.visit(this);
            }
            catch (Exception e) {
                visitor.handleException(e, this);
            }
        }

        @Override public void visitChildren(Visitor visitor) {
            walkTypeOperatorExpression(visitor, this);
        }

        private Type type;
        public Type getType() { return type; }
        public void setType(Type node) { type = node; connect(node); }

    }

    public static class IsOp extends TypeOperatorExpression {

        public IsOp(Token token) {
            super(token);
        }

        @Override public void visit(Visitor visitor) {
            try {
                visitor.visit(this);
            }
            catch (Exception e) {
                visitor.handleException(e, this);
            }
        }

        @Override public void visitChildren(Visitor visitor) {
            walkIsOp(visitor, this);
        }

    }

    public static class Satisfies extends TypeOperatorExpression {

        public Satisfies(Token token) {
            super(token);
        }

        @Override public void visit(Visitor visitor) {
            try {
                visitor.visit(this);
            }
            catch (Exception e) {
                visitor.handleException(e, this);
            }
        }

        @Override public void visitChildren(Visitor visitor) {
            walkSatisfies(visitor, this);
        }

    }

    public static class Extends extends TypeOperatorExpression {

        public Extends(Token token) {
            super(token);
        }

        @Override public void visit(Visitor visitor) {
            try {
                visitor.visit(this);
            }
            catch (Exception e) {
                visitor.handleException(e, this);
            }
        }

        @Override public void visitChildren(Visitor visitor) {
            walkExtends(visitor, this);
        }

    }

    public static class OfOp extends TypeOperatorExpression {

        public OfOp(Token token) {
            super(token);
        }

        @Override public void visit(Visitor visitor) {
            try {
                visitor.visit(this);
            }
            catch (Exception e) {
                visitor.handleException(e, this);
            }
        }

        @Override public void visitChildren(Visitor visitor) {
            walkOfOp(visitor, this);
        }

    }

    public static abstract class PrefixOperatorExpression extends UnaryOperatorExpression {

        public PrefixOperatorExpression(Token token) {
            super(token);
        }

        @Override public void visit(Visitor visitor) {
            try {
                visitor.visit(this);
            }
            catch (Exception e) {
                visitor.handleException(e, this);
            }
        }

        @Override public void visitChildren(Visitor visitor) {
            walkPrefixOperatorExpression(visitor, this);
        }

    }

    public static class IncrementOp extends PrefixOperatorExpression {

        public IncrementOp(Token token) {
            super(token);
        }

        @Override public void visit(Visitor visitor) {
            try {
                visitor.visit(this);
            }
            catch (Exception e) {
                visitor.handleException(e, this);
            }
        }

        @Override public void visitChildren(Visitor visitor) {
            walkIncrementOp(visitor, this);
        }

    }

    public static class DecrementOp extends PrefixOperatorExpression {

        public DecrementOp(Token token) {
            super(token);
        }

        @Override public void visit(Visitor visitor) {
            try {
                visitor.visit(this);
            }
            catch (Exception e) {
                visitor.handleException(e, this);
            }
        }

        @Override public void visitChildren(Visitor visitor) {
            walkDecrementOp(visitor, this);
        }

    }

    /**
     * A postfix increment or decrement expression.
     */
    public static abstract class PostfixOperatorExpression extends UnaryOperatorExpression {

        public PostfixOperatorExpression(Token token) {
            super(token);
        }

        @Override public void visit(Visitor visitor) {
            try {
                visitor.visit(this);
            }
            catch (Exception e) {
                visitor.handleException(e, this);
            }
        }

        @Override public void visitChildren(Visitor visitor) {
            walkPostfixOperatorExpression(visitor, this);
        }

    }

    public static class PostfixIncrementOp extends PostfixOperatorExpression {

        public PostfixIncrementOp(Token token) {
            super(token);
        }

        @Override public void visit(Visitor visitor) {
            try {
                visitor.visit(this);
            }
            catch (Exception e) {
                visitor.handleException(e, this);
            }
        }

        @Override public void visitChildren(Visitor visitor) {
            walkPostfixIncrementOp(visitor, this);
        }

    }

    public static class PostfixDecrementOp extends PostfixOperatorExpression {

        public PostfixDecrementOp(Token token) {
            super(token);
        }

        @Override public void visit(Visitor visitor) {
            try {
                visitor.visit(this);
            }
            catch (Exception e) {
                visitor.handleException(e, this);
            }
        }

        @Override public void visitChildren(Visitor visitor) {
            walkPostfixDecrementOp(visitor, this);
        }

    }

    /**
     * A parenthesized list of expressions.
     */
    public static class ExpressionList extends Node {

        public ExpressionList(Token token) {
            super(token);
        }

        @Override public void visit(Visitor visitor) {
            try {
                visitor.visit(this);
            }
            catch (Exception e) {
                visitor.handleException(e, this);
            }
        }

        @Override public void visitChildren(Visitor visitor) {
            walkExpressionList(visitor, this);
        }

        private List<Expression> expressions = new ArrayList<Expression>(3);
        public List<Expression> getExpressions() { return expressions; }
        public void addExpression(Expression node) { expressions.add(node); connect(node); }

    }

    /**
     * An expression.
     */
    public static class Expression extends Atom {

        public Expression(Token token) {
            super(token);
        }

        @Override public void visit(Visitor visitor) {
            try {
                visitor.visit(this);
            }
            catch (Exception e) {
                visitor.handleException(e, this);
            }
        }

        @Override public void visitChildren(Visitor visitor) {
            walkExpression(visitor, this);
        }

        private Term term;
        public Term getTerm() { return term; }
        public void setTerm(Term node) { term = node; connect(node); }

    }

    /**
     * An parenthesized expression.
     */
    public static class ParExpression extends Expression {

        public ParExpression(Token token) {
            super(token);
        }

        @Override public void visit(Visitor visitor) {
            try {
                visitor.visit(this);
            }
            catch (Exception e) {
                visitor.handleException(e, this);
            }
        }

        @Override public void visitChildren(Visitor visitor) {
            walkParExpression(visitor, this);
        }

    }

    /**
     * The receiver of a member reference or invocation expression.
     */
    public static abstract class Primary extends Term {

        public Primary(Token token) {
            super(token);
        }

        @Override public void visit(Visitor visitor) {
            try {
                visitor.visit(this);
            }
            catch (Exception e) {
                visitor.handleException(e, this);
            }
        }

        @Override public void visitChildren(Visitor visitor) {
            walkPrimary(visitor, this);
        }

    }

    public static abstract class PostfixExpression extends Primary {

        public PostfixExpression(Token token) {
            super(token);
        }

        @Override public void visit(Visitor visitor) {
            try {
                visitor.visit(this);
            }
            catch (Exception e) {
                visitor.handleException(e, this);
            }
        }

        @Override public void visitChildren(Visitor visitor) {
            walkPostfixExpression(visitor, this);
        }

        private Primary primary;
        public Primary getPrimary() { return primary; }
        public void setPrimary(Primary node) { primary = node; connect(node); }

    }

    /**
     * An invocation expression.
     */
    public static class InvocationExpression extends PostfixExpression {

        public InvocationExpression(Token token) {
            super(token);
        }

        @Override public void visit(Visitor visitor) {
            try {
                visitor.visit(this);
            }
            catch (Exception e) {
                visitor.handleException(e, this);
            }
        }

        @Override public void visitChildren(Visitor visitor) {
            walkInvocationExpression(visitor, this);
        }

        private PositionalArgumentList positionalArgumentList;
        public PositionalArgumentList getPositionalArgumentList() { return positionalArgumentList; }
        public void setPositionalArgumentList(PositionalArgumentList node) { positionalArgumentList = node; connect(node); }

        private NamedArgumentList namedArgumentList;
        public NamedArgumentList getNamedArgumentList() { return namedArgumentList; }
        public void setNamedArgumentList(NamedArgumentList node) { namedArgumentList = node; connect(node); }

    }

    public static class ParameterizedExpression extends Primary {

        public ParameterizedExpression(Token token) {
            super(token);
        }

        @Override public void visit(Visitor visitor) {
            try {
                visitor.visit(this);
            }
            catch (Exception e) {
                visitor.handleException(e, this);
            }
        }

        @Override public void visitChildren(Visitor visitor) {
            walkParameterizedExpression(visitor, this);
        }

        private Primary primary;
        public Primary getPrimary() { return primary; }
        public void setPrimary(Primary node) { primary = node; connect(node); }

        private TypeParameterList typeParameterList;
        public TypeParameterList getTypeParameterList() { return typeParameterList; }
        public void setTypeParameterList(TypeParameterList node) { typeParameterList = node; connect(node); }

        private List<ParameterList> parameterLists = new ArrayList<ParameterList>(3);
        public List<ParameterList> getParameterLists() { return parameterLists; }
        public void addParameterList(ParameterList node) { parameterLists.add(node); connect(node); }

        private boolean leftTerm;
        public boolean getLeftTerm() { return leftTerm; }
        public void setLeftTerm(boolean value) { leftTerm = value; }

    }

    public static abstract class MemberOrTypeExpression extends Primary {

        public MemberOrTypeExpression(Token token) {
            super(token);
        }

        @Override public void visit(Visitor visitor) {
            try {
                visitor.visit(this);
            }
            catch (Exception e) {
                visitor.handleException(e, this);
            }
        }

        @Override public void visitChildren(Visitor visitor) {
            walkMemberOrTypeExpression(visitor, this);
        }

        private com.redhat.ceylon.model.typechecker.model.Reference target;
        public com.redhat.ceylon.model.typechecker.model.Reference getTarget() { return target; }
        public void setTarget(com.redhat.ceylon.model.typechecker.model.Reference value) { target = value; }

        private com.redhat.ceylon.model.typechecker.model.Declaration declaration;
        public com.redhat.ceylon.model.typechecker.model.Declaration getDeclaration() { return declaration; }
        public void setDeclaration(com.redhat.ceylon.model.typechecker.model.Declaration value) { declaration = value; }

        private List<com.redhat.ceylon.model.typechecker.model.Type> signature;
        public List<com.redhat.ceylon.model.typechecker.model.Type> getSignature() { return signature; }
        public void setSignature(List<com.redhat.ceylon.model.typechecker.model.Type> value) { signature = value; }

        private boolean ellipsis;
        public boolean getEllipsis() { return ellipsis; }
        public void setEllipsis(boolean value) { ellipsis = value; }

        private boolean directlyInvoked;
        public boolean getDirectlyInvoked() { return directlyInvoked; }
        public void setDirectlyInvoked(boolean value) { directlyInvoked = value; }

        private boolean indirectlyInvoked;
        public boolean getIndirectlyInvoked() { return indirectlyInvoked; }
        public void setIndirectlyInvoked(boolean value) { indirectlyInvoked = value; }

        private boolean assigned;
        public boolean getAssigned() { return assigned; }
        public void setAssigned(boolean value) { assigned = value; }

        private boolean staticMethodReference;
        public boolean getStaticMethodReference() { return staticMethodReference; }
        public void setStaticMethodReference(boolean value) { staticMethodReference = value; }

        private boolean staticMethodReferencePrimary;
        public boolean getStaticMethodReferencePrimary() { return staticMethodReferencePrimary; }
        public void setStaticMethodReferencePrimary(boolean value) { staticMethodReferencePrimary = value; }

    }

    public static class ExtendedTypeExpression extends MemberOrTypeExpression {

        public ExtendedTypeExpression(Token token) {
            super(token);
        }

        @Override public void visit(Visitor visitor) {
            try {
                visitor.visit(this);
            }
            catch (Exception e) {
                visitor.handleException(e, this);
            }
        }

        @Override public void visitChildren(Visitor visitor) {
            walkExtendedTypeExpression(visitor, this);
        }

    }

    public static abstract class StaticMemberOrTypeExpression extends MemberOrTypeExpression {

        public StaticMemberOrTypeExpression(Token token) {
            super(token);
        }

        @Override public void visit(Visitor visitor) {
            try {
                visitor.visit(this);
            }
            catch (Exception e) {
                visitor.handleException(e, this);
            }
        }

        @Override public void visitChildren(Visitor visitor) {
            walkStaticMemberOrTypeExpression(visitor, this);
        }

        private Identifier identifier;
        public Identifier getIdentifier() { return identifier; }
        public void setIdentifier(Identifier node) { identifier = node; connect(node); }

        private TypeArguments typeArguments;
        public TypeArguments getTypeArguments() { return typeArguments; }
        public void setTypeArguments(TypeArguments node) { typeArguments = node; connect(node); }

        private com.redhat.ceylon.model.typechecker.model.TypedReference targetParameter;
        public com.redhat.ceylon.model.typechecker.model.TypedReference getTargetParameter() { return targetParameter; }
        public void setTargetParameter(com.redhat.ceylon.model.typechecker.model.TypedReference value) { targetParameter = value; }

        private com.redhat.ceylon.model.typechecker.model.Type parameterType;
        public com.redhat.ceylon.model.typechecker.model.Type getParameterType() { return parameterType; }
        public void setParameterType(com.redhat.ceylon.model.typechecker.model.Type value) { parameterType = value; }

    }

    public static abstract class BaseMemberOrTypeExpression extends StaticMemberOrTypeExpression {

        public BaseMemberOrTypeExpression(Token token) {
            super(token);
        }

        @Override public void visit(Visitor visitor) {
            try {
                visitor.visit(this);
            }
            catch (Exception e) {
                visitor.handleException(e, this);
            }
        }

        @Override public void visitChildren(Visitor visitor) {
            walkBaseMemberOrTypeExpression(visitor, this);
        }

    }

    /**
     * A reference to a member in an expression.
     */
    public static class BaseMemberExpression extends BaseMemberOrTypeExpression {

        public BaseMemberExpression(Token token) {
            super(token);
        }

        @Override public void visit(Visitor visitor) {
            try {
                visitor.visit(this);
            }
            catch (Exception e) {
                visitor.handleException(e, this);
            }
        }

        @Override public void visitChildren(Visitor visitor) {
            walkBaseMemberExpression(visitor, this);
        }

    }

    /**
     * A reference to a type in an expression.
     */
    public static class BaseTypeExpression extends BaseMemberOrTypeExpression {

        public BaseTypeExpression(Token token) {
            super(token);
        }

        @Override public void visit(Visitor visitor) {
            try {
                visitor.visit(this);
            }
            catch (Exception e) {
                visitor.handleException(e, this);
            }
        }

        @Override public void visitChildren(Visitor visitor) {
            walkBaseTypeExpression(visitor, this);
        }

    }

    public static abstract class QualifiedMemberOrTypeExpression extends StaticMemberOrTypeExpression {

        public QualifiedMemberOrTypeExpression(Token token) {
            super(token);
        }

        @Override public void visit(Visitor visitor) {
            try {
                visitor.visit(this);
            }
            catch (Exception e) {
                visitor.handleException(e, this);
            }
        }

        @Override public void visitChildren(Visitor visitor) {
            walkQualifiedMemberOrTypeExpression(visitor, this);
        }

        private Primary primary;
        public Primary getPrimary() { return primary; }
        public void setPrimary(Primary node) { primary = node; connect(node); }

        private MemberOperator memberOperator;
        public MemberOperator getMemberOperator() { return memberOperator; }
        public void setMemberOperator(MemberOperator node) { memberOperator = node; connect(node); }

    }

    /**
     * A qualified member reference expression.
     */
    public static class QualifiedMemberExpression extends QualifiedMemberOrTypeExpression {

        public QualifiedMemberExpression(Token token) {
            super(token);
        }

        @Override public void visit(Visitor visitor) {
            try {
                visitor.visit(this);
            }
            catch (Exception e) {
                visitor.handleException(e, this);
            }
        }

        @Override public void visitChildren(Visitor visitor) {
            walkQualifiedMemberExpression(visitor, this);
        }

    }

    /**
     * A qualified member type reference expression.
     */
    public static class QualifiedTypeExpression extends QualifiedMemberOrTypeExpression {

        public QualifiedTypeExpression(Token token) {
            super(token);
        }

        @Override public void visit(Visitor visitor) {
            try {
                visitor.visit(this);
            }
            catch (Exception e) {
                visitor.handleException(e, this);
            }
        }

        @Override public void visitChildren(Visitor visitor) {
            walkQualifiedTypeExpression(visitor, this);
        }

    }

    public static abstract class MemberOperator extends Node {

        public MemberOperator(Token token) {
            super(token);
        }

        @Override public void visit(Visitor visitor) {
            try {
                visitor.visit(this);
            }
            catch (Exception e) {
                visitor.handleException(e, this);
            }
        }

        @Override public void visitChildren(Visitor visitor) {
            walkMemberOperator(visitor, this);
        }

    }

    public static class MemberOp extends MemberOperator {

        public MemberOp(Token token) {
            super(token);
        }

        @Override public void visit(Visitor visitor) {
            try {
                visitor.visit(this);
            }
            catch (Exception e) {
                visitor.handleException(e, this);
            }
        }

        @Override public void visitChildren(Visitor visitor) {
            walkMemberOp(visitor, this);
        }

    }

    public static class SafeMemberOp extends MemberOperator {

        public SafeMemberOp(Token token) {
            super(token);
        }

        @Override public void visit(Visitor visitor) {
            try {
                visitor.visit(this);
            }
            catch (Exception e) {
                visitor.handleException(e, this);
            }
        }

        @Override public void visitChildren(Visitor visitor) {
            walkSafeMemberOp(visitor, this);
        }

    }

    public static class SpreadOp extends MemberOperator {

        public SpreadOp(Token token) {
            super(token);
        }

        @Override public void visit(Visitor visitor) {
            try {
                visitor.visit(this);
            }
            catch (Exception e) {
                visitor.handleException(e, this);
            }
        }

        @Override public void visitChildren(Visitor visitor) {
            walkSpreadOp(visitor, this);
        }

    }

    /**
     * An index (element access by key) expression.
     */
    public static class IndexExpression extends PostfixExpression {

        public IndexExpression(Token token) {
            super(token);
        }

        @Override public void visit(Visitor visitor) {
            try {
                visitor.visit(this);
            }
            catch (Exception e) {
                visitor.handleException(e, this);
            }
        }

        @Override public void visitChildren(Visitor visitor) {
            walkIndexExpression(visitor, this);
        }

        private ElementOrRange elementOrRange;
        public ElementOrRange getElementOrRange() { return elementOrRange; }
        public void setElementOrRange(ElementOrRange node) { elementOrRange = node; connect(node); }

        private boolean assigned;
        public boolean getAssigned() { return assigned; }
        public void setAssigned(boolean value) { assigned = value; }

    }

    /**
     * An element index or element range.
     */
    public static abstract class ElementOrRange extends Node {

        public ElementOrRange(Token token) {
            super(token);
        }

        @Override public void visit(Visitor visitor) {
            try {
                visitor.visit(this);
            }
            catch (Exception e) {
                visitor.handleException(e, this);
            }
        }

        @Override public void visitChildren(Visitor visitor) {
            walkElementOrRange(visitor, this);
        }

    }

    /**
     * An element index.
     */
    public static class Element extends ElementOrRange {

        public Element(Token token) {
            super(token);
        }

        @Override public void visit(Visitor visitor) {
            try {
                visitor.visit(this);
            }
            catch (Exception e) {
                visitor.handleException(e, this);
            }
        }

        @Override public void visitChildren(Visitor visitor) {
            walkElement(visitor, this);
        }

        private Expression expression;
        public Expression getExpression() { return expression; }
        public void setExpression(Expression node) { expression = node; connect(node); }

    }

    /**
     * An element range.
     */
    public static class ElementRange extends ElementOrRange {

        public ElementRange(Token token) {
            super(token);
        }

        @Override public void visit(Visitor visitor) {
            try {
                visitor.visit(this);
            }
            catch (Exception e) {
                visitor.handleException(e, this);
            }
        }

        @Override public void visitChildren(Visitor visitor) {
            walkElementRange(visitor, this);
        }

        private Expression lowerBound;
        public Expression getLowerBound() { return lowerBound; }
        public void setLowerBound(Expression node) { lowerBound = node; connect(node); }

        private Expression upperBound;
        public Expression getUpperBound() { return upperBound; }
        public void setUpperBound(Expression node) { upperBound = node; connect(node); }

        private Expression length;
        public Expression getLength() { return length; }
        public void setLength(Expression node) { length = node; connect(node); }

    }

    /**
     * A reference to the outer containing instance.
     */
    public static class Outer extends Atom {

        public Outer(Token token) {
            super(token);
        }

        @Override public void visit(Visitor visitor) {
            try {
                visitor.visit(this);
            }
            catch (Exception e) {
                visitor.handleException(e, this);
            }
        }

        @Override public void visitChildren(Visitor visitor) {
            walkOuter(visitor, this);
        }

        private com.redhat.ceylon.model.typechecker.model.TypeDeclaration declarationModel;
        public com.redhat.ceylon.model.typechecker.model.TypeDeclaration getDeclarationModel() { return declarationModel; }
        public void setDeclarationModel(com.redhat.ceylon.model.typechecker.model.TypeDeclaration value) { declarationModel = value; }

    }

    /**
     * A reference to the containing package.
     */
    public static class Package extends Atom {

        public Package(Token token) {
            super(token);
        }

        @Override public void visit(Visitor visitor) {
            try {
                visitor.visit(this);
            }
            catch (Exception e) {
                visitor.handleException(e, this);
            }
        }

        @Override public void visitChildren(Visitor visitor) {
            walkPackage(visitor, this);
        }

        private boolean qualifier;
        public boolean getQualifier() { return qualifier; }
        public void setQualifier(boolean value) { qualifier = value; }

    }

    /**
     * A list of arguments in an invocation expression.
     */
    public static abstract class ArgumentList extends Node {

        public ArgumentList(Token token) {
            super(token);
        }

        @Override public void visit(Visitor visitor) {
            try {
                visitor.visit(this);
            }
            catch (Exception e) {
                visitor.handleException(e, this);
            }
        }

        @Override public void visitChildren(Visitor visitor) {
            walkArgumentList(visitor, this);
        }

    }

    /**
     * A list of named arguments.
     */
    public static class NamedArgumentList extends ArgumentList {

        public NamedArgumentList(Token token) {
            super(token);
        }

        @Override public void visit(Visitor visitor) {
            try {
                visitor.visit(this);
            }
            catch (Exception e) {
                visitor.handleException(e, this);
            }
        }

        @Override public void visitChildren(Visitor visitor) {
            walkNamedArgumentList(visitor, this);
        }

        private List<NamedArgument> namedArguments = new ArrayList<NamedArgument>(3);
        public List<NamedArgument> getNamedArguments() { return namedArguments; }
        public void addNamedArgument(NamedArgument node) { namedArguments.add(node); connect(node); }

        private SequencedArgument sequencedArgument;
        public SequencedArgument getSequencedArgument() { return sequencedArgument; }
        public void setSequencedArgument(SequencedArgument node) { sequencedArgument = node; connect(node); }

        private com.redhat.ceylon.model.typechecker.model.NamedArgumentList namedArgumentList;
        public com.redhat.ceylon.model.typechecker.model.NamedArgumentList getNamedArgumentList() { return namedArgumentList; }
        public void setNamedArgumentList(com.redhat.ceylon.model.typechecker.model.NamedArgumentList value) { namedArgumentList = value; }

    }

    /**
     * A comma-separated lost of arguments, possibly including a comprehension or spread argument.
     */
    public static class SequencedArgument extends StatementOrArgument {

        public SequencedArgument(Token token) {
            super(token);
        }

        @Override public void visit(Visitor visitor) {
            try {
                visitor.visit(this);
            }
            catch (Exception e) {
                visitor.handleException(e, this);
            }
        }

        @Override public void visitChildren(Visitor visitor) {
            walkSequencedArgument(visitor, this);
        }

        private List<PositionalArgument> positionalArguments = new ArrayList<PositionalArgument>(3);
        public List<PositionalArgument> getPositionalArguments() { return positionalArguments; }
        public void addPositionalArgument(PositionalArgument node) { positionalArguments.add(node); connect(node); }

        private com.redhat.ceylon.model.typechecker.model.Parameter parameter;
        public com.redhat.ceylon.model.typechecker.model.Parameter getParameter() { return parameter; }
        public void setParameter(com.redhat.ceylon.model.typechecker.model.Parameter value) { parameter = value; }

    }

    /**
     * A list of positional arguments.
     */
    public static class PositionalArgumentList extends ArgumentList {

        public PositionalArgumentList(Token token) {
            super(token);
        }

        @Override public void visit(Visitor visitor) {
            try {
                visitor.visit(this);
            }
            catch (Exception e) {
                visitor.handleException(e, this);
            }
        }

        @Override public void visitChildren(Visitor visitor) {
            walkPositionalArgumentList(visitor, this);
        }

        private List<PositionalArgument> positionalArguments = new ArrayList<PositionalArgument>(3);
        public List<PositionalArgument> getPositionalArguments() { return positionalArguments; }
        public void addPositionalArgument(PositionalArgument node) { positionalArguments.add(node); connect(node); }

    }

    /**
     * A single listed argument, spread argument or comprehension.
     */
    public static abstract class PositionalArgument extends Node {

        public PositionalArgument(Token token) {
            super(token);
        }

        @Override public void visit(Visitor visitor) {
            try {
                visitor.visit(this);
            }
            catch (Exception e) {
                visitor.handleException(e, this);
            }
        }

        @Override public void visitChildren(Visitor visitor) {
            walkPositionalArgument(visitor, this);
        }

        private com.redhat.ceylon.model.typechecker.model.Type typeModel;
        public com.redhat.ceylon.model.typechecker.model.Type getTypeModel() { return typeModel; }
        public void setTypeModel(com.redhat.ceylon.model.typechecker.model.Type value) { typeModel = value; }

        private com.redhat.ceylon.model.typechecker.model.Parameter parameter;
        public com.redhat.ceylon.model.typechecker.model.Parameter getParameter() { return parameter; }
        public void setParameter(com.redhat.ceylon.model.typechecker.model.Parameter value) { parameter = value; }

    }

    /**
     * A single listed argument.
     */
    public static class ListedArgument extends PositionalArgument {

        public ListedArgument(Token token) {
            super(token);
        }

        @Override public void visit(Visitor visitor) {
            try {
                visitor.visit(this);
            }
            catch (Exception e) {
                visitor.handleException(e, this);
            }
        }

        @Override public void visitChildren(Visitor visitor) {
            walkListedArgument(visitor, this);
        }

        private Expression expression;
        public Expression getExpression() { return expression; }
        public void setExpression(Expression node) { expression = node; connect(node); }

    }

    /**
     * A spread argument.
     */
    public static class SpreadArgument extends PositionalArgument {

        public SpreadArgument(Token token) {
            super(token);
        }

        @Override public void visit(Visitor visitor) {
            try {
                visitor.visit(this);
            }
            catch (Exception e) {
                visitor.handleException(e, this);
            }
        }

        @Override public void visitChildren(Visitor visitor) {
            walkSpreadArgument(visitor, this);
        }

        private Expression expression;
        public Expression getExpression() { return expression; }
        public void setExpression(Expression node) { expression = node; connect(node); }

    }

    /**
     * An anonymous function.
     */
    public static class FunctionArgument extends Term {

        public FunctionArgument(Token token) {
            super(token);
        }

        @Override public void visit(Visitor visitor) {
            try {
                visitor.visit(this);
            }
            catch (Exception e) {
                visitor.handleException(e, this);
            }
        }

        @Override public void visitChildren(Visitor visitor) {
            walkFunctionArgument(visitor, this);
        }

        private Type type;
        public Type getType() { return type; }
        public void setType(Type node) { type = node; connect(node); }

        private TypeParameterList typeParameterList;
        public TypeParameterList getTypeParameterList() { return typeParameterList; }
        public void setTypeParameterList(TypeParameterList node) { typeParameterList = node; connect(node); }

        private List<ParameterList> parameterLists = new ArrayList<ParameterList>(3);
        public List<ParameterList> getParameterLists() { return parameterLists; }
        public void addParameterList(ParameterList node) { parameterLists.add(node); connect(node); }

        private TypeConstraintList typeConstraintList;
        public TypeConstraintList getTypeConstraintList() { return typeConstraintList; }
        public void setTypeConstraintList(TypeConstraintList node) { typeConstraintList = node; connect(node); }

        private Expression expression;
        public Expression getExpression() { return expression; }
        public void setExpression(Expression node) { expression = node; connect(node); }

        private Block block;
        public Block getBlock() { return block; }
        public void setBlock(Block node) { block = node; connect(node); }

        private com.redhat.ceylon.model.typechecker.model.Function declarationModel;
        public com.redhat.ceylon.model.typechecker.model.Function getDeclarationModel() { return declarationModel; }
        public void setDeclarationModel(com.redhat.ceylon.model.typechecker.model.Function value) { declarationModel = value; }

    }

    /**
     * An anonymous function.
     */
    public static class ObjectExpression extends Primary {

        public ObjectExpression(Token token) {
            super(token);
        }

        @Override public void visit(Visitor visitor) {
            try {
                visitor.visit(this);
            }
            catch (Exception e) {
                visitor.handleException(e, this);
            }
        }

        @Override public void visitChildren(Visitor visitor) {
            walkObjectExpression(visitor, this);
        }

        private ExtendedType extendedType;
        public ExtendedType getExtendedType() { return extendedType; }
        public void setExtendedType(ExtendedType node) { extendedType = node; connect(node); }

        private SatisfiedTypes satisfiedTypes;
        public SatisfiedTypes getSatisfiedTypes() { return satisfiedTypes; }
        public void setSatisfiedTypes(SatisfiedTypes node) { satisfiedTypes = node; connect(node); }

        private ClassBody classBody;
        public ClassBody getClassBody() { return classBody; }
        public void setClassBody(ClassBody node) { classBody = node; connect(node); }

        private com.redhat.ceylon.model.typechecker.model.Class anonymousClass;
        public com.redhat.ceylon.model.typechecker.model.Class getAnonymousClass() { return anonymousClass; }
        public void setAnonymousClass(com.redhat.ceylon.model.typechecker.model.Class value) { anonymousClass = value; }

    }

    /**
     * An if/then/else conditional expression.
     */
    public static class IfExpression extends Term {

        public IfExpression(Token token) {
            super(token);
        }

        @Override public void visit(Visitor visitor) {
            try {
                visitor.visit(this);
            }
            catch (Exception e) {
                visitor.handleException(e, this);
            }
        }

        @Override public void visitChildren(Visitor visitor) {
            walkIfExpression(visitor, this);
        }

        private IfClause ifClause;
        public IfClause getIfClause() { return ifClause; }
        public void setIfClause(IfClause node) { ifClause = node; connect(node); }

        private ElseClause elseClause;
        public ElseClause getElseClause() { return elseClause; }
        public void setElseClause(ElseClause node) { elseClause = node; connect(node); }

    }

    /**
     * A switch/case/else conditional expression.
     */
    public static class SwitchExpression extends Term {

        public SwitchExpression(Token token) {
            super(token);
        }

        @Override public void visit(Visitor visitor) {
            try {
                visitor.visit(this);
            }
            catch (Exception e) {
                visitor.handleException(e, this);
            }
        }

        @Override public void visitChildren(Visitor visitor) {
            walkSwitchExpression(visitor, this);
        }

        private SwitchClause switchClause;
        public SwitchClause getSwitchClause() { return switchClause; }
        public void setSwitchClause(SwitchClause node) { switchClause = node; connect(node); }

        private SwitchCaseList switchCaseList;
        public SwitchCaseList getSwitchCaseList() { return switchCaseList; }
        public void setSwitchCaseList(SwitchCaseList node) { switchCaseList = node; connect(node); }

    }

    /**
     * A named argument.
     */
    public static abstract class NamedArgument extends StatementOrArgument {

        public NamedArgument(Token token) {
            super(token);
        }

        @Override public void visit(Visitor visitor) {
            try {
                visitor.visit(this);
            }
            catch (Exception e) {
                visitor.handleException(e, this);
            }
        }

        @Override public void visitChildren(Visitor visitor) {
            walkNamedArgument(visitor, this);
        }

        private Identifier identifier;
        public Identifier getIdentifier() { return identifier; }
        public void setIdentifier(Identifier node) { identifier = node; connect(node); }

        private com.redhat.ceylon.model.typechecker.model.Parameter parameter;
        public com.redhat.ceylon.model.typechecker.model.Parameter getParameter() { return parameter; }
        public void setParameter(com.redhat.ceylon.model.typechecker.model.Parameter value) { parameter = value; }

    }

    /**
     * A specifier statement-style named argument.
     */
    public static class SpecifiedArgument extends NamedArgument {

        public SpecifiedArgument(Token token) {
            super(token);
        }

        @Override public void visit(Visitor visitor) {
            try {
                visitor.visit(this);
            }
            catch (Exception e) {
                visitor.handleException(e, this);
            }
        }

        @Override public void visitChildren(Visitor visitor) {
            walkSpecifiedArgument(visitor, this);
        }

        private SpecifierExpression specifierExpression;
        public SpecifierExpression getSpecifierExpression() { return specifierExpression; }
        public void setSpecifierExpression(SpecifierExpression node) { specifierExpression = node; connect(node); }

    }

    /**
     * A declaration-style named argument.
     */
    public static abstract class TypedArgument extends NamedArgument {

        public TypedArgument(Token token) {
            super(token);
        }

        @Override public void visit(Visitor visitor) {
            try {
                visitor.visit(this);
            }
            catch (Exception e) {
                visitor.handleException(e, this);
            }
        }

        @Override public void visitChildren(Visitor visitor) {
            walkTypedArgument(visitor, this);
        }

        private Type type;
        public Type getType() { return type; }
        public void setType(Type node) { type = node; connect(node); }

        public abstract com.redhat.ceylon.model.typechecker.model.TypedDeclaration getDeclarationModel();

    }

    /**
     * A function declaration that occurs as a named argument.
     */
    public static class MethodArgument extends TypedArgument {

        public MethodArgument(Token token) {
            super(token);
        }

        @Override public void visit(Visitor visitor) {
            try {
                visitor.visit(this);
            }
            catch (Exception e) {
                visitor.handleException(e, this);
            }
        }

        @Override public void visitChildren(Visitor visitor) {
            walkMethodArgument(visitor, this);
        }

        private TypeParameterList typeParameterList;
        public TypeParameterList getTypeParameterList() { return typeParameterList; }
        public void setTypeParameterList(TypeParameterList node) { typeParameterList = node; connect(node); }

        private List<ParameterList> parameterLists = new ArrayList<ParameterList>(3);
        public List<ParameterList> getParameterLists() { return parameterLists; }
        public void addParameterList(ParameterList node) { parameterLists.add(node); connect(node); }

        private Block block;
        public Block getBlock() { return block; }
        public void setBlock(Block node) { block = node; connect(node); }

        private SpecifierExpression specifierExpression;
        public SpecifierExpression getSpecifierExpression() { return specifierExpression; }
        public void setSpecifierExpression(SpecifierExpression node) { specifierExpression = node; connect(node); }

        private com.redhat.ceylon.model.typechecker.model.Function declarationModel;
        public com.redhat.ceylon.model.typechecker.model.Function getDeclarationModel() { return declarationModel; }
        public void setDeclarationModel(com.redhat.ceylon.model.typechecker.model.Function value) { declarationModel = value; }

    }

    /**
     * A value declaration that occurs as a named argument.
     */
    public static class AttributeArgument extends TypedArgument {

        public AttributeArgument(Token token) {
            super(token);
        }

        @Override public void visit(Visitor visitor) {
            try {
                visitor.visit(this);
            }
            catch (Exception e) {
                visitor.handleException(e, this);
            }
        }

        @Override public void visitChildren(Visitor visitor) {
            walkAttributeArgument(visitor, this);
        }

        private Block block;
        public Block getBlock() { return block; }
        public void setBlock(Block node) { block = node; connect(node); }

        private SpecifierExpression specifierExpression;
        public SpecifierExpression getSpecifierExpression() { return specifierExpression; }
        public void setSpecifierExpression(SpecifierExpression node) { specifierExpression = node; connect(node); }

        private com.redhat.ceylon.model.typechecker.model.Value declarationModel;
        public com.redhat.ceylon.model.typechecker.model.Value getDeclarationModel() { return declarationModel; }
        public void setDeclarationModel(com.redhat.ceylon.model.typechecker.model.Value value) { declarationModel = value; }

    }

    /**
     * An object declaration that occurs as a named argument.
     */
    public static class ObjectArgument extends TypedArgument {

        public ObjectArgument(Token token) {
            super(token);
        }

        @Override public void visit(Visitor visitor) {
            try {
                visitor.visit(this);
            }
            catch (Exception e) {
                visitor.handleException(e, this);
            }
        }

        @Override public void visitChildren(Visitor visitor) {
            walkObjectArgument(visitor, this);
        }

        private ExtendedType extendedType;
        public ExtendedType getExtendedType() { return extendedType; }
        public void setExtendedType(ExtendedType node) { extendedType = node; connect(node); }

        private SatisfiedTypes satisfiedTypes;
        public SatisfiedTypes getSatisfiedTypes() { return satisfiedTypes; }
        public void setSatisfiedTypes(SatisfiedTypes node) { satisfiedTypes = node; connect(node); }

        private ClassBody classBody;
        public ClassBody getClassBody() { return classBody; }
        public void setClassBody(ClassBody node) { classBody = node; connect(node); }

        private com.redhat.ceylon.model.typechecker.model.Value declarationModel;
        public com.redhat.ceylon.model.typechecker.model.Value getDeclarationModel() { return declarationModel; }
        public void setDeclarationModel(com.redhat.ceylon.model.typechecker.model.Value value) { declarationModel = value; }

        private com.redhat.ceylon.model.typechecker.model.Class anonymousClass;
        public com.redhat.ceylon.model.typechecker.model.Class getAnonymousClass() { return anonymousClass; }
        public void setAnonymousClass(com.redhat.ceylon.model.typechecker.model.Class value) { anonymousClass = value; }

    }

    /**
     * Deprecated!
     */
    public static abstract class SpecifierOrInitializerExpression extends Node {

        public SpecifierOrInitializerExpression(Token token) {
            super(token);
        }

        @Override public void visit(Visitor visitor) {
            try {
                visitor.visit(this);
            }
            catch (Exception e) {
                visitor.handleException(e, this);
            }
        }

        @Override public void visitChildren(Visitor visitor) {
            walkSpecifierOrInitializerExpression(visitor, this);
        }

        private Expression expression;
        public Expression getExpression() { return expression; }
        public void setExpression(Expression node) { expression = node; connect(node); }

    }

    /**
     * A specifier expression.
     */
    public static class SpecifierExpression extends SpecifierOrInitializerExpression {

        public SpecifierExpression(Token token) {
            super(token);
        }

        @Override public void visit(Visitor visitor) {
            try {
                visitor.visit(this);
            }
            catch (Exception e) {
                visitor.handleException(e, this);
            }
        }

        @Override public void visitChildren(Visitor visitor) {
            walkSpecifierExpression(visitor, this);
        }

    }

    /**
     * A shortcut getter or method body.
     */
    public static class LazySpecifierExpression extends SpecifierExpression {

        public LazySpecifierExpression(Token token) {
            super(token);
        }

        @Override public void visit(Visitor visitor) {
            try {
                visitor.visit(this);
            }
            catch (Exception e) {
                visitor.handleException(e, this);
            }
        }

        @Override public void visitChildren(Visitor visitor) {
            walkLazySpecifierExpression(visitor, this);
        }

    }

    /**
     * An initializer expression.
     */
    public static class InitializerExpression extends SpecifierOrInitializerExpression {

        public InitializerExpression(Token token) {
            super(token);
        }

        @Override public void visit(Visitor visitor) {
            try {
                visitor.visit(this);
            }
            catch (Exception e) {
                visitor.handleException(e, this);
            }
        }

        @Override public void visitChildren(Visitor visitor) {
            walkInitializerExpression(visitor, this);
        }

    }

    /**
     * A member reference, type reference, literal, string template, or parenthesized expression.
     */
    public static abstract class Atom extends Primary {

        public Atom(Token token) {
            super(token);
        }

        @Override public void visit(Visitor visitor) {
            try {
                visitor.visit(this);
            }
            catch (Exception e) {
                visitor.handleException(e, this);
            }
        }

        @Override public void visitChildren(Visitor visitor) {
            walkAtom(visitor, this);
        }

    }

    /**
     * A literal.
     */
    public static abstract class Literal extends Atom {

        public Literal(Token token) {
            super(token);
        }

        @Override public void visit(Visitor visitor) {
            try {
                visitor.visit(this);
            }
            catch (Exception e) {
                visitor.handleException(e, this);
            }
        }

        @Override public void visitChildren(Visitor visitor) {
            walkLiteral(visitor, this);
        }

    }

    public static class NaturalLiteral extends Literal {

        public NaturalLiteral(Token token) {
            super(token);
        }

        @Override public void visit(Visitor visitor) {
            try {
                visitor.visit(this);
            }
            catch (Exception e) {
                visitor.handleException(e, this);
            }
        }

        @Override public void visitChildren(Visitor visitor) {
            walkNaturalLiteral(visitor, this);
        }

    }

    public static class FloatLiteral extends Literal {

        public FloatLiteral(Token token) {
            super(token);
        }

        @Override public void visit(Visitor visitor) {
            try {
                visitor.visit(this);
            }
            catch (Exception e) {
                visitor.handleException(e, this);
            }
        }

        @Override public void visitChildren(Visitor visitor) {
            walkFloatLiteral(visitor, this);
        }

    }

    public static class CharLiteral extends Literal {

        public CharLiteral(Token token) {
            super(token);
        }

        @Override public void visit(Visitor visitor) {
            try {
                visitor.visit(this);
            }
            catch (Exception e) {
                visitor.handleException(e, this);
            }
        }

        @Override public void visitChildren(Visitor visitor) {
            walkCharLiteral(visitor, this);
        }

    }

    public static class StringLiteral extends Literal {

        public StringLiteral(Token token) {
            super(token);
        }

        @Override public void visit(Visitor visitor) {
            try {
                visitor.visit(this);
            }
            catch (Exception e) {
                visitor.handleException(e, this);
            }
        }

        @Override public void visitChildren(Visitor visitor) {
            walkStringLiteral(visitor, this);
        }

        private List<DocLink> docLinks = new ArrayList<DocLink>(3);
        public List<DocLink> getDocLinks() { return docLinks; }
        public void addDocLink(DocLink node) { docLinks.add(node); connect(node); }

    }

    public static class QuotedLiteral extends Literal {

        public QuotedLiteral(Token token) {
            super(token);
        }

        @Override public void visit(Visitor visitor) {
            try {
                visitor.visit(this);
            }
            catch (Exception e) {
                visitor.handleException(e, this);
            }
        }

        @Override public void visitChildren(Visitor visitor) {
            walkQuotedLiteral(visitor, this);
        }

    }

    /**
     * A wiki-style link in a documentation string
     */
    public static class DocLink extends Node {

        public DocLink(Token token) {
            super(token);
        }

        @Override public void visit(Visitor visitor) {
            try {
                visitor.visit(this);
            }
            catch (Exception e) {
                visitor.handleException(e, this);
            }
        }

        @Override public void visitChildren(Visitor visitor) {
            walkDocLink(visitor, this);
        }

        private com.redhat.ceylon.model.typechecker.model.Module module;
        public com.redhat.ceylon.model.typechecker.model.Module getModule() { return module; }
        public void setModule(com.redhat.ceylon.model.typechecker.model.Module value) { module = value; }

        private com.redhat.ceylon.model.typechecker.model.Package pkg;
        public com.redhat.ceylon.model.typechecker.model.Package getPkg() { return pkg; }
        public void setPkg(com.redhat.ceylon.model.typechecker.model.Package value) { pkg = value; }

        private com.redhat.ceylon.model.typechecker.model.Declaration base;
        public com.redhat.ceylon.model.typechecker.model.Declaration getBase() { return base; }
        public void setBase(com.redhat.ceylon.model.typechecker.model.Declaration value) { base = value; }

        private List<com.redhat.ceylon.model.typechecker.model.Declaration> qualified;
        public List<com.redhat.ceylon.model.typechecker.model.Declaration> getQualified() { return qualified; }
        public void setQualified(List<com.redhat.ceylon.model.typechecker.model.Declaration> value) { qualified = value; }

    }

    /**
     * A reference to the current instance.
     */
    public static abstract class SelfExpression extends Atom {

        public SelfExpression(Token token) {
            super(token);
        }

        @Override public void visit(Visitor visitor) {
            try {
                visitor.visit(this);
            }
            catch (Exception e) {
                visitor.handleException(e, this);
            }
        }

        @Override public void visitChildren(Visitor visitor) {
            walkSelfExpression(visitor, this);
        }

        private com.redhat.ceylon.model.typechecker.model.TypeDeclaration declarationModel;
        public com.redhat.ceylon.model.typechecker.model.TypeDeclaration getDeclarationModel() { return declarationModel; }
        public void setDeclarationModel(com.redhat.ceylon.model.typechecker.model.TypeDeclaration value) { declarationModel = value; }

    }

    public static class This extends SelfExpression {

        public This(Token token) {
            super(token);
        }

        @Override public void visit(Visitor visitor) {
            try {
                visitor.visit(this);
            }
            catch (Exception e) {
                visitor.handleException(e, this);
            }
        }

        @Override public void visitChildren(Visitor visitor) {
            walkThis(visitor, this);
        }

    }

    public static class Super extends SelfExpression {

        public Super(Token token) {
            super(token);
        }

        @Override public void visit(Visitor visitor) {
            try {
                visitor.visit(this);
            }
            catch (Exception e) {
                visitor.handleException(e, this);
            }
        }

        @Override public void visitChildren(Visitor visitor) {
            walkSuper(visitor, this);
        }

    }

    /**
     * Enumerated elements of an iterable.
     */
    public static class SequenceEnumeration extends Atom {

        public SequenceEnumeration(Token token) {
            super(token);
        }

        @Override public void visit(Visitor visitor) {
            try {
                visitor.visit(this);
            }
            catch (Exception e) {
                visitor.handleException(e, this);
            }
        }

        @Override public void visitChildren(Visitor visitor) {
            walkSequenceEnumeration(visitor, this);
        }

        private SequencedArgument sequencedArgument;
        public SequencedArgument getSequencedArgument() { return sequencedArgument; }
        public void setSequencedArgument(SequencedArgument node) { sequencedArgument = node; connect(node); }

        private List<Statement> statements = new ArrayList<Statement>(3);
        public List<Statement> getStatements() { return statements; }
        public void addStatement(Statement node) { statements.add(node); connect(node); }

    }

    /**
     * Enumerated elements of a tuple.
     */
    public static class Tuple extends Atom {

        public Tuple(Token token) {
            super(token);
        }

        @Override public void visit(Visitor visitor) {
            try {
                visitor.visit(this);
            }
            catch (Exception e) {
                visitor.handleException(e, this);
            }
        }

        @Override public void visitChildren(Visitor visitor) {
            walkTuple(visitor, this);
        }

        private SequencedArgument sequencedArgument;
        public SequencedArgument getSequencedArgument() { return sequencedArgument; }
        public void setSequencedArgument(SequencedArgument node) { sequencedArgument = node; connect(node); }

    }

    public static class Dynamic extends Atom {

        public Dynamic(Token token) {
            super(token);
        }

        @Override public void visit(Visitor visitor) {
            try {
                visitor.visit(this);
            }
            catch (Exception e) {
                visitor.handleException(e, this);
            }
        }

        @Override public void visitChildren(Visitor visitor) {
            walkDynamic(visitor, this);
        }

        private NamedArgumentList namedArgumentList;
        public NamedArgumentList getNamedArgumentList() { return namedArgumentList; }
        public void setNamedArgumentList(NamedArgumentList node) { namedArgumentList = node; connect(node); }

    }

    /**
     * A string template.
     */
    public static class StringTemplate extends Atom {

        public StringTemplate(Token token) {
            super(token);
        }

        @Override public void visit(Visitor visitor) {
            try {
                visitor.visit(this);
            }
            catch (Exception e) {
                visitor.handleException(e, this);
            }
        }

        @Override public void visitChildren(Visitor visitor) {
            walkStringTemplate(visitor, this);
        }

        private List<StringLiteral> stringLiterals = new ArrayList<StringLiteral>(3);
        public List<StringLiteral> getStringLiterals() { return stringLiterals; }
        public void addStringLiteral(StringLiteral node) { stringLiterals.add(node); connect(node); }

        private List<Expression> expressions = new ArrayList<Expression>(3);
        public List<Expression> getExpressions() { return expressions; }
        public void addExpression(Expression node) { expressions.add(node); connect(node); }

    }

    /**
     * A program element annotation.
     */
    public static class Annotation extends InvocationExpression {

        public Annotation(Token token) {
            super(token);
        }

        @Override public void visit(Visitor visitor) {
            try {
                visitor.visit(this);
            }
            catch (Exception e) {
                visitor.handleException(e, this);
            }
        }

        @Override public void visitChildren(Visitor visitor) {
            walkAnnotation(visitor, this);
        }

    }

    /**
     * An abbreviated doc annotation.
     */
    public static class AnonymousAnnotation extends Node {

        public AnonymousAnnotation(Token token) {
            super(token);
        }

        @Override public void visit(Visitor visitor) {
            try {
                visitor.visit(this);
            }
            catch (Exception e) {
                visitor.handleException(e, this);
            }
        }

        @Override public void visitChildren(Visitor visitor) {
            walkAnonymousAnnotation(visitor, this);
        }

        private StringLiteral stringLiteral;
        public StringLiteral getStringLiteral() { return stringLiteral; }
        public void setStringLiteral(StringLiteral node) { stringLiteral = node; connect(node); }

        private StringTemplate stringTemplate;
        public StringTemplate getStringTemplate() { return stringTemplate; }
        public void setStringTemplate(StringTemplate node) { stringTemplate = node; connect(node); }

    }

    /**
     * A list of annotations of a program element.
     */
    public static class AnnotationList extends Node {

        public AnnotationList(Token token) {
            super(token);
        }

        @Override public void visit(Visitor visitor) {
            try {
                visitor.visit(this);
            }
            catch (Exception e) {
                visitor.handleException(e, this);
            }
        }

        @Override public void visitChildren(Visitor visitor) {
            walkAnnotationList(visitor, this);
        }

        private AnonymousAnnotation anonymousAnnotation;
        public AnonymousAnnotation getAnonymousAnnotation() { return anonymousAnnotation; }
        public void setAnonymousAnnotation(AnonymousAnnotation node) { anonymousAnnotation = node; connect(node); }

        private List<Annotation> annotations = new ArrayList<Annotation>(3);
        public List<Annotation> getAnnotations() { return annotations; }
        public void addAnnotation(Annotation node) { annotations.add(node); connect(node); }

    }

    /**
     * An identifier (the name of a program element).
     */
    public static class Identifier extends Node {

        public Identifier(Token token) {
            super(token);
        }

        @Override public void visit(Visitor visitor) {
            try {
                visitor.visit(this);
            }
            catch (Exception e) {
                visitor.handleException(e, this);
            }
        }

        @Override public void visitChildren(Visitor visitor) {
            walkIdentifier(visitor, this);
        }

    }

    /**
     * A comprehension.
     */
    public static class Comprehension extends PositionalArgument {

        public Comprehension(Token token) {
            super(token);
        }

        @Override public void visit(Visitor visitor) {
            try {
                visitor.visit(this);
            }
            catch (Exception e) {
                visitor.handleException(e, this);
            }
        }

        @Override public void visitChildren(Visitor visitor) {
            walkComprehension(visitor, this);
        }

        private InitialComprehensionClause initialComprehensionClause;
        public InitialComprehensionClause getInitialComprehensionClause() { return initialComprehensionClause; }
        public void setInitialComprehensionClause(InitialComprehensionClause node) { initialComprehensionClause = node; connect(node); }

    }

    /**
     * A single clause of comprehension
     */
    public static abstract class ComprehensionClause extends ControlClause {

        public ComprehensionClause(Token token) {
            super(token);
        }

        @Override public void visit(Visitor visitor) {
            try {
                visitor.visit(this);
            }
            catch (Exception e) {
                visitor.handleException(e, this);
            }
        }

        @Override public void visitChildren(Visitor visitor) {
            walkComprehensionClause(visitor, this);
        }

        private com.redhat.ceylon.model.typechecker.model.Type typeModel;
        public com.redhat.ceylon.model.typechecker.model.Type getTypeModel() { return typeModel; }
        public void setTypeModel(com.redhat.ceylon.model.typechecker.model.Type value) { typeModel = value; }

        private com.redhat.ceylon.model.typechecker.model.Type firstTypeModel;
        public com.redhat.ceylon.model.typechecker.model.Type getFirstTypeModel() { return firstTypeModel; }
        public void setFirstTypeModel(com.redhat.ceylon.model.typechecker.model.Type value) { firstTypeModel = value; }

        private boolean possiblyEmpty;
        public boolean getPossiblyEmpty() { return possiblyEmpty; }
        public void setPossiblyEmpty(boolean value) { possiblyEmpty = value; }

    }

    /**
     * A clause that can appear at the beginning of a comprehension.
     */
    public static abstract class InitialComprehensionClause extends ComprehensionClause {

        public InitialComprehensionClause(Token token) {
            super(token);
        }

        @Override public void visit(Visitor visitor) {
            try {
                visitor.visit(this);
            }
            catch (Exception e) {
                visitor.handleException(e, this);
            }
        }

        @Override public void visitChildren(Visitor visitor) {
            walkInitialComprehensionClause(visitor, this);
        }

    }

    /**
     * The expression at the end of a comprehension.
     */
    public static class ExpressionComprehensionClause extends ComprehensionClause {

        public ExpressionComprehensionClause(Token token) {
            super(token);
        }

        @Override public void visit(Visitor visitor) {
            try {
                visitor.visit(this);
            }
            catch (Exception e) {
                visitor.handleException(e, this);
            }
        }

        @Override public void visitChildren(Visitor visitor) {
            walkExpressionComprehensionClause(visitor, this);
        }

        private Expression expression;
        public Expression getExpression() { return expression; }
        public void setExpression(Expression node) { expression = node; connect(node); }

    }

    /**
     * A quantifier clause in a comprehension.
     */
    public static class ForComprehensionClause extends InitialComprehensionClause {

        public ForComprehensionClause(Token token) {
            super(token);
        }

        @Override public void visit(Visitor visitor) {
            try {
                visitor.visit(this);
            }
            catch (Exception e) {
                visitor.handleException(e, this);
            }
        }

        @Override public void visitChildren(Visitor visitor) {
            walkForComprehensionClause(visitor, this);
        }

        private ForIterator forIterator;
        public ForIterator getForIterator() { return forIterator; }
        public void setForIterator(ForIterator node) { forIterator = node; connect(node); }

        private ComprehensionClause comprehensionClause;
        public ComprehensionClause getComprehensionClause() { return comprehensionClause; }
        public void setComprehensionClause(ComprehensionClause node) { comprehensionClause = node; connect(node); }

    }

    /**
     * A filter clause in a comprehension.
     */
    public static class IfComprehensionClause extends InitialComprehensionClause {

        public IfComprehensionClause(Token token) {
            super(token);
        }

        @Override public void visit(Visitor visitor) {
            try {
                visitor.visit(this);
            }
            catch (Exception e) {
                visitor.handleException(e, this);
            }
        }

        @Override public void visitChildren(Visitor visitor) {
            walkIfComprehensionClause(visitor, this);
        }

        private ConditionList conditionList;
        public ConditionList getConditionList() { return conditionList; }
        public void setConditionList(ConditionList node) { conditionList = node; connect(node); }

        private ComprehensionClause comprehensionClause;
        public ComprehensionClause getComprehensionClause() { return comprehensionClause; }
        public void setComprehensionClause(ComprehensionClause node) { comprehensionClause = node; connect(node); }

    }

}
