package com.redhat.ceylon.compiler.typechecker.tree;

import static com.redhat.ceylon.compiler.typechecker.tree.Tree.*;
import static com.redhat.ceylon.compiler.typechecker.tree.Tree.Package;

public class Validator extends Visitor {

    public void visit(CompilationUnit that) {
        super.visit(that);
    }

    public void visit(ModuleDescriptor that) {
        super.visit(that);
        if (that.getImportPath()==null)
            that.addError("missing import path");
        if (that.getImportModuleList()==null)
            that.addError("missing import module list");
    }

    public void visit(PackageDescriptor that) {
        super.visit(that);
        if (that.getImportPath()==null)
            that.addError("missing import path");
    }

    public void visit(ImportModuleList that) {
        super.visit(that);
    }

    public void visit(ImportModule that) {
        super.visit(that);
    }

    public void visit(ImportList that) {
        super.visit(that);
    }

    public void visit(Import that) {
        super.visit(that);
        if (that.getImportPath()==null)
            that.addError("missing import path");
        if (that.getImportMemberOrTypeList()==null)
            that.addError("missing import member or type list");
    }

    public void visit(ImportPath that) {
        super.visit(that);
    }

    public void visit(ImportMemberOrTypeList that) {
        super.visit(that);
    }

    public void visit(ImportMemberOrType that) {
        super.visit(that);
        if (that.getIdentifier()==null)
            that.addError("missing identifier");
    }

    public void visit(ImportMember that) {
        super.visit(that);
    }

    public void visit(ImportType that) {
        super.visit(that);
    }

    public void visit(Alias that) {
        super.visit(that);
        if (that.getIdentifier()==null)
            that.addError("missing identifier");
    }

    public void visit(ImportWildcard that) {
        super.visit(that);
    }

    public void visit(Declaration that) {
        super.visit(that);
    }

    public void visit(MissingDeclaration that) {
        super.visit(that);
    }

    public void visit(TypeDeclaration that) {
        super.visit(that);
    }

    public void visit(ClassOrInterface that) {
        super.visit(that);
    }

    public void visit(TypeAliasDeclaration that) {
        super.visit(that);
    }

    public void visit(SatisfiedTypes that) {
        super.visit(that);
    }

    public void visit(AbstractedType that) {
        super.visit(that);
        if (that.getType()==null)
            that.addError("missing type");
    }

    public void visit(CaseTypes that) {
        super.visit(that);
    }

    public void visit(ExtendedType that) {
        super.visit(that);
    }

    public void visit(TypeConstraintList that) {
        super.visit(that);
    }

    public void visit(TypeConstraint that) {
        super.visit(that);
    }

    public void visit(TypeSpecifier that) {
        super.visit(that);
    }

    public void visit(DefaultTypeArgument that) {
        super.visit(that);
    }

    public void visit(ClassSpecifier that) {
        super.visit(that);
    }

    public void visit(AnyClass that) {
        super.visit(that);
    }

    public void visit(ClassDefinition that) {
        super.visit(that);
        if (that.getClassBody()==null)
            that.addError("missing class body");
    }

    public void visit(Enumerated that) {
        super.visit(that);
        if (that.getBlock()==null)
            that.addError("missing block");
    }

    public void visit(Constructor that) {
        super.visit(that);
        if (that.getBlock()==null)
            that.addError("missing block");
    }

    public void visit(DelegatedConstructor that) {
        super.visit(that);
        if (that.getInvocationExpression()==null)
            that.addError("missing invocation expression");
    }

    public void visit(ClassDeclaration that) {
        super.visit(that);
    }

    public void visit(AnyInterface that) {
        super.visit(that);
    }

    public void visit(InterfaceDefinition that) {
        super.visit(that);
        if (that.getInterfaceBody()==null)
            that.addError("missing interface body");
    }

    public void visit(InterfaceDeclaration that) {
        super.visit(that);
    }

    public void visit(TypedDeclaration that) {
        super.visit(that);
    }

    public void visit(AnyAttribute that) {
        super.visit(that);
    }

    public void visit(AttributeDeclaration that) {
        super.visit(that);
    }

    public void visit(AttributeGetterDefinition that) {
        super.visit(that);
        if (that.getBlock()==null)
            that.addError("missing block");
    }

    public void visit(AttributeSetterDefinition that) {
        super.visit(that);
    }

    public void visit(AnyMethod that) {
        super.visit(that);
    }

    public void visit(MethodDefinition that) {
        super.visit(that);
        if (that.getBlock()==null)
            that.addError("missing block");
    }

    public void visit(MethodDeclaration that) {
        super.visit(that);
    }

    public void visit(VoidModifier that) {
        super.visit(that);
    }

    public void visit(ObjectDefinition that) {
        super.visit(that);
        if (that.getClassBody()==null)
            that.addError("missing class body");
    }

    public void visit(ParameterList that) {
        super.visit(that);
    }

    public void visit(Parameter that) {
        super.visit(that);
    }

    public void visit(ParameterDeclaration that) {
        super.visit(that);
        if (that.getTypedDeclaration()==null)
            that.addError("missing typed declaration");
    }

    public void visit(ValueParameterDeclaration that) {
        super.visit(that);
    }

    public void visit(FunctionalParameterDeclaration that) {
        super.visit(that);
    }

    public void visit(InitializerParameter that) {
        super.visit(that);
        if (that.getIdentifier()==null)
            that.addError("missing identifier");
    }

    public void visit(PatternParameter that) {
        super.visit(that);
        if (that.getPattern()==null)
            that.addError("missing pattern");
    }

    public void visit(TypeParameterList that) {
        super.visit(that);
    }

    public void visit(TypeParameterDeclaration that) {
        super.visit(that);
    }

    public void visit(TypeVariance that) {
        super.visit(that);
    }

    public void visit(Body that) {
        super.visit(that);
    }

    public void visit(Block that) {
        super.visit(that);
    }

    public void visit(ClassBody that) {
        super.visit(that);
    }

    public void visit(InterfaceBody that) {
        super.visit(that);
    }

    public void visit(Type that) {
        super.visit(that);
    }

    public void visit(StaticType that) {
        super.visit(that);
    }

    public void visit(GroupedType that) {
        super.visit(that);
        if (that.getType()==null)
            that.addError("missing type");
    }

    public void visit(SimpleType that) {
        super.visit(that);
        if (that.getIdentifier()==null)
            that.addError("missing identifier");
    }

    public void visit(BaseType that) {
        super.visit(that);
    }

    public void visit(QualifiedType that) {
        super.visit(that);
        if (that.getOuterType()==null)
            that.addError("missing outertype");
    }

    public void visit(UnionType that) {
        super.visit(that);
    }

    public void visit(IntersectionType that) {
        super.visit(that);
    }

    public void visit(SequenceType that) {
        super.visit(that);
        if (that.getElementType()==null)
            that.addError("missing elementtype");
    }

    public void visit(IterableType that) {
        super.visit(that);
    }

    public void visit(OptionalType that) {
        super.visit(that);
        if (that.getDefiniteType()==null)
            that.addError("missing definitetype");
    }

    public void visit(TupleType that) {
        super.visit(that);
    }

    public void visit(FunctionType that) {
        super.visit(that);
        if (that.getReturnType()==null)
            that.addError("missing returntype");
    }

    public void visit(EntryType that) {
        super.visit(that);
        if (that.getKeyType()==null)
            that.addError("missing keytype");
        if (that.getValueType()==null)
            that.addError("missing valuetype");
    }

    public void visit(TypeConstructor that) {
        super.visit(that);
        if (that.getTypeParameterList()==null)
            that.addError("missing type parameter list");
        if (that.getType()==null)
            that.addError("missing type");
    }

    public void visit(SuperType that) {
        super.visit(that);
    }

    public void visit(MetaLiteral that) {
        super.visit(that);
    }

    public void visit(TypeLiteral that) {
        super.visit(that);
    }

    public void visit(MemberLiteral that) {
        super.visit(that);
        if (that.getIdentifier()==null)
            that.addError("missing identifier");
    }

    public void visit(ClassLiteral that) {
        super.visit(that);
    }

    public void visit(NewLiteral that) {
        super.visit(that);
    }

    public void visit(InterfaceLiteral that) {
        super.visit(that);
    }

    public void visit(AliasLiteral that) {
        super.visit(that);
    }

    public void visit(TypeParameterLiteral that) {
        super.visit(that);
    }

    public void visit(ValueLiteral that) {
        super.visit(that);
    }

    public void visit(FunctionLiteral that) {
        super.visit(that);
    }

    public void visit(ModuleLiteral that) {
        super.visit(that);
    }

    public void visit(PackageLiteral that) {
        super.visit(that);
    }

    public void visit(DynamicModifier that) {
        super.visit(that);
    }

    public void visit(LocalModifier that) {
        super.visit(that);
    }

    public void visit(ValueModifier that) {
        super.visit(that);
    }

    public void visit(FunctionModifier that) {
        super.visit(that);
    }

    public void visit(SyntheticVariable that) {
        super.visit(that);
    }

    public void visit(TypeArguments that) {
        super.visit(that);
    }

    public void visit(TypeArgumentList that) {
        super.visit(that);
    }

    public void visit(InferredTypeArguments that) {
        super.visit(that);
    }

    public void visit(SequencedType that) {
        super.visit(that);
        if (that.getType()==null)
            that.addError("missing type");
    }

    public void visit(DefaultedType that) {
        super.visit(that);
        if (that.getType()==null)
            that.addError("missing type");
    }

    public void visit(SpreadType that) {
        super.visit(that);
        if (that.getType()==null)
            that.addError("missing type");
    }

    public void visit(Directive that) {
        super.visit(that);
    }

    public void visit(Return that) {
        super.visit(that);
    }

    public void visit(Throw that) {
        super.visit(that);
    }

    public void visit(Continue that) {
        super.visit(that);
    }

    public void visit(Break that) {
        super.visit(that);
    }

    public void visit(StatementOrArgument that) {
        super.visit(that);
    }

    public void visit(Statement that) {
        super.visit(that);
    }

    public void visit(CompilerAnnotation that) {
        super.visit(that);
        if (that.getIdentifier()==null)
            that.addError("missing identifier");
    }

    public void visit(ExecutableStatement that) {
        super.visit(that);
    }

    public void visit(Assertion that) {
        super.visit(that);
        if (that.getConditionList()==null)
            that.addError("missing condition list");
    }

    public void visit(SpecifierStatement that) {
        super.visit(that);
        if (that.getBaseMemberExpression()==null)
            that.addError("missing basememberexpression");
        if (that.getSpecifierExpression()==null)
            that.addError("missing specifier expression");
    }

    public void visit(ExpressionStatement that) {
        super.visit(that);
        if (that.getExpression()==null)
            that.addError("missing expression");
    }

    public void visit(Pattern that) {
        super.visit(that);
    }

    public void visit(VariablePattern that) {
        super.visit(that);
        if (that.getVariable()==null)
            that.addError("missing variable");
    }

    public void visit(TuplePattern that) {
        super.visit(that);
    }

    public void visit(KeyValuePattern that) {
        super.visit(that);
        if (that.getKey()==null)
            that.addError("missing key");
        if (that.getValue()==null)
            that.addError("missing value");
    }

    public void visit(Destructure that) {
        super.visit(that);
        if (that.getPattern()==null)
            that.addError("missing pattern");
        if (that.getSpecifierExpression()==null)
            that.addError("missing specifier expression");
    }

    public void visit(ControlStatement that) {
        super.visit(that);
    }

    public void visit(ControlClause that) {
        super.visit(that);
    }

    public void visit(DynamicStatement that) {
        super.visit(that);
        if (that.getDynamicClause()==null)
            that.addError("missing dynamic clause");
    }

    public void visit(DynamicClause that) {
        super.visit(that);
    }

    public void visit(LetExpression that) {
        super.visit(that);
        if (that.getLetClause()==null)
            that.addError("missing let clause");
    }

    public void visit(LetClause that) {
        super.visit(that);
        if (that.getExpression()==null)
            that.addError("missing expression");
    }

    public void visit(IfStatement that) {
        super.visit(that);
        if (that.getIfClause()==null)
            that.addError("missing if clause");
    }

    public void visit(IfClause that) {
        super.visit(that);
        if (that.getConditionList()==null)
            that.addError("missing condition list");
    }

    public void visit(ElseClause that) {
        super.visit(that);
    }

    public void visit(SwitchStatement that) {
        super.visit(that);
        if (that.getSwitchClause()==null)
            that.addError("missing switch clause");
        if (that.getSwitchCaseList()==null)
            that.addError("missing switch case list");
    }

    public void visit(SwitchClause that) {
        super.visit(that);
        if (that.getSwitched()==null)
            that.addError("missing switched");
    }

    public void visit(Switched that) {
        super.visit(that);
    }

    public void visit(SwitchCaseList that) {
        super.visit(that);
    }

    public void visit(CaseClause that) {
        super.visit(that);
        if (that.getCaseItem()==null)
            that.addError("missing case item");
    }

    public void visit(CaseItem that) {
        super.visit(that);
    }

    public void visit(MatchCase that) {
        super.visit(that);
        if (that.getExpressionList()==null)
            that.addError("missing expression list");
    }

    public void visit(IsCase that) {
        super.visit(that);
        if (that.getType()==null)
            that.addError("missing type");
    }

    public void visit(PatternCase that) {
        super.visit(that);
        if (that.getPattern()==null)
            that.addError("missing pattern");
    }

    public void visit(SatisfiesCase that) {
        super.visit(that);
        if (that.getType()==null)
            that.addError("missing type");
    }

    public void visit(TryCatchStatement that) {
        super.visit(that);
        if (that.getTryClause()==null)
            that.addError("missing try clause");
    }

    public void visit(TryClause that) {
        super.visit(that);
    }

    public void visit(CatchClause that) {
        super.visit(that);
        if (that.getCatchVariable()==null)
            that.addError("missing catch variable");
    }

    public void visit(FinallyClause that) {
        super.visit(that);
    }

    public void visit(ResourceList that) {
        super.visit(that);
    }

    public void visit(Resource that) {
        super.visit(that);
    }

    public void visit(CatchVariable that) {
        super.visit(that);
        if (that.getVariable()==null)
            that.addError("missing variable");
    }

    public void visit(ForStatement that) {
        super.visit(that);
        if (that.getForClause()==null)
            that.addError("missing for clause");
    }

    public void visit(ForClause that) {
        super.visit(that);
        if (that.getForIterator()==null)
            that.addError("missing for iterator");
    }

    public void visit(ForIterator that) {
        super.visit(that);
        if (that.getSpecifierExpression()==null)
            that.addError("missing specifier expression");
    }

    public void visit(ValueIterator that) {
        super.visit(that);
        if (that.getVariable()==null)
            that.addError("missing variable");
    }

    public void visit(PatternIterator that) {
        super.visit(that);
        if (that.getPattern()==null)
            that.addError("missing pattern");
    }

    public void visit(WhileStatement that) {
        super.visit(that);
        if (that.getWhileClause()==null)
            that.addError("missing while clause");
    }

    public void visit(WhileClause that) {
        super.visit(that);
        if (that.getConditionList()==null)
            that.addError("missing condition list");
    }

    public void visit(ConditionList that) {
        super.visit(that);
    }

    public void visit(Condition that) {
        super.visit(that);
    }

    public void visit(BooleanCondition that) {
        super.visit(that);
        if (that.getExpression()==null)
            that.addError("missing expression");
    }

    public void visit(ExistsOrNonemptyCondition that) {
        super.visit(that);
    }

    public void visit(ExistsCondition that) {
        super.visit(that);
    }

    public void visit(NonemptyCondition that) {
        super.visit(that);
    }

    public void visit(IsCondition that) {
        super.visit(that);
        if (that.getType()==null)
            that.addError("missing type");
        if (that.getVariable()==null)
            that.addError("missing variable");
    }

    public void visit(SatisfiesCondition that) {
        super.visit(that);
        if (that.getType()==null)
            that.addError("missing type");
        if (that.getIdentifier()==null)
            that.addError("missing identifier");
    }

    public void visit(Variable that) {
        super.visit(that);
    }

    public void visit(Term that) {
        super.visit(that);
    }

    public void visit(OperatorExpression that) {
        super.visit(that);
    }

    public void visit(BinaryOperatorExpression that) {
        super.visit(that);
        if (that.getLeftTerm()==null)
            that.addError("missing leftterm");
        if (that.getRightTerm()==null)
            that.addError("missing rightterm");
    }

    public void visit(ArithmeticOp that) {
        super.visit(that);
    }

    public void visit(SumOp that) {
        super.visit(that);
    }

    public void visit(DifferenceOp that) {
        super.visit(that);
    }

    public void visit(ProductOp that) {
        super.visit(that);
    }

    public void visit(QuotientOp that) {
        super.visit(that);
    }

    public void visit(PowerOp that) {
        super.visit(that);
    }

    public void visit(RemainderOp that) {
        super.visit(that);
    }

    public void visit(AssignmentOp that) {
        super.visit(that);
    }

    public void visit(AssignOp that) {
        super.visit(that);
    }

    public void visit(ArithmeticAssignmentOp that) {
        super.visit(that);
    }

    public void visit(AddAssignOp that) {
        super.visit(that);
    }

    public void visit(SubtractAssignOp that) {
        super.visit(that);
    }

    public void visit(MultiplyAssignOp that) {
        super.visit(that);
    }

    public void visit(DivideAssignOp that) {
        super.visit(that);
    }

    public void visit(RemainderAssignOp that) {
        super.visit(that);
    }

    public void visit(BitwiseAssignmentOp that) {
        super.visit(that);
    }

    public void visit(IntersectAssignOp that) {
        super.visit(that);
    }

    public void visit(UnionAssignOp that) {
        super.visit(that);
    }

    public void visit(ComplementAssignOp that) {
        super.visit(that);
    }

    public void visit(LogicalAssignmentOp that) {
        super.visit(that);
    }

    public void visit(AndAssignOp that) {
        super.visit(that);
    }

    public void visit(OrAssignOp that) {
        super.visit(that);
    }

    public void visit(LogicalOp that) {
        super.visit(that);
    }

    public void visit(AndOp that) {
        super.visit(that);
    }

    public void visit(OrOp that) {
        super.visit(that);
    }

    public void visit(BitwiseOp that) {
        super.visit(that);
    }

    public void visit(IntersectionOp that) {
        super.visit(that);
    }

    public void visit(UnionOp that) {
        super.visit(that);
    }

    public void visit(ComplementOp that) {
        super.visit(that);
    }

    public void visit(EqualityOp that) {
        super.visit(that);
    }

    public void visit(EqualOp that) {
        super.visit(that);
    }

    public void visit(NotEqualOp that) {
        super.visit(that);
    }

    public void visit(ComparisonOp that) {
        super.visit(that);
    }

    public void visit(LargerOp that) {
        super.visit(that);
    }

    public void visit(SmallerOp that) {
        super.visit(that);
    }

    public void visit(LargeAsOp that) {
        super.visit(that);
    }

    public void visit(SmallAsOp that) {
        super.visit(that);
    }

    public void visit(ScaleOp that) {
        super.visit(that);
    }

    public void visit(Bound that) {
        super.visit(that);
        if (that.getTerm()==null)
            that.addError("missing term");
    }

    public void visit(OpenBound that) {
        super.visit(that);
    }

    public void visit(ClosedBound that) {
        super.visit(that);
    }

    public void visit(WithinOp that) {
        super.visit(that);
        if (that.getUpperBound()==null)
            that.addError("missing upperbound");
        if (that.getLowerBound()==null)
            that.addError("missing lowerbound");
        if (that.getTerm()==null)
            that.addError("missing term");
    }

    public void visit(DefaultOp that) {
        super.visit(that);
    }

    public void visit(ThenOp that) {
        super.visit(that);
    }

    public void visit(IdenticalOp that) {
        super.visit(that);
    }

    public void visit(EntryOp that) {
        super.visit(that);
    }

    public void visit(RangeOp that) {
        super.visit(that);
    }

    public void visit(SegmentOp that) {
        super.visit(that);
    }

    public void visit(CompareOp that) {
        super.visit(that);
    }

    public void visit(InOp that) {
        super.visit(that);
    }

    public void visit(UnaryOperatorExpression that) {
        super.visit(that);
        if (that.getTerm()==null)
            that.addError("missing term");
    }

    public void visit(NotOp that) {
        super.visit(that);
    }

    public void visit(Exists that) {
        super.visit(that);
    }

    public void visit(Nonempty that) {
        super.visit(that);
    }

    public void visit(NegativeOp that) {
        super.visit(that);
    }

    public void visit(PositiveOp that) {
        super.visit(that);
    }

    public void visit(TypeOperatorExpression that) {
        super.visit(that);
        if (that.getType()==null)
            that.addError("missing type");
    }

    public void visit(IsOp that) {
        super.visit(that);
    }

    public void visit(Satisfies that) {
        super.visit(that);
    }

    public void visit(Extends that) {
        super.visit(that);
    }

    public void visit(OfOp that) {
        super.visit(that);
    }

    public void visit(PrefixOperatorExpression that) {
        super.visit(that);
    }

    public void visit(IncrementOp that) {
        super.visit(that);
    }

    public void visit(DecrementOp that) {
        super.visit(that);
    }

    public void visit(PostfixOperatorExpression that) {
        super.visit(that);
    }

    public void visit(PostfixIncrementOp that) {
        super.visit(that);
    }

    public void visit(PostfixDecrementOp that) {
        super.visit(that);
    }

    public void visit(ExpressionList that) {
        super.visit(that);
    }

    public void visit(Expression that) {
        super.visit(that);
        if (that.getTerm()==null)
            that.addError("missing term");
    }

    public void visit(ParExpression that) {
        super.visit(that);
    }

    public void visit(Primary that) {
        super.visit(that);
    }

    public void visit(PostfixExpression that) {
        super.visit(that);
        if (that.getPrimary()==null)
            that.addError("missing primary");
    }

    public void visit(InvocationExpression that) {
        super.visit(that);
    }

    public void visit(ParameterizedExpression that) {
        super.visit(that);
        if (that.getPrimary()==null)
            that.addError("missing primary");
    }

    public void visit(MemberOrTypeExpression that) {
        super.visit(that);
    }

    public void visit(ExtendedTypeExpression that) {
        super.visit(that);
    }

    public void visit(StaticMemberOrTypeExpression that) {
        super.visit(that);
        if (that.getIdentifier()==null)
            that.addError("missing identifier");
    }

    public void visit(BaseMemberOrTypeExpression that) {
        super.visit(that);
    }

    public void visit(BaseMemberExpression that) {
        super.visit(that);
    }

    public void visit(BaseTypeExpression that) {
        super.visit(that);
    }

    public void visit(QualifiedMemberOrTypeExpression that) {
        super.visit(that);
        if (that.getPrimary()==null)
            that.addError("missing primary");
        if (that.getMemberOperator()==null)
            that.addError("missing member operator");
    }

    public void visit(QualifiedMemberExpression that) {
        super.visit(that);
    }

    public void visit(QualifiedTypeExpression that) {
        super.visit(that);
    }

    public void visit(MemberOperator that) {
        super.visit(that);
    }

    public void visit(MemberOp that) {
        super.visit(that);
    }

    public void visit(SafeMemberOp that) {
        super.visit(that);
    }

    public void visit(SpreadOp that) {
        super.visit(that);
    }

    public void visit(IndexExpression that) {
        super.visit(that);
        if (that.getElementOrRange()==null)
            that.addError("missing element or range");
    }

    public void visit(ElementOrRange that) {
        super.visit(that);
    }

    public void visit(Element that) {
        super.visit(that);
        if (that.getExpression()==null)
            that.addError("missing expression");
    }

    public void visit(ElementRange that) {
        super.visit(that);
    }

    public void visit(Outer that) {
        super.visit(that);
    }

    public void visit(Package that) {
        super.visit(that);
    }

    public void visit(ArgumentList that) {
        super.visit(that);
    }

    public void visit(NamedArgumentList that) {
        super.visit(that);
    }

    public void visit(SequencedArgument that) {
        super.visit(that);
    }

    public void visit(PositionalArgumentList that) {
        super.visit(that);
    }

    public void visit(PositionalArgument that) {
        super.visit(that);
    }

    public void visit(ListedArgument that) {
        super.visit(that);
        if (that.getExpression()==null)
            that.addError("missing expression");
    }

    public void visit(SpreadArgument that) {
        super.visit(that);
        if (that.getExpression()==null)
            that.addError("missing expression");
    }

    public void visit(FunctionArgument that) {
        super.visit(that);
        if (that.getType()==null)
            that.addError("missing type");
    }

    public void visit(ObjectExpression that) {
        super.visit(that);
        if (that.getClassBody()==null)
            that.addError("missing class body");
    }

    public void visit(IfExpression that) {
        super.visit(that);
        if (that.getIfClause()==null)
            that.addError("missing if clause");
        if (that.getElseClause()==null)
            that.addError("missing else clause");
    }

    public void visit(SwitchExpression that) {
        super.visit(that);
        if (that.getSwitchClause()==null)
            that.addError("missing switch clause");
        if (that.getSwitchCaseList()==null)
            that.addError("missing switch case list");
    }

    public void visit(NamedArgument that) {
        super.visit(that);
    }

    public void visit(SpecifiedArgument that) {
        super.visit(that);
        if (that.getSpecifierExpression()==null)
            that.addError("missing specifier expression");
    }

    public void visit(TypedArgument that) {
        super.visit(that);
        if (that.getType()==null)
            that.addError("missing type");
    }

    public void visit(MethodArgument that) {
        super.visit(that);
    }

    public void visit(AttributeArgument that) {
        super.visit(that);
    }

    public void visit(ObjectArgument that) {
        super.visit(that);
        if (that.getClassBody()==null)
            that.addError("missing class body");
    }

    public void visit(SpecifierOrInitializerExpression that) {
        super.visit(that);
        if (that.getExpression()==null)
            that.addError("missing expression");
    }

    public void visit(SpecifierExpression that) {
        super.visit(that);
    }

    public void visit(LazySpecifierExpression that) {
        super.visit(that);
    }

    public void visit(InitializerExpression that) {
        super.visit(that);
    }

    public void visit(Atom that) {
        super.visit(that);
    }

    public void visit(Literal that) {
        super.visit(that);
    }

    public void visit(NaturalLiteral that) {
        super.visit(that);
    }

    public void visit(FloatLiteral that) {
        super.visit(that);
    }

    public void visit(CharLiteral that) {
        super.visit(that);
    }

    public void visit(StringLiteral that) {
        super.visit(that);
    }

    public void visit(QuotedLiteral that) {
        super.visit(that);
    }

    public void visit(DocLink that) {
        super.visit(that);
    }

    public void visit(SelfExpression that) {
        super.visit(that);
    }

    public void visit(This that) {
        super.visit(that);
    }

    public void visit(Super that) {
        super.visit(that);
    }

    public void visit(SequenceEnumeration that) {
        super.visit(that);
    }

    public void visit(Tuple that) {
        super.visit(that);
    }

    public void visit(Dynamic that) {
        super.visit(that);
    }

    public void visit(StringTemplate that) {
        super.visit(that);
    }

    public void visit(Annotation that) {
        super.visit(that);
    }

    public void visit(AnonymousAnnotation that) {
        super.visit(that);
    }

    public void visit(AnnotationList that) {
        super.visit(that);
    }

    public void visit(Identifier that) {
        super.visit(that);
    }

    public void visit(Comprehension that) {
        super.visit(that);
        if (that.getInitialComprehensionClause()==null)
            that.addError("missing initial comprehension clause");
    }

    public void visit(ComprehensionClause that) {
        super.visit(that);
    }

    public void visit(InitialComprehensionClause that) {
        super.visit(that);
    }

    public void visit(ExpressionComprehensionClause that) {
        super.visit(that);
        if (that.getExpression()==null)
            that.addError("missing expression");
    }

    public void visit(ForComprehensionClause that) {
        super.visit(that);
        if (that.getForIterator()==null)
            that.addError("missing for iterator");
        if (that.getComprehensionClause()==null)
            that.addError("missing comprehension clause");
    }

    public void visit(IfComprehensionClause that) {
        super.visit(that);
        if (that.getConditionList()==null)
            that.addError("missing condition list");
        if (that.getComprehensionClause()==null)
            that.addError("missing comprehension clause");
    }


}
