package com.redhat.ceylon.compiler.typechecker.tree;

import static com.redhat.ceylon.compiler.typechecker.tree.Tree.*;
import static com.redhat.ceylon.compiler.typechecker.tree.Tree.Package;

public abstract class Visitor {

    public static interface ExceptionHandler {
        /*
         * Returns true if the exception has been handled, false if it should be handled
         * by the visitor itself
         */
        boolean handleException(Exception e, Node that);
    }
    private ExceptionHandler externalExceptionHandler = null;
    public Visitor setExceptionHandler(ExceptionHandler exceptionHandler) { externalExceptionHandler = exceptionHandler; return this; }
    public void handleException(Exception e, Node that) {
        if (externalExceptionHandler != null &&
                externalExceptionHandler.handleException(e, that)) {
            return;
        }
        that.handleException(e, this);
    }
    public void visitAny(Node that) { that.visitChildren(this); }

    public void visit(CompilationUnit that) { visitAny(that); }
    public void visit(ModuleDescriptor that) { visit((StatementOrArgument) that); }
    public void visit(PackageDescriptor that) { visit((StatementOrArgument) that); }
    public void visit(ImportModuleList that) { visitAny(that); }
    public void visit(ImportModule that) { visit((StatementOrArgument) that); }
    public void visit(ImportList that) { visitAny(that); }
    public void visit(Import that) { visit((StatementOrArgument) that); }
    public void visit(ImportPath that) { visitAny(that); }
    public void visit(ImportMemberOrTypeList that) { visitAny(that); }
    public void visit(ImportMemberOrType that) { visit((StatementOrArgument) that); }
    public void visit(ImportMember that) { visit((ImportMemberOrType) that); }
    public void visit(ImportType that) { visit((ImportMemberOrType) that); }
    public void visit(Alias that) { visitAny(that); }
    public void visit(ImportWildcard that) { visitAny(that); }
    public void visit(Declaration that) { visit((Statement) that); }
    public void visit(MissingDeclaration that) { visit((Declaration) that); }
    public void visit(TypeDeclaration that) { visit((Declaration) that); }
    public void visit(ClassOrInterface that) { visit((TypeDeclaration) that); }
    public void visit(TypeAliasDeclaration that) { visit((TypeDeclaration) that); }
    public void visit(SatisfiedTypes that) { visitAny(that); }
    public void visit(AbstractedType that) { visitAny(that); }
    public void visit(CaseTypes that) { visitAny(that); }
    public void visit(ExtendedType that) { visitAny(that); }
    public void visit(TypeConstraintList that) { visitAny(that); }
    public void visit(TypeConstraint that) { visit((TypeDeclaration) that); }
    public void visit(TypeSpecifier that) { visitAny(that); }
    public void visit(DefaultTypeArgument that) { visit((TypeSpecifier) that); }
    public void visit(ClassSpecifier that) { visitAny(that); }
    public void visit(AnyClass that) { visit((ClassOrInterface) that); }
    public void visit(ClassDefinition that) { visit((AnyClass) that); }
    public void visit(Enumerated that) { visit((Declaration) that); }
    public void visit(Constructor that) { visit((Declaration) that); }
    public void visit(DelegatedConstructor that) { visitAny(that); }
    public void visit(ClassDeclaration that) { visit((AnyClass) that); }
    public void visit(AnyInterface that) { visit((ClassOrInterface) that); }
    public void visit(InterfaceDefinition that) { visit((AnyInterface) that); }
    public void visit(InterfaceDeclaration that) { visit((AnyInterface) that); }
    public void visit(TypedDeclaration that) { visit((Declaration) that); }
    public void visit(AnyAttribute that) { visit((TypedDeclaration) that); }
    public void visit(AttributeDeclaration that) { visit((AnyAttribute) that); }
    public void visit(AttributeGetterDefinition that) { visit((AnyAttribute) that); }
    public void visit(AttributeSetterDefinition that) { visit((TypedDeclaration) that); }
    public void visit(AnyMethod that) { visit((TypedDeclaration) that); }
    public void visit(MethodDefinition that) { visit((AnyMethod) that); }
    public void visit(MethodDeclaration that) { visit((AnyMethod) that); }
    public void visit(VoidModifier that) { visit((Type) that); }
    public void visit(ObjectDefinition that) { visit((TypedDeclaration) that); }
    public void visit(ParameterList that) { visitAny(that); }
    public void visit(Parameter that) { visitAny(that); }
    public void visit(ParameterDeclaration that) { visit((Parameter) that); }
    public void visit(ValueParameterDeclaration that) { visit((ParameterDeclaration) that); }
    public void visit(FunctionalParameterDeclaration that) { visit((ParameterDeclaration) that); }
    public void visit(InitializerParameter that) { visit((Parameter) that); }
    public void visit(PatternParameter that) { visit((Parameter) that); }
    public void visit(TypeParameterList that) { visitAny(that); }
    public void visit(TypeParameterDeclaration that) { visit((Declaration) that); }
    public void visit(TypeVariance that) { visitAny(that); }
    public void visit(Body that) { visitAny(that); }
    public void visit(Block that) { visit((Body) that); }
    public void visit(ClassBody that) { visit((Body) that); }
    public void visit(InterfaceBody that) { visit((Body) that); }
    public void visit(Type that) { visitAny(that); }
    public void visit(StaticType that) { visit((Type) that); }
    public void visit(GroupedType that) { visit((StaticType) that); }
    public void visit(SimpleType that) { visit((StaticType) that); }
    public void visit(BaseType that) { visit((SimpleType) that); }
    public void visit(QualifiedType that) { visit((SimpleType) that); }
    public void visit(UnionType that) { visit((StaticType) that); }
    public void visit(IntersectionType that) { visit((StaticType) that); }
    public void visit(SequenceType that) { visit((StaticType) that); }
    public void visit(IterableType that) { visit((StaticType) that); }
    public void visit(OptionalType that) { visit((StaticType) that); }
    public void visit(TupleType that) { visit((StaticType) that); }
    public void visit(FunctionType that) { visit((StaticType) that); }
    public void visit(EntryType that) { visit((StaticType) that); }
    public void visit(TypeConstructor that) { visit((StaticType) that); }
    public void visit(SuperType that) { visit((StaticType) that); }
    public void visit(MetaLiteral that) { visit((Primary) that); }
    public void visit(TypeLiteral that) { visit((MetaLiteral) that); }
    public void visit(MemberLiteral that) { visit((MetaLiteral) that); }
    public void visit(ClassLiteral that) { visit((TypeLiteral) that); }
    public void visit(NewLiteral that) { visit((TypeLiteral) that); }
    public void visit(InterfaceLiteral that) { visit((TypeLiteral) that); }
    public void visit(AliasLiteral that) { visit((TypeLiteral) that); }
    public void visit(TypeParameterLiteral that) { visit((TypeLiteral) that); }
    public void visit(ValueLiteral that) { visit((MemberLiteral) that); }
    public void visit(FunctionLiteral that) { visit((MemberLiteral) that); }
    public void visit(ModuleLiteral that) { visit((MetaLiteral) that); }
    public void visit(PackageLiteral that) { visit((MetaLiteral) that); }
    public void visit(DynamicModifier that) { visit((Type) that); }
    public void visit(LocalModifier that) { visit((Type) that); }
    public void visit(ValueModifier that) { visit((LocalModifier) that); }
    public void visit(FunctionModifier that) { visit((LocalModifier) that); }
    public void visit(SyntheticVariable that) { visit((ValueModifier) that); }
    public void visit(TypeArguments that) { visitAny(that); }
    public void visit(TypeArgumentList that) { visit((TypeArguments) that); }
    public void visit(InferredTypeArguments that) { visit((TypeArguments) that); }
    public void visit(SequencedType that) { visit((Type) that); }
    public void visit(DefaultedType that) { visit((Type) that); }
    public void visit(SpreadType that) { visit((Type) that); }
    public void visit(Directive that) { visit((ExecutableStatement) that); }
    public void visit(Return that) { visit((Directive) that); }
    public void visit(Throw that) { visit((Directive) that); }
    public void visit(Continue that) { visit((Directive) that); }
    public void visit(Break that) { visit((Directive) that); }
    public void visit(StatementOrArgument that) { visitAny(that); }
    public void visit(Statement that) { visit((StatementOrArgument) that); }
    public void visit(CompilerAnnotation that) { visitAny(that); }
    public void visit(ExecutableStatement that) { visit((Statement) that); }
    public void visit(Assertion that) { visit((ExecutableStatement) that); }
    public void visit(SpecifierStatement that) { visit((ExecutableStatement) that); }
    public void visit(ExpressionStatement that) { visit((ExecutableStatement) that); }
    public void visit(Pattern that) { visitAny(that); }
    public void visit(VariablePattern that) { visit((Pattern) that); }
    public void visit(TuplePattern that) { visit((Pattern) that); }
    public void visit(KeyValuePattern that) { visit((Pattern) that); }
    public void visit(Destructure that) { visit((ExecutableStatement) that); }
    public void visit(ControlStatement that) { visit((ExecutableStatement) that); }
    public void visit(ControlClause that) { visitAny(that); }
    public void visit(DynamicStatement that) { visit((ControlStatement) that); }
    public void visit(DynamicClause that) { visit((ControlClause) that); }
    public void visit(LetExpression that) { visit((Term) that); }
    public void visit(LetClause that) { visit((ControlClause) that); }
    public void visit(IfStatement that) { visit((ControlStatement) that); }
    public void visit(IfClause that) { visit((ControlClause) that); }
    public void visit(ElseClause that) { visit((ControlClause) that); }
    public void visit(SwitchStatement that) { visit((ControlStatement) that); }
    public void visit(SwitchClause that) { visitAny(that); }
    public void visit(Switched that) { visitAny(that); }
    public void visit(SwitchCaseList that) { visitAny(that); }
    public void visit(CaseClause that) { visit((ControlClause) that); }
    public void visit(CaseItem that) { visitAny(that); }
    public void visit(MatchCase that) { visit((CaseItem) that); }
    public void visit(IsCase that) { visit((CaseItem) that); }
    public void visit(PatternCase that) { visit((CaseItem) that); }
    public void visit(SatisfiesCase that) { visit((CaseItem) that); }
    public void visit(TryCatchStatement that) { visit((ControlStatement) that); }
    public void visit(TryClause that) { visit((ControlClause) that); }
    public void visit(CatchClause that) { visit((ControlClause) that); }
    public void visit(FinallyClause that) { visit((ControlClause) that); }
    public void visit(ResourceList that) { visitAny(that); }
    public void visit(Resource that) { visitAny(that); }
    public void visit(CatchVariable that) { visitAny(that); }
    public void visit(ForStatement that) { visit((ControlStatement) that); }
    public void visit(ForClause that) { visit((ControlClause) that); }
    public void visit(ForIterator that) { visit((StatementOrArgument) that); }
    public void visit(ValueIterator that) { visit((ForIterator) that); }
    public void visit(PatternIterator that) { visit((ForIterator) that); }
    public void visit(WhileStatement that) { visit((ControlStatement) that); }
    public void visit(WhileClause that) { visit((ControlClause) that); }
    public void visit(ConditionList that) { visitAny(that); }
    public void visit(Condition that) { visitAny(that); }
    public void visit(BooleanCondition that) { visit((Condition) that); }
    public void visit(ExistsOrNonemptyCondition that) { visit((Condition) that); }
    public void visit(ExistsCondition that) { visit((ExistsOrNonemptyCondition) that); }
    public void visit(NonemptyCondition that) { visit((ExistsOrNonemptyCondition) that); }
    public void visit(IsCondition that) { visit((Condition) that); }
    public void visit(SatisfiesCondition that) { visit((Condition) that); }
    public void visit(Variable that) { visit((TypedDeclaration) that); }
    public void visit(Term that) { visitAny(that); }
    public void visit(OperatorExpression that) { visit((Term) that); }
    public void visit(BinaryOperatorExpression that) { visit((OperatorExpression) that); }
    public void visit(ArithmeticOp that) { visit((BinaryOperatorExpression) that); }
    public void visit(SumOp that) { visit((ArithmeticOp) that); }
    public void visit(DifferenceOp that) { visit((ArithmeticOp) that); }
    public void visit(ProductOp that) { visit((ArithmeticOp) that); }
    public void visit(QuotientOp that) { visit((ArithmeticOp) that); }
    public void visit(PowerOp that) { visit((ArithmeticOp) that); }
    public void visit(RemainderOp that) { visit((ArithmeticOp) that); }
    public void visit(AssignmentOp that) { visit((BinaryOperatorExpression) that); }
    public void visit(AssignOp that) { visit((AssignmentOp) that); }
    public void visit(ArithmeticAssignmentOp that) { visit((AssignmentOp) that); }
    public void visit(AddAssignOp that) { visit((ArithmeticAssignmentOp) that); }
    public void visit(SubtractAssignOp that) { visit((ArithmeticAssignmentOp) that); }
    public void visit(MultiplyAssignOp that) { visit((ArithmeticAssignmentOp) that); }
    public void visit(DivideAssignOp that) { visit((ArithmeticAssignmentOp) that); }
    public void visit(RemainderAssignOp that) { visit((ArithmeticAssignmentOp) that); }
    public void visit(BitwiseAssignmentOp that) { visit((AssignmentOp) that); }
    public void visit(IntersectAssignOp that) { visit((BitwiseAssignmentOp) that); }
    public void visit(UnionAssignOp that) { visit((BitwiseAssignmentOp) that); }
    public void visit(ComplementAssignOp that) { visit((BitwiseAssignmentOp) that); }
    public void visit(LogicalAssignmentOp that) { visit((AssignmentOp) that); }
    public void visit(AndAssignOp that) { visit((LogicalAssignmentOp) that); }
    public void visit(OrAssignOp that) { visit((LogicalAssignmentOp) that); }
    public void visit(LogicalOp that) { visit((BinaryOperatorExpression) that); }
    public void visit(AndOp that) { visit((LogicalOp) that); }
    public void visit(OrOp that) { visit((LogicalOp) that); }
    public void visit(BitwiseOp that) { visit((BinaryOperatorExpression) that); }
    public void visit(IntersectionOp that) { visit((BitwiseOp) that); }
    public void visit(UnionOp that) { visit((BitwiseOp) that); }
    public void visit(ComplementOp that) { visit((BitwiseOp) that); }
    public void visit(EqualityOp that) { visit((BinaryOperatorExpression) that); }
    public void visit(EqualOp that) { visit((EqualityOp) that); }
    public void visit(NotEqualOp that) { visit((EqualityOp) that); }
    public void visit(ComparisonOp that) { visit((BinaryOperatorExpression) that); }
    public void visit(LargerOp that) { visit((ComparisonOp) that); }
    public void visit(SmallerOp that) { visit((ComparisonOp) that); }
    public void visit(LargeAsOp that) { visit((ComparisonOp) that); }
    public void visit(SmallAsOp that) { visit((ComparisonOp) that); }
    public void visit(ScaleOp that) { visit((BinaryOperatorExpression) that); }
    public void visit(Bound that) { visit((Term) that); }
    public void visit(OpenBound that) { visit((Bound) that); }
    public void visit(ClosedBound that) { visit((Bound) that); }
    public void visit(WithinOp that) { visit((OperatorExpression) that); }
    public void visit(DefaultOp that) { visit((BinaryOperatorExpression) that); }
    public void visit(ThenOp that) { visit((BinaryOperatorExpression) that); }
    public void visit(IdenticalOp that) { visit((BinaryOperatorExpression) that); }
    public void visit(EntryOp that) { visit((BinaryOperatorExpression) that); }
    public void visit(RangeOp that) { visit((BinaryOperatorExpression) that); }
    public void visit(SegmentOp that) { visit((BinaryOperatorExpression) that); }
    public void visit(CompareOp that) { visit((BinaryOperatorExpression) that); }
    public void visit(InOp that) { visit((BinaryOperatorExpression) that); }
    public void visit(UnaryOperatorExpression that) { visit((OperatorExpression) that); }
    public void visit(NotOp that) { visit((UnaryOperatorExpression) that); }
    public void visit(Exists that) { visit((UnaryOperatorExpression) that); }
    public void visit(Nonempty that) { visit((UnaryOperatorExpression) that); }
    public void visit(NegativeOp that) { visit((UnaryOperatorExpression) that); }
    public void visit(PositiveOp that) { visit((UnaryOperatorExpression) that); }
    public void visit(TypeOperatorExpression that) { visit((UnaryOperatorExpression) that); }
    public void visit(IsOp that) { visit((TypeOperatorExpression) that); }
    public void visit(Satisfies that) { visit((TypeOperatorExpression) that); }
    public void visit(Extends that) { visit((TypeOperatorExpression) that); }
    public void visit(OfOp that) { visit((TypeOperatorExpression) that); }
    public void visit(PrefixOperatorExpression that) { visit((UnaryOperatorExpression) that); }
    public void visit(IncrementOp that) { visit((PrefixOperatorExpression) that); }
    public void visit(DecrementOp that) { visit((PrefixOperatorExpression) that); }
    public void visit(PostfixOperatorExpression that) { visit((UnaryOperatorExpression) that); }
    public void visit(PostfixIncrementOp that) { visit((PostfixOperatorExpression) that); }
    public void visit(PostfixDecrementOp that) { visit((PostfixOperatorExpression) that); }
    public void visit(ExpressionList that) { visitAny(that); }
    public void visit(Expression that) { visit((Atom) that); }
    public void visit(ParExpression that) { visit((Expression) that); }
    public void visit(Primary that) { visit((Term) that); }
    public void visit(PostfixExpression that) { visit((Primary) that); }
    public void visit(InvocationExpression that) { visit((PostfixExpression) that); }
    public void visit(ParameterizedExpression that) { visit((Primary) that); }
    public void visit(MemberOrTypeExpression that) { visit((Primary) that); }
    public void visit(ExtendedTypeExpression that) { visit((MemberOrTypeExpression) that); }
    public void visit(StaticMemberOrTypeExpression that) { visit((MemberOrTypeExpression) that); }
    public void visit(BaseMemberOrTypeExpression that) { visit((StaticMemberOrTypeExpression) that); }
    public void visit(BaseMemberExpression that) { visit((BaseMemberOrTypeExpression) that); }
    public void visit(BaseTypeExpression that) { visit((BaseMemberOrTypeExpression) that); }
    public void visit(QualifiedMemberOrTypeExpression that) { visit((StaticMemberOrTypeExpression) that); }
    public void visit(QualifiedMemberExpression that) { visit((QualifiedMemberOrTypeExpression) that); }
    public void visit(QualifiedTypeExpression that) { visit((QualifiedMemberOrTypeExpression) that); }
    public void visit(MemberOperator that) { visitAny(that); }
    public void visit(MemberOp that) { visit((MemberOperator) that); }
    public void visit(SafeMemberOp that) { visit((MemberOperator) that); }
    public void visit(SpreadOp that) { visit((MemberOperator) that); }
    public void visit(IndexExpression that) { visit((PostfixExpression) that); }
    public void visit(ElementOrRange that) { visitAny(that); }
    public void visit(Element that) { visit((ElementOrRange) that); }
    public void visit(ElementRange that) { visit((ElementOrRange) that); }
    public void visit(Outer that) { visit((Atom) that); }
    public void visit(Package that) { visit((Atom) that); }
    public void visit(ArgumentList that) { visitAny(that); }
    public void visit(NamedArgumentList that) { visit((ArgumentList) that); }
    public void visit(SequencedArgument that) { visit((StatementOrArgument) that); }
    public void visit(PositionalArgumentList that) { visit((ArgumentList) that); }
    public void visit(PositionalArgument that) { visitAny(that); }
    public void visit(ListedArgument that) { visit((PositionalArgument) that); }
    public void visit(SpreadArgument that) { visit((PositionalArgument) that); }
    public void visit(FunctionArgument that) { visit((Term) that); }
    public void visit(ObjectExpression that) { visit((Primary) that); }
    public void visit(IfExpression that) { visit((Term) that); }
    public void visit(SwitchExpression that) { visit((Term) that); }
    public void visit(NamedArgument that) { visit((StatementOrArgument) that); }
    public void visit(SpecifiedArgument that) { visit((NamedArgument) that); }
    public void visit(TypedArgument that) { visit((NamedArgument) that); }
    public void visit(MethodArgument that) { visit((TypedArgument) that); }
    public void visit(AttributeArgument that) { visit((TypedArgument) that); }
    public void visit(ObjectArgument that) { visit((TypedArgument) that); }
    public void visit(SpecifierOrInitializerExpression that) { visitAny(that); }
    public void visit(SpecifierExpression that) { visit((SpecifierOrInitializerExpression) that); }
    public void visit(LazySpecifierExpression that) { visit((SpecifierExpression) that); }
    public void visit(InitializerExpression that) { visit((SpecifierOrInitializerExpression) that); }
    public void visit(Atom that) { visit((Primary) that); }
    public void visit(Literal that) { visit((Atom) that); }
    public void visit(NaturalLiteral that) { visit((Literal) that); }
    public void visit(FloatLiteral that) { visit((Literal) that); }
    public void visit(CharLiteral that) { visit((Literal) that); }
    public void visit(StringLiteral that) { visit((Literal) that); }
    public void visit(QuotedLiteral that) { visit((Literal) that); }
    public void visit(DocLink that) { visitAny(that); }
    public void visit(SelfExpression that) { visit((Atom) that); }
    public void visit(This that) { visit((SelfExpression) that); }
    public void visit(Super that) { visit((SelfExpression) that); }
    public void visit(SequenceEnumeration that) { visit((Atom) that); }
    public void visit(Tuple that) { visit((Atom) that); }
    public void visit(Dynamic that) { visit((Atom) that); }
    public void visit(StringTemplate that) { visit((Atom) that); }
    public void visit(Annotation that) { visit((InvocationExpression) that); }
    public void visit(AnonymousAnnotation that) { visitAny(that); }
    public void visit(AnnotationList that) { visitAny(that); }
    public void visit(Identifier that) { visitAny(that); }
    public void visit(Comprehension that) { visit((PositionalArgument) that); }
    public void visit(ComprehensionClause that) { visit((ControlClause) that); }
    public void visit(InitialComprehensionClause that) { visit((ComprehensionClause) that); }
    public void visit(ExpressionComprehensionClause that) { visit((ComprehensionClause) that); }
    public void visit(ForComprehensionClause that) { visit((InitialComprehensionClause) that); }
    public void visit(IfComprehensionClause that) { visit((InitialComprehensionClause) that); }

}
