package com.redhat.ceylon.compiler.typechecker.tree;

import static com.redhat.ceylon.compiler.typechecker.tree.Tree.*;
import static com.redhat.ceylon.compiler.typechecker.tree.Tree.Package;

public abstract class VisitorAdaptor extends Visitor {

    public void handleException(Exception e, Node that) { that.handleException(e, this); }

    public void visitAny(Node that) { that.visitChildren(this); }

    public void visitCompilationUnit(CompilationUnit that) { visitAny(that); }
    @Override public final void visit(CompilationUnit that) { visitCompilationUnit(that); }
    public void visitModuleDescriptor(ModuleDescriptor that) { visitStatementOrArgument(that); }
    @Override public final void visit(ModuleDescriptor that) { visitModuleDescriptor(that); }
    public void visitPackageDescriptor(PackageDescriptor that) { visitStatementOrArgument(that); }
    @Override public final void visit(PackageDescriptor that) { visitPackageDescriptor(that); }
    public void visitImportModuleList(ImportModuleList that) { visitAny(that); }
    @Override public final void visit(ImportModuleList that) { visitImportModuleList(that); }
    public void visitImportModule(ImportModule that) { visitStatementOrArgument(that); }
    @Override public final void visit(ImportModule that) { visitImportModule(that); }
    public void visitImportList(ImportList that) { visitAny(that); }
    @Override public final void visit(ImportList that) { visitImportList(that); }
    public void visitImport(Import that) { visitStatementOrArgument(that); }
    @Override public final void visit(Import that) { visitImport(that); }
    public void visitImportPath(ImportPath that) { visitAny(that); }
    @Override public final void visit(ImportPath that) { visitImportPath(that); }
    public void visitImportMemberOrTypeList(ImportMemberOrTypeList that) { visitAny(that); }
    @Override public final void visit(ImportMemberOrTypeList that) { visitImportMemberOrTypeList(that); }
    public void visitImportMemberOrType(ImportMemberOrType that) { visitStatementOrArgument(that); }
    @Override public final void visit(ImportMemberOrType that) { visitImportMemberOrType(that); }
    public void visitImportMember(ImportMember that) { visitImportMemberOrType(that); }
    @Override public final void visit(ImportMember that) { visitImportMember(that); }
    public void visitImportType(ImportType that) { visitImportMemberOrType(that); }
    @Override public final void visit(ImportType that) { visitImportType(that); }
    public void visitAlias(Alias that) { visitAny(that); }
    @Override public final void visit(Alias that) { visitAlias(that); }
    public void visitImportWildcard(ImportWildcard that) { visitAny(that); }
    @Override public final void visit(ImportWildcard that) { visitImportWildcard(that); }
    public void visitDeclaration(Declaration that) { visitStatement(that); }
    @Override public final void visit(Declaration that) { visitDeclaration(that); }
    public void visitMissingDeclaration(MissingDeclaration that) { visitDeclaration(that); }
    @Override public final void visit(MissingDeclaration that) { visitMissingDeclaration(that); }
    public void visitTypeDeclaration(TypeDeclaration that) { visitDeclaration(that); }
    @Override public final void visit(TypeDeclaration that) { visitTypeDeclaration(that); }
    public void visitClassOrInterface(ClassOrInterface that) { visitTypeDeclaration(that); }
    @Override public final void visit(ClassOrInterface that) { visitClassOrInterface(that); }
    public void visitTypeAliasDeclaration(TypeAliasDeclaration that) { visitTypeDeclaration(that); }
    @Override public final void visit(TypeAliasDeclaration that) { visitTypeAliasDeclaration(that); }
    public void visitSatisfiedTypes(SatisfiedTypes that) { visitAny(that); }
    @Override public final void visit(SatisfiedTypes that) { visitSatisfiedTypes(that); }
    public void visitAbstractedType(AbstractedType that) { visitAny(that); }
    @Override public final void visit(AbstractedType that) { visitAbstractedType(that); }
    public void visitCaseTypes(CaseTypes that) { visitAny(that); }
    @Override public final void visit(CaseTypes that) { visitCaseTypes(that); }
    public void visitExtendedType(ExtendedType that) { visitAny(that); }
    @Override public final void visit(ExtendedType that) { visitExtendedType(that); }
    public void visitTypeConstraintList(TypeConstraintList that) { visitAny(that); }
    @Override public final void visit(TypeConstraintList that) { visitTypeConstraintList(that); }
    public void visitTypeConstraint(TypeConstraint that) { visitTypeDeclaration(that); }
    @Override public final void visit(TypeConstraint that) { visitTypeConstraint(that); }
    public void visitTypeSpecifier(TypeSpecifier that) { visitAny(that); }
    @Override public final void visit(TypeSpecifier that) { visitTypeSpecifier(that); }
    public void visitDefaultTypeArgument(DefaultTypeArgument that) { visitTypeSpecifier(that); }
    @Override public final void visit(DefaultTypeArgument that) { visitDefaultTypeArgument(that); }
    public void visitClassSpecifier(ClassSpecifier that) { visitAny(that); }
    @Override public final void visit(ClassSpecifier that) { visitClassSpecifier(that); }
    public void visitAnyClass(AnyClass that) { visitClassOrInterface(that); }
    @Override public final void visit(AnyClass that) { visitAnyClass(that); }
    public void visitClassDefinition(ClassDefinition that) { visitAnyClass(that); }
    @Override public final void visit(ClassDefinition that) { visitClassDefinition(that); }
    public void visitEnumerated(Enumerated that) { visitDeclaration(that); }
    @Override public final void visit(Enumerated that) { visitEnumerated(that); }
    public void visitConstructor(Constructor that) { visitDeclaration(that); }
    @Override public final void visit(Constructor that) { visitConstructor(that); }
    public void visitDelegatedConstructor(DelegatedConstructor that) { visitAny(that); }
    @Override public final void visit(DelegatedConstructor that) { visitDelegatedConstructor(that); }
    public void visitClassDeclaration(ClassDeclaration that) { visitAnyClass(that); }
    @Override public final void visit(ClassDeclaration that) { visitClassDeclaration(that); }
    public void visitAnyInterface(AnyInterface that) { visitClassOrInterface(that); }
    @Override public final void visit(AnyInterface that) { visitAnyInterface(that); }
    public void visitInterfaceDefinition(InterfaceDefinition that) { visitAnyInterface(that); }
    @Override public final void visit(InterfaceDefinition that) { visitInterfaceDefinition(that); }
    public void visitInterfaceDeclaration(InterfaceDeclaration that) { visitAnyInterface(that); }
    @Override public final void visit(InterfaceDeclaration that) { visitInterfaceDeclaration(that); }
    public void visitTypedDeclaration(TypedDeclaration that) { visitDeclaration(that); }
    @Override public final void visit(TypedDeclaration that) { visitTypedDeclaration(that); }
    public void visitAnyAttribute(AnyAttribute that) { visitTypedDeclaration(that); }
    @Override public final void visit(AnyAttribute that) { visitAnyAttribute(that); }
    public void visitAttributeDeclaration(AttributeDeclaration that) { visitAnyAttribute(that); }
    @Override public final void visit(AttributeDeclaration that) { visitAttributeDeclaration(that); }
    public void visitAttributeGetterDefinition(AttributeGetterDefinition that) { visitAnyAttribute(that); }
    @Override public final void visit(AttributeGetterDefinition that) { visitAttributeGetterDefinition(that); }
    public void visitAttributeSetterDefinition(AttributeSetterDefinition that) { visitTypedDeclaration(that); }
    @Override public final void visit(AttributeSetterDefinition that) { visitAttributeSetterDefinition(that); }
    public void visitAnyMethod(AnyMethod that) { visitTypedDeclaration(that); }
    @Override public final void visit(AnyMethod that) { visitAnyMethod(that); }
    public void visitMethodDefinition(MethodDefinition that) { visitAnyMethod(that); }
    @Override public final void visit(MethodDefinition that) { visitMethodDefinition(that); }
    public void visitMethodDeclaration(MethodDeclaration that) { visitAnyMethod(that); }
    @Override public final void visit(MethodDeclaration that) { visitMethodDeclaration(that); }
    public void visitVoidModifier(VoidModifier that) { visitType(that); }
    @Override public final void visit(VoidModifier that) { visitVoidModifier(that); }
    public void visitObjectDefinition(ObjectDefinition that) { visitTypedDeclaration(that); }
    @Override public final void visit(ObjectDefinition that) { visitObjectDefinition(that); }
    public void visitParameterList(ParameterList that) { visitAny(that); }
    @Override public final void visit(ParameterList that) { visitParameterList(that); }
    public void visitParameter(Parameter that) { visitAny(that); }
    @Override public final void visit(Parameter that) { visitParameter(that); }
    public void visitParameterDeclaration(ParameterDeclaration that) { visitParameter(that); }
    @Override public final void visit(ParameterDeclaration that) { visitParameterDeclaration(that); }
    public void visitValueParameterDeclaration(ValueParameterDeclaration that) { visitParameterDeclaration(that); }
    @Override public final void visit(ValueParameterDeclaration that) { visitValueParameterDeclaration(that); }
    public void visitFunctionalParameterDeclaration(FunctionalParameterDeclaration that) { visitParameterDeclaration(that); }
    @Override public final void visit(FunctionalParameterDeclaration that) { visitFunctionalParameterDeclaration(that); }
    public void visitInitializerParameter(InitializerParameter that) { visitParameter(that); }
    @Override public final void visit(InitializerParameter that) { visitInitializerParameter(that); }
    public void visitPatternParameter(PatternParameter that) { visitParameter(that); }
    @Override public final void visit(PatternParameter that) { visitPatternParameter(that); }
    public void visitTypeParameterList(TypeParameterList that) { visitAny(that); }
    @Override public final void visit(TypeParameterList that) { visitTypeParameterList(that); }
    public void visitTypeParameterDeclaration(TypeParameterDeclaration that) { visitDeclaration(that); }
    @Override public final void visit(TypeParameterDeclaration that) { visitTypeParameterDeclaration(that); }
    public void visitTypeVariance(TypeVariance that) { visitAny(that); }
    @Override public final void visit(TypeVariance that) { visitTypeVariance(that); }
    public void visitBody(Body that) { visitAny(that); }
    @Override public final void visit(Body that) { visitBody(that); }
    public void visitBlock(Block that) { visitBody(that); }
    @Override public final void visit(Block that) { visitBlock(that); }
    public void visitClassBody(ClassBody that) { visitBody(that); }
    @Override public final void visit(ClassBody that) { visitClassBody(that); }
    public void visitInterfaceBody(InterfaceBody that) { visitBody(that); }
    @Override public final void visit(InterfaceBody that) { visitInterfaceBody(that); }
    public void visitType(Type that) { visitAny(that); }
    @Override public final void visit(Type that) { visitType(that); }
    public void visitStaticType(StaticType that) { visitType(that); }
    @Override public final void visit(StaticType that) { visitStaticType(that); }
    public void visitGroupedType(GroupedType that) { visitStaticType(that); }
    @Override public final void visit(GroupedType that) { visitGroupedType(that); }
    public void visitSimpleType(SimpleType that) { visitStaticType(that); }
    @Override public final void visit(SimpleType that) { visitSimpleType(that); }
    public void visitBaseType(BaseType that) { visitSimpleType(that); }
    @Override public final void visit(BaseType that) { visitBaseType(that); }
    public void visitQualifiedType(QualifiedType that) { visitSimpleType(that); }
    @Override public final void visit(QualifiedType that) { visitQualifiedType(that); }
    public void visitUnionType(UnionType that) { visitStaticType(that); }
    @Override public final void visit(UnionType that) { visitUnionType(that); }
    public void visitIntersectionType(IntersectionType that) { visitStaticType(that); }
    @Override public final void visit(IntersectionType that) { visitIntersectionType(that); }
    public void visitSequenceType(SequenceType that) { visitStaticType(that); }
    @Override public final void visit(SequenceType that) { visitSequenceType(that); }
    public void visitIterableType(IterableType that) { visitStaticType(that); }
    @Override public final void visit(IterableType that) { visitIterableType(that); }
    public void visitOptionalType(OptionalType that) { visitStaticType(that); }
    @Override public final void visit(OptionalType that) { visitOptionalType(that); }
    public void visitTupleType(TupleType that) { visitStaticType(that); }
    @Override public final void visit(TupleType that) { visitTupleType(that); }
    public void visitFunctionType(FunctionType that) { visitStaticType(that); }
    @Override public final void visit(FunctionType that) { visitFunctionType(that); }
    public void visitEntryType(EntryType that) { visitStaticType(that); }
    @Override public final void visit(EntryType that) { visitEntryType(that); }
    public void visitTypeConstructor(TypeConstructor that) { visitStaticType(that); }
    @Override public final void visit(TypeConstructor that) { visitTypeConstructor(that); }
    public void visitSuperType(SuperType that) { visitStaticType(that); }
    @Override public final void visit(SuperType that) { visitSuperType(that); }
    public void visitMetaLiteral(MetaLiteral that) { visitPrimary(that); }
    @Override public final void visit(MetaLiteral that) { visitMetaLiteral(that); }
    public void visitTypeLiteral(TypeLiteral that) { visitMetaLiteral(that); }
    @Override public final void visit(TypeLiteral that) { visitTypeLiteral(that); }
    public void visitMemberLiteral(MemberLiteral that) { visitMetaLiteral(that); }
    @Override public final void visit(MemberLiteral that) { visitMemberLiteral(that); }
    public void visitClassLiteral(ClassLiteral that) { visitTypeLiteral(that); }
    @Override public final void visit(ClassLiteral that) { visitClassLiteral(that); }
    public void visitNewLiteral(NewLiteral that) { visitTypeLiteral(that); }
    @Override public final void visit(NewLiteral that) { visitNewLiteral(that); }
    public void visitInterfaceLiteral(InterfaceLiteral that) { visitTypeLiteral(that); }
    @Override public final void visit(InterfaceLiteral that) { visitInterfaceLiteral(that); }
    public void visitAliasLiteral(AliasLiteral that) { visitTypeLiteral(that); }
    @Override public final void visit(AliasLiteral that) { visitAliasLiteral(that); }
    public void visitTypeParameterLiteral(TypeParameterLiteral that) { visitTypeLiteral(that); }
    @Override public final void visit(TypeParameterLiteral that) { visitTypeParameterLiteral(that); }
    public void visitValueLiteral(ValueLiteral that) { visitMemberLiteral(that); }
    @Override public final void visit(ValueLiteral that) { visitValueLiteral(that); }
    public void visitFunctionLiteral(FunctionLiteral that) { visitMemberLiteral(that); }
    @Override public final void visit(FunctionLiteral that) { visitFunctionLiteral(that); }
    public void visitModuleLiteral(ModuleLiteral that) { visitMetaLiteral(that); }
    @Override public final void visit(ModuleLiteral that) { visitModuleLiteral(that); }
    public void visitPackageLiteral(PackageLiteral that) { visitMetaLiteral(that); }
    @Override public final void visit(PackageLiteral that) { visitPackageLiteral(that); }
    public void visitDynamicModifier(DynamicModifier that) { visitType(that); }
    @Override public final void visit(DynamicModifier that) { visitDynamicModifier(that); }
    public void visitLocalModifier(LocalModifier that) { visitType(that); }
    @Override public final void visit(LocalModifier that) { visitLocalModifier(that); }
    public void visitValueModifier(ValueModifier that) { visitLocalModifier(that); }
    @Override public final void visit(ValueModifier that) { visitValueModifier(that); }
    public void visitFunctionModifier(FunctionModifier that) { visitLocalModifier(that); }
    @Override public final void visit(FunctionModifier that) { visitFunctionModifier(that); }
    public void visitSyntheticVariable(SyntheticVariable that) { visitValueModifier(that); }
    @Override public final void visit(SyntheticVariable that) { visitSyntheticVariable(that); }
    public void visitTypeArguments(TypeArguments that) { visitAny(that); }
    @Override public final void visit(TypeArguments that) { visitTypeArguments(that); }
    public void visitTypeArgumentList(TypeArgumentList that) { visitTypeArguments(that); }
    @Override public final void visit(TypeArgumentList that) { visitTypeArgumentList(that); }
    public void visitInferredTypeArguments(InferredTypeArguments that) { visitTypeArguments(that); }
    @Override public final void visit(InferredTypeArguments that) { visitInferredTypeArguments(that); }
    public void visitSequencedType(SequencedType that) { visitType(that); }
    @Override public final void visit(SequencedType that) { visitSequencedType(that); }
    public void visitDefaultedType(DefaultedType that) { visitType(that); }
    @Override public final void visit(DefaultedType that) { visitDefaultedType(that); }
    public void visitSpreadType(SpreadType that) { visitType(that); }
    @Override public final void visit(SpreadType that) { visitSpreadType(that); }
    public void visitDirective(Directive that) { visitExecutableStatement(that); }
    @Override public final void visit(Directive that) { visitDirective(that); }
    public void visitReturn(Return that) { visitDirective(that); }
    @Override public final void visit(Return that) { visitReturn(that); }
    public void visitThrow(Throw that) { visitDirective(that); }
    @Override public final void visit(Throw that) { visitThrow(that); }
    public void visitContinue(Continue that) { visitDirective(that); }
    @Override public final void visit(Continue that) { visitContinue(that); }
    public void visitBreak(Break that) { visitDirective(that); }
    @Override public final void visit(Break that) { visitBreak(that); }
    public void visitStatementOrArgument(StatementOrArgument that) { visitAny(that); }
    @Override public final void visit(StatementOrArgument that) { visitStatementOrArgument(that); }
    public void visitStatement(Statement that) { visitStatementOrArgument(that); }
    @Override public final void visit(Statement that) { visitStatement(that); }
    public void visitCompilerAnnotation(CompilerAnnotation that) { visitAny(that); }
    @Override public final void visit(CompilerAnnotation that) { visitCompilerAnnotation(that); }
    public void visitExecutableStatement(ExecutableStatement that) { visitStatement(that); }
    @Override public final void visit(ExecutableStatement that) { visitExecutableStatement(that); }
    public void visitAssertion(Assertion that) { visitExecutableStatement(that); }
    @Override public final void visit(Assertion that) { visitAssertion(that); }
    public void visitSpecifierStatement(SpecifierStatement that) { visitExecutableStatement(that); }
    @Override public final void visit(SpecifierStatement that) { visitSpecifierStatement(that); }
    public void visitExpressionStatement(ExpressionStatement that) { visitExecutableStatement(that); }
    @Override public final void visit(ExpressionStatement that) { visitExpressionStatement(that); }
    public void visitPattern(Pattern that) { visitAny(that); }
    @Override public final void visit(Pattern that) { visitPattern(that); }
    public void visitVariablePattern(VariablePattern that) { visitPattern(that); }
    @Override public final void visit(VariablePattern that) { visitVariablePattern(that); }
    public void visitTuplePattern(TuplePattern that) { visitPattern(that); }
    @Override public final void visit(TuplePattern that) { visitTuplePattern(that); }
    public void visitKeyValuePattern(KeyValuePattern that) { visitPattern(that); }
    @Override public final void visit(KeyValuePattern that) { visitKeyValuePattern(that); }
    public void visitDestructure(Destructure that) { visitExecutableStatement(that); }
    @Override public final void visit(Destructure that) { visitDestructure(that); }
    public void visitControlStatement(ControlStatement that) { visitExecutableStatement(that); }
    @Override public final void visit(ControlStatement that) { visitControlStatement(that); }
    public void visitControlClause(ControlClause that) { visitAny(that); }
    @Override public final void visit(ControlClause that) { visitControlClause(that); }
    public void visitDynamicStatement(DynamicStatement that) { visitControlStatement(that); }
    @Override public final void visit(DynamicStatement that) { visitDynamicStatement(that); }
    public void visitDynamicClause(DynamicClause that) { visitControlClause(that); }
    @Override public final void visit(DynamicClause that) { visitDynamicClause(that); }
    public void visitLetExpression(LetExpression that) { visitTerm(that); }
    @Override public final void visit(LetExpression that) { visitLetExpression(that); }
    public void visitLetClause(LetClause that) { visitControlClause(that); }
    @Override public final void visit(LetClause that) { visitLetClause(that); }
    public void visitIfStatement(IfStatement that) { visitControlStatement(that); }
    @Override public final void visit(IfStatement that) { visitIfStatement(that); }
    public void visitIfClause(IfClause that) { visitControlClause(that); }
    @Override public final void visit(IfClause that) { visitIfClause(that); }
    public void visitElseClause(ElseClause that) { visitControlClause(that); }
    @Override public final void visit(ElseClause that) { visitElseClause(that); }
    public void visitSwitchStatement(SwitchStatement that) { visitControlStatement(that); }
    @Override public final void visit(SwitchStatement that) { visitSwitchStatement(that); }
    public void visitSwitchClause(SwitchClause that) { visitAny(that); }
    @Override public final void visit(SwitchClause that) { visitSwitchClause(that); }
    public void visitSwitched(Switched that) { visitAny(that); }
    @Override public final void visit(Switched that) { visitSwitched(that); }
    public void visitSwitchCaseList(SwitchCaseList that) { visitAny(that); }
    @Override public final void visit(SwitchCaseList that) { visitSwitchCaseList(that); }
    public void visitCaseClause(CaseClause that) { visitControlClause(that); }
    @Override public final void visit(CaseClause that) { visitCaseClause(that); }
    public void visitCaseItem(CaseItem that) { visitAny(that); }
    @Override public final void visit(CaseItem that) { visitCaseItem(that); }
    public void visitMatchCase(MatchCase that) { visitCaseItem(that); }
    @Override public final void visit(MatchCase that) { visitMatchCase(that); }
    public void visitIsCase(IsCase that) { visitCaseItem(that); }
    @Override public final void visit(IsCase that) { visitIsCase(that); }
    public void visitPatternCase(PatternCase that) { visitCaseItem(that); }
    @Override public final void visit(PatternCase that) { visitPatternCase(that); }
    public void visitSatisfiesCase(SatisfiesCase that) { visitCaseItem(that); }
    @Override public final void visit(SatisfiesCase that) { visitSatisfiesCase(that); }
    public void visitTryCatchStatement(TryCatchStatement that) { visitControlStatement(that); }
    @Override public final void visit(TryCatchStatement that) { visitTryCatchStatement(that); }
    public void visitTryClause(TryClause that) { visitControlClause(that); }
    @Override public final void visit(TryClause that) { visitTryClause(that); }
    public void visitCatchClause(CatchClause that) { visitControlClause(that); }
    @Override public final void visit(CatchClause that) { visitCatchClause(that); }
    public void visitFinallyClause(FinallyClause that) { visitControlClause(that); }
    @Override public final void visit(FinallyClause that) { visitFinallyClause(that); }
    public void visitResourceList(ResourceList that) { visitAny(that); }
    @Override public final void visit(ResourceList that) { visitResourceList(that); }
    public void visitResource(Resource that) { visitAny(that); }
    @Override public final void visit(Resource that) { visitResource(that); }
    public void visitCatchVariable(CatchVariable that) { visitAny(that); }
    @Override public final void visit(CatchVariable that) { visitCatchVariable(that); }
    public void visitForStatement(ForStatement that) { visitControlStatement(that); }
    @Override public final void visit(ForStatement that) { visitForStatement(that); }
    public void visitForClause(ForClause that) { visitControlClause(that); }
    @Override public final void visit(ForClause that) { visitForClause(that); }
    public void visitForIterator(ForIterator that) { visitStatementOrArgument(that); }
    @Override public final void visit(ForIterator that) { visitForIterator(that); }
    public void visitValueIterator(ValueIterator that) { visitForIterator(that); }
    @Override public final void visit(ValueIterator that) { visitValueIterator(that); }
    public void visitPatternIterator(PatternIterator that) { visitForIterator(that); }
    @Override public final void visit(PatternIterator that) { visitPatternIterator(that); }
    public void visitWhileStatement(WhileStatement that) { visitControlStatement(that); }
    @Override public final void visit(WhileStatement that) { visitWhileStatement(that); }
    public void visitWhileClause(WhileClause that) { visitControlClause(that); }
    @Override public final void visit(WhileClause that) { visitWhileClause(that); }
    public void visitConditionList(ConditionList that) { visitAny(that); }
    @Override public final void visit(ConditionList that) { visitConditionList(that); }
    public void visitCondition(Condition that) { visitAny(that); }
    @Override public final void visit(Condition that) { visitCondition(that); }
    public void visitBooleanCondition(BooleanCondition that) { visitCondition(that); }
    @Override public final void visit(BooleanCondition that) { visitBooleanCondition(that); }
    public void visitExistsOrNonemptyCondition(ExistsOrNonemptyCondition that) { visitCondition(that); }
    @Override public final void visit(ExistsOrNonemptyCondition that) { visitExistsOrNonemptyCondition(that); }
    public void visitExistsCondition(ExistsCondition that) { visitExistsOrNonemptyCondition(that); }
    @Override public final void visit(ExistsCondition that) { visitExistsCondition(that); }
    public void visitNonemptyCondition(NonemptyCondition that) { visitExistsOrNonemptyCondition(that); }
    @Override public final void visit(NonemptyCondition that) { visitNonemptyCondition(that); }
    public void visitIsCondition(IsCondition that) { visitCondition(that); }
    @Override public final void visit(IsCondition that) { visitIsCondition(that); }
    public void visitSatisfiesCondition(SatisfiesCondition that) { visitCondition(that); }
    @Override public final void visit(SatisfiesCondition that) { visitSatisfiesCondition(that); }
    public void visitVariable(Variable that) { visitTypedDeclaration(that); }
    @Override public final void visit(Variable that) { visitVariable(that); }
    public void visitTerm(Term that) { visitAny(that); }
    @Override public final void visit(Term that) { visitTerm(that); }
    public void visitOperatorExpression(OperatorExpression that) { visitTerm(that); }
    @Override public final void visit(OperatorExpression that) { visitOperatorExpression(that); }
    public void visitBinaryOperatorExpression(BinaryOperatorExpression that) { visitOperatorExpression(that); }
    @Override public final void visit(BinaryOperatorExpression that) { visitBinaryOperatorExpression(that); }
    public void visitArithmeticOp(ArithmeticOp that) { visitBinaryOperatorExpression(that); }
    @Override public final void visit(ArithmeticOp that) { visitArithmeticOp(that); }
    public void visitSumOp(SumOp that) { visitArithmeticOp(that); }
    @Override public final void visit(SumOp that) { visitSumOp(that); }
    public void visitDifferenceOp(DifferenceOp that) { visitArithmeticOp(that); }
    @Override public final void visit(DifferenceOp that) { visitDifferenceOp(that); }
    public void visitProductOp(ProductOp that) { visitArithmeticOp(that); }
    @Override public final void visit(ProductOp that) { visitProductOp(that); }
    public void visitQuotientOp(QuotientOp that) { visitArithmeticOp(that); }
    @Override public final void visit(QuotientOp that) { visitQuotientOp(that); }
    public void visitPowerOp(PowerOp that) { visitArithmeticOp(that); }
    @Override public final void visit(PowerOp that) { visitPowerOp(that); }
    public void visitRemainderOp(RemainderOp that) { visitArithmeticOp(that); }
    @Override public final void visit(RemainderOp that) { visitRemainderOp(that); }
    public void visitAssignmentOp(AssignmentOp that) { visitBinaryOperatorExpression(that); }
    @Override public final void visit(AssignmentOp that) { visitAssignmentOp(that); }
    public void visitAssignOp(AssignOp that) { visitAssignmentOp(that); }
    @Override public final void visit(AssignOp that) { visitAssignOp(that); }
    public void visitArithmeticAssignmentOp(ArithmeticAssignmentOp that) { visitAssignmentOp(that); }
    @Override public final void visit(ArithmeticAssignmentOp that) { visitArithmeticAssignmentOp(that); }
    public void visitAddAssignOp(AddAssignOp that) { visitArithmeticAssignmentOp(that); }
    @Override public final void visit(AddAssignOp that) { visitAddAssignOp(that); }
    public void visitSubtractAssignOp(SubtractAssignOp that) { visitArithmeticAssignmentOp(that); }
    @Override public final void visit(SubtractAssignOp that) { visitSubtractAssignOp(that); }
    public void visitMultiplyAssignOp(MultiplyAssignOp that) { visitArithmeticAssignmentOp(that); }
    @Override public final void visit(MultiplyAssignOp that) { visitMultiplyAssignOp(that); }
    public void visitDivideAssignOp(DivideAssignOp that) { visitArithmeticAssignmentOp(that); }
    @Override public final void visit(DivideAssignOp that) { visitDivideAssignOp(that); }
    public void visitRemainderAssignOp(RemainderAssignOp that) { visitArithmeticAssignmentOp(that); }
    @Override public final void visit(RemainderAssignOp that) { visitRemainderAssignOp(that); }
    public void visitBitwiseAssignmentOp(BitwiseAssignmentOp that) { visitAssignmentOp(that); }
    @Override public final void visit(BitwiseAssignmentOp that) { visitBitwiseAssignmentOp(that); }
    public void visitIntersectAssignOp(IntersectAssignOp that) { visitBitwiseAssignmentOp(that); }
    @Override public final void visit(IntersectAssignOp that) { visitIntersectAssignOp(that); }
    public void visitUnionAssignOp(UnionAssignOp that) { visitBitwiseAssignmentOp(that); }
    @Override public final void visit(UnionAssignOp that) { visitUnionAssignOp(that); }
    public void visitComplementAssignOp(ComplementAssignOp that) { visitBitwiseAssignmentOp(that); }
    @Override public final void visit(ComplementAssignOp that) { visitComplementAssignOp(that); }
    public void visitLogicalAssignmentOp(LogicalAssignmentOp that) { visitAssignmentOp(that); }
    @Override public final void visit(LogicalAssignmentOp that) { visitLogicalAssignmentOp(that); }
    public void visitAndAssignOp(AndAssignOp that) { visitLogicalAssignmentOp(that); }
    @Override public final void visit(AndAssignOp that) { visitAndAssignOp(that); }
    public void visitOrAssignOp(OrAssignOp that) { visitLogicalAssignmentOp(that); }
    @Override public final void visit(OrAssignOp that) { visitOrAssignOp(that); }
    public void visitLogicalOp(LogicalOp that) { visitBinaryOperatorExpression(that); }
    @Override public final void visit(LogicalOp that) { visitLogicalOp(that); }
    public void visitAndOp(AndOp that) { visitLogicalOp(that); }
    @Override public final void visit(AndOp that) { visitAndOp(that); }
    public void visitOrOp(OrOp that) { visitLogicalOp(that); }
    @Override public final void visit(OrOp that) { visitOrOp(that); }
    public void visitBitwiseOp(BitwiseOp that) { visitBinaryOperatorExpression(that); }
    @Override public final void visit(BitwiseOp that) { visitBitwiseOp(that); }
    public void visitIntersectionOp(IntersectionOp that) { visitBitwiseOp(that); }
    @Override public final void visit(IntersectionOp that) { visitIntersectionOp(that); }
    public void visitUnionOp(UnionOp that) { visitBitwiseOp(that); }
    @Override public final void visit(UnionOp that) { visitUnionOp(that); }
    public void visitComplementOp(ComplementOp that) { visitBitwiseOp(that); }
    @Override public final void visit(ComplementOp that) { visitComplementOp(that); }
    public void visitEqualityOp(EqualityOp that) { visitBinaryOperatorExpression(that); }
    @Override public final void visit(EqualityOp that) { visitEqualityOp(that); }
    public void visitEqualOp(EqualOp that) { visitEqualityOp(that); }
    @Override public final void visit(EqualOp that) { visitEqualOp(that); }
    public void visitNotEqualOp(NotEqualOp that) { visitEqualityOp(that); }
    @Override public final void visit(NotEqualOp that) { visitNotEqualOp(that); }
    public void visitComparisonOp(ComparisonOp that) { visitBinaryOperatorExpression(that); }
    @Override public final void visit(ComparisonOp that) { visitComparisonOp(that); }
    public void visitLargerOp(LargerOp that) { visitComparisonOp(that); }
    @Override public final void visit(LargerOp that) { visitLargerOp(that); }
    public void visitSmallerOp(SmallerOp that) { visitComparisonOp(that); }
    @Override public final void visit(SmallerOp that) { visitSmallerOp(that); }
    public void visitLargeAsOp(LargeAsOp that) { visitComparisonOp(that); }
    @Override public final void visit(LargeAsOp that) { visitLargeAsOp(that); }
    public void visitSmallAsOp(SmallAsOp that) { visitComparisonOp(that); }
    @Override public final void visit(SmallAsOp that) { visitSmallAsOp(that); }
    public void visitScaleOp(ScaleOp that) { visitBinaryOperatorExpression(that); }
    @Override public final void visit(ScaleOp that) { visitScaleOp(that); }
    public void visitBound(Bound that) { visitTerm(that); }
    @Override public final void visit(Bound that) { visitBound(that); }
    public void visitOpenBound(OpenBound that) { visitBound(that); }
    @Override public final void visit(OpenBound that) { visitOpenBound(that); }
    public void visitClosedBound(ClosedBound that) { visitBound(that); }
    @Override public final void visit(ClosedBound that) { visitClosedBound(that); }
    public void visitWithinOp(WithinOp that) { visitOperatorExpression(that); }
    @Override public final void visit(WithinOp that) { visitWithinOp(that); }
    public void visitDefaultOp(DefaultOp that) { visitBinaryOperatorExpression(that); }
    @Override public final void visit(DefaultOp that) { visitDefaultOp(that); }
    public void visitThenOp(ThenOp that) { visitBinaryOperatorExpression(that); }
    @Override public final void visit(ThenOp that) { visitThenOp(that); }
    public void visitIdenticalOp(IdenticalOp that) { visitBinaryOperatorExpression(that); }
    @Override public final void visit(IdenticalOp that) { visitIdenticalOp(that); }
    public void visitEntryOp(EntryOp that) { visitBinaryOperatorExpression(that); }
    @Override public final void visit(EntryOp that) { visitEntryOp(that); }
    public void visitRangeOp(RangeOp that) { visitBinaryOperatorExpression(that); }
    @Override public final void visit(RangeOp that) { visitRangeOp(that); }
    public void visitSegmentOp(SegmentOp that) { visitBinaryOperatorExpression(that); }
    @Override public final void visit(SegmentOp that) { visitSegmentOp(that); }
    public void visitCompareOp(CompareOp that) { visitBinaryOperatorExpression(that); }
    @Override public final void visit(CompareOp that) { visitCompareOp(that); }
    public void visitInOp(InOp that) { visitBinaryOperatorExpression(that); }
    @Override public final void visit(InOp that) { visitInOp(that); }
    public void visitUnaryOperatorExpression(UnaryOperatorExpression that) { visitOperatorExpression(that); }
    @Override public final void visit(UnaryOperatorExpression that) { visitUnaryOperatorExpression(that); }
    public void visitNotOp(NotOp that) { visitUnaryOperatorExpression(that); }
    @Override public final void visit(NotOp that) { visitNotOp(that); }
    public void visitExists(Exists that) { visitUnaryOperatorExpression(that); }
    @Override public final void visit(Exists that) { visitExists(that); }
    public void visitNonempty(Nonempty that) { visitUnaryOperatorExpression(that); }
    @Override public final void visit(Nonempty that) { visitNonempty(that); }
    public void visitNegativeOp(NegativeOp that) { visitUnaryOperatorExpression(that); }
    @Override public final void visit(NegativeOp that) { visitNegativeOp(that); }
    public void visitPositiveOp(PositiveOp that) { visitUnaryOperatorExpression(that); }
    @Override public final void visit(PositiveOp that) { visitPositiveOp(that); }
    public void visitTypeOperatorExpression(TypeOperatorExpression that) { visitUnaryOperatorExpression(that); }
    @Override public final void visit(TypeOperatorExpression that) { visitTypeOperatorExpression(that); }
    public void visitIsOp(IsOp that) { visitTypeOperatorExpression(that); }
    @Override public final void visit(IsOp that) { visitIsOp(that); }
    public void visitSatisfies(Satisfies that) { visitTypeOperatorExpression(that); }
    @Override public final void visit(Satisfies that) { visitSatisfies(that); }
    public void visitExtends(Extends that) { visitTypeOperatorExpression(that); }
    @Override public final void visit(Extends that) { visitExtends(that); }
    public void visitOfOp(OfOp that) { visitTypeOperatorExpression(that); }
    @Override public final void visit(OfOp that) { visitOfOp(that); }
    public void visitPrefixOperatorExpression(PrefixOperatorExpression that) { visitUnaryOperatorExpression(that); }
    @Override public final void visit(PrefixOperatorExpression that) { visitPrefixOperatorExpression(that); }
    public void visitIncrementOp(IncrementOp that) { visitPrefixOperatorExpression(that); }
    @Override public final void visit(IncrementOp that) { visitIncrementOp(that); }
    public void visitDecrementOp(DecrementOp that) { visitPrefixOperatorExpression(that); }
    @Override public final void visit(DecrementOp that) { visitDecrementOp(that); }
    public void visitPostfixOperatorExpression(PostfixOperatorExpression that) { visitUnaryOperatorExpression(that); }
    @Override public final void visit(PostfixOperatorExpression that) { visitPostfixOperatorExpression(that); }
    public void visitPostfixIncrementOp(PostfixIncrementOp that) { visitPostfixOperatorExpression(that); }
    @Override public final void visit(PostfixIncrementOp that) { visitPostfixIncrementOp(that); }
    public void visitPostfixDecrementOp(PostfixDecrementOp that) { visitPostfixOperatorExpression(that); }
    @Override public final void visit(PostfixDecrementOp that) { visitPostfixDecrementOp(that); }
    public void visitExpressionList(ExpressionList that) { visitAny(that); }
    @Override public final void visit(ExpressionList that) { visitExpressionList(that); }
    public void visitExpression(Expression that) { visitAtom(that); }
    @Override public final void visit(Expression that) { visitExpression(that); }
    public void visitParExpression(ParExpression that) { visitExpression(that); }
    @Override public final void visit(ParExpression that) { visitParExpression(that); }
    public void visitPrimary(Primary that) { visitTerm(that); }
    @Override public final void visit(Primary that) { visitPrimary(that); }
    public void visitPostfixExpression(PostfixExpression that) { visitPrimary(that); }
    @Override public final void visit(PostfixExpression that) { visitPostfixExpression(that); }
    public void visitInvocationExpression(InvocationExpression that) { visitPostfixExpression(that); }
    @Override public final void visit(InvocationExpression that) { visitInvocationExpression(that); }
    public void visitParameterizedExpression(ParameterizedExpression that) { visitPrimary(that); }
    @Override public final void visit(ParameterizedExpression that) { visitParameterizedExpression(that); }
    public void visitMemberOrTypeExpression(MemberOrTypeExpression that) { visitPrimary(that); }
    @Override public final void visit(MemberOrTypeExpression that) { visitMemberOrTypeExpression(that); }
    public void visitExtendedTypeExpression(ExtendedTypeExpression that) { visitMemberOrTypeExpression(that); }
    @Override public final void visit(ExtendedTypeExpression that) { visitExtendedTypeExpression(that); }
    public void visitStaticMemberOrTypeExpression(StaticMemberOrTypeExpression that) { visitMemberOrTypeExpression(that); }
    @Override public final void visit(StaticMemberOrTypeExpression that) { visitStaticMemberOrTypeExpression(that); }
    public void visitBaseMemberOrTypeExpression(BaseMemberOrTypeExpression that) { visitStaticMemberOrTypeExpression(that); }
    @Override public final void visit(BaseMemberOrTypeExpression that) { visitBaseMemberOrTypeExpression(that); }
    public void visitBaseMemberExpression(BaseMemberExpression that) { visitBaseMemberOrTypeExpression(that); }
    @Override public final void visit(BaseMemberExpression that) { visitBaseMemberExpression(that); }
    public void visitBaseTypeExpression(BaseTypeExpression that) { visitBaseMemberOrTypeExpression(that); }
    @Override public final void visit(BaseTypeExpression that) { visitBaseTypeExpression(that); }
    public void visitQualifiedMemberOrTypeExpression(QualifiedMemberOrTypeExpression that) { visitStaticMemberOrTypeExpression(that); }
    @Override public final void visit(QualifiedMemberOrTypeExpression that) { visitQualifiedMemberOrTypeExpression(that); }
    public void visitQualifiedMemberExpression(QualifiedMemberExpression that) { visitQualifiedMemberOrTypeExpression(that); }
    @Override public final void visit(QualifiedMemberExpression that) { visitQualifiedMemberExpression(that); }
    public void visitQualifiedTypeExpression(QualifiedTypeExpression that) { visitQualifiedMemberOrTypeExpression(that); }
    @Override public final void visit(QualifiedTypeExpression that) { visitQualifiedTypeExpression(that); }
    public void visitMemberOperator(MemberOperator that) { visitAny(that); }
    @Override public final void visit(MemberOperator that) { visitMemberOperator(that); }
    public void visitMemberOp(MemberOp that) { visitMemberOperator(that); }
    @Override public final void visit(MemberOp that) { visitMemberOp(that); }
    public void visitSafeMemberOp(SafeMemberOp that) { visitMemberOperator(that); }
    @Override public final void visit(SafeMemberOp that) { visitSafeMemberOp(that); }
    public void visitSpreadOp(SpreadOp that) { visitMemberOperator(that); }
    @Override public final void visit(SpreadOp that) { visitSpreadOp(that); }
    public void visitIndexExpression(IndexExpression that) { visitPostfixExpression(that); }
    @Override public final void visit(IndexExpression that) { visitIndexExpression(that); }
    public void visitElementOrRange(ElementOrRange that) { visitAny(that); }
    @Override public final void visit(ElementOrRange that) { visitElementOrRange(that); }
    public void visitElement(Element that) { visitElementOrRange(that); }
    @Override public final void visit(Element that) { visitElement(that); }
    public void visitElementRange(ElementRange that) { visitElementOrRange(that); }
    @Override public final void visit(ElementRange that) { visitElementRange(that); }
    public void visitOuter(Outer that) { visitAtom(that); }
    @Override public final void visit(Outer that) { visitOuter(that); }
    public void visitPackage(Package that) { visitAtom(that); }
    @Override public final void visit(Package that) { visitPackage(that); }
    public void visitArgumentList(ArgumentList that) { visitAny(that); }
    @Override public final void visit(ArgumentList that) { visitArgumentList(that); }
    public void visitNamedArgumentList(NamedArgumentList that) { visitArgumentList(that); }
    @Override public final void visit(NamedArgumentList that) { visitNamedArgumentList(that); }
    public void visitSequencedArgument(SequencedArgument that) { visitStatementOrArgument(that); }
    @Override public final void visit(SequencedArgument that) { visitSequencedArgument(that); }
    public void visitPositionalArgumentList(PositionalArgumentList that) { visitArgumentList(that); }
    @Override public final void visit(PositionalArgumentList that) { visitPositionalArgumentList(that); }
    public void visitPositionalArgument(PositionalArgument that) { visitAny(that); }
    @Override public final void visit(PositionalArgument that) { visitPositionalArgument(that); }
    public void visitListedArgument(ListedArgument that) { visitPositionalArgument(that); }
    @Override public final void visit(ListedArgument that) { visitListedArgument(that); }
    public void visitSpreadArgument(SpreadArgument that) { visitPositionalArgument(that); }
    @Override public final void visit(SpreadArgument that) { visitSpreadArgument(that); }
    public void visitFunctionArgument(FunctionArgument that) { visitTerm(that); }
    @Override public final void visit(FunctionArgument that) { visitFunctionArgument(that); }
    public void visitObjectExpression(ObjectExpression that) { visitPrimary(that); }
    @Override public final void visit(ObjectExpression that) { visitObjectExpression(that); }
    public void visitIfExpression(IfExpression that) { visitTerm(that); }
    @Override public final void visit(IfExpression that) { visitIfExpression(that); }
    public void visitSwitchExpression(SwitchExpression that) { visitTerm(that); }
    @Override public final void visit(SwitchExpression that) { visitSwitchExpression(that); }
    public void visitNamedArgument(NamedArgument that) { visitStatementOrArgument(that); }
    @Override public final void visit(NamedArgument that) { visitNamedArgument(that); }
    public void visitSpecifiedArgument(SpecifiedArgument that) { visitNamedArgument(that); }
    @Override public final void visit(SpecifiedArgument that) { visitSpecifiedArgument(that); }
    public void visitTypedArgument(TypedArgument that) { visitNamedArgument(that); }
    @Override public final void visit(TypedArgument that) { visitTypedArgument(that); }
    public void visitMethodArgument(MethodArgument that) { visitTypedArgument(that); }
    @Override public final void visit(MethodArgument that) { visitMethodArgument(that); }
    public void visitAttributeArgument(AttributeArgument that) { visitTypedArgument(that); }
    @Override public final void visit(AttributeArgument that) { visitAttributeArgument(that); }
    public void visitObjectArgument(ObjectArgument that) { visitTypedArgument(that); }
    @Override public final void visit(ObjectArgument that) { visitObjectArgument(that); }
    public void visitSpecifierOrInitializerExpression(SpecifierOrInitializerExpression that) { visitAny(that); }
    @Override public final void visit(SpecifierOrInitializerExpression that) { visitSpecifierOrInitializerExpression(that); }
    public void visitSpecifierExpression(SpecifierExpression that) { visitSpecifierOrInitializerExpression(that); }
    @Override public final void visit(SpecifierExpression that) { visitSpecifierExpression(that); }
    public void visitLazySpecifierExpression(LazySpecifierExpression that) { visitSpecifierExpression(that); }
    @Override public final void visit(LazySpecifierExpression that) { visitLazySpecifierExpression(that); }
    public void visitInitializerExpression(InitializerExpression that) { visitSpecifierOrInitializerExpression(that); }
    @Override public final void visit(InitializerExpression that) { visitInitializerExpression(that); }
    public void visitAtom(Atom that) { visitPrimary(that); }
    @Override public final void visit(Atom that) { visitAtom(that); }
    public void visitLiteral(Literal that) { visitAtom(that); }
    @Override public final void visit(Literal that) { visitLiteral(that); }
    public void visitNaturalLiteral(NaturalLiteral that) { visitLiteral(that); }
    @Override public final void visit(NaturalLiteral that) { visitNaturalLiteral(that); }
    public void visitFloatLiteral(FloatLiteral that) { visitLiteral(that); }
    @Override public final void visit(FloatLiteral that) { visitFloatLiteral(that); }
    public void visitCharLiteral(CharLiteral that) { visitLiteral(that); }
    @Override public final void visit(CharLiteral that) { visitCharLiteral(that); }
    public void visitStringLiteral(StringLiteral that) { visitLiteral(that); }
    @Override public final void visit(StringLiteral that) { visitStringLiteral(that); }
    public void visitQuotedLiteral(QuotedLiteral that) { visitLiteral(that); }
    @Override public final void visit(QuotedLiteral that) { visitQuotedLiteral(that); }
    public void visitDocLink(DocLink that) { visitAny(that); }
    @Override public final void visit(DocLink that) { visitDocLink(that); }
    public void visitSelfExpression(SelfExpression that) { visitAtom(that); }
    @Override public final void visit(SelfExpression that) { visitSelfExpression(that); }
    public void visitThis(This that) { visitSelfExpression(that); }
    @Override public final void visit(This that) { visitThis(that); }
    public void visitSuper(Super that) { visitSelfExpression(that); }
    @Override public final void visit(Super that) { visitSuper(that); }
    public void visitSequenceEnumeration(SequenceEnumeration that) { visitAtom(that); }
    @Override public final void visit(SequenceEnumeration that) { visitSequenceEnumeration(that); }
    public void visitTuple(Tuple that) { visitAtom(that); }
    @Override public final void visit(Tuple that) { visitTuple(that); }
    public void visitDynamic(Dynamic that) { visitAtom(that); }
    @Override public final void visit(Dynamic that) { visitDynamic(that); }
    public void visitStringTemplate(StringTemplate that) { visitAtom(that); }
    @Override public final void visit(StringTemplate that) { visitStringTemplate(that); }
    public void visitAnnotation(Annotation that) { visitInvocationExpression(that); }
    @Override public final void visit(Annotation that) { visitAnnotation(that); }
    public void visitAnonymousAnnotation(AnonymousAnnotation that) { visitAny(that); }
    @Override public final void visit(AnonymousAnnotation that) { visitAnonymousAnnotation(that); }
    public void visitAnnotationList(AnnotationList that) { visitAny(that); }
    @Override public final void visit(AnnotationList that) { visitAnnotationList(that); }
    public void visitIdentifier(Identifier that) { visitAny(that); }
    @Override public final void visit(Identifier that) { visitIdentifier(that); }
    public void visitComprehension(Comprehension that) { visitPositionalArgument(that); }
    @Override public final void visit(Comprehension that) { visitComprehension(that); }
    public void visitComprehensionClause(ComprehensionClause that) { visitControlClause(that); }
    @Override public final void visit(ComprehensionClause that) { visitComprehensionClause(that); }
    public void visitInitialComprehensionClause(InitialComprehensionClause that) { visitComprehensionClause(that); }
    @Override public final void visit(InitialComprehensionClause that) { visitInitialComprehensionClause(that); }
    public void visitExpressionComprehensionClause(ExpressionComprehensionClause that) { visitComprehensionClause(that); }
    @Override public final void visit(ExpressionComprehensionClause that) { visitExpressionComprehensionClause(that); }
    public void visitForComprehensionClause(ForComprehensionClause that) { visitInitialComprehensionClause(that); }
    @Override public final void visit(ForComprehensionClause that) { visitForComprehensionClause(that); }
    public void visitIfComprehensionClause(IfComprehensionClause that) { visitInitialComprehensionClause(that); }
    @Override public final void visit(IfComprehensionClause that) { visitIfComprehensionClause(that); }

}
