package com.redhat.ceylon.model.loader.model;

import java.util.EnumSet;
import java.util.List;

import com.redhat.ceylon.model.loader.ModelCompleter;
import com.redhat.ceylon.model.typechecker.model.Class;
import com.redhat.ceylon.model.typechecker.model.Declaration;
import com.redhat.ceylon.model.typechecker.model.ParameterList;

/**
 * Used for annotation proxies for interop.
 * 
 * The completer only sets members and parameterlist, so we only load on access of those
 *
 * @author Stéphane Épardaud <stef@epardaud.fr>
 */
public class AnnotationProxyClass extends Class {

    public final LazyInterface iface;
    private ModelCompleter completer;
    private boolean isLoaded2;
    private boolean isLoaded;

    public AnnotationProxyClass(ModelCompleter completer, LazyInterface iface) {
        this.iface = iface;
        this.completer = completer;
    }

    @Override
    public List<Declaration> getMembers() {
        load();
        return super.getMembers();
    }
    
    @Override
    public ParameterList getParameterList() {
        // getParameterLists() depends on this, so we cover both in one override
        load();
        return super.getParameterList();
    }
    
    @Override
    public boolean isSealed() {
        // super.isSealed depends on the parameter list
        load();
        return super.isSealed();
    }

    private void load() {
        if(!isLoaded2){
            completer.synchronizedRun(new Runnable() {
                @Override
                public void run() {
                    if(!isLoaded){
                        isLoaded = true;
                        completer.complete(AnnotationProxyClass.this);
                        isLoaded2 = true;
                    }
                }
            });
        }
    }

    @Override
    public boolean isJava() {
        return true;
    }
}
