/*
 * Decompiled with CFR 0.152.
 */
package ceylon.language;

import ceylon.language.AliasesAnnotation$annotation$;
import ceylon.language.Array;
import ceylon.language.AssertionError;
import ceylon.language.Binary;
import ceylon.language.Binary$impl;
import ceylon.language.Character;
import ceylon.language.Comparable$impl;
import ceylon.language.Comparison;
import ceylon.language.Enumerable$impl;
import ceylon.language.Exponentiable;
import ceylon.language.FinalAnnotation$annotation$;
import ceylon.language.Float;
import ceylon.language.Integral;
import ceylon.language.Integral$impl;
import ceylon.language.Invertible$impl;
import ceylon.language.Iterable;
import ceylon.language.Iterator;
import ceylon.language.List;
import ceylon.language.NativeAnnotation$annotation$;
import ceylon.language.Number$impl;
import ceylon.language.OverflowException;
import ceylon.language.SharedAnnotation$annotation$;
import ceylon.language.StaticAnnotation$annotation$;
import ceylon.language.equal_;
import ceylon.language.finished_;
import ceylon.language.formatInteger_;
import ceylon.language.larger_;
import ceylon.language.parseIntegerInternal_;
import ceylon.language.smaller_;
import com.redhat.ceylon.compiler.java.Util;
import com.redhat.ceylon.compiler.java.metadata.Ceylon;
import com.redhat.ceylon.compiler.java.metadata.Class;
import com.redhat.ceylon.compiler.java.metadata.Defaulted;
import com.redhat.ceylon.compiler.java.metadata.Ignore;
import com.redhat.ceylon.compiler.java.metadata.Name;
import com.redhat.ceylon.compiler.java.metadata.SatisfiedTypes;
import com.redhat.ceylon.compiler.java.metadata.Transient;
import com.redhat.ceylon.compiler.java.metadata.TypeInfo;
import com.redhat.ceylon.compiler.java.metadata.TypeParameter;
import com.redhat.ceylon.compiler.java.metadata.TypeParameters;
import com.redhat.ceylon.compiler.java.metadata.ValueType;
import com.redhat.ceylon.compiler.java.runtime.model.ReifiedType;
import com.redhat.ceylon.compiler.java.runtime.model.TypeDescriptor;
import java.io.Serializable;

@Ceylon(major=8)
@SatisfiedTypes(value={"ceylon.language::Integral<ceylon.language::Integer>", "ceylon.language::Binary<ceylon.language::Integer>", "ceylon.language::Exponentiable<ceylon.language::Integer,ceylon.language::Integer>"})
@Class(extendsType="ceylon.language::Object", basic=false, identifiable=false, constructors=true)
@ValueType
@SharedAnnotation$annotation$
@FinalAnnotation$annotation$
@NativeAnnotation$annotation$(backends={})
public final class Integer
implements Integral<Integer>,
Binary<Integer>,
Exponentiable<Integer, Integer>,
ReifiedType,
Serializable,
Comparable<Integer> {
    private static final long serialVersionUID = 3611850372864102202L;
    static final long TWO_FIFTY_THREE = 0x20000000000000L;
    @Ignore
    public static final TypeDescriptor $TypeDescriptor$ = TypeDescriptor.klass(Integer.class, new TypeDescriptor[0]);
    @Ignore
    final long value;
    private static final long POWER_BY_SQUARING_BREAKEVEN = 6L;

    public static long sum(@TypeInfo(value="{ceylon.language::Integer*}") @Name(value="integers") Iterable<? extends Integer, ? extends Object> integers) {
        Object o;
        if (integers instanceof Array) {
            Object array = ((Array)integers).toArray();
            if (array instanceof int[]) {
                long sum = 0L;
                int[] intArray = (int[])array;
                int s = intArray.length;
                for (int i = 0; i < s; ++i) {
                    sum += (long)intArray[i];
                }
                return sum;
            }
            if (array instanceof long[]) {
                long sum = 0L;
                long[] longArray = (long[])array;
                int s = longArray.length;
                for (int i = 0; i < s; ++i) {
                    sum += longArray[i];
                }
                return sum;
            }
        }
        if (integers instanceof List) {
            List list = (List)integers;
            long size = list.getSize();
            long sum = 0L;
            int i = 0;
            while ((long)i < size) {
                sum += ((Integer)list.getFromFirst((long)((long)i))).value;
                ++i;
            }
            return sum;
        }
        long sum = 0L;
        Iterator<? extends Integer> it = integers.iterator();
        while ((o = it.next()) != finished_.get_()) {
            sum += ((Integer)o).value;
        }
        return sum;
    }

    public static long product(@TypeInfo(value="{ceylon.language::Integer*}") @Name(value="integers") Iterable<? extends Integer, ? extends Object> integers) {
        Object o;
        if (integers instanceof Array) {
            Object array = ((Array)integers).toArray();
            if (array instanceof int[]) {
                long product = 1L;
                int[] intArray = (int[])array;
                int s = intArray.length;
                for (int i = 0; i < s; ++i) {
                    product *= (long)intArray[i];
                }
                return product;
            }
            if (array instanceof long[]) {
                long product = 1L;
                long[] longArray = (long[])array;
                int s = longArray.length;
                for (int i = 0; i < s; ++i) {
                    product *= longArray[i];
                }
                return product;
            }
        }
        if (integers instanceof List) {
            List list = (List)integers;
            long size = list.getSize();
            long product = 1L;
            int i = 0;
            while ((long)i < size) {
                product *= ((Integer)list.getFromFirst((long)((long)i))).value;
                ++i;
            }
            return product;
        }
        long product = 1L;
        Iterator<? extends Integer> it = integers.iterator();
        while ((o = it.next()) != finished_.get_()) {
            product *= ((Integer)o).value;
        }
        return product;
    }

    @TypeParameters(value={@TypeParameter(value="Absent", satisfies={"ceylon.language::Null"})})
    @TypeInfo(value="ceylon.language::Integer|Absent")
    public static <Absent> Object min(@Ignore TypeDescriptor $reifiedAbsent, @TypeInfo(value="ceylon.language::Iterable<ceylon.language::Integer,Absent>") @Name(value="integers") Iterable<? extends Integer, ? extends Object> integers) {
        Object o;
        if (integers instanceof Array) {
            Object array = ((Array)integers).toArray();
            if (array instanceof int[]) {
                int[] intArray = (int[])array;
                int s = intArray.length;
                if (s == 0) {
                    return null;
                }
                int min = intArray[0];
                for (int i = 1; i < s; ++i) {
                    min = Math.min(min, intArray[i]);
                }
                return Integer.instance(min);
            }
            if (array instanceof long[]) {
                long[] longArray = (long[])array;
                int s = longArray.length;
                if (s == 0) {
                    return null;
                }
                long min = longArray[0];
                for (int i = 1; i < s; ++i) {
                    min = Math.min(min, longArray[i]);
                }
                return Integer.instance(min);
            }
        }
        if (integers instanceof List) {
            List list = (List)integers;
            long size = list.getSize();
            if (size == 0L) {
                return null;
            }
            long min = integers.getFromFirst((long)0L).value;
            int i = 1;
            while ((long)i < size) {
                min = Math.min(min, ((Integer)list.getFromFirst((long)((long)i))).value);
                ++i;
            }
            return Integer.instance(min);
        }
        long min = 0L;
        boolean first = true;
        Iterator<? extends Integer> it = integers.iterator();
        while ((o = it.next()) != finished_.get_()) {
            long x = ((Integer)o).value;
            if (first) {
                min = x;
                first = false;
                continue;
            }
            min = Math.min(min, x);
        }
        return first ? null : Integer.instance(min);
    }

    @TypeParameters(value={@TypeParameter(value="Absent", satisfies={"ceylon.language::Null"})})
    @TypeInfo(value="ceylon.language::Integer|Absent")
    public static <Absent> Object max(@Ignore TypeDescriptor $reifiedAbsent, @TypeInfo(value="ceylon.language::Iterable<ceylon.language::Integer,Absent>") @Name(value="integers") Iterable<? extends Integer, ? extends Object> integers) {
        Object o;
        if (integers instanceof Array) {
            Object array = ((Array)integers).toArray();
            if (array instanceof int[]) {
                int[] intArray = (int[])array;
                int s = intArray.length;
                if (s == 0) {
                    return null;
                }
                int max = intArray[0];
                for (int i = 1; i < s; ++i) {
                    max = Math.max(max, intArray[i]);
                }
                return Integer.instance(max);
            }
            if (array instanceof long[]) {
                long[] longArray = (long[])array;
                int s = longArray.length;
                if (s == 0) {
                    return null;
                }
                long max = longArray[0];
                for (int i = 1; i < s; ++i) {
                    max = Math.max(max, longArray[i]);
                }
                return Integer.instance(max);
            }
        }
        if (integers instanceof List) {
            List list = (List)integers;
            long size = list.getSize();
            if (size == 0L) {
                return null;
            }
            long max = integers.getFromFirst((long)0L).value;
            int i = 1;
            while ((long)i < size) {
                max = Math.max(max, ((Integer)list.getFromFirst((long)((long)i))).value);
                ++i;
            }
            return Integer.instance(max);
        }
        long max = 0L;
        boolean first = true;
        Iterator<? extends Integer> it = integers.iterator();
        while ((o = it.next()) != finished_.get_()) {
            long x = ((Integer)o).value;
            if (first) {
                max = x;
                first = false;
                continue;
            }
            max = Math.max(max, x);
        }
        return first ? null : Integer.instance(max);
    }

    public static long smallest(@Name(value="x") long x, @Name(value="y") long y) {
        return Math.min(x, y);
    }

    public static long largest(@Name(value="x") long x, @Name(value="y") long y) {
        return Math.max(x, y);
    }

    @SharedAnnotation$annotation$
    public Integer(@Name(value="integer") long integer) {
        this.value = integer;
    }

    @Override
    @Ignore
    public Number$impl<Integer> $ceylon$language$Number$impl() {
        throw Util.makeUnimplementedMixinAccessException();
    }

    @Override
    @Ignore
    public Invertible$impl<Integer> $ceylon$language$Invertible$impl() {
        throw Util.makeUnimplementedMixinAccessException();
    }

    @Override
    @Ignore
    public Comparable$impl<Integer> $ceylon$language$Comparable$impl() {
        throw Util.makeUnimplementedMixinAccessException();
    }

    @Override
    @Ignore
    public Integral$impl<Integer> $ceylon$language$Integral$impl() {
        throw Util.makeUnimplementedMixinAccessException();
    }

    @Override
    @Ignore
    public Enumerable$impl<Integer> $ceylon$language$Enumerable$impl() {
        throw Util.makeUnimplementedMixinAccessException();
    }

    @Override
    @Ignore
    public Binary$impl<Integer> $ceylon$language$Binary$impl() {
        throw Util.makeUnimplementedMixinAccessException();
    }

    @Ignore
    public static Integer instance(long l) {
        return new Integer(l);
    }

    @Ignore
    public long longValue() {
        return this.value;
    }

    @Ignore
    public static long parse$radix(String string) {
        return parseIntegerInternal_.parseIntegerInternal$radix(string);
    }

    @Ignore
    public static Object parse(String string) {
        return Integer.parse(string, Integer.parse$radix(string));
    }

    @SharedAnnotation$annotation$
    @StaticAnnotation$annotation$
    @TypeInfo(value="ceylon.language::Integer|ceylon.language::ParseException")
    public static Object parse(@Name(value="string") String string, @Name(value="radix") @Defaulted long radix) {
        return parseIntegerInternal_.parseIntegerInternal(string, radix);
    }

    @Ignore
    public static long format$radix(long integer) {
        return formatInteger_.formatInteger$radix(integer);
    }

    @Ignore
    public static Character format$groupingSeparator(long integer, long radix) {
        return formatInteger_.formatInteger$groupingSeparator(integer, radix);
    }

    @Ignore
    public static String format(long integer) {
        return formatInteger_.formatInteger(integer);
    }

    @Ignore
    public static String format(long integer, long radix) {
        return formatInteger_.formatInteger(integer, radix);
    }

    @SharedAnnotation$annotation$
    @StaticAnnotation$annotation$
    public static String format(@Name(value="integer") long integer, @Name(value="radix") @Defaulted long radix, @TypeInfo(value="ceylon.language::Character?") @Name(value="groupingSeparator") @Defaulted Character groupingSeparator) {
        return formatInteger_.formatInteger(integer, radix, groupingSeparator);
    }

    @Override
    public Integer plus(@Name(value="other") Integer other) {
        return Integer.instance(this.value + other.value);
    }

    @Ignore
    public static long plus(long value, long otherValue) {
        return value + otherValue;
    }

    @Override
    public Integer minus(@Name(value="other") Integer other) {
        return Integer.instance(this.value - other.value);
    }

    @Ignore
    public static long minus(long value, long otherValue) {
        return value - otherValue;
    }

    @Override
    public Integer times(@Name(value="other") Integer other) {
        return Integer.instance(this.value * other.value);
    }

    @Ignore
    public static long times(long value, long otherValue) {
        return value * otherValue;
    }

    @Override
    public Integer divided(@Name(value="other") Integer other) {
        return Integer.instance(this.value / other.value);
    }

    @Ignore
    public static long divided(long value, long otherValue) {
        return value / otherValue;
    }

    private static long powerBySquaring(long base, long power) {
        long result = 1L;
        long x = base;
        while (power != 0L) {
            if ((power & 1L) == 1L) {
                result *= x;
                --power;
            }
            x *= x;
            power /= 2L;
        }
        return result;
    }

    private static long powerByMultiplying(long base, long power) {
        long result = 1L;
        while (power > 0L) {
            result *= base;
            --power;
        }
        return result;
    }

    @Override
    public Integer power(@Name(value="other") Integer other) {
        return Integer.instance(Integer.power(this.value, other.value));
    }

    @Ignore
    public static long power(long value, long otherValue) {
        long power = otherValue;
        if (value == -1L) {
            return power % 2L == 0L ? 1L : -1L;
        }
        if (value == 1L) {
            return 1L;
        }
        if (power < 0L) {
            throw new AssertionError(value + "^" + power + " cannot be represented as an Integer");
        }
        if (power == 0L) {
            return 1L;
        }
        if (power == 1L) {
            return value;
        }
        if (power >= 6L) {
            return Integer.powerBySquaring(value, power);
        }
        return Integer.powerByMultiplying(value, power);
    }

    private static int powerBySquaring(int base, int power) {
        int result = 1;
        int x = base;
        while (power != 0) {
            if ((power & 1) == 1) {
                result *= x;
                --power;
            }
            x *= x;
            power /= 2;
        }
        return result;
    }

    private static int powerByMultiplying(int base, int power) {
        int result = 1;
        while (power > 0) {
            result *= base;
            --power;
        }
        return result;
    }

    @Ignore
    public static long $power$(long value, long otherValue) {
        return Integer.power(value, otherValue);
    }

    @Ignore
    public static int $power$(int value, int otherValue) {
        int power = otherValue;
        if (value == -1) {
            return power % 2 == 0 ? 1 : -1;
        }
        if (value == 1) {
            return 1;
        }
        if (power < 0) {
            throw new AssertionError(value + "^" + power + " cannot be represented as an Integer");
        }
        if (power == 0) {
            return 1;
        }
        if (power == 1) {
            return value;
        }
        if ((long)power >= 6L) {
            return Integer.powerBySquaring(value, power);
        }
        return Integer.powerByMultiplying(value, power);
    }

    @Override
    @Ignore
    public Float plus(Float other) {
        return Float.instance((double)this.value + other.value);
    }

    @Ignore
    public static double plus(long value, double otherValue) {
        return (double)value + otherValue;
    }

    @Override
    @Ignore
    public Float minus(Float other) {
        return Float.instance((double)this.value - other.value);
    }

    @Ignore
    public static double minus(long value, double otherValue) {
        return (double)value - otherValue;
    }

    @Override
    @Ignore
    public Float times(Float other) {
        return Float.instance((double)this.value * other.value);
    }

    @Ignore
    public static double times(long value, double otherValue) {
        return (double)value * otherValue;
    }

    @Override
    @Ignore
    public Float divided(Float other) {
        return Float.instance((double)this.value / other.value);
    }

    @Ignore
    public static double divided(long value, double otherValue) {
        return (double)value / otherValue;
    }

    @Override
    @Ignore
    public Float power(Float other) {
        return Float.instance(Math.pow(this.value, other.value));
    }

    @Ignore
    public static double power(long value, double otherValue) {
        return Math.pow(value, otherValue);
    }

    @Ignore
    public static double $power$(long value, double otherValue) {
        return Math.pow(value, otherValue);
    }

    @Override
    @AliasesAnnotation$annotation$(aliases={"absolute"})
    @Transient
    public Integer getMagnitude() {
        return Integer.instance(Math.abs(this.value));
    }

    @Ignore
    public static long getMagnitude(long value) {
        return Math.abs(value);
    }

    @Override
    @Transient
    public Integer getFractionalPart() {
        return Integer.instance(0L);
    }

    @Ignore
    public static long getFractionalPart(long value) {
        return 0L;
    }

    @Override
    @Transient
    public Integer getWholePart() {
        return this;
    }

    @Ignore
    public static long getWholePart(long value) {
        return value;
    }

    @Override
    @Transient
    public boolean getPositive() {
        return this.value > 0L;
    }

    @Ignore
    public static boolean getPositive(long value) {
        return value > 0L;
    }

    @Override
    @Transient
    public boolean getNegative() {
        return this.value < 0L;
    }

    @Ignore
    public static boolean getNegative(long value) {
        return value < 0L;
    }

    @Override
    @Transient
    public long getSign() {
        if (this.value > 0L) {
            return 1L;
        }
        if (this.value < 0L) {
            return -1L;
        }
        return 0L;
    }

    @Ignore
    public static long getSign(long value) {
        if (value > 0L) {
            return 1L;
        }
        if (value < 0L) {
            return -1L;
        }
        return 0L;
    }

    @Override
    public Integer remainder(@Name(value="other") Integer other) {
        return Integer.instance(this.value % other.value);
    }

    @Ignore
    public static long remainder(long value, long otherValue) {
        return value % otherValue;
    }

    @Override
    public Integer modulo(@Name(value="modulus") Integer modulus) {
        return Integer.instance(Integer.modulo(this.value, modulus.value));
    }

    @Ignore
    public static long modulo(long value, long modulus) {
        if (modulus < 0L) {
            throw new AssertionError("modulus must be positive: " + modulus);
        }
        long ret = value % modulus;
        if (ret < 0L) {
            return ret + modulus;
        }
        return ret;
    }

    @Override
    public final boolean divides(@Name(value="other") Integer other) {
        return other.value % this.value == 0L;
    }

    @Ignore
    public static boolean divides(long value, long otherValue) {
        return otherValue % value == 0L;
    }

    @Override
    public Integer getNegated() {
        return Integer.instance(-this.value);
    }

    @Ignore
    public static long getNegated(long value) {
        return -value;
    }

    @Override
    public Comparison compare(@Name(value="other") Integer other) {
        long x = this.value;
        long y = other.value;
        return x < y ? smaller_.get_() : (x == y ? equal_.get_() : larger_.get_());
    }

    @Override
    @Ignore
    public int compareTo(Integer other) {
        return Long.compare(this.value, other.value);
    }

    @Ignore
    public static Comparison compare(long value, long otherValue) {
        long x = value;
        long y = otherValue;
        return x < y ? smaller_.get_() : (x == y ? equal_.get_() : larger_.get_());
    }

    @Ignore
    public static Comparison compare(int value, int otherValue) {
        return Integer.compare((long)value, (long)otherValue);
    }

    public String toString() {
        return Long.toString(this.value);
    }

    @Ignore
    public static String toString(long value) {
        return Long.toString(value);
    }

    @Ignore
    public static long neighbour(long value, long offset) {
        long neighbour = value + offset;
        if (((value ^ neighbour) & (offset ^ neighbour)) < 0L) {
            throw new OverflowException(value + " has no neighbour with offset " + offset);
        }
        return neighbour;
    }

    @Override
    public Integer neighbour(@Name(value="offset") long offset) {
        return Integer.instance(Integer.neighbour(this.value, offset));
    }

    @Ignore
    public static long offset(long value, long other) {
        long offset = value - other;
        if (((value ^ other) & (value ^ offset)) < 0L) {
            throw new OverflowException("offset from " + value + " to " + other + " cannot be represented as a 64 bit integer.");
        }
        return offset;
    }

    @Override
    public long offset(@Name(value="other") Integer other) {
        return Integer.offset(this.value, other.value);
    }

    @Ignore
    public static long offsetSign(long value, long other) {
        if (value > other) {
            return 1L;
        }
        if (value < other) {
            return -1L;
        }
        return 0L;
    }

    @Override
    public long offsetSign(@Name(value="other") Integer other) {
        return Integer.offsetSign(this.value, other.value);
    }

    public double getFloat() {
        return Integer.getFloat(this.value);
    }

    @Ignore
    public static double getFloat(long value) {
        if (value <= -9007199254740992L || 0x20000000000000L <= value) {
            throw new OverflowException(value + " cannot be coerced into a 64 bit floating point value");
        }
        return value;
    }

    public double getNearestFloat() {
        return this.value;
    }

    @Ignore
    public static double getNearestFloat(long value) {
        return value;
    }

    @Transient
    public byte getByte() {
        return Integer.getByte(this.value);
    }

    @Ignore
    public static byte getByte(long value) {
        return (byte)value;
    }

    @TypeInfo(value="ceylon.language::Character")
    public int getCharacter() {
        return Character.codepoint(this.value);
    }

    @Ignore
    @TypeInfo(value="ceylon.language::Character")
    public static int getCharacter(long value) {
        return Character.codepoint(value);
    }

    @Transient
    public boolean getEven() {
        return (this.value & 1L) == 0L;
    }

    @Ignore
    public static boolean getEven(long value) {
        return (value & 1L) == 0L;
    }

    @Override
    @Transient
    public boolean getUnit() {
        return this.value == 1L;
    }

    @Ignore
    public static boolean getUnit(long value) {
        return value == 1L;
    }

    @Override
    @Transient
    public boolean getZero() {
        return this.value == 0L;
    }

    @Ignore
    public static boolean getZero(long value) {
        return value == 0L;
    }

    @Override
    @Transient
    public Integer getPredecessor() {
        return Integer.instance(this.value - 1L);
    }

    @Ignore
    public static long getPredecessor(long value) {
        return value - 1L;
    }

    @Override
    @Transient
    public Integer getSuccessor() {
        return Integer.instance(this.value + 1L);
    }

    @Ignore
    public static long getSuccessor(long value) {
        return value + 1L;
    }

    public boolean equals(@Name(value="that") Object that) {
        return Integer.equals(this.value, that);
    }

    @Ignore
    public static boolean equals(long value, Object that) {
        if (that instanceof Integer) {
            return value == ((Integer)that).value;
        }
        if (that instanceof Float) {
            return (double)value == ((Float)that).value && value > -9007199254740992L && value < 0x20000000000000L;
        }
        return false;
    }

    @Transient
    public int hashCode() {
        return (int)(this.value ^ this.value >>> 32);
    }

    @Ignore
    public static int hashCode(long value) {
        return (int)(value ^ value >>> 32);
    }

    @Override
    public Integer getNot() {
        return Integer.instance(this.value ^ 0xFFFFFFFFFFFFFFFFL);
    }

    @Ignore
    public static long getNot(long value) {
        return value ^ 0xFFFFFFFFFFFFFFFFL;
    }

    @Override
    @AliasesAnnotation$annotation$(aliases={"leftShift"})
    public Integer leftLogicalShift(@Name(value="shift") long shift) {
        return Integer.instance(this.value << (int)shift);
    }

    @Ignore
    public static long leftLogicalShift(long value, long shift) {
        return value << (int)shift;
    }

    @Override
    @AliasesAnnotation$annotation$(aliases={"rightShift"})
    public Integer rightLogicalShift(@Name(value="shift") long shift) {
        return Integer.instance(this.value >>> (int)shift);
    }

    @Ignore
    public static long rightLogicalShift(long value, long shift) {
        return value >>> (int)shift;
    }

    @Override
    public Integer rightArithmeticShift(@Name(value="shift") long shift) {
        return Integer.instance(this.value >> (int)shift);
    }

    @Ignore
    public static long rightArithmeticShift(long value, long shift) {
        return value >> (int)shift;
    }

    @Override
    public Integer and(@Name(value="other") Integer other) {
        return Integer.instance(this.value & other.value);
    }

    @Ignore
    public static long and(long value, long other) {
        return value & other;
    }

    @Override
    public Integer or(@Name(value="other") Integer other) {
        return Integer.instance(this.value | other.value);
    }

    @Ignore
    public static long or(long value, long other) {
        return value | other;
    }

    @Override
    public Integer xor(@Name(value="other") Integer other) {
        return Integer.instance(this.value ^ other.value);
    }

    @Ignore
    public static long xor(long value, long other) {
        return value ^ other;
    }

    @Override
    public boolean get(@Name(value="index") long index) {
        return Integer.get(this.value, index);
    }

    @Ignore
    public static boolean get(long value, long index) {
        if (index < 0L || index > 63L) {
            return false;
        }
        long mask = 1L << (int)index;
        return (value & mask) != 0L;
    }

    @Override
    @Ignore
    public Integer set(long index) {
        return Integer.instance(Integer.set(this.value, index));
    }

    @Override
    public Integer set(@Name(value="index") long index, @Name(value="bit") @Defaulted boolean bit) {
        return Integer.instance(Integer.set(this.value, index, bit));
    }

    @Override
    @Ignore
    public boolean set$bit(long index) {
        return true;
    }

    @Ignore
    public static long set(long value, long index) {
        return Integer.set(value, index, true);
    }

    @Ignore
    public static long set(long value, long index, boolean bit) {
        if (index < 0L || index > 63L) {
            return value;
        }
        long mask = 1L << (int)index;
        return bit ? value | mask : value & (mask ^ 0xFFFFFFFFFFFFFFFFL);
    }

    @Override
    public Integer clear(@Name(value="index") long index) {
        return Integer.instance(Integer.clear(this.value, index));
    }

    @Ignore
    public static long clear(long value, long index) {
        if (index < 0L || index > 63L) {
            return value;
        }
        long mask = 1L << (int)index;
        return value & (mask ^ 0xFFFFFFFFFFFFFFFFL);
    }

    @Override
    public Integer flip(@Name(value="index") long index) {
        return Integer.instance(Integer.flip(this.value, index));
    }

    @Ignore
    public static long flip(long value, long index) {
        if (index < 0L || index > 63L) {
            return value;
        }
        long mask = 1L << (int)index;
        return value ^ mask;
    }

    @Override
    @Ignore
    public TypeDescriptor $getType$() {
        return $TypeDescriptor$;
    }

    @Ignore
    public static boolean largerThan(long value, Integer other) {
        return value > other.value;
    }

    @Ignore
    public static boolean largerThan(long value, long other) {
        return value > other;
    }

    @Override
    public boolean largerThan(@Name(value="other") Integer other) {
        return this.value > other.value;
    }

    @Ignore
    public static boolean notSmallerThan(long value, Integer other) {
        return value >= other.value;
    }

    @Ignore
    public static boolean notSmallerThan(long value, long other) {
        return value >= other;
    }

    @Override
    public boolean notSmallerThan(@Name(value="other") Integer other) {
        return this.value >= other.value;
    }

    @Ignore
    public static boolean smallerThan(long value, Integer other) {
        return value < other.value;
    }

    @Ignore
    public static boolean smallerThan(long value, long other) {
        return value < other;
    }

    @Override
    public boolean smallerThan(@Name(value="other") Integer other) {
        return this.value < other.value;
    }

    @Ignore
    public static boolean notLargerThan(long value, Integer other) {
        return value <= other.value;
    }

    @Ignore
    public static boolean notLargerThan(long value, long other) {
        return value <= other;
    }

    @Override
    public boolean notLargerThan(@Name(value="other") Integer other) {
        return this.value <= other.value;
    }

    @Override
    public Integer timesInteger(@Name(value="integer") long integer) {
        return Integer.instance(this.value * integer);
    }

    @Ignore
    public static long timesInteger(long value, long integer) {
        return value * integer;
    }

    @Override
    public Integer plusInteger(@Name(value="integer") long integer) {
        return Integer.instance(this.value + integer);
    }

    @Ignore
    public static long plusInteger(long value, long integer) {
        return value + integer;
    }

    @Override
    public Integer powerOfInteger(@Name(value="integer") long integer) {
        return Integer.instance(Integer.power(this.value, integer));
    }

    @Ignore
    public static long powerOfInteger(long value, long integer) {
        return Integer.power(value, integer);
    }

    @Ignore
    public static Integer valueOf(String string) {
        return Integer.instance(Long.parseLong(string));
    }
}

