/*
 * Decompiled with CFR 0.152.
 */
package ceylon.language;

import ceylon.language.AuthorsAnnotation$annotation$;
import ceylon.language.DefaultAnnotation$annotation$;
import ceylon.language.DocAnnotation$annotation$;
import ceylon.language.Enumerable;
import ceylon.language.FormalAnnotation$annotation$;
import ceylon.language.Integral$impl;
import ceylon.language.Number;
import ceylon.language.SeeAnnotation$annotation$;
import ceylon.language.SeeAnnotation$annotations$;
import ceylon.language.SharedAnnotation$annotation$;
import ceylon.language.TagsAnnotation$annotation$;
import ceylon.language.ThrownExceptionAnnotation$annotation$;
import ceylon.language.ThrownExceptionAnnotation$annotations$;
import com.redhat.ceylon.compiler.java.metadata.Annotation;
import com.redhat.ceylon.compiler.java.metadata.Annotations;
import com.redhat.ceylon.compiler.java.metadata.CaseTypes;
import com.redhat.ceylon.compiler.java.metadata.Ceylon;
import com.redhat.ceylon.compiler.java.metadata.Ignore;
import com.redhat.ceylon.compiler.java.metadata.Name;
import com.redhat.ceylon.compiler.java.metadata.SatisfiedTypes;
import com.redhat.ceylon.compiler.java.metadata.TypeInfo;
import com.redhat.ceylon.compiler.java.metadata.TypeParameter;
import com.redhat.ceylon.compiler.java.metadata.TypeParameters;
import com.redhat.ceylon.compiler.java.metadata.Variance;

@Ceylon(major=8, minor=1)
@DocAnnotation$annotation$(description="Abstraction of integral numeric types. That is, types \nwith no fractional part, including [[Integer]].\n\nThe division operation for integral numeric types results \nin a remainder. Therefore, integral numeric types have \n[[an operation|remainder]], denoted by the _remainder_\noperator `%`, to determine the remainder of any division \noperation.\n\n    if (n%2==0) {\n        print(\"Even!\");\n    }\n\nDivision and the remainder operation should satisfy: \n\n- `x == (x/y)*y + x%y`\n\nfor any instance `x` and any instance `y` other than `0`.\n\nAll `Integral` numeric types are also [[Enumerable]], so \nranges of integral values may be produced using the \n[[measure]] and [[span]] operators.\n    \n    // Iterate from 0 to 100 inclusive\n    for (i in 0..100) {\n        print(\"The square of ``i`` is ``i^2``\");\n    }\n    \n    // Iterate all indices of the array, \n    // from 0 to array.size-1\n    for (i in 0:array.size) {\n        print(array[i]);\n    }")
@SeeAnnotation$annotations$(value={@SeeAnnotation$annotation$(programElements={"::1.3.3:ceylon.language::CInteger"})})
@AuthorsAnnotation$annotation$(authors={"Gavin"})
@TagsAnnotation$annotation$(tags={"Numbers"})
@SharedAnnotation$annotation$
@Annotations(modifiers=2L, value={@Annotation(value="doc", arguments={"Abstraction of integral numeric types. That is, types \nwith no fractional part, including [[Integer]].\n\nThe division operation for integral numeric types results \nin a remainder. Therefore, integral numeric types have \n[[an operation|remainder]], denoted by the _remainder_\noperator `%`, to determine the remainder of any division \noperation.\n\n    if (n%2==0) {\n        print(\"Even!\");\n    }\n\nDivision and the remainder operation should satisfy: \n\n- `x == (x/y)*y + x%y`\n\nfor any instance `x` and any instance `y` other than `0`.\n\nAll `Integral` numeric types are also [[Enumerable]], so \nranges of integral values may be produced using the \n[[measure]] and [[span]] operators.\n    \n    // Iterate from 0 to 100 inclusive\n    for (i in 0..100) {\n        print(\"The square of ``i`` is ``i^2``\");\n    }\n    \n    // Iterate all indices of the array, \n    // from 0 to array.size-1\n    for (i in 0:array.size) {\n        print(array[i]);\n    }"}), @Annotation(value="see", arguments={"Integer"}), @Annotation(value="by", arguments={"Gavin"}), @Annotation(value="tagged", arguments={"Numbers"})})
@SatisfiedTypes(value={"ceylon.language::Number<Other>", "ceylon.language::Enumerable<Other>"})
@CaseTypes(of="Other")
@TypeParameters(value={@TypeParameter(value="Other", variance=Variance.NONE, satisfies={"ceylon.language::Integral<Other>"}, caseTypes={})})
public interface Integral<Other extends Integral<Other>>
extends Number<Other>,
Enumerable<Other> {
    @Ignore
    public Integral$impl<Other> $ceylon$language$Integral$impl();

    @DocAnnotation$annotation$(description="The remainder, after dividing this number by the given \nnumber. The sign of the remainder depends upon the sign\nof this number, and of the argument [[divisor|other]]:\n\n- if this dividend is positive, the remainder has the\n  opposite sign as the divisor, or is `0`,\n- if this dividend is negative, the remainder has the\n  same sign as the divisor, or is `0`, or\n- if this dividend is zero, the remainder is always \n  `0`.\n\nThus, in order to satisfy the identity \n`x == (x/y)*y + x%y`, [[division|divided]] for an \nintegral numeric type must round toward `0`, the \nadditive identity.")
    @SeeAnnotation$annotations$(value={@SeeAnnotation$annotation$(programElements={"::1.3.3:ceylon.language::INumeric.Fdivided", "::1.3.3:ceylon.language::IIntegral.Fmodulo"})})
    @SharedAnnotation$annotation$
    @FormalAnnotation$annotation$
    @Annotations(modifiers=130L, value={@Annotation(value="doc", arguments={"The remainder, after dividing this number by the given \nnumber. The sign of the remainder depends upon the sign\nof this number, and of the argument [[divisor|other]]:\n\n- if this dividend is positive, the remainder has the\n  opposite sign as the divisor, or is `0`,\n- if this dividend is negative, the remainder has the\n  same sign as the divisor, or is `0`, or\n- if this dividend is zero, the remainder is always \n  `0`.\n\nThus, in order to satisfy the identity \n`x == (x/y)*y + x%y`, [[division|divided]] for an \nintegral numeric type must round toward `0`, the \nadditive identity."}), @Annotation(value="see", arguments={"divided", "modulo"})})
    @TypeInfo(value="Other", erased=true)
    public Other remainder(@Name(value="other") @TypeInfo(value="Other", erased=true) Other var1);

    @DocAnnotation$annotation$(description="The modulo, after dividing this number by the given \nnumber. This differs from [[remainder]] in that the\nresult is always positive or `0`.")
    @SeeAnnotation$annotations$(value={@SeeAnnotation$annotation$(programElements={"::1.3.3:ceylon.language::INumeric.Fdivided", "::1.3.3:ceylon.language::IIntegral.Fremainder"})})
    @ThrownExceptionAnnotation$annotations$(value={@ThrownExceptionAnnotation$annotation$(type="::1.3.3:ceylon.language::CAssertionError", when="If the modulus is not strictly positive")})
    @SharedAnnotation$annotation$
    @DefaultAnnotation$annotation$
    @Annotations(modifiers=258L, value={@Annotation(value="doc", arguments={"The modulo, after dividing this number by the given \nnumber. This differs from [[remainder]] in that the\nresult is always positive or `0`."}), @Annotation(value="see", arguments={"divided", "remainder"}), @Annotation(value="throws", arguments={"AssertionError", "If the modulus is not strictly positive"})})
    @TypeInfo(value="Other", erased=true)
    public Other modulo(@Name(value="modulus") @TypeInfo(value="Other", erased=true) Other var1);

    @DocAnnotation$annotation$(description="Determine if the number is the additive identity.")
    @SharedAnnotation$annotation$
    @FormalAnnotation$annotation$
    @Annotations(modifiers=130L, value={@Annotation(value="doc", arguments={"Determine if the number is the additive identity."})})
    public boolean getZero();

    @DocAnnotation$annotation$(description="Determine if the number is the multiplicative identity.")
    @SharedAnnotation$annotation$
    @FormalAnnotation$annotation$
    @Annotations(modifiers=130L, value={@Annotation(value="doc", arguments={"Determine if the number is the multiplicative identity."})})
    public boolean getUnit();

    @DocAnnotation$annotation$(description="Determine if this number is a factor of the given \nnumber, that is, if `remainder(other).zero` evaluates\nto `true`.")
    @SharedAnnotation$annotation$
    @DefaultAnnotation$annotation$
    @Annotations(modifiers=258L, value={@Annotation(value="doc", arguments={"Determine if this number is a factor of the given \nnumber, that is, if `remainder(other).zero` evaluates\nto `true`."})})
    public boolean divides(@Name(value="other") @TypeInfo(value="Other", erased=true) Other var1);
}

