/*
 * Decompiled with CFR 0.152.
 */
package ceylon.language;

import ceylon.language.ActualAnnotation$annotation$;
import ceylon.language.Boolean;
import ceylon.language.Callable;
import ceylon.language.Collection;
import ceylon.language.Correspondence;
import ceylon.language.DefaultAnnotation$annotation$;
import ceylon.language.DocAnnotation$annotation$;
import ceylon.language.Entry;
import ceylon.language.FormalAnnotation$annotation$;
import ceylon.language.Iterable;
import ceylon.language.Map$impl;
import ceylon.language.SeeAnnotation$annotation$;
import ceylon.language.SeeAnnotation$annotations$;
import ceylon.language.Sequence;
import ceylon.language.SharedAnnotation$annotation$;
import ceylon.language.SinceAnnotation$annotation$;
import ceylon.language.TagsAnnotation$annotation$;
import com.redhat.ceylon.common.NonNull;
import com.redhat.ceylon.common.Nullable;
import com.redhat.ceylon.compiler.java.metadata.Annotation;
import com.redhat.ceylon.compiler.java.metadata.Annotations;
import com.redhat.ceylon.compiler.java.metadata.Ceylon;
import com.redhat.ceylon.compiler.java.metadata.FunctionalParameter;
import com.redhat.ceylon.compiler.java.metadata.Ignore;
import com.redhat.ceylon.compiler.java.metadata.LocalDeclarations;
import com.redhat.ceylon.compiler.java.metadata.Member;
import com.redhat.ceylon.compiler.java.metadata.Members;
import com.redhat.ceylon.compiler.java.metadata.Name;
import com.redhat.ceylon.compiler.java.metadata.SatisfiedTypes;
import com.redhat.ceylon.compiler.java.metadata.Transient;
import com.redhat.ceylon.compiler.java.metadata.TypeInfo;
import com.redhat.ceylon.compiler.java.metadata.TypeParameter;
import com.redhat.ceylon.compiler.java.metadata.TypeParameters;
import com.redhat.ceylon.compiler.java.metadata.Variance;
import com.redhat.ceylon.compiler.java.runtime.model.TypeDescriptor;

@Ceylon(major=8, minor=1)
@DocAnnotation$annotation$(description="A collection which maps _keys_ to _items_, where a key \ncan map to at most one item. Each such mapping may be \nrepresented by an [[Entry]]. Thus, each distinct key \noccurs in at most one entry. Two \nnon-[[identical|Identifiable]] keys are considered \ndistinct only if they are unequal, according to their own \ndefinition of [[value equality|Object.equals]].\n\nA `Map` is a [[Collection]] of its `Entry`s, and a \n[[Correspondence]] from keys to items.\n\nA new `Map` may be obtained by calling the function \n[[ceylon.language::map]].\n\n    value settings = map { \"lang\"->\"en_AU\", \"loc\"->\"ES\" };\n\nThe [[emptyMap]] is a `Map` with no entries.\n\nThe presence of an entry in a map may be tested using the \n`in` operator:\n\n    if (\"lang\"->\"en_AU\" in settings) { ... }\n\nThe entries of the map may be iterated using `for`:\n\n    for (key->item in settings) { ... }\n\nThe item for a key may be obtained using the item\noperator:\n\n    String lang = settings[\"lang\"] else \"en_US\";\n\nAn implementation of `Map` may compare keys for equality \nusing [[Object.equals]] or [[Comparable.compare]].")
@SeeAnnotation$annotations$(value={@SeeAnnotation$annotation$(programElements={"::1.3.3:ceylon.language::CEntry", "::1.3.3:ceylon.language::Fmap", "::1.3.3:ceylon.language::FforKey", "::1.3.3:ceylon.language::FforItem", "::1.3.3:ceylon.language::FbyItem", "::1.3.3:ceylon.language::FbyKey", "::1.3.3:ceylon.language::VemptyMap"})})
@TagsAnnotation$annotation$(tags={"Collections"})
@SharedAnnotation$annotation$
@Members(value={@Member(klass=impl$Items.class)})
@LocalDeclarations(value={"1anonymous_0_", "1anonymous_4_", "1anonymous_6_", "1anonymous_7_", "1anonymous_9_"})
@Annotations(modifiers=2L, value={@Annotation(value="doc", arguments={"A collection which maps _keys_ to _items_, where a key \ncan map to at most one item. Each such mapping may be \nrepresented by an [[Entry]]. Thus, each distinct key \noccurs in at most one entry. Two \nnon-[[identical|Identifiable]] keys are considered \ndistinct only if they are unequal, according to their own \ndefinition of [[value equality|Object.equals]].\n\nA `Map` is a [[Collection]] of its `Entry`s, and a \n[[Correspondence]] from keys to items.\n\nA new `Map` may be obtained by calling the function \n[[ceylon.language::map]].\n\n    value settings = map { \"lang\"->\"en_AU\", \"loc\"->\"ES\" };\n\nThe [[emptyMap]] is a `Map` with no entries.\n\nThe presence of an entry in a map may be tested using the \n`in` operator:\n\n    if (\"lang\"->\"en_AU\" in settings) { ... }\n\nThe entries of the map may be iterated using `for`:\n\n    for (key->item in settings) { ... }\n\nThe item for a key may be obtained using the item\noperator:\n\n    String lang = settings[\"lang\"] else \"en_US\";\n\nAn implementation of `Map` may compare keys for equality \nusing [[Object.equals]] or [[Comparable.compare]]."}), @Annotation(value="see", arguments={"Entry", "map", "forKey", "forItem", "byItem", "byKey", "emptyMap"}), @Annotation(value="tagged", arguments={"Collections"})})
@SatisfiedTypes(value={"ceylon.language::Collection<Key->Item>", "ceylon.language::Correspondence<ceylon.language::Object,Item>"})
@TypeParameters(value={@TypeParameter(value="Key", variance=Variance.OUT, satisfies={"ceylon.language::Object"}, caseTypes={}, defaultValue="ceylon.language::Object"), @TypeParameter(value="Item", variance=Variance.OUT, satisfies={}, caseTypes={}, defaultValue="ceylon.language::Anything")})
public interface Map<Key, Item>
extends Collection<Entry<? extends Key, ? extends Item>>,
Correspondence<Object, Item> {
    @Ignore
    public Map$impl<? extends Key, ? extends Item> $ceylon$language$Map$impl();

    @Override
    @DocAnnotation$annotation$(description="Returns the item of the entry with the given [[key]], \nor `null` if there is no entry with the given `key` in\nthis map.")
    @SeeAnnotation$annotations$(value={@SeeAnnotation$annotation$(programElements={"::1.3.3:ceylon.language::IMap.FgetOrDefault"})})
    @SharedAnnotation$annotation$
    @ActualAnnotation$annotation$
    @FormalAnnotation$annotation$
    @Annotations(modifiers=194L, value={@Annotation(value="doc", arguments={"Returns the item of the entry with the given [[key]], \nor `null` if there is no entry with the given `key` in\nthis map."}), @Annotation(value="see", arguments={"getOrDefault"})})
    @TypeInfo(value="Item?")
    @Nullable
    public Item get(@Name(value="key") @TypeInfo(value="ceylon.language::Object") @NonNull Object var1);

    @Override
    @DocAnnotation$annotation$(description="Determines if there is an entry in this map with the\ngiven [[key]].")
    @SeeAnnotation$annotations$(value={@SeeAnnotation$annotation$(programElements={"::1.3.3:ceylon.language::IMap.Fcontains"})})
    @SharedAnnotation$annotation$
    @ActualAnnotation$annotation$
    @FormalAnnotation$annotation$
    @Annotations(modifiers=194L, value={@Annotation(value="doc", arguments={"Determines if there is an entry in this map with the\ngiven [[key]]."}), @Annotation(value="see", arguments={"contains"})})
    public boolean defines(@Name(value="key") @TypeInfo(value="ceylon.language::Object") @NonNull Object var1);

    @DocAnnotation$annotation$(description="Returns the item of the entry with the given [[key]], \nor the given [[default]] if there is no entry with the \ngiven `key` in this map.\n\nFor maps with non-null items, the expression:\n\n    map.getOrDefault(key, def)\n\nis equivalent to this common idiom:\n\n    map[key] else def\n\nHowever, when the map has null items, `getOrDefault()`\nwill preserve them.\n\nNote that high-quality implementations of `Map` should \nrefine this default implementation.")
    @SeeAnnotation$annotations$(value={@SeeAnnotation$annotation$(programElements={"::1.3.3:ceylon.language::IMap.Fget"})})
    @SinceAnnotation$annotation$(version="1.2.0")
    @SharedAnnotation$annotation$
    @DefaultAnnotation$annotation$
    @Annotations(modifiers=258L, value={@Annotation(value="doc", arguments={"Returns the item of the entry with the given [[key]], \nor the given [[default]] if there is no entry with the \ngiven `key` in this map.\n\nFor maps with non-null items, the expression:\n\n    map.getOrDefault(key, def)\n\nis equivalent to this common idiom:\n\n    map[key] else def\n\nHowever, when the map has null items, `getOrDefault()`\nwill preserve them.\n\nNote that high-quality implementations of `Map` should \nrefine this default implementation."}), @Annotation(value="see", arguments={"get"})})
    @TypeInfo(value="Item|Default", erased=true)
    @TypeParameters(value={@TypeParameter(value="Default", variance=Variance.NONE, satisfies={}, caseTypes={})})
    @Nullable
    public <Default> Object getOrDefault(@Ignore TypeDescriptor var1, @Name(value="key") @TypeInfo(value="ceylon.language::Object") @NonNull Object var2, @Name(value="default") @TypeInfo(value="Default") Default var3);

    @Override
    @DocAnnotation$annotation$(description="Determines if the given [[value|entry]] is an [[Entry]]\nbelonging to this map.")
    @SeeAnnotation$annotations$(value={@SeeAnnotation$annotation$(programElements={"::1.3.3:ceylon.language::IMap.Fdefines"})})
    @SharedAnnotation$annotation$
    @ActualAnnotation$annotation$
    @DefaultAnnotation$annotation$
    @Annotations(modifiers=322L, value={@Annotation(value="doc", arguments={"Determines if the given [[value|entry]] is an [[Entry]]\nbelonging to this map."}), @Annotation(value="see", arguments={"defines"})})
    public boolean contains(@Name(value="entry") @TypeInfo(value="ceylon.language::Object") @NonNull Object var1);

    @Override
    @SharedAnnotation$annotation$
    @ActualAnnotation$annotation$
    @Annotations(modifiers=66L)
    @TypeInfo(value="{<Key->Item>*}")
    @Transient
    @NonNull
    public Iterable<? extends Entry<? extends Key, ? extends Item>, ? extends Object> getDistinct();

    @Override
    @SharedAnnotation$annotation$
    @ActualAnnotation$annotation$
    @Annotations(modifiers=66L)
    @TypeInfo(value="{<Key->Item>*}", erased=true, untrusted=true)
    @TypeParameters(value={@TypeParameter(value="Default", variance=Variance.NONE, satisfies={"ceylon.language::Object"}, caseTypes={})})
    @NonNull
    public <Default> Iterable defaultNullElements(@Ignore TypeDescriptor var1, @Name(value="defaultValue") @TypeInfo(value="Default") Default var2);

    @DocAnnotation$annotation$(description="A shallow copy of this map, that is, a map with the\nsame entries as this map, which do not change if the\nentries in this map change.")
    @SharedAnnotation$annotation$
    @ActualAnnotation$annotation$
    @DefaultAnnotation$annotation$
    @Annotations(modifiers=322L, value={@Annotation(value="doc", arguments={"A shallow copy of this map, that is, a map with the\nsame entries as this map, which do not change if the\nentries in this map change."})})
    @TypeInfo(value="ceylon.language::Map<Key,Item>")
    @NonNull
    public Map<? extends Key, ? extends Item> $clone();

    @Override
    @DocAnnotation$annotation$(description="A [[Collection]] containing the keys of this map.")
    @SharedAnnotation$annotation$
    @ActualAnnotation$annotation$
    @DefaultAnnotation$annotation$
    @Annotations(modifiers=322L, value={@Annotation(value="doc", arguments={"A [[Collection]] containing the keys of this map."})})
    @TypeInfo(value="ceylon.language::Collection<Key>")
    @Transient
    @NonNull
    public Collection<? extends Key> getKeys();

    @DocAnnotation$annotation$(description="A [[Collection]] containing the items stored in this \nmap. An element can be stored under more than one key \nin the map, and so it can occur more than once in the \nresulting collection.")
    @SinceAnnotation$annotation$(version="1.1.0")
    @SharedAnnotation$annotation$
    @DefaultAnnotation$annotation$
    @Annotations(modifiers=258L, value={@Annotation(value="doc", arguments={"A [[Collection]] containing the items stored in this \nmap. An element can be stored under more than one key \nin the map, and so it can occur more than once in the \nresulting collection."})})
    @TypeInfo(value="ceylon.language::Collection<Item>")
    @Transient
    @NonNull
    public Collection<? extends Item> getItems();

    @DocAnnotation$annotation$(description="Invert this map, producing a new immutable map where \nthe keys of the new map are the non-null items of this\nmap, and each item of the new map is a nonempty \nsequence of keys of this map.\n\nFor example, the expression:\n\n    { \"fee\", \"fi\", \"fo\", \"fum\", \"foo\" }\n       .tabulate(String.size)\n       .inverse()\n\nproduces the map \n`{ 2->[\"fo\", \"fi\"], 3->[ \"fum\", \"fee\", \"foo\"] }`.\n\nThe order of keys in the key sequences is not defined\nand should not be relied upon.\n\nThis is an eager operation, and the resulting map does\nnot reflect changes to this map.")
    @SinceAnnotation$annotation$(version="1.2.0")
    @SharedAnnotation$annotation$
    @DefaultAnnotation$annotation$
    @Annotations(modifiers=258L, value={@Annotation(value="doc", arguments={"Invert this map, producing a new immutable map where \nthe keys of the new map are the non-null items of this\nmap, and each item of the new map is a nonempty \nsequence of keys of this map.\n\nFor example, the expression:\n\n    { \"fee\", \"fi\", \"fo\", \"fum\", \"foo\" }\n       .tabulate(String.size)\n       .inverse()\n\nproduces the map \n`{ 2->[\"fo\", \"fi\"], 3->[ \"fum\", \"fee\", \"foo\"] }`.\n\nThe order of keys in the key sequences is not defined\nand should not be relied upon.\n\nThis is an eager operation, and the resulting map does\nnot reflect changes to this map."})})
    @TypeInfo(value="ceylon.language::Map<Item&ceylon.language::Object,[Key+]>")
    @NonNull
    public Map<? extends Item, ? extends Sequence<? extends Key>> inverse();

    @DocAnnotation$annotation$(description="Two maps are considered equal iff they have the same \n_entry sets_. The entry set of a `Map` is the set of \n`Entry`s belonging to the map. Therefore, the maps are \nequal iff they have same set of `keys`, and for every \nkey in the key set, the maps have equal items.")
    @SharedAnnotation$annotation$
    @ActualAnnotation$annotation$
    @DefaultAnnotation$annotation$
    @Annotations(modifiers=322L, value={@Annotation(value="doc", arguments={"Two maps are considered equal iff they have the same \n_entry sets_. The entry set of a `Map` is the set of \n`Entry`s belonging to the map. Therefore, the maps are \nequal iff they have same set of `keys`, and for every \nkey in the key set, the maps have equal items."})})
    public boolean equals(@Name(value="that") @TypeInfo(value="ceylon.language::Object") @NonNull Object var1);

    @SharedAnnotation$annotation$
    @ActualAnnotation$annotation$
    @DefaultAnnotation$annotation$
    @Annotations(modifiers=322L)
    @Transient
    public int hashCode();

    @DocAnnotation$annotation$(description="Produces a map with the same [[keys]] as this map. For \nevery key, the item is the result of applying the given \n[[transformation|Map.mapItems.mapping]] function to its \nassociated item in this map. This is a lazy operation, \nreturning a view of this map.")
    @SharedAnnotation$annotation$
    @DefaultAnnotation$annotation$
    @Annotations(modifiers=258L, value={@Annotation(value="doc", arguments={"Produces a map with the same [[keys]] as this map. For \nevery key, the item is the result of applying the given \n[[transformation|Map.mapItems.mapping]] function to its \nassociated item in this map. This is a lazy operation, \nreturning a view of this map."})})
    @TypeInfo(value="ceylon.language::Map<Key,Result>")
    @TypeParameters(value={@TypeParameter(value="Result", variance=Variance.NONE, satisfies={"ceylon.language::Object"}, caseTypes={})})
    @NonNull
    public <Result> Map<? extends Key, ? extends Result> mapItems(@Ignore TypeDescriptor var1, @Name(value="mapping") @FunctionalParameter(value="(key,item)") @TypeInfo(value="Result(Key, Item)") @Annotations(value={@Annotation(value="doc", arguments={"The function that transforms a key/item pair of\nthis map, producing the item of the resulting map."})}) @NonNull Callable<? extends Result> var2);

    @DocAnnotation$annotation$(description="Produces a map containing the elements of this map, \nafter replacing every `null` item in the map with the \n[[given default value|defaultValue]]. The item `null` \ndoes not ocur in the resulting map.")
    @SeeAnnotation$annotations$(value={@SeeAnnotation$annotation$(programElements={"::1.3.3:ceylon.language::IMap.VcoalescedMap"})})
    @SinceAnnotation$annotation$(version="1.2.0")
    @SharedAnnotation$annotation$
    @DefaultAnnotation$annotation$
    @Annotations(modifiers=258L, value={@Annotation(value="doc", arguments={"Produces a map containing the elements of this map, \nafter replacing every `null` item in the map with the \n[[given default value|defaultValue]]. The item `null` \ndoes not ocur in the resulting map."}), @Annotation(value="see", arguments={"coalescedMap"})})
    @TypeInfo(value="ceylon.language::Map<Key,Item&ceylon.language::Object|Default>", erased=true)
    @TypeParameters(value={@TypeParameter(value="Default", variance=Variance.NONE, satisfies={"ceylon.language::Object"}, caseTypes={})})
    @NonNull
    public <Default> Map defaultNullItems(@Ignore TypeDescriptor var1, @Name(value="defaultValue") @TypeInfo(value="Default") @DocAnnotation$annotation$(description="A default value that replaces `null` items.") @Annotations(value={@Annotation(value="doc", arguments={"A default value that replaces `null` items."})}) Default var2);

    @DocAnnotation$annotation$(description="Produces a map by applying a [[filtering]] function \nto the [[keys]] of this map. This is a lazy operation, \nreturning a view of this map.")
    @SinceAnnotation$annotation$(version="1.1.0")
    @SharedAnnotation$annotation$
    @DefaultAnnotation$annotation$
    @Annotations(modifiers=258L, value={@Annotation(value="doc", arguments={"Produces a map by applying a [[filtering]] function \nto the [[keys]] of this map. This is a lazy operation, \nreturning a view of this map."})})
    @TypeInfo(value="ceylon.language::Map<Key,Item>")
    @NonNull
    public Map<? extends Key, ? extends Item> filterKeys(@Name(value="filtering") @FunctionalParameter(value="(key)") @TypeInfo(value="ceylon.language::Boolean(Key)") @Annotations(value={@Annotation(value="doc", arguments={"The predicate function that filters the keys of \nthis map, determining if there is a corresponding\nentry in the resulting map."})}) @NonNull Callable<? extends Boolean> var1);

    @DocAnnotation$annotation$(description="Produces a map whose keys are the union of the keys\nof this map, with the keys of the given [[map|other]].\nFor any given key in the resulting map, its associated\nitem is the item associated with the key in the given\nmap, if any, or the item associated with the key in \nthis map otherwise.\n\nThat is, for any `key` in the resulting patched map:\n\n    map.patch(other)[key] == other.getOrDefault(key, map[key])\n\nThis is a lazy operation producing a view of this map\nand the given map.")
    @SinceAnnotation$annotation$(version="1.1.0")
    @SharedAnnotation$annotation$
    @DefaultAnnotation$annotation$
    @Annotations(modifiers=258L, value={@Annotation(value="doc", arguments={"Produces a map whose keys are the union of the keys\nof this map, with the keys of the given [[map|other]].\nFor any given key in the resulting map, its associated\nitem is the item associated with the key in the given\nmap, if any, or the item associated with the key in \nthis map otherwise.\n\nThat is, for any `key` in the resulting patched map:\n\n    map.patch(other)[key] == other.getOrDefault(key, map[key])\n\nThis is a lazy operation producing a view of this map\nand the given map."})})
    @TypeInfo(value="ceylon.language::Map<Key|OtherKey,Item|OtherItem>", erased=true)
    @TypeParameters(value={@TypeParameter(value="OtherKey", variance=Variance.NONE, satisfies={"ceylon.language::Object"}, caseTypes={}), @TypeParameter(value="OtherItem", variance=Variance.NONE, satisfies={}, caseTypes={})})
    @NonNull
    public <OtherKey, OtherItem> Map patch(@Ignore TypeDescriptor var1, @Ignore TypeDescriptor var2, @Name(value="other") @TypeInfo(value="ceylon.language::Map<OtherKey,OtherItem>") @NonNull Map<? extends OtherKey, ? extends OtherItem> var3);

    @DocAnnotation$annotation$(description="A map with every entry of this map whose item is\nnon-null.")
    @SeeAnnotation$annotations$(value={@SeeAnnotation$annotation$(programElements={"::1.3.3:ceylon.language::IMap.FdefaultNullItems"})})
    @SinceAnnotation$annotation$(version="1.2.0")
    @SharedAnnotation$annotation$
    @DefaultAnnotation$annotation$
    @Annotations(modifiers=258L, value={@Annotation(value="doc", arguments={"A map with every entry of this map whose item is\nnon-null."}), @Annotation(value="see", arguments={"defaultNullItems"})})
    @TypeInfo(value="ceylon.language::Map<Key,Item&ceylon.language::Object>")
    @Transient
    @NonNull
    public Map<? extends Key, ? extends Item> getCoalescedMap();
}

