/*
 * Decompiled with CFR 0.152.
 */
package ceylon.language;

import ceylon.language.ActualAnnotation$annotation$;
import ceylon.language.AliasesAnnotation$annotation$;
import ceylon.language.AuthorsAnnotation$annotation$;
import ceylon.language.Comparable;
import ceylon.language.Comparison;
import ceylon.language.DefaultAnnotation$annotation$;
import ceylon.language.DocAnnotation$annotation$;
import ceylon.language.FormalAnnotation$annotation$;
import ceylon.language.Number$impl;
import ceylon.language.Numeric;
import ceylon.language.SeeAnnotation$annotation$;
import ceylon.language.SeeAnnotation$annotations$;
import ceylon.language.SharedAnnotation$annotation$;
import ceylon.language.SinceAnnotation$annotation$;
import ceylon.language.TagsAnnotation$annotation$;
import ceylon.language.ThrownExceptionAnnotation$annotation$;
import ceylon.language.ThrownExceptionAnnotation$annotations$;
import com.redhat.ceylon.common.NonNull;
import com.redhat.ceylon.compiler.java.metadata.Annotation;
import com.redhat.ceylon.compiler.java.metadata.Annotations;
import com.redhat.ceylon.compiler.java.metadata.CaseTypes;
import com.redhat.ceylon.compiler.java.metadata.Ceylon;
import com.redhat.ceylon.compiler.java.metadata.Ignore;
import com.redhat.ceylon.compiler.java.metadata.Name;
import com.redhat.ceylon.compiler.java.metadata.SatisfiedTypes;
import com.redhat.ceylon.compiler.java.metadata.Transient;
import com.redhat.ceylon.compiler.java.metadata.TypeInfo;
import com.redhat.ceylon.compiler.java.metadata.TypeParameter;
import com.redhat.ceylon.compiler.java.metadata.TypeParameters;
import com.redhat.ceylon.compiler.java.metadata.Variance;

@Ceylon(major=8, minor=1)
@DocAnnotation$annotation$(description="Abstraction of [[numeric|Numeric]] types with a natural \n[[total order|Comparable]], including the built-in numeric \ntypes [[Integer]] and [[Float]].\n\nA `Number` has a well-defined [[magnitude]] together with a \n[[sign]] of type [[Integer]], defined for any instance `x`\nas follows:\n\n- if `x==0` then `x.sign==0` and `x.magnitude==0`,\n- if `x>0` then `x.sign==1` and `x.magnitude==x`, or\n- if `x<0` then `x.sign==-1` and `x.magnitude==-x`,\n\nwhere `0` is the additive identity of the numeric type.\n\nNot every value commonly considered to be a \"number\" is\na `Number`. For example, complex numbers aren't `Number`s\nsince they don't have a total order.")
@SeeAnnotation$annotations$(value={@SeeAnnotation$annotation$(programElements={"::1.3.3:ceylon.language::CInteger", "::1.3.3:ceylon.language::CFloat"})})
@AuthorsAnnotation$annotation$(authors={"Gavin"})
@TagsAnnotation$annotation$(tags={"Numbers"})
@SharedAnnotation$annotation$
@Annotations(modifiers=2L, value={@Annotation(value="doc", arguments={"Abstraction of [[numeric|Numeric]] types with a natural \n[[total order|Comparable]], including the built-in numeric \ntypes [[Integer]] and [[Float]].\n\nA `Number` has a well-defined [[magnitude]] together with a \n[[sign]] of type [[Integer]], defined for any instance `x`\nas follows:\n\n- if `x==0` then `x.sign==0` and `x.magnitude==0`,\n- if `x>0` then `x.sign==1` and `x.magnitude==x`, or\n- if `x<0` then `x.sign==-1` and `x.magnitude==-x`,\n\nwhere `0` is the additive identity of the numeric type.\n\nNot every value commonly considered to be a \"number\" is\na `Number`. For example, complex numbers aren't `Number`s\nsince they don't have a total order."}), @Annotation(value="see", arguments={"Integer", "Float"}), @Annotation(value="by", arguments={"Gavin"}), @Annotation(value="tagged", arguments={"Numbers"})})
@SatisfiedTypes(value={"ceylon.language::Numeric<Other>", "ceylon.language::Comparable<Other>"})
@CaseTypes(of="Other")
@TypeParameters(value={@TypeParameter(value="Other", variance=Variance.NONE, satisfies={"ceylon.language::Number<Other>"}, caseTypes={})})
public interface Number<Other extends Number<Other>>
extends Numeric<Other>,
Comparable<Other> {
    @Ignore
    public Number$impl<Other> $ceylon$language$Number$impl();

    @DocAnnotation$annotation$(description="The magnitude of this number, defined for any instance \n`x` as:\n\n- `-x` if `x<0`, or \n- `x` otherwise,\n\nwhere `0` is the additive identity. Hence:\n\n- `x.magnitude >= 0` for any `x`, and\n- `x.magnitude == 0` if and only if `x==0`.")
    @AliasesAnnotation$annotation$(aliases={"absolute"})
    @SharedAnnotation$annotation$
    @DefaultAnnotation$annotation$
    @Annotations(modifiers=258L, value={@Annotation(value="doc", arguments={"The magnitude of this number, defined for any instance \n`x` as:\n\n- `-x` if `x<0`, or \n- `x` otherwise,\n\nwhere `0` is the additive identity. Hence:\n\n- `x.magnitude >= 0` for any `x`, and\n- `x.magnitude == 0` if and only if `x==0`."}), @Annotation(value="aliased", arguments={"absolute"})})
    @TypeInfo(value="Other", erased=true)
    @Transient
    public Other getMagnitude();

    @DocAnnotation$annotation$(description="The sign of this number: \n\n- `1` if the number is [[positive]], \n- `-1` if it is [[negative]], or \n- `0` if it is the additive identity.\n\nMust satisfy:\n\n    x.magnitude.timesInteger(x.sign) == x")
    @SharedAnnotation$annotation$
    @DefaultAnnotation$annotation$
    @Annotations(modifiers=258L, value={@Annotation(value="doc", arguments={"The sign of this number: \n\n- `1` if the number is [[positive]], \n- `-1` if it is [[negative]], or \n- `0` if it is the additive identity.\n\nMust satisfy:\n\n    x.magnitude.timesInteger(x.sign) == x"})})
    @Transient
    public long getSign();

    @DocAnnotation$annotation$(description="Determine if the number is strictly positive, that is, \nif `this>0`, where `0` is the additive identity.")
    @SharedAnnotation$annotation$
    @FormalAnnotation$annotation$
    @Annotations(modifiers=130L, value={@Annotation(value="doc", arguments={"Determine if the number is strictly positive, that is, \nif `this>0`, where `0` is the additive identity."})})
    public boolean getPositive();

    @DocAnnotation$annotation$(description="Determine if the number is strictly negative, that is, \nif `this<0`, where `0` is the additive identity.")
    @SharedAnnotation$annotation$
    @FormalAnnotation$annotation$
    @Annotations(modifiers=130L, value={@Annotation(value="doc", arguments={"Determine if the number is strictly negative, that is, \nif `this<0`, where `0` is the additive identity."})})
    public boolean getNegative();

    @DocAnnotation$annotation$(description="The fractional part of this number, after truncation of \nthe integral part. For [[Integral]] numeric types, the \nfractional part is always zero.")
    @SharedAnnotation$annotation$
    @FormalAnnotation$annotation$
    @Annotations(modifiers=130L, value={@Annotation(value="doc", arguments={"The fractional part of this number, after truncation of \nthe integral part. For [[Integral]] numeric types, the \nfractional part is always zero."})})
    @TypeInfo(value="Other", erased=true)
    public Other getFractionalPart();

    @DocAnnotation$annotation$(description="The integral value of the number after truncation of \nthe fractional part. For [[Integral]] numeric types, \nthe integral value of a number is the number itself.")
    @SharedAnnotation$annotation$
    @FormalAnnotation$annotation$
    @Annotations(modifiers=130L, value={@Annotation(value="doc", arguments={"The integral value of the number after truncation of \nthe fractional part. For [[Integral]] numeric types, \nthe integral value of a number is the number itself."})})
    @TypeInfo(value="Other", erased=true)
    public Other getWholePart();

    @DocAnnotation$annotation$(description="The result of multiplying this number by the given \n[[Integer]].")
    @SinceAnnotation$annotation$(version="1.1.0")
    @SharedAnnotation$annotation$
    @FormalAnnotation$annotation$
    @Annotations(modifiers=130L, value={@Annotation(value="doc", arguments={"The result of multiplying this number by the given \n[[Integer]]."})})
    @TypeInfo(value="Other", erased=true)
    public Other timesInteger(@Name(value="integer") long var1);

    @DocAnnotation$annotation$(description="The result of adding this number to the given \n[[Integer]].")
    @SinceAnnotation$annotation$(version="1.1.0")
    @SharedAnnotation$annotation$
    @FormalAnnotation$annotation$
    @Annotations(modifiers=130L, value={@Annotation(value="doc", arguments={"The result of adding this number to the given \n[[Integer]]."})})
    @TypeInfo(value="Other", erased=true)
    public Other plusInteger(@Name(value="integer") long var1);

    @DocAnnotation$annotation$(description="The result of raising this number to the given \nnon-negative [[Integer]] power. For a negative power,\nthe behavior is implementation-dependent.")
    @ThrownExceptionAnnotation$annotations$(value={@ThrownExceptionAnnotation$annotation$(type="::1.3.3:ceylon.language::CAssertionError", when="if the exponent is a negative power and this is \nan integral numeric type")})
    @SinceAnnotation$annotation$(version="1.1.0")
    @SharedAnnotation$annotation$
    @FormalAnnotation$annotation$
    @Annotations(modifiers=130L, value={@Annotation(value="doc", arguments={"The result of raising this number to the given \nnon-negative [[Integer]] power. For a negative power,\nthe behavior is implementation-dependent."}), @Annotation(value="throws", arguments={"AssertionError", "if the exponent is a negative power and this is \nan integral numeric type"})})
    @TypeInfo(value="Other", erased=true)
    public Other powerOfInteger(@Name(value="integer") long var1);

    @Override
    @DocAnnotation$annotation$(description="Compares this number with the given number, returning:\n\n- [[larger]], if the [[difference|minus]] `this-other`\n  between the numbers is [[positive]],\n- [[smaller]], if the difference `this-other` between \n  the numbers is [[negative]], or\n- [[equal]] otherwise.")
    @SharedAnnotation$annotation$
    @ActualAnnotation$annotation$
    @DefaultAnnotation$annotation$
    @Annotations(modifiers=322L, value={@Annotation(value="doc", arguments={"Compares this number with the given number, returning:\n\n- [[larger]], if the [[difference|minus]] `this-other`\n  between the numbers is [[positive]],\n- [[smaller]], if the difference `this-other` between \n  the numbers is [[negative]], or\n- [[equal]] otherwise."})})
    @TypeInfo(value="ceylon.language::Comparison")
    @NonNull
    public Comparison compare(@Name(value="other") @TypeInfo(value="Other", erased=true) Other var1);
}

