/*
 * Decompiled with CFR 0.152.
 */
package ceylon.language;

import ceylon.language.AuthorsAnnotation$annotation$;
import ceylon.language.DocAnnotation$annotation$;
import ceylon.language.FormalAnnotation$annotation$;
import ceylon.language.Invertible;
import ceylon.language.SeeAnnotation$annotation$;
import ceylon.language.SeeAnnotation$annotations$;
import ceylon.language.SharedAnnotation$annotation$;
import ceylon.language.TagsAnnotation$annotation$;
import com.redhat.ceylon.compiler.java.metadata.Annotation;
import com.redhat.ceylon.compiler.java.metadata.Annotations;
import com.redhat.ceylon.compiler.java.metadata.CaseTypes;
import com.redhat.ceylon.compiler.java.metadata.Ceylon;
import com.redhat.ceylon.compiler.java.metadata.Name;
import com.redhat.ceylon.compiler.java.metadata.SatisfiedTypes;
import com.redhat.ceylon.compiler.java.metadata.TypeInfo;
import com.redhat.ceylon.compiler.java.metadata.TypeParameter;
import com.redhat.ceylon.compiler.java.metadata.TypeParameters;
import com.redhat.ceylon.compiler.java.metadata.Variance;

@Ceylon(major=8, minor=1)
@DocAnnotation$annotation$(description="Abstraction of numeric types with the usual binary \noperations:\n\n- addition, `x + y`, \n- subtraction, `x - y`, \n- multiplication, `x * y`, and \n- division, `x / y`, along with \n- additive inverse `-x`.\n\nA concrete class which implements this interface should be\na mathematical _ring_. That is:\n\n- both addition, `+`, and multiplication, `*`, should be\n  associative and commutative,\n- there should be additive and multiplicative identities,\n  denoted `0` and `1` respectively, satisfying `x+0 == x`\n  and `x*1 == x`,\n- every instance `x` should have an additive inverse `-x`, \n  satisfying `x + -x == 0`, and\n- multiplication should distribute over addition, \n  satisfying `x*(y+z) == x*y + x*z`.\n\nIt is preferred, but not required, that the class be a\nmathematical _field_. That is, in addition to the above:\n\n- every instance `x` such that `x!=0` should have a \n  multiplicative inverse `1/x`, satisfying `x * 1/x == 1`. \n\nFor numeric types which are not fields, for example, \n[[Integer]], there is still a division operation, which is\nunderstood to produce a [[remainder|Integral.remainder]].\nThe division operation should satisfy:\n\n- `x*y / y == x`\n\nfor any instance `y` other than `0`.\n\nFor numeric types which _are_ fields, division never\nproduces a remainder, and division should additionally \nsatisfy:\n\n- `x/y * y == x`\n\nfor any instance `y` other than `0`.\n\nSome numeric types, for example complex numbers, do not \nhave a [[total order|Comparable]]. Numeric types with a \ntotal order also satisfy [[Number]].")
@SeeAnnotation$annotations$(value={@SeeAnnotation$annotation$(programElements={"::1.3.3:ceylon.language::INumber"})})
@AuthorsAnnotation$annotation$(authors={"Gavin"})
@TagsAnnotation$annotation$(tags={"Numbers"})
@SharedAnnotation$annotation$
@Annotations(modifiers=2L, value={@Annotation(value="doc", arguments={"Abstraction of numeric types with the usual binary \noperations:\n\n- addition, `x + y`, \n- subtraction, `x - y`, \n- multiplication, `x * y`, and \n- division, `x / y`, along with \n- additive inverse `-x`.\n\nA concrete class which implements this interface should be\na mathematical _ring_. That is:\n\n- both addition, `+`, and multiplication, `*`, should be\n  associative and commutative,\n- there should be additive and multiplicative identities,\n  denoted `0` and `1` respectively, satisfying `x+0 == x`\n  and `x*1 == x`,\n- every instance `x` should have an additive inverse `-x`, \n  satisfying `x + -x == 0`, and\n- multiplication should distribute over addition, \n  satisfying `x*(y+z) == x*y + x*z`.\n\nIt is preferred, but not required, that the class be a\nmathematical _field_. That is, in addition to the above:\n\n- every instance `x` such that `x!=0` should have a \n  multiplicative inverse `1/x`, satisfying `x * 1/x == 1`. \n\nFor numeric types which are not fields, for example, \n[[Integer]], there is still a division operation, which is\nunderstood to produce a [[remainder|Integral.remainder]].\nThe division operation should satisfy:\n\n- `x*y / y == x`\n\nfor any instance `y` other than `0`.\n\nFor numeric types which _are_ fields, division never\nproduces a remainder, and division should additionally \nsatisfy:\n\n- `x/y * y == x`\n\nfor any instance `y` other than `0`.\n\nSome numeric types, for example complex numbers, do not \nhave a [[total order|Comparable]]. Numeric types with a \ntotal order also satisfy [[Number]]."}), @Annotation(value="see", arguments={"Number"}), @Annotation(value="by", arguments={"Gavin"}), @Annotation(value="tagged", arguments={"Numbers"})})
@SatisfiedTypes(value={"ceylon.language::Invertible<Other>"})
@CaseTypes(of="Other")
@TypeParameters(value={@TypeParameter(value="Other", variance=Variance.NONE, satisfies={"ceylon.language::Numeric<Other>"}, caseTypes={})})
public interface Numeric<Other extends Numeric<Other>>
extends Invertible<Other> {
    @DocAnnotation$annotation$(description="The product of this number and the given number.")
    @SharedAnnotation$annotation$
    @FormalAnnotation$annotation$
    @Annotations(modifiers=130L, value={@Annotation(value="doc", arguments={"The product of this number and the given number."})})
    @TypeInfo(value="Other", erased=true)
    public Other times(@Name(value="other") @TypeInfo(value="Other", erased=true) Other var1);

    @DocAnnotation$annotation$(description="The quotient obtained by dividing this number by the \ngiven number. For [[integral|Integral]] numeric types, \nthis operation rounds toward `0`, the additive identity,\nand results in a [[remainder|Integral.remainder]].\n\nWhen the given [[divisor|other]] is exactly `0`, the \nadditive identity, the behavior depends on the numeric \ntype:\n\n- For some numeric types, including [[Integer]], \n  division by `0` results in an exception.\n- For others, including [[Float]], it results in a \n  special value of the type, for example, [[infinity]].")
    @SeeAnnotation$annotations$(value={@SeeAnnotation$annotation$(programElements={"::1.3.3:ceylon.language::IIntegral.Fremainder", "::1.3.3:ceylon.language::Vinfinity"})})
    @SharedAnnotation$annotation$
    @FormalAnnotation$annotation$
    @Annotations(modifiers=130L, value={@Annotation(value="doc", arguments={"The quotient obtained by dividing this number by the \ngiven number. For [[integral|Integral]] numeric types, \nthis operation rounds toward `0`, the additive identity,\nand results in a [[remainder|Integral.remainder]].\n\nWhen the given [[divisor|other]] is exactly `0`, the \nadditive identity, the behavior depends on the numeric \ntype:\n\n- For some numeric types, including [[Integer]], \n  division by `0` results in an exception.\n- For others, including [[Float]], it results in a \n  special value of the type, for example, [[infinity]]."}), @Annotation(value="see", arguments={"Integral.remainder", "infinity"})})
    @TypeInfo(value="Other", erased=true)
    public Other divided(@Name(value="other") @TypeInfo(value="Other", erased=true) Other var1);
}

