/*
 * Decompiled with CFR 0.152.
 */
package ceylon.language;

import ceylon.language.AbstractAnnotation$annotation$;
import ceylon.language.AuthorsAnnotation$annotation$;
import ceylon.language.DefaultAnnotation$annotation$;
import ceylon.language.DocAnnotation$annotation$;
import ceylon.language.FormalAnnotation$annotation$;
import ceylon.language.Integer;
import ceylon.language.SeeAnnotation$annotation$;
import ceylon.language.SeeAnnotation$annotations$;
import ceylon.language.SharedAnnotation$annotation$;
import ceylon.language.TagsAnnotation$annotation$;
import ceylon.language.className_;
import com.redhat.ceylon.common.NonNull;
import com.redhat.ceylon.compiler.java.metadata.Annotation;
import com.redhat.ceylon.compiler.java.metadata.Annotations;
import com.redhat.ceylon.compiler.java.metadata.Ceylon;
import com.redhat.ceylon.compiler.java.metadata.Class;
import com.redhat.ceylon.compiler.java.metadata.Ignore;
import com.redhat.ceylon.compiler.java.metadata.Name;
import com.redhat.ceylon.compiler.java.metadata.Transient;
import com.redhat.ceylon.compiler.java.metadata.TypeInfo;
import com.redhat.ceylon.compiler.java.runtime.model.ReifiedType;
import com.redhat.ceylon.compiler.java.runtime.model.TypeDescriptor;

@Ceylon(major=8, minor=1)
@DocAnnotation$annotation$(description="The abstract supertype of all types representing definite \nvalues. Any two values which are assignable to `Object` \nmay be compared for value equality using the `==` and `!=` \noperators, even if the values are of different concrete \ntype:\n\n    true == false\n    1 == \"hello world\"\n    \"hello\"+\" \"+\"world\" == \"hello world\"\n    Singleton(\"hello world\") == [\"hello world\"]\n\nHowever, since [[Null]] is not a subtype of `Object`, the\nvalue [[null]] cannot be compared to any other value \nusing the `==` operator. Thus, value equality is not \ndefined for optional types. This neatly bypasses the \nproblem of deciding the value of the expression \n`null==null`, which is simply illegal.\n\nA concrete subclass of `Object` must refine [[equals]] \nand [[hash]] (or inherit concrete refinements), providing \na concrete definition of value equality for the class.\n\nIn extreme cases it is acceptable for two values to be\nequal even when they are not instances of the same class.\nFor example, the [[Integer]] value `1` and the [[Float]]\nvalue `1.0` are considered equal. Except in these extreme\ncases, instances of different classes are considered\nunequal.")
@SeeAnnotation$annotations$(value={@SeeAnnotation$annotation$(programElements={"::1.3.3:ceylon.language::CBasic", "::1.3.3:ceylon.language::CNull"})})
@AuthorsAnnotation$annotation$(authors={"Gavin"})
@TagsAnnotation$annotation$(tags={"Basic types"})
@SharedAnnotation$annotation$
@AbstractAnnotation$annotation$
@Annotations(modifiers=10L, value={@Annotation(value="doc", arguments={"The abstract supertype of all types representing definite \nvalues. Any two values which are assignable to `Object` \nmay be compared for value equality using the `==` and `!=` \noperators, even if the values are of different concrete \ntype:\n\n    true == false\n    1 == \"hello world\"\n    \"hello\"+\" \"+\"world\" == \"hello world\"\n    Singleton(\"hello world\") == [\"hello world\"]\n\nHowever, since [[Null]] is not a subtype of `Object`, the\nvalue [[null]] cannot be compared to any other value \nusing the `==` operator. Thus, value equality is not \ndefined for optional types. This neatly bypasses the \nproblem of deciding the value of the expression \n`null==null`, which is simply illegal.\n\nA concrete subclass of `Object` must refine [[equals]] \nand [[hash]] (or inherit concrete refinements), providing \na concrete definition of value equality for the class.\n\nIn extreme cases it is acceptable for two values to be\nequal even when they are not instances of the same class.\nFor example, the [[Integer]] value `1` and the [[Float]]\nvalue `1.0` are considered equal. Except in these extreme\ncases, instances of different classes are considered\nunequal."}), @Annotation(value="see", arguments={"Basic", "Null"}), @Annotation(value="by", arguments={"Gavin"}), @Annotation(value="tagged", arguments={"Basic types"})})
@Class(identifiable=false, basic=false, extendsType="ceylon.language::Anything")
public abstract class Object
implements ReifiedType {
    @Ignore
    public static final TypeDescriptor $TypeDescriptor$ = TypeDescriptor.klass(Object.class, new TypeDescriptor[0]);

    @DocAnnotation$annotation$(description="Determine if two values are equal.\n\nFor any two non-null objects `x` and `y`, `x.equals(y)`\nmay be written as:\n\n    x == y \n\nImplementations should respect the constraints that:\n\n- if `x===y` then `x==y` (reflexivity), \n- if `x==y` then `y==x` (symmetry), \n- if `x==y` and `y==z` then `x==z` (transitivity).\n\nFurthermore it is recommended that implementations\nensure that if `x==y` then `x` and `y` have the same \nconcrete class.\n\nA class which explicitly refines `equals()` is said to \nsupport _value equality_, and the equality operator \n`==` is considered much more meaningful for such \nclasses than for a class which simply inherits the\ndefault implementation of _identity equality_ from\n[[Identifiable]].\n\nNote that an implementation of `equals()` that always\nreturns [[false]] does satisfy the constraints given\nabove, as long as the class does _not_ inherit \n[[Identifiable]]. Therefore, in very rare cases where \nthere is no reasonable definition of value equality for \na class, for example, [[function references|Callable]], \nit is acceptable for `equals()` to be defined to return \n`false` for every argument.")
    @SharedAnnotation$annotation$
    @FormalAnnotation$annotation$
    @Annotations(modifiers=130L, value={@Annotation(value="doc", arguments={"Determine if two values are equal.\n\nFor any two non-null objects `x` and `y`, `x.equals(y)`\nmay be written as:\n\n    x == y \n\nImplementations should respect the constraints that:\n\n- if `x===y` then `x==y` (reflexivity), \n- if `x==y` then `y==x` (symmetry), \n- if `x==y` and `y==z` then `x==z` (transitivity).\n\nFurthermore it is recommended that implementations\nensure that if `x==y` then `x` and `y` have the same \nconcrete class.\n\nA class which explicitly refines `equals()` is said to \nsupport _value equality_, and the equality operator \n`==` is considered much more meaningful for such \nclasses than for a class which simply inherits the\ndefault implementation of _identity equality_ from\n[[Identifiable]].\n\nNote that an implementation of `equals()` that always\nreturns [[false]] does satisfy the constraints given\nabove, as long as the class does _not_ inherit \n[[Identifiable]]. Therefore, in very rare cases where \nthere is no reasonable definition of value equality for \na class, for example, [[function references|Callable]], \nit is acceptable for `equals()` to be defined to return \n`false` for every argument."})})
    public abstract boolean equals(@Name(value="that") @TypeInfo(value="ceylon.language::Object") @NonNull java.lang.Object var1);

    @DocAnnotation$annotation$(description="The hash value of the value, which allows the value to \nbe an element of a hash-based set or key of a\nhash-based map. Implementations must respect the\nconstraint that:\n\n- if `x==y` then `x.hash==y.hash`.\n\nTherefore, a class which refines [[equals]] must also\nrefine `hash`.\n\nIn general, `hash` values vary between platforms and\nbetween executions of the same program.\n\nNote that when executing on a Java Virtual Machine, the \n64-bit [[Integer]] value returned by an implementation \nof `hash` is truncated to a 32-bit integer value by \ntaking the exclusive disjunction of the 32 lowest-order\nbits with the 32 highest-order bits, before returning\nthe value to the caller.")
    @SeeAnnotation$annotations$(value={@SeeAnnotation$annotation$(programElements={"::1.3.3:ceylon.language::FidentityHash"})})
    @SharedAnnotation$annotation$
    @FormalAnnotation$annotation$
    @Annotations(modifiers=130L, value={@Annotation(value="doc", arguments={"The hash value of the value, which allows the value to \nbe an element of a hash-based set or key of a\nhash-based map. Implementations must respect the\nconstraint that:\n\n- if `x==y` then `x.hash==y.hash`.\n\nTherefore, a class which refines [[equals]] must also\nrefine `hash`.\n\nIn general, `hash` values vary between platforms and\nbetween executions of the same program.\n\nNote that when executing on a Java Virtual Machine, the \n64-bit [[Integer]] value returned by an implementation \nof `hash` is truncated to a 32-bit integer value by \ntaking the exclusive disjunction of the 32 lowest-order\nbits with the 32 highest-order bits, before returning\nthe value to the caller."}), @Annotation(value="see", arguments={"identityHash"})})
    public abstract int hashCode();

    @DocAnnotation$annotation$(description="A developer-friendly string representing the instance. \nConcatenates the name of the concrete class of the \ninstance with the `hash` of the instance. Subclasses \nare encouraged to refine this implementation to produce \na more meaningful representation.")
    @SharedAnnotation$annotation$
    @DefaultAnnotation$annotation$
    @Annotations(modifiers=258L, value={@Annotation(value="doc", arguments={"A developer-friendly string representing the instance. \nConcatenates the name of the concrete class of the \ninstance with the `hash` of the instance. Subclasses \nare encouraged to refine this implementation to produce \na more meaningful representation."})})
    @Transient
    @NonNull
    public String toString() {
        return className_.className(this) + "@" + Integer.format(this.hashCode(), 16L);
    }

    @Override
    @Ignore
    public TypeDescriptor $getType$() {
        return $TypeDescriptor$;
    }
}

