/*
 * Decompiled with CFR 0.152.
 */
package ceylon.language;

import ceylon.language.AbstractAnnotation$annotation$;
import ceylon.language.ActualAnnotation$annotation$;
import ceylon.language.AssertionError;
import ceylon.language.Boolean;
import ceylon.language.Callable;
import ceylon.language.Category$impl;
import ceylon.language.Collection$impl;
import ceylon.language.Comparison;
import ceylon.language.Correspondence$impl;
import ceylon.language.DocAnnotation$annotation$;
import ceylon.language.Entry;
import ceylon.language.Enumerable;
import ceylon.language.FormalAnnotation$annotation$;
import ceylon.language.Integer;
import ceylon.language.Iterable;
import ceylon.language.Iterable$impl;
import ceylon.language.List;
import ceylon.language.List$impl;
import ceylon.language.Map;
import ceylon.language.Object;
import ceylon.language.SealedAnnotation$annotation$;
import ceylon.language.SeeAnnotation$annotation$;
import ceylon.language.SeeAnnotation$annotations$;
import ceylon.language.Sequence;
import ceylon.language.Sequence$impl;
import ceylon.language.Sequential;
import ceylon.language.Sequential$impl;
import ceylon.language.SerializableAnnotation$annotation$;
import ceylon.language.SharedAnnotation$annotation$;
import ceylon.language.SinceAnnotation$annotation$;
import ceylon.language.TagsAnnotation$annotation$;
import ceylon.language.serialization.Member;
import ceylon.language.serialization.ReachableReference;
import com.redhat.ceylon.common.NonNull;
import com.redhat.ceylon.compiler.java.Util;
import com.redhat.ceylon.compiler.java.metadata.Annotation;
import com.redhat.ceylon.compiler.java.metadata.Annotations;
import com.redhat.ceylon.compiler.java.metadata.CaseTypes;
import com.redhat.ceylon.compiler.java.metadata.Ceylon;
import com.redhat.ceylon.compiler.java.metadata.Class;
import com.redhat.ceylon.compiler.java.metadata.Ignore;
import com.redhat.ceylon.compiler.java.metadata.Name;
import com.redhat.ceylon.compiler.java.metadata.SatisfiedTypes;
import com.redhat.ceylon.compiler.java.metadata.Transient;
import com.redhat.ceylon.compiler.java.metadata.TypeInfo;
import com.redhat.ceylon.compiler.java.metadata.TypeParameter;
import com.redhat.ceylon.compiler.java.metadata.TypeParameters;
import com.redhat.ceylon.compiler.java.metadata.Variance;
import com.redhat.ceylon.compiler.java.runtime.model.ReifiedType;
import com.redhat.ceylon.compiler.java.runtime.model.TypeDescriptor;
import com.redhat.ceylon.compiler.java.runtime.serialization.$Serialization$;
import com.redhat.ceylon.compiler.java.runtime.serialization.Serializable;
import java.util.ArrayList;
import java.util.Collection;

@Ceylon(major=8, minor=1)
@DocAnnotation$annotation$(description="A range of adjacent [[Enumerable]] values. Two values of an\nenumerable type are considered _adjacent_ if their \n[[offset|Enumerable.offset]] is of unit or zero magnitude. \nThus, a `Range` is a list of values where for every integer \n`index` where both `index` and `index+1` fall within the \nindices of the range:\n\n    range[index+1].offset(range[index]).magnitude <= 1\n\nA range is always nonempty, containing at least one value.\nThus, it is a [[Sequence]].\n\nA sequence of adjacent values may be represented very \nefficiently in memory, either:\n\n- via its endpoints, `first..last`, or \n- via an endpoint and length, `first:size`.\n\nFurthermore, certain operations are much more efficient \nthan for other lists, assuming that the enumerable type has \nefficient [[neighbour|Enumerable.neighbour]] and\n[[offset|Enumerable.offset]] functions.\n\nThe functions [[ceylon.language::span]] and \n[[ceylon.language::measure]], and corresponding operators \n`..` and `:` are used to create new instances of `Range`.")
@SeeAnnotation$annotations$(value={@SeeAnnotation$annotation$(programElements={"::1.3.3:ceylon.language::Fspan", "::1.3.3:ceylon.language::Fmeasure"})})
@TagsAnnotation$annotation$(tags={"Sequences"})
@SharedAnnotation$annotation$
@SealedAnnotation$annotation$
@AbstractAnnotation$annotation$
@SerializableAnnotation$annotation$
@Annotations(modifiers=4122L, value={@Annotation(value="doc", arguments={"A range of adjacent [[Enumerable]] values. Two values of an\nenumerable type are considered _adjacent_ if their \n[[offset|Enumerable.offset]] is of unit or zero magnitude. \nThus, a `Range` is a list of values where for every integer \n`index` where both `index` and `index+1` fall within the \nindices of the range:\n\n    range[index+1].offset(range[index]).magnitude <= 1\n\nA range is always nonempty, containing at least one value.\nThus, it is a [[Sequence]].\n\nA sequence of adjacent values may be represented very \nefficiently in memory, either:\n\n- via its endpoints, `first..last`, or \n- via an endpoint and length, `first:size`.\n\nFurthermore, certain operations are much more efficient \nthan for other lists, assuming that the enumerable type has \nefficient [[neighbour|Enumerable.neighbour]] and\n[[offset|Enumerable.offset]] functions.\n\nThe functions [[ceylon.language::span]] and \n[[ceylon.language::measure]], and corresponding operators \n`..` and `:` are used to create new instances of `Range`."}), @Annotation(value="see", arguments={"makeSpan", "makeMeasure"}), @Annotation(value="tagged", arguments={"Sequences"})})
@SatisfiedTypes(value={"[Element+]"})
@CaseTypes(value={"ceylon.language::Span<Element>", "ceylon.language::Measure<Element>"})
@TypeParameters(value={@TypeParameter(value="Element", variance=Variance.NONE, satisfies={"ceylon.language::Enumerable<Element>"}, caseTypes={})})
@Class(identifiable=false, basic=false, extendsType="ceylon.language::Object")
public abstract class Range<Element extends Enumerable<Element>>
implements ReifiedType,
Sequence<Element>,
java.io.Serializable,
Serializable {
    @Ignore
    private final TypeDescriptor $reified$Element;
    @Ignore
    protected final Sequence$impl<Element> $ceylon$language$Sequence$this$;
    @Ignore
    protected final Sequential$impl<Element> $ceylon$language$Sequential$this$;
    @Ignore
    protected final List$impl<Element> $ceylon$language$List$this$;
    @Ignore
    protected final Collection$impl<Element> $ceylon$language$Collection$this$;
    @Ignore
    protected final Iterable$impl<Element, java.lang.Object> $ceylon$language$Iterable$this$;
    @Ignore
    protected final Category$impl<java.lang.Object> $ceylon$language$Category$this$;
    @Ignore
    protected final Correspondence$impl<Integer, Element> $ceylon$language$Correspondence$this$;

    @Ignore
    public Range($Serialization$ ignored, TypeDescriptor $reified$Element) {
        this.$reified$Element = $reified$Element;
        this.$ceylon$language$Category$this$ = new Category$impl<java.lang.Object>(Object.$TypeDescriptor$, this);
        this.$ceylon$language$Iterable$this$ = new Iterable$impl($reified$Element, TypeDescriptor.NothingType, this);
        this.$ceylon$language$Collection$this$ = new Collection$impl($reified$Element, this);
        this.$ceylon$language$Correspondence$this$ = new Correspondence$impl(Integer.$TypeDescriptor$, $reified$Element, this);
        this.$ceylon$language$List$this$ = new List$impl($reified$Element, this);
        this.$ceylon$language$Sequential$this$ = new Sequential$impl($reified$Element, this);
        this.$ceylon$language$Sequence$this$ = new Sequence$impl($reified$Element, this);
    }

    public Range(@Ignore TypeDescriptor $reified$Element) {
        this.$reified$Element = $reified$Element;
        this.$ceylon$language$Sequence$this$ = new Sequence$impl($reified$Element, this);
        this.$ceylon$language$Sequential$this$ = new Sequential$impl($reified$Element, this);
        this.$ceylon$language$List$this$ = new List$impl($reified$Element, this);
        this.$ceylon$language$Collection$this$ = new Collection$impl($reified$Element, this);
        this.$ceylon$language$Iterable$this$ = new Iterable$impl($reified$Element, TypeDescriptor.NothingType, this);
        this.$ceylon$language$Category$this$ = new Category$impl<java.lang.Object>(Object.$TypeDescriptor$, this);
        this.$ceylon$language$Correspondence$this$ = new Correspondence$impl(Integer.$TypeDescriptor$, $reified$Element, this);
    }

    @Override
    @Ignore
    public Sequence$impl<? extends Element> $ceylon$language$Sequence$impl() {
        return this.$ceylon$language$Sequence$this$;
    }

    @Override
    @Ignore
    public <Other> Sequence append(TypeDescriptor $reified$Other, Sequential<? extends Other> elements) {
        return this.$ceylon$language$Sequence$this$.append($reified$Other, elements);
    }

    @Override
    @Ignore
    public Sequence<? extends Element> $clone() {
        return this.$ceylon$language$Sequence$this$.$clone();
    }

    @Override
    @Ignore
    public <Result> Sequence collect(TypeDescriptor $reified$Result, Callable<? extends Result> collecting) {
        return this.$ceylon$language$Sequence$this$.collect($reified$Result, collecting);
    }

    @Override
    @Ignore
    public final boolean getEmpty() {
        return this.$ceylon$language$Sequence$this$.getEmpty();
    }

    @Override
    @Ignore
    public Sequential<? extends Element> getExceptLast() {
        return this.$ceylon$language$Sequence$this$.getExceptLast();
    }

    @Override
    @Ignore
    public Element find(Callable<? extends Boolean> selecting) {
        return (Element)((Enumerable)this.$ceylon$language$Sequence$this$.find(selecting));
    }

    @Override
    @Ignore
    public Element findLast(Callable<? extends Boolean> selecting) {
        return (Element)((Enumerable)this.$ceylon$language$Sequence$this$.findLast(selecting));
    }

    @Override
    @Ignore
    public Range indexes() {
        return this.$ceylon$language$Sequence$this$.indexes();
    }

    @Override
    @Ignore
    public Range<Integer> getKeys() {
        return this.$ceylon$language$Sequence$this$.getKeys();
    }

    @Override
    @Ignore
    public Integer getLastIndex() {
        return this.$ceylon$language$Sequence$this$.getLastIndex();
    }

    @Override
    @Ignore
    public boolean longerThan(long length) {
        return this.$ceylon$language$Sequence$this$.longerThan(length);
    }

    @Override
    @Ignore
    public Sequential measure(Integer from, long length) {
        return this.$ceylon$language$Sequence$this$.measure(from, length);
    }

    @Override
    @Ignore
    public <Other> Sequence prepend(TypeDescriptor $reified$Other, Sequential<? extends Other> elements) {
        return this.$ceylon$language$Sequence$this$.prepend($reified$Other, elements);
    }

    @Override
    @Ignore
    public Sequential<? extends Element> repeat(long times) {
        return this.$ceylon$language$Sequence$this$.repeat(times);
    }

    @Override
    @Ignore
    public Sequential<? extends Element> getRest() {
        return this.$ceylon$language$Sequence$this$.getRest();
    }

    @Override
    @Ignore
    public Sequence<? extends Element> getReversed() {
        return this.$ceylon$language$Sequence$this$.getReversed();
    }

    @Override
    @Ignore
    public Sequence sequence() {
        return this.$ceylon$language$Sequence$this$.sequence();
    }

    @Override
    @Ignore
    public boolean shorterThan(long length) {
        return this.$ceylon$language$Sequence$this$.shorterThan(length);
    }

    @Override
    @Ignore
    public Sequence slice(long index) {
        return this.$ceylon$language$Sequence$this$.slice(index);
    }

    @Override
    @Ignore
    public Sequence sort(Callable<? extends Comparison> comparing) {
        return this.$ceylon$language$Sequence$this$.sort(comparing);
    }

    @Override
    @Ignore
    public Sequential span(Integer from, Integer to) {
        return this.$ceylon$language$Sequence$this$.span(from, to);
    }

    @Override
    @Ignore
    public Sequential spanFrom(Integer from) {
        return this.$ceylon$language$Sequence$this$.spanFrom(from);
    }

    @Override
    @Ignore
    public Sequential spanTo(Integer to) {
        return this.$ceylon$language$Sequence$this$.spanTo(to);
    }

    @Override
    @Ignore
    public String toString() {
        return this.$ceylon$language$Sequence$this$.toString();
    }

    @Override
    @Ignore
    public Sequential<? extends Element> sublist(long from, long to) {
        return this.$ceylon$language$Sequence$this$.sublist(from, to);
    }

    @Override
    @Ignore
    public Sequential<? extends Element> sublistFrom(long from) {
        return this.$ceylon$language$Sequence$this$.sublistFrom(from);
    }

    @Override
    @Ignore
    public Sequential<? extends Element> sublistTo(long to) {
        return this.$ceylon$language$Sequence$this$.sublistTo(to);
    }

    @Override
    @Ignore
    public Sequence<? extends Element> tuple() {
        return this.$ceylon$language$Sequence$this$.tuple();
    }

    @Override
    @Ignore
    public <Other> Sequence withLeading(TypeDescriptor $reified$Other, Other element) {
        return this.$ceylon$language$Sequence$this$.withLeading($reified$Other, element);
    }

    @Override
    @Ignore
    public <Other> Sequence withTrailing(TypeDescriptor $reified$Other, Other element) {
        return this.$ceylon$language$Sequence$this$.withTrailing($reified$Other, element);
    }

    @Override
    @Ignore
    public Sequential$impl<? extends Element> $ceylon$language$Sequential$impl() {
        return this.$ceylon$language$Sequential$this$;
    }

    @Override
    @Ignore
    public Sequential<? extends Element> initial(long length) {
        return this.$ceylon$language$Sequential$this$.initial(length);
    }

    @Override
    @Ignore
    public Sequential<? extends Element> terminal(long length) {
        return this.$ceylon$language$Sequential$this$.terminal(length);
    }

    @Override
    @Ignore
    public Sequential<? extends Element> trim(Callable<? extends Boolean> trimming) {
        return this.$ceylon$language$Sequential$this$.trim(trimming);
    }

    @Override
    @Ignore
    public Sequential<? extends Element> trimLeading(Callable<? extends Boolean> trimming) {
        return this.$ceylon$language$Sequential$this$.trimLeading(trimming);
    }

    @Override
    @Ignore
    public Sequential<? extends Element> trimTrailing(Callable<? extends Boolean> trimming) {
        return this.$ceylon$language$Sequential$this$.trimTrailing(trimming);
    }

    @Override
    @Ignore
    public List$impl<? extends Element> $ceylon$language$List$impl() {
        return this.$ceylon$language$List$this$;
    }

    @Override
    @Ignore
    public boolean defines(Integer index) {
        return this.$ceylon$language$List$this$.defines(index);
    }

    @Override
    @Ignore
    public boolean endsWith(List<? extends java.lang.Object> sublist) {
        return this.$ceylon$language$List$this$.endsWith(sublist);
    }

    @Override
    @Ignore
    public boolean equals(java.lang.Object that) {
        return this.$ceylon$language$List$this$.equals(that);
    }

    @Override
    @Ignore
    public Integer firstIndexWhere(Callable<? extends Boolean> selecting) {
        return this.$ceylon$language$List$this$.firstIndexWhere(selecting);
    }

    @Override
    @Ignore
    public final Element get(Integer index) {
        return (Element)((Enumerable)this.$ceylon$language$List$this$.get(index));
    }

    @Override
    @Ignore
    public Element getFromLast(long index) {
        return (Element)((Enumerable)this.$ceylon$language$List$this$.getFromLast(index));
    }

    @Override
    @Ignore
    public int hashCode() {
        return this.$ceylon$language$List$this$.hashCode();
    }

    @Override
    @Ignore
    public Iterable<? extends Integer, ? extends java.lang.Object> indexesWhere(Callable<? extends Boolean> selecting) {
        return this.$ceylon$language$List$this$.indexesWhere(selecting);
    }

    @Override
    @Ignore
    public Integer lastIndexWhere(Callable<? extends Boolean> selecting) {
        return this.$ceylon$language$List$this$.lastIndexWhere(selecting);
    }

    @Override
    @Ignore
    public <Result> List<? extends Result> mapElements(TypeDescriptor $reified$Result, Callable<? extends Result> mapping) {
        return this.$ceylon$language$List$this$.mapElements($reified$Result, mapping);
    }

    @Override
    @Ignore
    public final <Other> long patch$from(TypeDescriptor $reified$Other, List<? extends Other> list) {
        return this.$ceylon$language$List$this$.patch$from($reified$Other, list);
    }

    @Override
    @Ignore
    public <Other> List patch(TypeDescriptor $reified$Other, List<? extends Other> list) {
        long $ceylontmp$from$0 = this.patch$from($reified$Other, list);
        long $ceylontmp$length$1 = this.patch$length($reified$Other, list, $ceylontmp$from$0);
        return this.patch$canonical$($reified$Other, list, $ceylontmp$from$0, $ceylontmp$length$1);
    }

    @Override
    @Ignore
    public final <Other> long patch$length(TypeDescriptor $reified$Other, List<? extends Other> list, long from) {
        return this.$ceylon$language$List$this$.patch$length($reified$Other, list, from);
    }

    @Override
    @Ignore
    public <Other> List patch(TypeDescriptor $reified$Other, List<? extends Other> list, long from) {
        long $ceylontmp$length$2 = this.patch$length($reified$Other, list, from);
        return this.patch$canonical$($reified$Other, list, from, $ceylontmp$length$2);
    }

    @Override
    @Ignore
    public <Other> List patch(TypeDescriptor $reified$Other, List<? extends Other> list, long from, long length) {
        return this.$ceylon$language$List$this$.patch($reified$Other, list, from, length);
    }

    @Ignore
    private <Other> List patch$canonical$(TypeDescriptor $reified$Other, List<? extends Other> list, long from, long length) {
        return this.$ceylon$language$List$this$.patch($reified$Other, list, from, length);
    }

    @Override
    @Ignore
    public boolean startsWith(List<? extends java.lang.Object> sublist) {
        return this.$ceylon$language$List$this$.startsWith(sublist);
    }

    @Override
    @Ignore
    public Collection$impl<? extends Element> $ceylon$language$Collection$impl() {
        return this.$ceylon$language$Collection$this$;
    }

    @Override
    @Ignore
    public final Iterable<? extends Sequence<? extends Element>, ? extends java.lang.Object> combinations(long length) {
        return this.$ceylon$language$Collection$this$.combinations(length);
    }

    @Override
    @Ignore
    public final Iterable<? extends Sequence<? extends Element>, ? extends java.lang.Object> getPermutations() {
        return this.$ceylon$language$Collection$this$.getPermutations();
    }

    @Override
    @Ignore
    public Iterable$impl<? extends Element, ? extends java.lang.Object> $ceylon$language$Iterable$impl() {
        return this.$ceylon$language$Iterable$this$;
    }

    @Override
    @Ignore
    public boolean any(Callable<? extends Boolean> selecting) {
        return this.$ceylon$language$Iterable$this$.any(selecting);
    }

    @Override
    @Ignore
    public Iterable<? extends Element, ? extends java.lang.Object> by(long step) {
        return this.$ceylon$language$Iterable$this$.by(step);
    }

    @Override
    @Ignore
    public <Other, OtherAbsent> Iterable chain(TypeDescriptor $reified$Other, TypeDescriptor $reified$OtherAbsent, Iterable<? extends Other, ? extends OtherAbsent> other) {
        return this.$ceylon$language$Iterable$this$.chain($reified$Other, $reified$OtherAbsent, other);
    }

    @Override
    @Ignore
    public long count(Callable<? extends Boolean> selecting) {
        return this.$ceylon$language$Iterable$this$.count(selecting);
    }

    @Override
    @Ignore
    public Iterable<? extends Element, ? extends java.lang.Object> getCycled() {
        return this.$ceylon$language$Iterable$this$.getCycled();
    }

    @Override
    @Ignore
    public <Default> Iterable defaultNullElements(TypeDescriptor $reified$Default, Default defaultValue) {
        return this.$ceylon$language$Iterable$this$.defaultNullElements($reified$Default, defaultValue);
    }

    @Override
    @Ignore
    public java.lang.Object each(Callable<? extends java.lang.Object> step) {
        return this.$ceylon$language$Iterable$this$.each(step);
    }

    @Override
    @Ignore
    public boolean every(Callable<? extends Boolean> selecting) {
        return this.$ceylon$language$Iterable$this$.every(selecting);
    }

    @Override
    @Ignore
    public Iterable<? extends Element, ? extends java.lang.Object> filter(Callable<? extends Boolean> selecting) {
        return this.$ceylon$language$Iterable$this$.filter(selecting);
    }

    @Override
    @Ignore
    public <Result, OtherAbsent> Iterable flatMap(TypeDescriptor $reified$Result, TypeDescriptor $reified$OtherAbsent, Callable<? extends Iterable<? extends Result, ? extends OtherAbsent>> collecting) {
        return this.$ceylon$language$Iterable$this$.flatMap($reified$Result, $reified$OtherAbsent, collecting);
    }

    @Override
    @Ignore
    public <Result> Callable<? extends Result> fold(TypeDescriptor $reified$Result, Result initial) {
        return this.$ceylon$language$Iterable$this$.fold($reified$Result, initial);
    }

    @Override
    @Ignore
    public <Other> Iterable follow(TypeDescriptor $reified$Other, Other head) {
        return this.$ceylon$language$Iterable$this$.follow($reified$Other, head);
    }

    @Override
    @Ignore
    public final Map<? extends Element, ? extends Integer> frequencies() {
        return this.$ceylon$language$Iterable$this$.frequencies();
    }

    @Override
    @Ignore
    public Element getFromFirst(long index) {
        return (Element)((Enumerable)this.$ceylon$language$Iterable$this$.getFromFirst(index));
    }

    @Override
    @Ignore
    public final <Group> Map<? extends Group, ? extends Sequence<? extends Element>> group(TypeDescriptor $reified$Group, Callable<? extends Group> grouping) {
        return this.$ceylon$language$Iterable$this$.group($reified$Group, grouping);
    }

    @Override
    @Ignore
    public Iterable<? extends Entry<? extends Integer, ? extends Element>, ? extends java.lang.Object> getIndexed() {
        return this.$ceylon$language$Iterable$this$.getIndexed();
    }

    @Override
    @Ignore
    public final <Other> long interpose$step(TypeDescriptor $reified$Other, Other element) {
        return this.$ceylon$language$Iterable$this$.interpose$step($reified$Other, element);
    }

    @Override
    @Ignore
    public <Other> Iterable interpose(TypeDescriptor $reified$Other, Other element) {
        long $ceylontmp$step$3 = this.interpose$step($reified$Other, element);
        return this.interpose$canonical$($reified$Other, element, $ceylontmp$step$3);
    }

    @Override
    @Ignore
    public <Other> Iterable interpose(TypeDescriptor $reified$Other, Other element, long step) {
        return this.$ceylon$language$Iterable$this$.interpose($reified$Other, element, step);
    }

    @Ignore
    private <Other> Iterable interpose$canonical$(TypeDescriptor $reified$Other, Other element, long step) {
        return this.$ceylon$language$Iterable$this$.interpose($reified$Other, element, step);
    }

    @Override
    @Ignore
    public Entry<? extends Integer, ? extends Element> locate(Callable<? extends Boolean> selecting) {
        return this.$ceylon$language$Iterable$this$.locate(selecting);
    }

    @Override
    @Ignore
    public Entry<? extends Integer, ? extends Element> locateLast(Callable<? extends Boolean> selecting) {
        return this.$ceylon$language$Iterable$this$.locateLast(selecting);
    }

    @Override
    @Ignore
    public Iterable<? extends Entry<? extends Integer, ? extends Element>, ? extends java.lang.Object> locations(Callable<? extends Boolean> selecting) {
        return this.$ceylon$language$Iterable$this$.locations(selecting);
    }

    @Override
    @Ignore
    public <Result> Iterable<? extends Result, ? extends java.lang.Object> map(TypeDescriptor $reified$Result, Callable<? extends Result> collecting) {
        return this.$ceylon$language$Iterable$this$.map($reified$Result, collecting);
    }

    @Override
    @Ignore
    public Element max(Callable<? extends Comparison> comparing) {
        return (Element)((Enumerable)this.$ceylon$language$Iterable$this$.max(comparing));
    }

    @Override
    @Ignore
    public <Type> Iterable narrow(TypeDescriptor $reified$Type) {
        return this.$ceylon$language$Iterable$this$.narrow($reified$Type);
    }

    @Override
    @Ignore
    public Iterable getPaired() {
        return this.$ceylon$language$Iterable$this$.getPaired();
    }

    @Override
    @Ignore
    public Iterable<? extends Sequence<? extends Element>, ? extends java.lang.Object> partition(long length) {
        return this.$ceylon$language$Iterable$this$.partition(length);
    }

    @Override
    @Ignore
    public <Other, OtherAbsent> Iterable product(TypeDescriptor $reified$Other, TypeDescriptor $reified$OtherAbsent, Iterable<? extends Other, ? extends OtherAbsent> other) {
        return this.$ceylon$language$Iterable$this$.product($reified$Other, $reified$OtherAbsent, other);
    }

    @Override
    @Ignore
    public <Result> java.lang.Object reduce(TypeDescriptor $reified$Result, Callable<? extends Result> accumulating) {
        return this.$ceylon$language$Iterable$this$.reduce($reified$Result, accumulating);
    }

    @Override
    @Ignore
    public <Result> Callable<? extends Iterable<? extends Result, ? extends java.lang.Object>> scan(TypeDescriptor $reified$Result, Result initial) {
        return this.$ceylon$language$Iterable$this$.scan($reified$Result, initial);
    }

    @Override
    @Ignore
    public Sequential<? extends Element> select(Callable<? extends Boolean> selecting) {
        return this.$ceylon$language$Iterable$this$.select(selecting);
    }

    @Override
    @Ignore
    public Iterable<? extends Element, ? extends java.lang.Object> skip(long skipping) {
        return this.$ceylon$language$Iterable$this$.skip(skipping);
    }

    @Override
    @Ignore
    public Iterable<? extends Element, ? extends java.lang.Object> skipWhile(Callable<? extends Boolean> skipping) {
        return this.$ceylon$language$Iterable$this$.skipWhile(skipping);
    }

    @Override
    @Ignore
    public <Result, Args extends Sequential<? extends java.lang.Object>> Callable<? extends Iterable<? extends Result, ? extends java.lang.Object>> spread(TypeDescriptor $reified$Result, TypeDescriptor $reified$Args, Callable<? extends Callable<? extends Result>> method) {
        return this.$ceylon$language$Iterable$this$.spread($reified$Result, $reified$Args, method);
    }

    @Override
    @Ignore
    public final <Group, Result> Map<? extends Group, ? extends Result> summarize(TypeDescriptor $reified$Group, TypeDescriptor $reified$Result, Callable<? extends Group> grouping, Callable<? extends Result> accumulating) {
        return this.$ceylon$language$Iterable$this$.summarize($reified$Group, $reified$Result, grouping, accumulating);
    }

    @Override
    @Ignore
    public final <Result> Map<? extends Element, ? extends Result> tabulate(TypeDescriptor $reified$Result, Callable<? extends Result> collecting) {
        return this.$ceylon$language$Iterable$this$.tabulate($reified$Result, collecting);
    }

    @Override
    @Ignore
    public Iterable<? extends Element, ? extends java.lang.Object> take(long taking) {
        return this.$ceylon$language$Iterable$this$.take(taking);
    }

    @Override
    @Ignore
    public Iterable<? extends Element, ? extends java.lang.Object> takeWhile(Callable<? extends Boolean> taking) {
        return this.$ceylon$language$Iterable$this$.takeWhile(taking);
    }

    @Override
    @Ignore
    public Category$impl<? super java.lang.Object> $ceylon$language$Category$impl() {
        return this.$ceylon$language$Category$this$;
    }

    @Override
    @Ignore
    public boolean containsAny(Iterable<? extends java.lang.Object, ? extends java.lang.Object> elements) {
        return this.$ceylon$language$Category$this$.containsAny(elements);
    }

    @Override
    @Ignore
    public boolean containsEvery(Iterable<? extends java.lang.Object, ? extends java.lang.Object> elements) {
        return this.$ceylon$language$Category$this$.containsEvery(elements);
    }

    @Override
    @Ignore
    public Correspondence$impl<? super Integer, ? extends Element> $ceylon$language$Correspondence$impl() {
        return this.$ceylon$language$Correspondence$this$;
    }

    @Override
    @Ignore
    public boolean definesAny(Iterable<? extends Integer, ? extends java.lang.Object> keys) {
        return this.$ceylon$language$Correspondence$this$.definesAny(keys);
    }

    @Override
    @Ignore
    public boolean definesEvery(Iterable<? extends Integer, ? extends java.lang.Object> keys) {
        return this.$ceylon$language$Correspondence$this$.definesEvery(keys);
    }

    @Override
    @Ignore
    public <Absent> Iterable<? extends Element, ? extends Absent> getAll(TypeDescriptor $reified$Absent, Iterable<? extends Integer, ? extends Absent> keys) {
        return this.$ceylon$language$Correspondence$this$.getAll($reified$Absent, keys);
    }

    @DocAnnotation$annotation$(description="Determines if this range includes the given value.")
    @SharedAnnotation$annotation$
    @FormalAnnotation$annotation$
    @Annotations(modifiers=130L, value={@Annotation(value="doc", arguments={"Determines if this range includes the given value."})})
    public abstract boolean containsElement(@Name(value="element") @TypeInfo(value="Element", erased=true) Element var1);

    @DocAnnotation$annotation$(description="Determines if this range includes the given range.")
    @SharedAnnotation$annotation$
    @FormalAnnotation$annotation$
    @Annotations(modifiers=130L, value={@Annotation(value="doc", arguments={"Determines if this range includes the given range."})})
    public abstract boolean includesRange(@Name(value="range") @TypeInfo(value="ceylon.language::Range<Element>", erased=true) @NonNull Range<Element> var1);

    /*
     * WARNING - void declaration
     */
    @Override
    @SharedAnnotation$annotation$
    @ActualAnnotation$annotation$
    @Annotations(modifiers=66L)
    public final boolean contains(@Name(value="element") @TypeInfo(value="ceylon.language::Object") @NonNull java.lang.Object element) {
        void var2_4;
        boolean $ceylontmp$ifResult$4;
        java.lang.Object element$6 = element;
        if (element$6 instanceof Enumerable && Util.isReified(element$6, this.$reified$Element)) {
            Enumerable element$7 = (Enumerable)element$6;
            $ceylontmp$ifResult$4 = this.containsElement(element$7);
        } else {
            $ceylontmp$ifResult$4 = false;
        }
        return (boolean)var2_4;
    }

    @DocAnnotation$annotation$(description="Returns a range of the same length and type as this\n   range, with its endpoints shifted by the given number \n   of elements, where:\n   \n   - a negative [[shift]] measures \n     [[decrements|Ordinal.predecessor]], and \n   - a positive `shift` measures \n     [[increments|Ordinal.successor]].")
    @SinceAnnotation$annotation$(version="1.1.0")
    @SharedAnnotation$annotation$
    @FormalAnnotation$annotation$
    @Annotations(modifiers=130L, value={@Annotation(value="doc", arguments={"Returns a range of the same length and type as this\n   range, with its endpoints shifted by the given number \n   of elements, where:\n   \n   - a negative [[shift]] measures \n     [[decrements|Ordinal.predecessor]], and \n   - a positive `shift` measures \n     [[increments|Ordinal.successor]]."})})
    @TypeInfo(value="ceylon.language::Range<Element>", erased=true)
    @NonNull
    public abstract Range<Element> shifted(@Name(value="shift") long var1);

    @DocAnnotation$annotation$(description="Determines if the range is increasing, that is, if\nsuccessors occur after predecessors.")
    @SinceAnnotation$annotation$(version="1.1.0")
    @SharedAnnotation$annotation$
    @FormalAnnotation$annotation$
    @Annotations(modifiers=130L, value={@Annotation(value="doc", arguments={"Determines if the range is increasing, that is, if\nsuccessors occur after predecessors."})})
    public abstract boolean getIncreasing();

    @DocAnnotation$annotation$(description="Determines if the range is decreasing, that is, if\npredecessors occur after successors.")
    @SharedAnnotation$annotation$
    @FormalAnnotation$annotation$
    @Annotations(modifiers=130L, value={@Annotation(value="doc", arguments={"Determines if the range is decreasing, that is, if\npredecessors occur after successors."})})
    public abstract boolean getDecreasing();

    @DocAnnotation$annotation$(description="Returns the range itself, since a range cannot contain \nnull elements.")
    @SharedAnnotation$annotation$
    @ActualAnnotation$annotation$
    @Annotations(modifiers=66L, value={@Annotation(value="doc", arguments={"Returns the range itself, since a range cannot contain \nnull elements."})})
    @TypeInfo(value="ceylon.language::Range<Element>", erased=true)
    @Transient
    @NonNull
    public final Range getCoalesced() {
        return this;
    }

    @DocAnnotation$annotation$(description="Returns the range itself, since a range cannot contain \nduplicate elements.")
    @SharedAnnotation$annotation$
    @ActualAnnotation$annotation$
    @Annotations(modifiers=66L, value={@Annotation(value="doc", arguments={"Returns the range itself, since a range cannot contain \nduplicate elements."})})
    @TypeInfo(value="ceylon.language::Range<Element>", erased=true)
    @Transient
    @NonNull
    public final Range getDistinct() {
        return this;
    }

    @Override
    @Ignore
    public TypeDescriptor $getType$() {
        return TypeDescriptor.klass(Range.class, this.$reified$Element);
    }

    @Override
    @Ignore
    public Collection<ReachableReference> $references$() {
        ArrayList<ReachableReference> reference = new ArrayList<ReachableReference>();
        return reference;
    }

    @Override
    @Ignore
    public java.lang.Object $get$(ReachableReference reference) {
        switch (((Member)reference).getAttribute().getQualifiedName()) {
            default: 
        }
        throw new RuntimeException("unknown attribute");
    }

    @Override
    @Ignore
    public void $set$(ReachableReference reference, java.lang.Object instance) {
        if (reference instanceof Member) {
            switch (((Member)reference).getAttribute().getQualifiedName()) {
                default: 
            }
            throw new RuntimeException("unknown attribute");
        }
        throw new AssertionError("unexpected reachable reference " + reference);
    }
}

