/*
 * Decompiled with CFR 0.152.
 */
package ceylon.language;

import ceylon.language.ActualAnnotation$annotation$;
import ceylon.language.Boolean;
import ceylon.language.Callable;
import ceylon.language.DefaultAnnotation$annotation$;
import ceylon.language.DocAnnotation$annotation$;
import ceylon.language.FormalAnnotation$annotation$;
import ceylon.language.Integer;
import ceylon.language.List;
import ceylon.language.Ranged;
import ceylon.language.SeeAnnotation$annotation$;
import ceylon.language.SeeAnnotation$annotations$;
import ceylon.language.Sequence;
import ceylon.language.Sequential$impl;
import ceylon.language.SharedAnnotation$annotation$;
import ceylon.language.SinceAnnotation$annotation$;
import ceylon.language.TagsAnnotation$annotation$;
import com.redhat.ceylon.common.NonNull;
import com.redhat.ceylon.compiler.java.metadata.Annotation;
import com.redhat.ceylon.compiler.java.metadata.Annotations;
import com.redhat.ceylon.compiler.java.metadata.CaseTypes;
import com.redhat.ceylon.compiler.java.metadata.Ceylon;
import com.redhat.ceylon.compiler.java.metadata.FunctionalParameter;
import com.redhat.ceylon.compiler.java.metadata.Ignore;
import com.redhat.ceylon.compiler.java.metadata.Name;
import com.redhat.ceylon.compiler.java.metadata.SatisfiedTypes;
import com.redhat.ceylon.compiler.java.metadata.Transient;
import com.redhat.ceylon.compiler.java.metadata.TypeInfo;
import com.redhat.ceylon.compiler.java.metadata.TypeParameter;
import com.redhat.ceylon.compiler.java.metadata.TypeParameters;
import com.redhat.ceylon.compiler.java.metadata.Variance;
import com.redhat.ceylon.compiler.java.runtime.model.TypeDescriptor;

@Ceylon(major=8, minor=1)
@DocAnnotation$annotation$(description="A possibly-empty, immutable sequence of values. The type \n`Sequential<Element>` may be abbreviated `[Element*]` or \n`Element[]`. \n\n`Sequential` has two enumerated subtypes:\n\n- [[Empty]], abbreviated `[]`, represents an empty \n  sequence, and\n- [[Sequence]]`<Element>`, abbreviated `[Element+]` \n  represents a non-empty sequence, and has the very \n  important subclass [[Tuple]].")
@SeeAnnotation$annotations$(value={@SeeAnnotation$annotation$(programElements={"::1.3.3:ceylon.language::CTuple"})})
@TagsAnnotation$annotation$(tags={"Sequences"})
@SharedAnnotation$annotation$
@Annotations(modifiers=2L, value={@Annotation(value="doc", arguments={"A possibly-empty, immutable sequence of values. The type \n`Sequential<Element>` may be abbreviated `[Element*]` or \n`Element[]`. \n\n`Sequential` has two enumerated subtypes:\n\n- [[Empty]], abbreviated `[]`, represents an empty \n  sequence, and\n- [[Sequence]]`<Element>`, abbreviated `[Element+]` \n  represents a non-empty sequence, and has the very \n  important subclass [[Tuple]]."}), @Annotation(value="see", arguments={"Tuple"}), @Annotation(value="tagged", arguments={"Sequences"})})
@SatisfiedTypes(value={"ceylon.language::List<Element>", "ceylon.language::Ranged<ceylon.language::Integer,Element,Element[]>"})
@CaseTypes(value={"[]", "[Element+]"})
@TypeParameters(value={@TypeParameter(value="Element", variance=Variance.OUT, satisfies={}, caseTypes={}, defaultValue="ceylon.language::Anything")})
public interface Sequential<Element>
extends List<Element>,
Ranged<Integer, Element, Sequential<? extends Element>> {
    @Ignore
    public Sequential$impl<? extends Element> $ceylon$language$Sequential$impl();

    @Override
    @Ignore
    public Sequential span(Integer var1, Integer var2);

    @Override
    @Ignore
    public Sequential spanFrom(Integer var1);

    @Override
    @Ignore
    public Sequential spanTo(Integer var1);

    @Override
    @Ignore
    public Sequential measure(Integer var1, long var2);

    @Override
    @DocAnnotation$annotation$(description="The strictly-positive length of this sequence, that is, \nthe number of elements in this sequence.")
    @SharedAnnotation$annotation$
    @ActualAnnotation$annotation$
    @FormalAnnotation$annotation$
    @Annotations(modifiers=194L, value={@Annotation(value="doc", arguments={"The strictly-positive length of this sequence, that is, \nthe number of elements in this sequence."})})
    public long getSize();

    @Override
    @DocAnnotation$annotation$(description="A sequence containing all indexes of this sequence,\nthat is, every index in the range `0:sequence.size`.")
    @SharedAnnotation$annotation$
    @ActualAnnotation$annotation$
    @DefaultAnnotation$annotation$
    @Annotations(modifiers=322L, value={@Annotation(value="doc", arguments={"A sequence containing all indexes of this sequence,\nthat is, every index in the range `0:sequence.size`."})})
    @TypeInfo(value="ceylon.language::Integer[]")
    @Transient
    @NonNull
    public Sequential<? extends Integer> getKeys();

    @Override
    @DocAnnotation$annotation$(description="This sequence.")
    @SharedAnnotation$annotation$
    @ActualAnnotation$annotation$
    @DefaultAnnotation$annotation$
    @Annotations(modifiers=322L, value={@Annotation(value="doc", arguments={"This sequence."})})
    @TypeInfo(value="[Element+]|[]", erased=true)
    @NonNull
    public Sequential sequence();

    @Override
    @DocAnnotation$annotation$(description="The rest of the sequence, without the first element.")
    @SharedAnnotation$annotation$
    @ActualAnnotation$annotation$
    @FormalAnnotation$annotation$
    @Annotations(modifiers=194L, value={@Annotation(value="doc", arguments={"The rest of the sequence, without the first element."})})
    @TypeInfo(value="Element[]")
    @NonNull
    public Sequential<? extends Element> getRest();

    @DocAnnotation$annotation$(description="This sequence, without the last element.")
    @SinceAnnotation$annotation$(version="1.3.3")
    @SharedAnnotation$annotation$
    @ActualAnnotation$annotation$
    @FormalAnnotation$annotation$
    @Annotations(modifiers=194L, value={@Annotation(value="doc", arguments={"This sequence, without the last element."})})
    @TypeInfo(value="Element[]")
    @NonNull
    public Sequential<? extends Element> getExceptLast();

    @Override
    @DocAnnotation$annotation$(description="A subsequence of this sequence, starting at the element \nwith index [[from]], ending at the element with the \nindex [[to]].")
    @SinceAnnotation$annotation$(version="1.3.3")
    @SharedAnnotation$annotation$
    @ActualAnnotation$annotation$
    @FormalAnnotation$annotation$
    @Annotations(modifiers=194L, value={@Annotation(value="doc", arguments={"A subsequence of this sequence, starting at the element \nwith index [[from]], ending at the element with the \nindex [[to]]."})})
    @TypeInfo(value="Element[]")
    @NonNull
    public Sequential<? extends Element> sublist(@Name(value="from") long var1, @Name(value="to") long var3);

    @Override
    @DocAnnotation$annotation$(description="A subsequence of this sequence, ending at the element \nwith the given [[index|to]].")
    @SinceAnnotation$annotation$(version="1.3.3")
    @SharedAnnotation$annotation$
    @ActualAnnotation$annotation$
    @FormalAnnotation$annotation$
    @Annotations(modifiers=194L, value={@Annotation(value="doc", arguments={"A subsequence of this sequence, ending at the element \nwith the given [[index|to]]."})})
    @TypeInfo(value="Element[]")
    @NonNull
    public Sequential<? extends Element> sublistTo(@Name(value="to") long var1);

    @Override
    @DocAnnotation$annotation$(description="A subsequence of this sequence, starting at the element \nwith the given [[index|from]].")
    @SinceAnnotation$annotation$(version="1.3.3")
    @SharedAnnotation$annotation$
    @ActualAnnotation$annotation$
    @FormalAnnotation$annotation$
    @Annotations(modifiers=194L, value={@Annotation(value="doc", arguments={"A subsequence of this sequence, starting at the element \nwith the given [[index|from]]."})})
    @TypeInfo(value="Element[]")
    @NonNull
    public Sequential<? extends Element> sublistFrom(@Name(value="from") long var1);

    @Override
    @DocAnnotation$annotation$(description="A sequence containing the elements of this sequence in\nreverse order to the order in which they occur in this\nsequence, or the [[empty sequence|empty]] if this\nsequence is the empty sequence.")
    @SharedAnnotation$annotation$
    @ActualAnnotation$annotation$
    @FormalAnnotation$annotation$
    @Annotations(modifiers=194L, value={@Annotation(value="doc", arguments={"A sequence containing the elements of this sequence in\nreverse order to the order in which they occur in this\nsequence, or the [[empty sequence|empty]] if this\nsequence is the empty sequence."})})
    @TypeInfo(value="Element[]")
    @NonNull
    public Sequential<? extends Element> getReversed();

    @Override
    @DocAnnotation$annotation$(description="Produces a sequence formed by repeating the elements of\nthis sequence the given [[number of times|times]], or\nthe [[empty sequence|empty]] if `times<=0` or if this\nsequence is the empty sequence.")
    @SharedAnnotation$annotation$
    @ActualAnnotation$annotation$
    @FormalAnnotation$annotation$
    @Annotations(modifiers=194L, value={@Annotation(value="doc", arguments={"Produces a sequence formed by repeating the elements of\nthis sequence the given [[number of times|times]], or\nthe [[empty sequence|empty]] if `times<=0` or if this\nsequence is the empty sequence."})})
    @TypeInfo(value="Element[]")
    @NonNull
    public Sequential<? extends Element> repeat(@Name(value="times") long var1);

    @Override
    @DocAnnotation$annotation$(description="Select the first elements of this sequence, returning \na sequence no longer than the given length. If this \nsequence is shorter than the given length, return this \nsequence. Otherwise return a sequence of the given \nlength. If `length<=0` return an [[Empty]] sequence.")
    @SharedAnnotation$annotation$
    @ActualAnnotation$annotation$
    @DefaultAnnotation$annotation$
    @Annotations(modifiers=322L, value={@Annotation(value="doc", arguments={"Select the first elements of this sequence, returning \na sequence no longer than the given length. If this \nsequence is shorter than the given length, return this \nsequence. Otherwise return a sequence of the given \nlength. If `length<=0` return an [[Empty]] sequence."})})
    @TypeInfo(value="Element[]")
    @NonNull
    public Sequential<? extends Element> initial(@Name(value="length") long var1);

    @Override
    @DocAnnotation$annotation$(description="Select the last elements of the sequence, returning a \nsequence no longer than the given length. If this \nsequence is shorter than the given length, return this \nsequence. Otherwise return a sequence of the given \nlength.")
    @SharedAnnotation$annotation$
    @ActualAnnotation$annotation$
    @DefaultAnnotation$annotation$
    @Annotations(modifiers=322L, value={@Annotation(value="doc", arguments={"Select the last elements of the sequence, returning a \nsequence no longer than the given length. If this \nsequence is shorter than the given length, return this \nsequence. Otherwise return a sequence of the given \nlength."})})
    @TypeInfo(value="Element[]")
    @NonNull
    public Sequential<? extends Element> terminal(@Name(value="length") long var1);

    @Override
    @DocAnnotation$annotation$(description="This sequence.")
    @SharedAnnotation$annotation$
    @ActualAnnotation$annotation$
    @DefaultAnnotation$annotation$
    @Annotations(modifiers=322L, value={@Annotation(value="doc", arguments={"This sequence."})})
    @TypeInfo(value="Element[]")
    @NonNull
    public Sequential<? extends Element> $clone();

    @Override
    @DocAnnotation$annotation$(description="Trim the elements satisfying the given predicate\nfunction from the start and end of this sequence, \nreturning a sequence no longer than this sequence.")
    @SharedAnnotation$annotation$
    @ActualAnnotation$annotation$
    @DefaultAnnotation$annotation$
    @Annotations(modifiers=322L, value={@Annotation(value="doc", arguments={"Trim the elements satisfying the given predicate\nfunction from the start and end of this sequence, \nreturning a sequence no longer than this sequence."})})
    @TypeInfo(value="Element[]")
    @NonNull
    public Sequential<? extends Element> trim(@Name(value="trimming") @FunctionalParameter(value="(element)") @TypeInfo(value="ceylon.language::Boolean(Element&ceylon.language::Object)") @Annotations(value={@Annotation(value="doc", arguments={"The predicate function that determines if an \nelement at the start or end of this sequence should\nbe trimmed"})}) @NonNull Callable<? extends Boolean> var1);

    @Override
    @DocAnnotation$annotation$(description="Trim the elements satisfying the given predicate\nfunction from the start of this sequence, returning \na sequence no longer than this sequence.")
    @SharedAnnotation$annotation$
    @ActualAnnotation$annotation$
    @DefaultAnnotation$annotation$
    @Annotations(modifiers=322L, value={@Annotation(value="doc", arguments={"Trim the elements satisfying the given predicate\nfunction from the start of this sequence, returning \na sequence no longer than this sequence."})})
    @TypeInfo(value="Element[]")
    @NonNull
    public Sequential<? extends Element> trimLeading(@Name(value="trimming") @FunctionalParameter(value="(element)") @TypeInfo(value="ceylon.language::Boolean(Element&ceylon.language::Object)") @Annotations(value={@Annotation(value="doc", arguments={"The predicate function that determines if an \nelement at the start of this sequence should be \ntrimmed"})}) @NonNull Callable<? extends Boolean> var1);

    @Override
    @DocAnnotation$annotation$(description="Trim the elements satisfying the given predicate\nfunction from the end of this sequence, returning a \nsequence no longer than this sequence.")
    @SharedAnnotation$annotation$
    @ActualAnnotation$annotation$
    @DefaultAnnotation$annotation$
    @Annotations(modifiers=322L, value={@Annotation(value="doc", arguments={"Trim the elements satisfying the given predicate\nfunction from the end of this sequence, returning a \nsequence no longer than this sequence."})})
    @TypeInfo(value="Element[]")
    @NonNull
    public Sequential<? extends Element> trimTrailing(@Name(value="trimming") @FunctionalParameter(value="(element)") @TypeInfo(value="ceylon.language::Boolean(Element&ceylon.language::Object)") @Annotations(value={@Annotation(value="doc", arguments={"The predicate function that determines if an \nelement at the end of this sequence should be \ntrimmed"})}) @NonNull Callable<? extends Boolean> var1);

    @Override
    @DocAnnotation$annotation$(description="Return two sequences, the first containing the elements\nthat occur before the given [[index]], the second with\nthe elements that occur after the given `index`. If the\ngiven `index` is outside the range of indices of this\nlist, one of the returned sequences will be empty.")
    @SharedAnnotation$annotation$
    @ActualAnnotation$annotation$
    @DefaultAnnotation$annotation$
    @Annotations(modifiers=322L, value={@Annotation(value="doc", arguments={"Return two sequences, the first containing the elements\nthat occur before the given [[index]], the second with\nthe elements that occur after the given `index`. If the\ngiven `index` is outside the range of indices of this\nlist, one of the returned sequences will be empty."})})
    @TypeInfo(value="Element[][2]", erased=true, untrusted=true)
    @NonNull
    public Sequence slice(@Name(value="index") long var1);

    @DocAnnotation$annotation$(description="Returns a new sequence that starts with the specified\n[[element]], followed by the elements of this sequence,\nin the order they occur in this sequence.")
    @SeeAnnotation$annotations$(value={@SeeAnnotation$annotation$(programElements={"::1.3.3:ceylon.language::ISequential.Fprepend", "::1.3.3:ceylon.language::ISequential.FwithTrailing", "::1.3.3:ceylon.language::IIterable.Ffollow"})})
    @SinceAnnotation$annotation$(version="1.1.0")
    @SharedAnnotation$annotation$
    @FormalAnnotation$annotation$
    @Annotations(modifiers=130L, value={@Annotation(value="doc", arguments={"Returns a new sequence that starts with the specified\n[[element]], followed by the elements of this sequence,\nin the order they occur in this sequence."}), @Annotation(value="see", arguments={"prepend", "withTrailing", "follow"})})
    @TypeInfo(value="[Other, Element*]", erased=true)
    @TypeParameters(value={@TypeParameter(value="Other", variance=Variance.NONE, satisfies={}, caseTypes={})})
    @NonNull
    public <Other> Sequence withLeading(@Ignore TypeDescriptor var1, @Name(value="element") @TypeInfo(value="Other") @DocAnnotation$annotation$(description="The first element of the resulting sequence.") @Annotations(value={@Annotation(value="doc", arguments={"The first element of the resulting sequence."})}) Other var2);

    @DocAnnotation$annotation$(description="Returns a new sequence that starts with the elements of \nthis sequence, in the order they occur in this sequence, \nand ends with the specified [[element]].")
    @SeeAnnotation$annotations$(value={@SeeAnnotation$annotation$(programElements={"::1.3.3:ceylon.language::ISequential.Fappend", "::1.3.3:ceylon.language::ISequential.FwithLeading"})})
    @SinceAnnotation$annotation$(version="1.1.0")
    @SharedAnnotation$annotation$
    @FormalAnnotation$annotation$
    @Annotations(modifiers=130L, value={@Annotation(value="doc", arguments={"Returns a new sequence that starts with the elements of \nthis sequence, in the order they occur in this sequence, \nand ends with the specified [[element]]."}), @Annotation(value="see", arguments={"append", "withLeading"})})
    @TypeInfo(value="[Element|Other+]", erased=true)
    @TypeParameters(value={@TypeParameter(value="Other", variance=Variance.NONE, satisfies={}, caseTypes={})})
    @NonNull
    public <Other> Sequence withTrailing(@Ignore TypeDescriptor var1, @Name(value="element") @TypeInfo(value="Other") @DocAnnotation$annotation$(description="The last element of the resulting sequence.") @Annotations(value={@Annotation(value="doc", arguments={"The last element of the resulting sequence."})}) Other var2);

    @DocAnnotation$annotation$(description="Return a sequence containing the elements of this \nsequence, in the order in which they occur in this \nsequence, followed by the given [[elements]], in the \norder in which they occur in the given sequence.")
    @SeeAnnotation$annotations$(value={@SeeAnnotation$annotation$(programElements={"::1.3.3:ceylon.language::ISequential.Fprepend", "::1.3.3:ceylon.language::ISequential.FwithTrailing", "::1.3.3:ceylon.language::Fconcatenate", "::1.3.3:ceylon.language::IIterable.Fchain"})})
    @SinceAnnotation$annotation$(version="1.1.0")
    @SharedAnnotation$annotation$
    @FormalAnnotation$annotation$
    @Annotations(modifiers=130L, value={@Annotation(value="doc", arguments={"Return a sequence containing the elements of this \nsequence, in the order in which they occur in this \nsequence, followed by the given [[elements]], in the \norder in which they occur in the given sequence."}), @Annotation(value="see", arguments={"prepend", "withTrailing", "concatenate", "chain"})})
    @TypeInfo(value="<Element|Other>[]", erased=true)
    @TypeParameters(value={@TypeParameter(value="Other", variance=Variance.NONE, satisfies={}, caseTypes={})})
    @NonNull
    public <Other> Sequential append(@Ignore TypeDescriptor var1, @Name(value="elements") @TypeInfo(value="Other[]") @NonNull Sequential<? extends Other> var2);

    @DocAnnotation$annotation$(description="Return a sequence containing the given [[elements]], in \nthe order in which they occur in the given sequence,\nfollowed by the elements of this sequence, in the order \nin which they occur in this sequence.")
    @SeeAnnotation$annotations$(value={@SeeAnnotation$annotation$(programElements={"::1.3.3:ceylon.language::ISequential.Fappend", "::1.3.3:ceylon.language::ISequential.FwithLeading", "::1.3.3:ceylon.language::Fconcatenate"})})
    @SinceAnnotation$annotation$(version="1.1.0")
    @SharedAnnotation$annotation$
    @FormalAnnotation$annotation$
    @Annotations(modifiers=130L, value={@Annotation(value="doc", arguments={"Return a sequence containing the given [[elements]], in \nthe order in which they occur in the given sequence,\nfollowed by the elements of this sequence, in the order \nin which they occur in this sequence."}), @Annotation(value="see", arguments={"append", "withLeading", "concatenate"})})
    @TypeInfo(value="<Element|Other>[]", erased=true)
    @TypeParameters(value={@TypeParameter(value="Other", variance=Variance.NONE, satisfies={}, caseTypes={})})
    @NonNull
    public <Other> Sequential prepend(@Ignore TypeDescriptor var1, @Name(value="elements") @TypeInfo(value="Other[]") @NonNull Sequential<? extends Other> var2);

    @DocAnnotation$annotation$(description="A [[Tuple]] with the same elements as this sequence.\n\nThis operation makes it possible to narrow this \nsequence to a given static length, for example:\n\n    assert (is String[3] bits \n               = string.split('/'.equals)\n                       .sequence()\n                       .tuple);\n    value [prefix, middle, postfix] = bits;")
    @SinceAnnotation$annotation$(version="1.3.3")
    @SharedAnnotation$annotation$
    @FormalAnnotation$annotation$
    @Annotations(modifiers=130L, value={@Annotation(value="doc", arguments={"A [[Tuple]] with the same elements as this sequence.\n\nThis operation makes it possible to narrow this \nsequence to a given static length, for example:\n\n    assert (is String[3] bits \n               = string.split('/'.equals)\n                       .sequence()\n                       .tuple);\n    value [prefix, middle, postfix] = bits;"})})
    @TypeInfo(value="Element[]")
    @NonNull
    public Sequential<? extends Element> tuple();

    @Override
    @DocAnnotation$annotation$(description="A string of form `\"[ x, y, z ]\"` where `x`, `y`, and \n`z` are the `string` representations of the elements of \nthis collection, as produced by the iterator of the \ncollection, or the string `\"{}\"` if this collection \nis empty. If the collection iterator produces the value \n`null`, the string representation contains the string \n`\"null\"`.")
    @SharedAnnotation$annotation$
    @ActualAnnotation$annotation$
    @DefaultAnnotation$annotation$
    @Annotations(modifiers=322L, value={@Annotation(value="doc", arguments={"A string of form `\"[ x, y, z ]\"` where `x`, `y`, and \n`z` are the `string` representations of the elements of \nthis collection, as produced by the iterator of the \ncollection, or the string `\"{}\"` if this collection \nis empty. If the collection iterator produces the value \n`null`, the string representation contains the string \n`\"null\"`."})})
    @Transient
    @NonNull
    public String toString();
}

