/*
 * Decompiled with CFR 0.152.
 */
package ceylon.language;

import ceylon.language.Callable;
import ceylon.language.Comparison;
import ceylon.language.DocAnnotation$annotation$;
import ceylon.language.Finished;
import ceylon.language.Iterable;
import ceylon.language.Iterator;
import ceylon.language.SeeAnnotation$annotation$;
import ceylon.language.SeeAnnotation$annotations$;
import ceylon.language.SharedAnnotation$annotation$;
import ceylon.language.SinceAnnotation$annotation$;
import ceylon.language.TagsAnnotation$annotation$;
import ceylon.language.equal_;
import ceylon.language.larger_;
import ceylon.language.smaller_;
import com.redhat.ceylon.common.NonNull;
import com.redhat.ceylon.compiler.java.metadata.Annotation;
import com.redhat.ceylon.compiler.java.metadata.Annotations;
import com.redhat.ceylon.compiler.java.metadata.Ceylon;
import com.redhat.ceylon.compiler.java.metadata.FunctionalParameter;
import com.redhat.ceylon.compiler.java.metadata.Ignore;
import com.redhat.ceylon.compiler.java.metadata.Method;
import com.redhat.ceylon.compiler.java.metadata.Name;
import com.redhat.ceylon.compiler.java.metadata.TypeInfo;
import com.redhat.ceylon.compiler.java.metadata.TypeParameter;
import com.redhat.ceylon.compiler.java.metadata.TypeParameters;
import com.redhat.ceylon.compiler.java.metadata.Variance;
import com.redhat.ceylon.compiler.java.runtime.model.TypeDescriptor;

@Ceylon(major=8, minor=1)
@Method
public final class compareCorresponding_ {
    private compareCorresponding_() {
    }

    @DocAnnotation$annotation$(description="Compares corresponding elements of the given streams using \nthe given [[comparison function|comparing]]. Two elements \nare considered _corresponding_ if they occupy the same \nposition in their respective streams. Returns:\n\n- the result of the given comparison for the earliest pair\n  of corresponding elements whose comparison does not \n  evaluate to [[equal]], or, otherwise, if every comparison \n  of corresponding pairs of elements produces `equal`,\n- [[smaller]], if the first stream produces fewer elements \n  than the second stream, \n- [[larger]], if the first stream produces more elements \n  than the second stream, or\n- [[equal]] if the two streams produce the same number of \n  elements.\n\nIf both streams are empty, return `equal`.\n\nFor example:\n\n    compareCorresponding({ 1, 2, 2, 5 }, 1:4,\n           (Integer i, Integer j) => i<=>j)\n\nand:\n\n    compareCorresponding({ 1, 2, 3 }, 1:4,\n           (Integer i, Integer j) => i<=>j)\n\nboth evaluate to `smaller`.")
    @SeeAnnotation$annotations$(value={@SeeAnnotation$annotation$(programElements={"::1.3.3:ceylon.language::Fcorresponding"})})
    @TagsAnnotation$annotation$(tags={"Comparisons", "Streams"})
    @SinceAnnotation$annotation$(version="1.3.0")
    @SharedAnnotation$annotation$
    @Annotations(modifiers=2L, value={@Annotation(value="doc", arguments={"Compares corresponding elements of the given streams using \nthe given [[comparison function|comparing]]. Two elements \nare considered _corresponding_ if they occupy the same \nposition in their respective streams. Returns:\n\n- the result of the given comparison for the earliest pair\n  of corresponding elements whose comparison does not \n  evaluate to [[equal]], or, otherwise, if every comparison \n  of corresponding pairs of elements produces `equal`,\n- [[smaller]], if the first stream produces fewer elements \n  than the second stream, \n- [[larger]], if the first stream produces more elements \n  than the second stream, or\n- [[equal]] if the two streams produce the same number of \n  elements.\n\nIf both streams are empty, return `equal`.\n\nFor example:\n\n    compareCorresponding({ 1, 2, 2, 5 }, 1:4,\n           (Integer i, Integer j) => i<=>j)\n\nand:\n\n    compareCorresponding({ 1, 2, 3 }, 1:4,\n           (Integer i, Integer j) => i<=>j)\n\nboth evaluate to `smaller`."}), @Annotation(value="see", arguments={"corresponding"}), @Annotation(value="tagged", arguments={"Comparisons", "Streams"})})
    @TypeInfo(value="ceylon.language::Comparison")
    @TypeParameters(value={@TypeParameter(value="First", variance=Variance.NONE, satisfies={}, caseTypes={}), @TypeParameter(value="Second", variance=Variance.NONE, satisfies={}, caseTypes={})})
    @NonNull
    public static <First, Second> Comparison compareCorresponding(@Ignore TypeDescriptor $reified$First, @Ignore TypeDescriptor $reified$Second, @Name(value="firstIterable") @TypeInfo(value="{First*}") @NonNull Iterable<? extends First, ? extends Object> firstIterable, @Name(value="secondIterable") @TypeInfo(value="{Second*}") @NonNull Iterable<? extends Second, ? extends Object> secondIterable, @Name(value="comparing") @FunctionalParameter(value="(first,second)") @TypeInfo(value="ceylon.language::Comparison(First, Second)") @Annotations(value={@Annotation(value="doc", arguments={"The comparison function that compares an element of the\n[[first stream|firstIterable]] with the corresponding \nelement of the [[second stream|secondIterable]]."})}) @NonNull Callable<? extends Comparison> comparing) {
        Comparison $ceylontmp$ifResult$23;
        Object second;
        Object first;
        block7: {
            Object second$19;
            Object first$17;
            Comparison comp;
            Iterator<First> firstIter = firstIterable.iterator();
            Iterator<Second> secondIter = secondIterable.iterator();
            do {
                first = firstIter.next();
                second = secondIter.next();
                boolean $ceylontmp$if$15 = false;
                Object first$16 = first;
                if (!(first$16 instanceof Finished)) {
                    first$17 = first$16;
                    Object second$18 = second;
                    if (!(second$18 instanceof Finished)) {
                        second$19 = second$18;
                        $ceylontmp$if$15 = true;
                    } else {
                        second$19 = null;
                    }
                } else {
                    first$17 = null;
                    second$19 = null;
                }
                if (!$ceylontmp$if$15) break block7;
            } while ((comp = comparing.$call$(first$17, second$19)).equals(equal_.get_()));
            return comp;
        }
        Object $ceylontmp$21 = first;
        boolean firstFinished = $ceylontmp$21 instanceof Finished;
        Object $ceylontmp$22 = second;
        boolean secondFinished = $ceylontmp$22 instanceof Finished;
        if (firstFinished && !secondFinished) {
            $ceylontmp$ifResult$23 = smaller_.get_();
        } else {
            Comparison $ceylontmp$ifResult$25 = !firstFinished && secondFinished ? larger_.get_() : equal_.get_();
            $ceylontmp$ifResult$23 = $ceylontmp$ifResult$25;
        }
        return $ceylontmp$ifResult$23;
    }
}

