/*
 * Decompiled with CFR 0.152.
 */
package ceylon.language.meta.declaration;

import ceylon.language.DocAnnotation$annotation$;
import ceylon.language.FormalAnnotation$annotation$;
import ceylon.language.SealedAnnotation$annotation$;
import ceylon.language.Sequential;
import ceylon.language.SharedAnnotation$annotation$;
import ceylon.language.ThrownExceptionAnnotation$annotation$;
import ceylon.language.ThrownExceptionAnnotation$annotations$;
import ceylon.language.meta.declaration.ClassOrInterfaceDeclaration;
import ceylon.language.meta.model.Interface;
import ceylon.language.meta.model.MemberInterface;
import ceylon.language.meta.model.Type;
import com.redhat.ceylon.common.NonNull;
import com.redhat.ceylon.compiler.java.metadata.Annotation;
import com.redhat.ceylon.compiler.java.metadata.Annotations;
import com.redhat.ceylon.compiler.java.metadata.Ceylon;
import com.redhat.ceylon.compiler.java.metadata.Ignore;
import com.redhat.ceylon.compiler.java.metadata.Name;
import com.redhat.ceylon.compiler.java.metadata.SatisfiedTypes;
import com.redhat.ceylon.compiler.java.metadata.Sequenced;
import com.redhat.ceylon.compiler.java.metadata.TypeInfo;
import com.redhat.ceylon.compiler.java.metadata.TypeParameter;
import com.redhat.ceylon.compiler.java.metadata.TypeParameters;
import com.redhat.ceylon.compiler.java.metadata.Variance;
import com.redhat.ceylon.compiler.java.runtime.model.TypeDescriptor;

@Ceylon(major=8, minor=1)
@DocAnnotation$annotation$(description="An interface declaration.\n\n<a name=\"toplevel-sample\"></a>\n### Usage sample for toplevel interfaces\n\nBecause some interfaces have type parameters, getting a model requires applying type arguments to the\ninterface declaration with [[interfaceApply]] in order to be able to get a closed type. For example, here is how you would\nobtain an interface model from a toplevel interface declaration:\n\n    interface Foo<T> satisfies List<T> {\n    }\n    \n    void test(){\n        // We need to apply the Integer closed type to the Foo declaration in order to get the Foo<Integer> closed type\n        Interface<Foo<Integer>> interfaceModel = `interface Foo`.interfaceApply<Foo<Integer>>(`Integer`);\n        // This will print: ceylon.language::List<ceylon.language::Integer>\n        for(satisfiedType in interfaceModel.satisfiedTypes){\n            print(satisfiedType);\n        }\n    }\n\n<a name=\"member-sample\"></a>\n### Usage sample for member interfaces\n\nFor member interfaces it is a bit longer, because member interfaces need to be applied not only their type arguments but also\nthe containing type, so you should use [[memberInterfaceApply]] and start by giving the containing closed type:\n\n    class Outer(){\n        shared interface Inner<T> satisfies List<T> {\n        }\n    }\n\n    void test(){\n        // apply the containing closed type `Outer` to the member class declaration `Outer.Inner`\n        MemberInterface<Outer,Outer.Inner<Integer>> memberInterfaceModel = `interface Outer.Inner`.memberInterfaceApply<Outer,Outer.Inner<Integer>>(`Outer`, `Integer`);\n        // This will print: ceylon.language::List<ceylon.language::Integer>\n        for(satisfiedType in memberInterfaceModel.satisfiedTypes){\n            print(satisfiedType);\n        }\n    }\n")
@SharedAnnotation$annotation$
@SealedAnnotation$annotation$
@Annotations(modifiers=18L, value={@Annotation(value="doc", arguments={"An interface declaration.\n\n<a name=\"toplevel-sample\"></a>\n### Usage sample for toplevel interfaces\n\nBecause some interfaces have type parameters, getting a model requires applying type arguments to the\ninterface declaration with [[interfaceApply]] in order to be able to get a closed type. For example, here is how you would\nobtain an interface model from a toplevel interface declaration:\n\n    interface Foo<T> satisfies List<T> {\n    }\n    \n    void test(){\n        // We need to apply the Integer closed type to the Foo declaration in order to get the Foo<Integer> closed type\n        Interface<Foo<Integer>> interfaceModel = `interface Foo`.interfaceApply<Foo<Integer>>(`Integer`);\n        // This will print: ceylon.language::List<ceylon.language::Integer>\n        for(satisfiedType in interfaceModel.satisfiedTypes){\n            print(satisfiedType);\n        }\n    }\n\n<a name=\"member-sample\"></a>\n### Usage sample for member interfaces\n\nFor member interfaces it is a bit longer, because member interfaces need to be applied not only their type arguments but also\nthe containing type, so you should use [[memberInterfaceApply]] and start by giving the containing closed type:\n\n    class Outer(){\n        shared interface Inner<T> satisfies List<T> {\n        }\n    }\n\n    void test(){\n        // apply the containing closed type `Outer` to the member class declaration `Outer.Inner`\n        MemberInterface<Outer,Outer.Inner<Integer>> memberInterfaceModel = `interface Outer.Inner`.memberInterfaceApply<Outer,Outer.Inner<Integer>>(`Outer`, `Integer`);\n        // This will print: ceylon.language::List<ceylon.language::Integer>\n        for(satisfiedType in memberInterfaceModel.satisfiedTypes){\n            print(satisfiedType);\n        }\n    }\n"})})
@SatisfiedTypes(value={"ceylon.language.meta.declaration::ClassOrInterfaceDeclaration"})
public interface InterfaceDeclaration
extends ClassOrInterfaceDeclaration {
    @Ignore
    public static final TypeDescriptor $TypeDescriptor$ = TypeDescriptor.klass(InterfaceDeclaration.class, new TypeDescriptor[0]);

    @Ignore
    public <Type> Interface<? extends Type> interfaceApply(TypeDescriptor var1);

    @DocAnnotation$annotation$(description="Applies the given closed type arguments to this toplevel interface \ndeclaration in order to obtain an interface model. \nSee [this code sample](#toplevel-sample) for an example on how to use this.")
    @ThrownExceptionAnnotation$annotations$(value={@ThrownExceptionAnnotation$annotation$(type="::1.3.3:ceylon.language:meta.model:CIncompatibleTypeException", when="If the specified `Type` type argument is not compatible with the \nactual result."), @ThrownExceptionAnnotation$annotation$(type="::1.3.3:ceylon.language:meta.model:CTypeApplicationException", when="If the specified closed type argument values are not compatible \nwith the actual result's type parameters.")})
    @SharedAnnotation$annotation$
    @FormalAnnotation$annotation$
    @Annotations(modifiers=130L, value={@Annotation(value="doc", arguments={"Applies the given closed type arguments to this toplevel interface \ndeclaration in order to obtain an interface model. \nSee [this code sample](#toplevel-sample) for an example on how to use this."}), @Annotation(value="throws", arguments={"IncompatibleTypeException", "If the specified `Type` type argument is not compatible with the \nactual result."}), @Annotation(value="throws", arguments={"TypeApplicationException", "If the specified closed type argument values are not compatible \nwith the actual result's type parameters."})})
    @TypeInfo(value="ceylon.language.meta.model::Interface<Type>")
    @TypeParameters(value={@TypeParameter(value="Type", variance=Variance.NONE, satisfies={}, caseTypes={}, defaultValue="ceylon.language::Anything")})
    @NonNull
    public <Type> Interface<? extends Type> interfaceApply(@Ignore TypeDescriptor var1, @Name(value="typeArguments") @Sequenced @TypeInfo(value="ceylon.language.meta.model::Type<ceylon.language::Anything>[]") @NonNull Sequential<? extends Type<? extends Object>> var2);

    @Ignore
    public <Container, Type> MemberInterface<? super Container, ? extends Type> memberInterfaceApply(TypeDescriptor var1, TypeDescriptor var2, Type<? extends Object> var3);

    @DocAnnotation$annotation$(description="Applies the given closed container type and type arguments to this member \ninterface declaration in order to obtain a member interface model. \nSee [this code sample](#member-sample) for an example on how to use this.")
    @ThrownExceptionAnnotation$annotations$(value={@ThrownExceptionAnnotation$annotation$(type="::1.3.3:ceylon.language:meta.model:CIncompatibleTypeException", when="If the specified `Container` or `Type` type arguments are not \ncompatible with the actual result."), @ThrownExceptionAnnotation$annotation$(type="::1.3.3:ceylon.language:meta.model:CTypeApplicationException", when="If the specified closed container type or type argument values \nare not compatible with the actual result's container type or \ntype parameters.")})
    @SharedAnnotation$annotation$
    @FormalAnnotation$annotation$
    @Annotations(modifiers=130L, value={@Annotation(value="doc", arguments={"Applies the given closed container type and type arguments to this member \ninterface declaration in order to obtain a member interface model. \nSee [this code sample](#member-sample) for an example on how to use this."}), @Annotation(value="throws", arguments={"IncompatibleTypeException", "If the specified `Container` or `Type` type arguments are not \ncompatible with the actual result."}), @Annotation(value="throws", arguments={"TypeApplicationException", "If the specified closed container type or type argument values \nare not compatible with the actual result's container type or \ntype parameters."})})
    @TypeInfo(value="ceylon.language.meta.model::MemberInterface<Container,Type>")
    @TypeParameters(value={@TypeParameter(value="Container", variance=Variance.NONE, satisfies={}, caseTypes={}, defaultValue="ceylon.language::Nothing"), @TypeParameter(value="Type", variance=Variance.NONE, satisfies={}, caseTypes={}, defaultValue="ceylon.language::Anything")})
    @NonNull
    public <Container, Type> MemberInterface<? super Container, ? extends Type> memberInterfaceApply(@Ignore TypeDescriptor var1, @Ignore TypeDescriptor var2, @Name(value="containerType") @TypeInfo(value="ceylon.language.meta.model::Type<ceylon.language::Object>") @NonNull Type<? extends Object> var3, @Name(value="typeArguments") @Sequenced @TypeInfo(value="ceylon.language.meta.model::Type<ceylon.language::Anything>[]") @NonNull Sequential<? extends Type<? extends Object>> var4);
}

