/*
 * Decompiled with CFR 0.152.
 */
package ceylon.language.serialization;

import ceylon.language.ActualAnnotation$annotation$;
import ceylon.language.Anything;
import ceylon.language.Array;
import ceylon.language.AssertionError;
import ceylon.language.DocAnnotation$annotation$;
import ceylon.language.Entry;
import ceylon.language.Finished;
import ceylon.language.Iterable;
import ceylon.language.Iterator;
import ceylon.language.Object;
import ceylon.language.SharedAnnotation$annotation$;
import ceylon.language.String;
import ceylon.language.ThrownExceptionAnnotation$annotation$;
import ceylon.language.ThrownExceptionAnnotation$annotations$;
import ceylon.language.Tuple;
import ceylon.language.impl.ElementImpl;
import ceylon.language.impl.MemberImpl;
import ceylon.language.meta.declaration.ValueDeclaration;
import ceylon.language.meta.model.ClassModel;
import ceylon.language.meta.typeLiteral_;
import ceylon.language.meta.type_;
import ceylon.language.serialization.DeserializationContext;
import ceylon.language.serialization.DeserializationException;
import ceylon.language.serialization.NativeDeque;
import ceylon.language.serialization.NativeMap;
import ceylon.language.serialization.Partial;
import ceylon.language.serialization.PartialImpl;
import ceylon.language.serialization.ReachableReference;
import com.redhat.ceylon.common.NonNull;
import com.redhat.ceylon.common.Nullable;
import com.redhat.ceylon.compiler.java.Util;
import com.redhat.ceylon.compiler.java.metadata.Annotation;
import com.redhat.ceylon.compiler.java.metadata.Annotations;
import com.redhat.ceylon.compiler.java.metadata.Ceylon;
import com.redhat.ceylon.compiler.java.metadata.Ignore;
import com.redhat.ceylon.compiler.java.metadata.Name;
import com.redhat.ceylon.compiler.java.metadata.SatisfiedTypes;
import com.redhat.ceylon.compiler.java.metadata.TypeInfo;
import com.redhat.ceylon.compiler.java.metadata.TypeParameter;
import com.redhat.ceylon.compiler.java.metadata.TypeParameters;
import com.redhat.ceylon.compiler.java.metadata.Variance;
import com.redhat.ceylon.compiler.java.runtime.model.ReifiedType;
import com.redhat.ceylon.compiler.java.runtime.model.TypeDescriptor;
import java.io.Serializable;

@Ceylon(major=8, minor=1)
@DocAnnotation$annotation$(description="Implementation of [[DeserializationContext]] using a few native helper classes.")
@Annotations(value={@Annotation(value="doc", arguments={"Implementation of [[DeserializationContext]] using a few native helper classes."})})
@SatisfiedTypes(value={"ceylon.language.serialization::DeserializationContext<Id>"})
@TypeParameters(value={@TypeParameter(value="Id", variance=Variance.NONE, satisfies={"ceylon.language::Object"}, caseTypes={})})
class DeserializationContextImpl<Id>
implements ReifiedType,
DeserializationContext<Id>,
Serializable {
    @Ignore
    private final TypeDescriptor $reified$Id;
    @Ignore
    private final NativeMap<Id, java.lang.Object> instances;
    @Ignore
    private final NativeMap<Entry<? extends java.lang.Object, ? extends String>, java.lang.Object> memberTypeCache;

    DeserializationContextImpl(@Ignore TypeDescriptor $reified$Id) {
        this.$reified$Id = $reified$Id;
        this.instances = new NativeMap($reified$Id, Anything.$TypeDescriptor$);
        this.memberTypeCache = new NativeMap(TypeDescriptor.klass(Entry.class, Object.$TypeDescriptor$, String.$TypeDescriptor$), Object.$TypeDescriptor$);
    }

    @DocAnnotation$annotation$(description="The `Item` in the instances map is either a `Partial` or the actual instance\nthat's not ambiguous because `Partial` never leaks, so it's impossible\nfor a client to use the API to instantiate a `Partial`\nthey can only end up in the map due to our implementation.\n")
    @Annotations(value={@Annotation(value="doc", arguments={"The `Item` in the instances map is either a `Partial` or the actual instance\nthat's not ambiguous because `Partial` never leaks, so it's impossible\nfor a client to use the API to instantiate a `Partial`\nthey can only end up in the map due to our implementation.\n"})})
    @TypeInfo(value="ceylon.language.serialization::NativeMap<Id,ceylon.language::Anything>")
    @NonNull
    private final NativeMap<Id, java.lang.Object> getInstances$priv$() {
        return this.instances;
    }

    @DocAnnotation$annotation$(description="a cache of \"attribute\" (represented as a TypeDescriptor and an attribute name)\nto its type")
    @SharedAnnotation$annotation$
    @Annotations(modifiers=2L, value={@Annotation(value="doc", arguments={"a cache of \"attribute\" (represented as a TypeDescriptor and an attribute name)\nto its type"})})
    @TypeInfo(value="ceylon.language.serialization::NativeMap<ceylon.language::Object->ceylon.language::String,ceylon.language::Object>")
    @NonNull
    public final NativeMap<Entry<? extends java.lang.Object, ? extends String>, java.lang.Object> getMemberTypeCache() {
        return this.memberTypeCache;
    }

    @DocAnnotation$annotation$(description="Get the [[Partial]] or instance with the given id")
    @SharedAnnotation$annotation$
    @Annotations(modifiers=2L, value={@Annotation(value="doc", arguments={"Get the [[Partial]] or instance with the given id"})})
    @TypeInfo(value="ceylon.language::Anything")
    @Nullable
    public final java.lang.Object leakInstance(@Name(value="id") @TypeInfo(value="Id") Id id) {
        return this.getInstances$priv$().get(id);
    }

    @Override
    @SharedAnnotation$annotation$
    @ActualAnnotation$annotation$
    @Annotations(modifiers=66L)
    @TypeInfo(value="ceylon.language::Anything", declaredVoid=true)
    @Nullable
    public final java.lang.Object attribute(@Name(value="instanceId") @TypeInfo(value="Id") Id instanceId, @Name(value="attribute") @TypeInfo(value="ceylon.language.meta.declaration::ValueDeclaration") @NonNull ValueDeclaration attribute, @Name(value="attributeValueId") @TypeInfo(value="Id") Id attributeValueId) {
        this.attributeOrElement$priv$(instanceId, new MemberImpl(attribute), attributeValueId);
        return null;
    }

    @DocAnnotation$annotation$(description="A [[DeserializationException]] to day that the instance with the given id has already been instantiated.")
    @SharedAnnotation$annotation$
    @Annotations(modifiers=2L, value={@Annotation(value="doc", arguments={"A [[DeserializationException]] to day that the instance with the given id has already been instantiated."})})
    @TypeInfo(value="ceylon.language.serialization::DeserializationException")
    @NonNull
    public final DeserializationException alreadyComplete(@Name(value="instanceId") @TypeInfo(value="Id") Id instanceId) {
        return new DeserializationException("instance referred to by id " + instanceId.toString() + " already complete.");
    }

    @DocAnnotation$annotation$(description="Get or create the [[Partial]] for `instanceId`; \nadd the given `attributeValueId` to its partial state.")
    @ThrownExceptionAnnotation$annotations$(value={@ThrownExceptionAnnotation$annotation$(type="::1.3.3:ceylon.language:serialization:CDeserializationException", when="If the `instanceId` corresponds to a reconstructed \ninstance or to a partial that's already been instantiated")})
    @Annotations(value={@Annotation(value="doc", arguments={"Get or create the [[Partial]] for `instanceId`; \nadd the given `attributeValueId` to its partial state."}), @Annotation(value="throws", arguments={"DeserializationException", "If the `instanceId` corresponds to a reconstructed \ninstance or to a partial that's already been instantiated"})})
    private final void attributeOrElement$priv$(@Name(value="instanceId") @TypeInfo(value="Id") Id instanceId, @Name(value="attributeOrIndex") @TypeInfo(value="ceylon.language.serialization::ReachableReference") @NonNull ReachableReference attributeOrIndex, @Name(value="attributeValueId") @TypeInfo(value="Id") Id attributeValueId) {
        Partial referring;
        java.lang.Object sel$0 = this.getInstances$priv$().get(instanceId);
        if (sel$0 == null) {
            java.lang.Object r$4 = sel$0;
            PartialImpl p = new PartialImpl(instanceId);
            this.getInstances$priv$().put(instanceId, p);
            referring = p;
        } else if (sel$0 instanceof Partial) {
            Partial r$2 = (Partial)sel$0;
            referring = r$2;
            if (referring.getInstantiated()) {
                throw this.alreadyComplete(instanceId);
            }
        } else {
            java.lang.Object r$1 = sel$0;
            throw this.alreadyComplete(instanceId);
        }
        referring.addState(attributeOrIndex, attributeValueId);
    }

    @Override
    @SharedAnnotation$annotation$
    @ActualAnnotation$annotation$
    @Annotations(modifiers=66L)
    @TypeInfo(value="ceylon.language::Anything", declaredVoid=true)
    @Nullable
    public final java.lang.Object element(@Name(value="instanceId") @TypeInfo(value="Id") Id instanceId, @Name(value="index") long index, @Name(value="elementValueId") @TypeInfo(value="Id") Id elementValueId) {
        this.attributeOrElement$priv$(instanceId, new ElementImpl(index), elementValueId);
        return null;
    }

    @Override
    @SharedAnnotation$annotation$
    @ActualAnnotation$annotation$
    @Annotations(modifiers=66L)
    @TypeInfo(value="ceylon.language::Anything", declaredVoid=true)
    @Nullable
    public final java.lang.Object instance(@Name(value="instanceId") @TypeInfo(value="Id") Id instanceId, @Name(value="clazz") @TypeInfo(value="ceylon.language.meta.model::ClassModel<ceylon.language::Anything,ceylon.language::Nothing>", erased=true) @NonNull ClassModel clazz) {
        if (!clazz.getDeclaration().getSerializable()) {
            throw new DeserializationException("not serializable: " + clazz.toString());
        }
        this.getOrCreatePartial$priv$(instanceId).setClazz(clazz);
        return null;
    }

    @DocAnnotation$annotation$(description="Get or create a [[Partial]] for the given `instanceId`.")
    @Annotations(value={@Annotation(value="doc", arguments={"Get or create a [[Partial]] for the given `instanceId`."})})
    @TypeInfo(value="ceylon.language.serialization::Partial")
    @NonNull
    private final Partial getOrCreatePartial$priv$(@Name(value="instanceId") @TypeInfo(value="Id") Id instanceId) {
        Partial partial;
        java.lang.Object sel$6 = this.getInstances$priv$().get(instanceId);
        if (sel$6 == null) {
            java.lang.Object r$9 = sel$6;
            PartialImpl p = new PartialImpl(instanceId);
            this.getInstances$priv$().put(instanceId, p);
            partial = p;
        } else if (sel$6 instanceof Partial) {
            Partial r$8;
            partial = r$8 = (Partial)sel$6;
        } else {
            java.lang.Object r$7 = sel$6;
            throw this.alreadyComplete(instanceId);
        }
        return partial;
    }

    @Override
    @SharedAnnotation$annotation$
    @ActualAnnotation$annotation$
    @Annotations(modifiers=66L)
    @TypeInfo(value="ceylon.language::Anything", declaredVoid=true)
    @Nullable
    public final java.lang.Object memberInstance(@Name(value="containerId") @TypeInfo(value="Id") Id containerId, @Name(value="instanceId") @TypeInfo(value="Id") Id instanceId) {
        java.lang.Object container;
        java.lang.Object sel$10 = this.getInstances$priv$().get(containerId);
        if (sel$10 == null) {
            java.lang.Object r$12 = sel$10;
            PartialImpl p = new PartialImpl(containerId);
            this.getInstances$priv$().put(containerId, p);
            container = p;
        } else {
            java.lang.Object r$11;
            container = r$11 = sel$10;
        }
        this.getOrCreatePartial$priv$(instanceId).setContainer(container);
        return null;
    }

    @Override
    @SharedAnnotation$annotation$
    @ActualAnnotation$annotation$
    @Annotations(modifiers=66L)
    @TypeInfo(value="ceylon.language::Anything", declaredVoid=true)
    @Nullable
    public final java.lang.Object instanceValue(@Name(value="instanceId") @TypeInfo(value="Id") Id instanceId, @Name(value="instanceValue") @TypeInfo(value="ceylon.language::Anything") @Nullable java.lang.Object instanceValue) {
        this.getInstances$priv$().put(instanceId, instanceValue);
        return null;
    }

    @Override
    @SharedAnnotation$annotation$
    @ActualAnnotation$annotation$
    @Annotations(modifiers=66L)
    @TypeInfo(value="Instance")
    @TypeParameters(value={@TypeParameter(value="Instance", variance=Variance.NONE, satisfies={}, caseTypes={})})
    public final <Instance> Instance reconstruct(@Ignore TypeDescriptor $reified$Instance, @Name(value="instanceId") @TypeInfo(value="Id") Id instanceId) {
        NativeDeque deque = new NativeDeque();
        java.lang.Object root = this.getInstances$priv$().get(instanceId);
        if (root == null) {
            if (this.getInstances$priv$().contains(instanceId)) {
                Instance r$15 = null;
                r$15 = null;
                if (!Util.isReified(null, $reified$Instance)) {
                    throw new AssertionError("Assertion failed" + System.lineSeparator() + "\tviolated " + "is Instance r=null" + Util.assertIsFailed(false, $reified$Instance, null));
                }
                Instance r$16 = r$15;
                return r$16;
            }
            throw new DeserializationException("unknown id: " + instanceId.toString() + ".");
        }
        deque.pushFront(this.getInstances$priv$().get(instanceId));
        while (!deque.getEmpty()) {
            java.lang.Object r$19;
            java.lang.Object r = deque.popFront();
            java.lang.Object sel$17 = r;
            if (sel$17 == null) {
                java.lang.Object r$37 = sel$17;
                throw new AssertionError("Assertion failed" + System.lineSeparator() + "\tviolated " + "false");
            }
            if (sel$17 instanceof Partial) {
                Iterator<? extends java.lang.Object> referredId$iterator$$31;
                Partial container$22;
                java.lang.Object container$21;
                r$19 = (Partial)sel$17;
                if (((Partial)r$19).getMember() && (container$21 = ((Partial)r$19).getContainer()) instanceof Partial && !(container$22 = (Partial)container$21).getInstantiated()) {
                    deque.pushFront(r$19);
                    deque.pushFront(container$22);
                    continue;
                }
                if (!((Partial)r$19).getInstantiated()) {
                    ((Partial)r$19).instantiate();
                }
                Iterable<? extends java.lang.Object, ? extends java.lang.Object> iterable$26 = ((Partial)r$19).getRefersTo();
                boolean isArray$27 = iterable$26 instanceof Array;
                boolean isTuple$28 = iterable$26 instanceof Tuple && ((Tuple)iterable$26).$getArray$() != null;
                java.lang.Object elem$25 = null;
                int i$29 = 0;
                int length$30 = isArray$27 || isTuple$28 ? (int)iterable$26.getSize() : 0;
                Iterator<? extends java.lang.Object> iterator = referredId$iterator$$31 = isTuple$28 || isArray$27 ? null : iterable$26.iterator();
                while (isTuple$28 || isArray$27 ? i$29 < length$30 : !((elem$25 = referredId$iterator$$31.next()) instanceof Finished)) {
                    Partial referred$36;
                    if (isArray$27 || isTuple$28) {
                        elem$25 = iterable$26.getFromFirst(i$29++);
                    }
                    java.lang.Object referredId = elem$25;
                    java.lang.Object referredId$32 = null;
                    referredId$32 = referredId;
                    if (!Util.isReified(referredId$32, this.$reified$Id)) {
                        throw new AssertionError("Assertion failed" + System.lineSeparator() + "\tviolated " + "is Id referredId" + Util.assertIsFailed(false, this.$reified$Id, referredId$32));
                    }
                    java.lang.Object referredId$33 = referredId$32;
                    java.lang.Object referred = this.getInstances$priv$().get(referredId$33);
                    java.lang.Object referred$35 = referred;
                    if (!(referred$35 instanceof Partial) || (referred$36 = (Partial)referred$35).getInstantiated()) continue;
                    deque.pushFront(referred$36);
                }
                continue;
            }
            r$19 = sel$17;
        }
        deque.pushFront(this.getInstances$priv$().get(instanceId));
        while (!deque.getEmpty()) {
            java.lang.Object r$40;
            java.lang.Object sel$38 = deque.popFront();
            if (sel$38 instanceof Partial) {
                Partial container$61;
                java.lang.Object container$60;
                Iterator<? extends java.lang.Object> referredId$iterator$$53;
                Partial container$44;
                java.lang.Object container$43;
                r$40 = (Partial)sel$38;
                if (((Partial)r$40).getMember() && (container$43 = ((Partial)r$40).getContainer()) instanceof Partial && !(container$44 = (Partial)container$43).getInitialized()) {
                    deque.pushFront(r$40);
                    deque.pushFront(container$44);
                    continue;
                }
                if (((Partial)r$40).getInitialized()) continue;
                Iterable<? extends java.lang.Object, ? extends java.lang.Object> iterable$48 = ((Partial)r$40).getRefersTo();
                boolean isArray$49 = iterable$48 instanceof Array;
                boolean isTuple$50 = iterable$48 instanceof Tuple && ((Tuple)iterable$48).$getArray$() != null;
                java.lang.Object elem$47 = null;
                int i$51 = 0;
                int length$52 = isArray$49 || isTuple$50 ? (int)iterable$48.getSize() : 0;
                Iterator<? extends java.lang.Object> iterator = referredId$iterator$$53 = isTuple$50 || isArray$49 ? null : iterable$48.iterator();
                while (isTuple$50 || isArray$49 ? i$51 < length$52 : !((elem$47 = referredId$iterator$$53.next()) instanceof Finished)) {
                    Partial referred$58;
                    if (isArray$49 || isTuple$50) {
                        elem$47 = iterable$48.getFromFirst(i$51++);
                    }
                    java.lang.Object referredId = elem$47;
                    java.lang.Object referredId$54 = null;
                    referredId$54 = referredId;
                    if (!Util.isReified(referredId$54, this.$reified$Id)) {
                        throw new AssertionError("Assertion failed" + System.lineSeparator() + "\tviolated " + "is Id referredId" + Util.assertIsFailed(false, this.$reified$Id, referredId$54));
                    }
                    java.lang.Object referredId$55 = referredId$54;
                    java.lang.Object referred = this.getInstances$priv$().get(referredId$55);
                    java.lang.Object referred$57 = referred;
                    if (!(referred$57 instanceof Partial) || (referred$58 = (Partial)referred$57).getInitialized()) continue;
                    deque.pushFront(referred$58);
                }
                if (((Partial)r$40).getMember() && (container$60 = ((Partial)r$40).getContainer()) instanceof Partial && !(container$61 = (Partial)container$60).getInitialized()) {
                    deque.pushFront(container$61);
                }
                ((Partial)r$40).initialize(this.$reified$Id, this);
                continue;
            }
            r$40 = sel$38;
        }
        java.lang.Object sel$62 = this.getInstances$priv$().get(instanceId);
        if (sel$62 instanceof Partial) {
            Partial r$68 = (Partial)sel$62;
            java.lang.Object result = r$68.instance();
            java.lang.Object result$70 = result;
            if (Util.isReified(result$70, $reified$Instance)) {
                java.lang.Object result$71 = result$70;
                this.getInstances$priv$().put(instanceId, result$71);
                return (Instance)result$71;
            }
            throw new DeserializationException("instance with id " + instanceId.toString() + " has class " + type_.type(Anything.$TypeDescriptor$, result).toString() + " not assignable to given type " + typeLiteral_.typeLiteral($reified$Instance).toString());
        }
        java.lang.Object r$63 = sel$62;
        java.lang.Object r$65 = r$63;
        if (Util.isReified(r$65, $reified$Instance)) {
            java.lang.Object r$67 = r$65;
            return (Instance)r$67;
        }
        java.lang.Object r$66 = r$65;
        throw new DeserializationException("instance with id " + instanceId.toString() + " has class " + type_.type(Anything.$TypeDescriptor$, r$66).toString() + " not assignable to given type " + typeLiteral_.typeLiteral($reified$Instance).toString());
    }

    @Override
    @Ignore
    public TypeDescriptor $getType$() {
        return TypeDescriptor.klass(DeserializationContextImpl.class, this.$reified$Id);
    }
}

