/*
 * Decompiled with CFR 0.152.
 */
package ceylon.language.serialization;

import ceylon.language.AbstractAnnotation$annotation$;
import ceylon.language.AssertionError;
import ceylon.language.DocAnnotation$annotation$;
import ceylon.language.FormalAnnotation$annotation$;
import ceylon.language.Iterable;
import ceylon.language.Object;
import ceylon.language.SharedAnnotation$annotation$;
import ceylon.language.ThrownExceptionAnnotation$annotation$;
import ceylon.language.ThrownExceptionAnnotation$annotations$;
import ceylon.language.VariableAnnotation$annotation$;
import ceylon.language.empty_;
import ceylon.language.meta.model.ClassModel;
import ceylon.language.serialization.DeserializationContextImpl;
import ceylon.language.serialization.NativeMap;
import ceylon.language.serialization.ReachableReference;
import com.redhat.ceylon.common.NonNull;
import com.redhat.ceylon.common.Nullable;
import com.redhat.ceylon.compiler.java.metadata.Annotation;
import com.redhat.ceylon.compiler.java.metadata.Annotations;
import com.redhat.ceylon.compiler.java.metadata.Ceylon;
import com.redhat.ceylon.compiler.java.metadata.Ignore;
import com.redhat.ceylon.compiler.java.metadata.Jpa;
import com.redhat.ceylon.compiler.java.metadata.Name;
import com.redhat.ceylon.compiler.java.metadata.Transient;
import com.redhat.ceylon.compiler.java.metadata.TypeInfo;
import com.redhat.ceylon.compiler.java.metadata.TypeParameter;
import com.redhat.ceylon.compiler.java.metadata.TypeParameters;
import com.redhat.ceylon.compiler.java.metadata.Variance;
import com.redhat.ceylon.compiler.java.runtime.model.ReifiedType;
import com.redhat.ceylon.compiler.java.runtime.model.TypeDescriptor;
import java.io.Serializable;

@Ceylon(major=8, minor=1)
@DocAnnotation$annotation$(description="A partially reconstructed instance: \nHolds state for reconstructing an instance which is built up \nprogressively by calls to the [[DeserializationContext]].")
@AbstractAnnotation$annotation$
@Annotations(modifiers=8L, value={@Annotation(value="doc", arguments={"A partially reconstructed instance: \nHolds state for reconstructing an instance which is built up \nprogressively by calls to the [[DeserializationContext]]."})})
abstract class Partial
implements ReifiedType,
Serializable {
    @Ignore
    private final java.lang.Object id;
    @Ignore
    private ClassModel clazz;
    @Ignore
    private java.lang.Object container;
    @Ignore
    private java.lang.Object instance_;
    @Ignore
    private NativeMap<ReachableReference, java.lang.Object> state;
    @Ignore
    public static final TypeDescriptor $TypeDescriptor$ = TypeDescriptor.klass(Partial.class, new TypeDescriptor[0]);

    @Jpa
    @Ignore
    protected Partial() {
        this.id = null;
        this.clazz = null;
        this.container = null;
        this.instance_ = null;
        this.state = null;
    }

    Partial(@Name(value="id") @TypeInfo(value="ceylon.language::Object") @DocAnnotation$annotation$(description="The id") @SharedAnnotation$annotation$ @NonNull java.lang.Object id) {
        this.id = id;
        this.clazz = null;
        this.container = null;
        this.instance_ = null;
        this.state = new NativeMap(ReachableReference.$TypeDescriptor$, Object.$TypeDescriptor$);
    }

    @DocAnnotation$annotation$(description="The id")
    @SharedAnnotation$annotation$
    @Annotations(modifiers=2L, value={@Annotation(value="doc", arguments={"The id"})})
    @TypeInfo(value="ceylon.language::Object")
    @NonNull
    public final java.lang.Object getId() {
        return this.id;
    }

    @DocAnnotation$annotation$(description="The class, if we know it yet")
    @SharedAnnotation$annotation$
    @VariableAnnotation$annotation$
    @Annotations(modifiers=6L, value={@Annotation(value="doc", arguments={"The class, if we know it yet"})})
    @TypeInfo(value="ceylon.language.meta.model::ClassModel<ceylon.language::Anything,ceylon.language::Nothing>?")
    @Nullable
    public final ClassModel getClazz() {
        return this.clazz;
    }

    public final void setClazz(@Name(value="clazz") @TypeInfo(value="ceylon.language.meta.model::ClassModel<ceylon.language::Anything,ceylon.language::Nothing>?") @Nullable ClassModel clazz) {
        this.clazz = clazz;
    }

    @DocAnnotation$annotation$(description="The containing instance (a partial for it, or the instance itself).\nnull if this partial is not a member or we don't know the container yet.")
    @SharedAnnotation$annotation$
    @VariableAnnotation$annotation$
    @Annotations(modifiers=6L, value={@Annotation(value="doc", arguments={"The containing instance (a partial for it, or the instance itself).\nnull if this partial is not a member or we don't know the container yet."})})
    @TypeInfo(value="ceylon.language::Anything")
    @Nullable
    public final java.lang.Object getContainer() {
        return this.container;
    }

    public final void setContainer(@Name(value="container") @TypeInfo(value="ceylon.language::Anything") @Nullable java.lang.Object container) {
        this.container = container;
    }

    @DocAnnotation$annotation$(description="The (partially initialized) instance, if it has been [[instantiated|instantiate]], or null.")
    @SharedAnnotation$annotation$
    @VariableAnnotation$annotation$
    @Annotations(modifiers=6L, value={@Annotation(value="doc", arguments={"The (partially initialized) instance, if it has been [[instantiated|instantiate]], or null."})})
    @TypeInfo(value="ceylon.language::Anything")
    @Nullable
    public final java.lang.Object getInstance_() {
        return this.instance_;
    }

    public final void setInstance_(@Name(value="instance_") @TypeInfo(value="ceylon.language::Anything") @Nullable java.lang.Object instance_2) {
        this.instance_ = instance_2;
    }

    @DocAnnotation$annotation$(description="The state, mapping references to the \n**id** of the corresponding value in the [[DeserializationContext]].\nnullified by a successful call to [[initialize]].")
    @SharedAnnotation$annotation$
    @VariableAnnotation$annotation$
    @Annotations(modifiers=6L, value={@Annotation(value="doc", arguments={"The state, mapping references to the \n**id** of the corresponding value in the [[DeserializationContext]].\nnullified by a successful call to [[initialize]]."})})
    @TypeInfo(value="ceylon.language.serialization::NativeMap<ceylon.language.serialization::ReachableReference,ceylon.language::Object>?")
    @Nullable
    public final NativeMap<ReachableReference, java.lang.Object> getState() {
        return this.state;
    }

    public final void setState(@Name(value="state") @TypeInfo(value="ceylon.language.serialization::NativeMap<ceylon.language.serialization::ReachableReference,ceylon.language::Object>?") @Nullable NativeMap<ReachableReference, java.lang.Object> state) {
        this.state = state;
    }

    @DocAnnotation$annotation$(description="Add some state.")
    @SharedAnnotation$annotation$
    @Annotations(modifiers=2L, value={@Annotation(value="doc", arguments={"Add some state."})})
    public final void addState(@Name(value="attrOrIndex") @TypeInfo(value="ceylon.language.serialization::ReachableReference") @NonNull ReachableReference attrOrIndex, @Name(value="partialOrComplete") @TypeInfo(value="ceylon.language::Object") @NonNull java.lang.Object partialOrComplete) {
        NativeMap<ReachableReference, java.lang.Object> s$0 = null;
        s$0 = this.getState();
        if (s$0 == null) {
            throw new AssertionError("Assertion failed" + System.lineSeparator() + "\tviolated " + "exists s=state");
        }
        NativeMap<ReachableReference, java.lang.Object> s$1 = s$0;
        s$1.put(attrOrIndex, partialOrComplete);
    }

    @DocAnnotation$annotation$(description="Creates (but does not initialize) the [[instance_]] using backend-specific reflection.\nAfter normal completion of this method instance_ will be non-null.")
    @ThrownExceptionAnnotation$annotations$(value={@ThrownExceptionAnnotation$annotation$(type="::1.3.3:ceylon.language:serialization:CDeserializationException", when="* the class of the instance has already been specified\n* instance is a member instance and the container has not been specified")})
    @SharedAnnotation$annotation$
    @FormalAnnotation$annotation$
    @Annotations(modifiers=130L, value={@Annotation(value="doc", arguments={"Creates (but does not initialize) the [[instance_]] using backend-specific reflection.\nAfter normal completion of this method instance_ will be non-null."}), @Annotation(value="throws", arguments={"DeserializationException", "* the class of the instance has already been specified\n* instance is a member instance and the container has not been specified"})})
    @TypeInfo(value="ceylon.language::Anything", declaredVoid=true)
    @Nullable
    public abstract java.lang.Object instantiate();

    @DocAnnotation$annotation$(description="Initializes the [[instance_]] using backend-specific reflection.\nAfter normal completion of this method state will be null.")
    @ThrownExceptionAnnotation$annotations$(value={@ThrownExceptionAnnotation$annotation$(type="::1.3.3:ceylon.language:serialization:CDeserializationException", when="the partial contains insufficient state")})
    @SharedAnnotation$annotation$
    @FormalAnnotation$annotation$
    @Annotations(modifiers=130L, value={@Annotation(value="doc", arguments={"Initializes the [[instance_]] using backend-specific reflection.\nAfter normal completion of this method state will be null."}), @Annotation(value="throws", arguments={"DeserializationException", "the partial contains insufficient state"})})
    @TypeInfo(value="ceylon.language::Anything", declaredVoid=true)
    @TypeParameters(value={@TypeParameter(value="Id", variance=Variance.NONE, satisfies={"ceylon.language::Object"}, caseTypes={})})
    @Nullable
    public abstract <Id> java.lang.Object initialize(@Ignore TypeDescriptor var1, @Name(value="context") @TypeInfo(value="ceylon.language.serialization::DeserializationContextImpl<Id>") @NonNull DeserializationContextImpl<Id> var2);

    @DocAnnotation$annotation$(description="Whether the partial has been instantiated")
    @SharedAnnotation$annotation$
    @Annotations(modifiers=2L, value={@Annotation(value="doc", arguments={"Whether the partial has been instantiated"})})
    @Transient
    public final boolean getInstantiated() {
        return this.getInstance_() != null;
    }

    @DocAnnotation$annotation$(description="Whether the partial has been initialized")
    @SharedAnnotation$annotation$
    @Annotations(modifiers=2L, value={@Annotation(value="doc", arguments={"Whether the partial has been initialized"})})
    @Transient
    public final boolean getInitialized() {
        return this.getState() == null;
    }

    @DocAnnotation$annotation$(description="Whether the partial is for an instance of a member class")
    @SharedAnnotation$annotation$
    @Annotations(modifiers=2L, value={@Annotation(value="doc", arguments={"Whether the partial is for an instance of a member class"})})
    @Transient
    public final boolean getMember() {
        return this.getContainer() != null;
    }

    @DocAnnotation$annotation$(description="Gets the fully initialized instance, or throws")
    @SharedAnnotation$annotation$
    @Annotations(modifiers=2L, value={@Annotation(value="doc", arguments={"Gets the fully initialized instance, or throws"})})
    @TypeInfo(value="ceylon.language::Anything")
    @Nullable
    public final java.lang.Object instance() {
        if (!this.getInstantiated() || !this.getInitialized()) {
            throw new AssertionError("Assertion failed" + System.lineSeparator() + "\tviolated " + "instantiated && initialized");
        }
        return this.getInstance_();
    }

    @DocAnnotation$annotation$(description="The ids of the instances that this instance refers to")
    @SharedAnnotation$annotation$
    @Annotations(modifiers=2L, value={@Annotation(value="doc", arguments={"The ids of the instances that this instance refers to"})})
    @TypeInfo(value="{ceylon.language::Object*}")
    @Transient
    @NonNull
    public final Iterable<? extends java.lang.Object, ? extends java.lang.Object> getRefersTo() {
        NativeMap<ReachableReference, java.lang.Object> s$3 = this.getState();
        if (s$3 != null) {
            NativeMap<ReachableReference, java.lang.Object> s$4 = s$3;
            return s$4.getItems();
        }
        return empty_.get_();
    }

    @Override
    @Ignore
    public TypeDescriptor $getType$() {
        return $TypeDescriptor$;
    }
}

