/*
 * Decompiled with CFR 0.152.
 */
package ceylon.modules.api.runtime;

import ceylon.modules.CeylonRuntimeException;
import ceylon.modules.Configuration;
import ceylon.modules.api.runtime.SecurityActions;
import ceylon.modules.spi.Constants;
import ceylon.modules.spi.runtime.ClassLoaderHolder;
import ceylon.modules.spi.runtime.Runtime;
import com.redhat.ceylon.common.JVMModuleUtil;

public abstract class AbstractRuntime
implements Runtime {
    public static final String MODULE_INFO_CLASS = ".$module_";
    public static final String OLD_MODULE_INFO_CLASS = ".module_";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static void invokeRun(ClassLoaderHolder clh, String moduleName, String ceylonRunnableName, String[] args) throws Exception {
        ClassLoader cl = clh.getClassLoader();
        ClassLoader oldClassLoader = SecurityActions.setContextClassLoader(cl);
        try {
            Class<?> runClass;
            try {
                String javaClassName = JVMModuleUtil.javaClassNameFromCeylon(moduleName, ceylonRunnableName);
                if (ceylonRunnableName == null) {
                    ceylonRunnableName = moduleName + "::" + "run";
                }
                runClass = cl.loadClass(javaClassName);
            }
            catch (ClassNotFoundException cnfe) {
                String type = Character.isUpperCase(ceylonRunnableName.charAt(0)) ? "class" : "function";
                String msg = String.format("Could not find toplevel %s '%s'.", type, ceylonRunnableName);
                if (!(moduleName.equals(Constants.DEFAULT.toString()) || ceylonRunnableName.contains(".") || ceylonRunnableName.contains("::"))) {
                    msg = msg + String.format(" Class and method names need to be fully qualified, maybe you meant '%s'?", moduleName + "::" + ceylonRunnableName);
                }
                throw new CeylonRuntimeException(msg);
            }
            if ((runClass.getModifiers() & 1) == 0) {
                String type = Character.isUpperCase(ceylonRunnableName.charAt(0)) ? "class" : "function";
                String msg = String.format("Cannot run toplevel %s '%s': it should be shared.", type, ceylonRunnableName);
                throw new CeylonRuntimeException(msg);
            }
            try {
                SecurityActions.invokeRun(runClass, args);
            }
            catch (NoSuchMethodException ex) {
                String type = Character.isUpperCase(ceylonRunnableName.charAt(0)) ? "class" : "function";
                String msg = String.format("Cannot run toplevel %s '%s': it should have no parameters or they should all have default values.", type, ceylonRunnableName);
                throw new CeylonRuntimeException(msg);
            }
        }
        finally {
            SecurityActions.setContextClassLoader(oldClassLoader);
        }
    }

    @Override
    public void execute(Configuration conf) throws Exception {
        String exe = conf.module;
        if (exe == null) {
            throw new CeylonRuntimeException("No initial module defined");
        }
        int p = exe.indexOf("/");
        if (p == 0) {
            throw new CeylonRuntimeException("Missing runnable info: " + exe);
        }
        if (p == exe.length() - 1) {
            throw new CeylonRuntimeException("Missing version info: " + exe);
        }
        String name = exe.substring(0, p > 0 ? p : exe.length());
        String mv = p > 0 ? exe.substring(p + 1) : null;
        ClassLoaderHolder clh = this.createClassLoader(name, mv, conf);
        this.execute(conf, name, clh);
    }

    protected void execute(Configuration conf, String name, ClassLoaderHolder clh) throws Exception {
        AbstractRuntime.invokeRun(clh, name, conf.run, conf.arguments);
    }
}

