/*
 * Decompiled with CFR 0.152.
 */
package ceylon.modules.bootstrap.loader;

import ceylon.modules.bootstrap.loader.BootstrapModuleLoader;
import ceylon.modules.bootstrap.loader.ModuleXmlParser;
import ceylon.modules.bootstrap.loader.SecurityActions;
import com.redhat.ceylon.common.FileUtil;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Method;
import java.net.URL;
import java.util.List;
import org.jboss.modules.LocalModuleLoader;
import org.jboss.modules.ModuleIdentifier;
import org.jboss.modules.ModuleLoadException;
import org.jboss.modules.ModuleLoader;
import org.jboss.modules.ModuleSpec;

public class RemoteModuleLoader
extends BootstrapModuleLoader {
    private static final String DEFAULT_CEYLON_VERSION = "1.3.3";
    private static final String INDEX = ".index";
    private static final String XML = "module.xml";
    private static final Method findModule = SecurityActions.findModule();
    private final ModuleLoader delegate;
    private final String rootURL;
    private final String ceylonVersion;
    private final File repoRoot;

    public RemoteModuleLoader() {
        this(new LocalModuleLoader());
    }

    protected RemoteModuleLoader(ModuleLoader delegate) {
        if (delegate == null) {
            throw new IllegalArgumentException("Null delegate");
        }
        this.delegate = delegate;
        this.rootURL = SecurityActions.getProperty("modules.remote.root.url", "https://modules.ceylon-lang.org/repo/1");
        this.ceylonVersion = SecurityActions.getProperty("ceylon.modules.version", DEFAULT_CEYLON_VERSION);
        this.repoRoot = new File(RemoteModuleLoader.getCeylonRepository());
    }

    protected ModuleSpec getModuleSpec(ModuleIdentifier mi) throws ModuleLoadException {
        try {
            return (ModuleSpec)findModule.invoke((Object)this.delegate, mi);
        }
        catch (Exception e) {
            throw new ModuleLoadException(e);
        }
    }

    @Override
    protected ModuleSpec findModule(ModuleIdentifier moduleIdentifier) throws ModuleLoadException {
        try {
            ModuleSpec spec = this.getModuleSpec(moduleIdentifier);
            if (spec != null) {
                return spec;
            }
        }
        catch (ModuleLoadException moduleLoadException) {
            // empty catch block
        }
        return this.fetchRemoteModule(moduleIdentifier) ? this.getModuleSpec(moduleIdentifier) : null;
    }

    protected boolean fetchRemoteModule(ModuleIdentifier moduleIdentifier) throws ModuleLoadException {
        try {
            String localPath = this.toPathString(moduleIdentifier, false);
            String remotePath = this.toPathString(moduleIdentifier, true);
            File localModuleXML = this.getLocalFile(localPath + XML);
            boolean existsLocally = localModuleXML.exists();
            InputStream moduleXMLStream = existsLocally ? new FileInputStream(localModuleXML) : this.getInputStream(remotePath, XML);
            if (moduleXMLStream != null) {
                if (!existsLocally) {
                    File moduleXML = this.writeStream(moduleXMLStream, localPath + XML);
                    moduleXMLStream = new FileInputStream(moduleXML);
                }
                List<String> resourcePaths = this.parseResourcePaths(moduleXMLStream, moduleIdentifier);
                for (String resource : resourcePaths) {
                    InputStream indexStream;
                    InputStream jarStream;
                    String fullName = localPath + resource;
                    if (!this.getLocalFile(fullName).exists() && (jarStream = this.getInputStream(remotePath, resource)) != null) {
                        this.writeStream(jarStream, fullName);
                    }
                    if (this.getLocalFile(fullName + INDEX).exists() || (indexStream = this.getInputStream(remotePath, resource + INDEX)) == null) continue;
                    this.writeStream(indexStream, fullName + INDEX);
                }
                this.log("Module fetch completed OK: " + moduleIdentifier);
                return true;
            }
            return false;
        }
        catch (IOException e) {
            e.printStackTrace();
            throw new ModuleLoadException("Cannot fetch remote resource: " + moduleIdentifier, e);
        }
    }

    protected List<String> parseResourcePaths(InputStream moduleXMLStream, ModuleIdentifier moduleIdentifier) throws ModuleLoadException {
        return ModuleXmlParser.parseResourcePaths(moduleXMLStream, moduleIdentifier);
    }

    protected File getLocalFile(String name) {
        return new File(this.repoRoot, name);
    }

    protected InputStream getInputStream(String path, String resource) {
        try {
            URL url = new URL(this.rootURL + path + resource);
            this.log("Fetching resource: " + url);
            return url.openStream();
        }
        catch (Exception e) {
            this.log("Cannot open stream: " + e);
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected File writeStream(InputStream inputStream, String name) throws IOException {
        try {
            File file;
            File file2 = new File(this.repoRoot, name);
            File parent = file2.getParentFile();
            if (!parent.exists() && !FileUtil.mkdirs(parent)) {
                throw new IOException("Cannot create parent directories: " + parent);
            }
            this.log("Saving resource: " + file2);
            FileOutputStream out = new FileOutputStream(file2);
            try {
                int b;
                while ((b = inputStream.read()) != -1) {
                    out.write(b);
                }
                out.flush();
                this.log("Resource saved: " + file2);
                file = file2;
            }
            catch (Throwable throwable) {
                try {
                    out.close();
                    throw throwable;
                }
                catch (Exception e) {
                    e.printStackTrace();
                    throw new IOException(e);
                }
            }
            out.close();
            return file;
        }
        finally {
            inputStream.close();
        }
    }

    private String toPathString(ModuleIdentifier moduleIdentifier, boolean addVersion) {
        StringBuilder builder = new StringBuilder();
        if (addVersion) {
            builder.append(this.ceylonVersion).append(File.separatorChar);
        }
        builder.append(moduleIdentifier.getName().replace('.', File.separatorChar));
        builder.append(File.separatorChar).append(moduleIdentifier.getSlot());
        builder.append(File.separatorChar);
        return builder.toString();
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("Remote ModuleLoader @").append(Integer.toHexString(this.hashCode())).append(" (url: ").append(this.rootURL);
        b.append(')');
        return b.toString();
    }

    protected void log(String msg) {
        System.out.println(msg);
    }
}

